//////////////////////////////////////////////////////////////////////////////
// * File name: main_bypass1.c
// *                                                                          
// * Description: This file includes main() and system initialization funcitons.
// *                                                                          
// * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/ 
// *                                                                          
// *                                                                          
// *  Redistribution and use in source and binary forms, with or without      
// *  modification, are permitted provided that the following conditions      
// *  are met:                                                                
// *                                                                          
// *    Redistributions of source code must retain the above copyright        
// *    notice, this list of conditions and the following disclaimer.         
// *                                                                          
// *    Redistributions in binary form must reproduce the above copyright     
// *    notice, this list of conditions and the following disclaimer in the   
// *    documentation and/or other materials provided with the                
// *    distribution.                                                         
// *                                                                          
// *    Neither the name of Texas Instruments Incorporated nor the names of   
// *    its contributors may be used to endorse or promote products derived   
// *    from this software without specific prior written permission.         
// *                                                                          
// *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS     
// *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT       
// *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR   
// *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT    
// *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,   
// *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT        
// *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,   
// *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY   
// *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT     
// *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE   
// *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.    
// *                                                                          
//////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "errors.h"
#include "register_system.h"
#include "register_cpu.h"
#include "control.h"
#include "i2s_bypass1.h"
#include "dma_bypass1.h"
#include "ref_data_bypass.h"

void InitSystem(void);
void ConfigPort(void);
void SYS_GlobalIntEnable(void);
void SYS_GlobalIntDisable(void);
void PLL_98MHz(void);
void buff_copy(unsigned short *input, unsigned short *output, short size);

extern void AIC3254_init(void);
extern void reset_isr(void);
extern unsigned short CurrentRxL_DMAChannel;
extern unsigned short CurrentRxR_DMAChannel;
extern unsigned short CurrentTxL_DMAChannel;
extern unsigned short CurrentTxR_DMAChannel;
extern unsigned short RunFilterForL;
extern unsigned short RunFilterForR;

//Input Buffers
unsigned short RcvL1[XMIT_BUFF_SIZE];
unsigned short RcvR1[XMIT_BUFF_SIZE];
unsigned short RcvL2[XMIT_BUFF_SIZE];
unsigned short RcvR2[XMIT_BUFF_SIZE];

#define WORD_8		0
#define WORD_16		0x04
#define WORD_24		0x07
#define WORD_32		0x08
#define FS_8		0
#define FS_16		0x1
#define FS_32		0x2
#define FS_64		0x3
#define FS_128		0x4
#define FS_256		0x5
#define WORD_SIZE	WORD_16	 
#define FS_DIV		FS_32

unsigned short Buf_Address =0;

void main(void)
{
	reset_isr();
    InitSystem();
    ConfigPort();
    SYS_GlobalIntEnable();
    
    IER0 = 0x0110;      // enable dma, timer int      

    setDMA_address();
    //set_i2s0_master();
    set_i2s0_slave(); 
    AIC3254_init();

    PLL_98MHz();

	enable_i2s0();
    enable_dma_int();
    //set_dma0_ch0_i2s0_Lout();
    set_dma0_ch1_i2s0_Rout();
   	set_dma0_ch2_i2s0_Lin();
	set_dma0_ch3_i2s0_Rin();

    while(1)
    {        
            if(RunFilterForL ==1)
            {
                RunFilterForL =0;
                if (CurrentRxL_DMAChannel ==2)
                {
                    //buff_copy(&RcvL1[0],&FilterOutL1[0], XMIT_BUFF_SIZE);
                    //buff_copy(&RcvL1[0],&FilterOutR1[0], XMIT_BUFF_SIZE);
               }
                else
                {
                    //buff_copy(&RcvL2[0],&FilterOutL2[0], XMIT_BUFF_SIZE); 
                    //buff_copy(&RcvL2[0],&FilterOutR2[0], XMIT_BUFF_SIZE);                                    
                }
                
            }
            if(RunFilterForR ==1)
            {
                RunFilterForR=0;
                if (CurrentRxR_DMAChannel ==2)
                {
                    //buff_copy(&RcvR1[0],&FilterOutR1[0], XMIT_BUFF_SIZE);
                }
                else
                {
                    //buff_copy(&RcvR2[0],&FilterOutR2[0], XMIT_BUFF_SIZE);                
                }
            }
    }

}

void PLL_98MHz(void)
{
// PLL set up from RTC
    // bypass PLL
    CONFIG_MSW = 0x0;

#if (PLL_100M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0000;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x8BE8; //PG1.4: 0x82FA;
    
#elif (PLL_12M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0200;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82ED;
#elif (PLL_98M ==1)    
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0000;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82ED;
    
#endif
    while ( (PLL_CNTL3 & 0x0008) == 0);
    // Switch to PLL clk
    CONFIG_MSW = 0x1;
}

void InitSystem(void)
{
	unsigned short i;
// PLL set up from RTC
    // bypass PLL
    CONFIG_MSW = 0x0;

#if (PLL_100M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0000;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x8BE8; //PG1.4: 0x82FA;
    
#elif (PLL_12M ==1)
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0200;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82ED;
#elif (PLL_98M ==1)    
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0000;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x82ED;

#elif (PLL_40M ==1)        
    PLL_CNTL2 = 0x8000;
    PLL_CNTL4 = 0x0300;
    PLL_CNTL3 = 0x0806;
    PLL_CNTL1 = 0x8262;    
#endif

    while ( (PLL_CNTL3 & 0x0008) == 0);
    // Switch to PLL clk
    CONFIG_MSW = 0x1;

// clock gating
// enable all clocks
    IDLE_PCGCR = 0x0;
    IDLE_PCGCR_MSW = 0xFF84;
    

// reset peripherals
    PER_RSTCOUNT = 0x02;
    PER_RESET = 0x00fb;    
    for (i=0; i< 0xFFF; i++);
}

void ConfigPort(void)
{
    short i;
    //  configure ports
    PERIPHSEL0 = 0x6900;        // parallel port: mode 6, serial port1: mode 2 

    for (i=0; i< 0xFFF; i++);
}


void SYS_GlobalIntEnable(void)
{
    asm(" BIT (ST1, #ST1_INTM) = #0");
}

void SYS_GlobalIntDisable(void)
{
    asm(" BIT (ST1, #ST1_INTM) = #1");
}

void buff_copy(unsigned short *input, unsigned short *output, short size)
{
	short i;
	
	for(i =0; i<size; i++)
	{
		*(output + i) = *(input +i);
	}
	
}

unsigned short set_i2s0_master(void)
{
    unsigned short temp=0;

	temp = WORD_SIZE <<2;
	temp |= 0x0082;				// Master, Pack
    i2s0_write_CR(temp);        // Master, I2S, 16 bit
    temp = i2s0_read_CR();
    
	temp = FS_DIV <<3;
	temp |= 0x0005; 				// clock = CPU / 4 
    i2s0_write_SRGR(temp);       
    
#if(USE_DMA ==1)    
    i2s0_write_INT_MASK(0);         // Disable I2S interrupt
#else
    i2s0_write_INT_MASK(0x20);         // Tx stereo interrupt

    i2s0_write_TXL_LSW(0x5678);
    i2s0_write_TXL_MSW(0x1234);
    i2s0_write_TXR_LSW(0x5678);
    i2s0_write_TXR_MSW(0x1234);
#endif

        
    return SUCCESS;
}

void set_i2s0_slave(void)
{
    unsigned short temp=0;

	temp = WORD_SIZE <<2;
	temp |= 0x0080;				// Slave, Pack
    i2s0_write_CR(temp);        // Master, I2S, 16 bit
    temp = i2s0_read_CR();

#if(USE_DMA ==1)    
    i2s0_write_INT_MASK(0);         // Disable I2S interrupt
#else
    i2s0_write_INT_MASK(0x20);         // Tx stereo interrupt

    i2s0_write_TXL_LSW(0x5678);
    i2s0_write_TXL_MSW(0x1234);
    i2s0_write_TXR_LSW(0x5678);
    i2s0_write_TXR_MSW(0x1234);
#endif
    
}





