#include <math.h>
#include <stdio.h>

#define PI 3.14159


void split_gen (float *pATable, float *pBTable, int n)
{
	int i;

	for (i = 0; i < n; i++)
	{
		pATable[2 * i] = 0.5 * (1.0 - sin (2 * PI / (double) (2 * n) * (double) i));
		pATable[2 * i + 1] = 0.5 * (-1.0 * cos (2 * PI / (double) (2 * n) * (double) i));
		pBTable[2 * i] = 0.5 * (1.0 + sin (2 * PI / (double) (2 * n) * (double) i));
		pBTable[2 * i + 1] = 0.5 * (1.0 * cos (2 * PI / (double) (2 * n) * (double) i));
	}
}

void FFT_Split (int n, float *restrict pIn, float *pATable, float *pBTable, float *pOut)
{
	int i;
	float Tr, Ti;

	_nassert ((int) pIn % 8 == 0);
	_nassert ((int) pOut % 8 == 0);
	_nassert ((int) pATable % 8 == 0);
	_nassert ((int) pBTable % 8 == 0);

	pIn[2 * n] = pIn[0];
	pIn[2 * n + 1] = pIn[1];

#pragma UNROLL(2)
	for (i = 0; i < n; i++)
	{
		Tr = (pIn[2 * i] * pATable[2 * i] - pIn[2 * i + 1] * pATable[2 * i + 1] + pIn[2 * n - 2 * i] * pBTable[2 * i] + pIn[2 * n - 2 * i + 1] * pBTable[2 * i + 1]);

		Ti = (pIn[2 * i + 1] * pATable[2 * i] + pIn[2 * i] * pATable[2 * i + 1] + pIn[2 * n - 2 * i] * pBTable[2 * i + 1] - pIn[2 * n - 2 * i + 1] * pBTable[2 * i]);

		pOut[2 * i] = Tr;
		pOut[2 * i + 1] = Ti;
		// Use complex conjugate symmetry properties to get the rest..
		pOut[4 * n - 2 * i] = Tr;
		pOut[4 * n - 2 * i + 1] = -Ti;

	}
	pOut[2 * n] = pIn[0] - pIn[1];
	pOut[2 * n + 1] = 0;

}