#include "ADS7881cfg.h"
#include "Constants.h"

/* Header file */
#include "csl.h"
#include "csl_irq.h"
#include <stdio.h>
#include <math.h>
#include <dsk6713_flash.h>

//#include "dsk6713.h"
#include "dsk6713_led.h"
#include "dsk6713_dip.h"

/*Declarations*/
//#define N   1024/* size of data buffer */ 
#define PI 3.14159
#define SZ 4

#define ADS7881   (0xA0014000)

#pragma DATA_ALIGN(pRFFT_In, 8);							// The alignment is very important
#pragma DATA_ALIGN(pRFFT_Out, 8);							// for input/ouput and twiddle pointers
#pragma DATA_ALIGN(pTemp, 8);
#pragma DATA_ALIGN (fft_mag, 8);

void tw_gen (float *w, int n);
void split_gen (float *A, float *B, int n);
void DSPF_sp_fftSPxSP (int, float *, float *, float *, unsigned char *, int, int, int);
void FFT_Split (int n, float *pIn, float *A, float *B, float *pOut);
float magcalculation(double x, double y);
void Average();
void minmax();

float pRFFT_In[N];
float pRFFT_Out[2 * N];
float pTemp[N];
float fft_mag[N];

//we can generate twidle factors using tw_gen();
float w[N];
float A[N];
float B[N];


#pragma DATA_ALIGN (brev , 8);
unsigned char brev[64] = {
	0x0, 0x20, 0x10, 0x30, 0x8, 0x28, 0x18, 0x38,
	0x4, 0x24, 0x14, 0x34, 0xc, 0x2c, 0x1c, 0x3c,
	0x2, 0x22, 0x12, 0x32, 0xa, 0x2a, 0x1a, 0x3a,
	0x6, 0x26, 0x16, 0x36, 0xe, 0x2e, 0x1e, 0x3e,
	0x1, 0x21, 0x11, 0x31, 0x9, 0x29, 0x19, 0x39,
	0x5, 0x25, 0x15, 0x35, 0xd, 0x2d, 0x1d, 0x3d,
	0x3, 0x23, 0x13, 0x33, 0xb, 0x2b, 0x1b, 0x3b,
	0x7, 0x27, 0x17, 0x37, 0xf, 0x2f, 0x1f, 0x3f
};

float vRef = 2.5f;
int rad, nTemp = N / 2;
float *twiddle;
int i=0;  
int j=0; 
int n=0;
int m=0;
int k=0;
int fileExist=0;

// Variables for max and min

float mnmx[SZ];
int mm = 0;

unsigned int start = 0x90017FFF + 0x1;
unsigned int length = 0x8000;

unsigned int start1 = 0x90017FFF;
unsigned int length1 = 0x10;

int ind = 0;
int FirstTime = 0;

/******************************************************************************\
* Function: main()
* Description: Enables McBSP1 receive interrupt and McBSP1
\******************************************************************************/

void main() 
{
	HWI_enable();
	IRQ_enable(IRQ_EVT_EXTINT5);
    TIMER_start(hTimer1);

    //DSK6713_init();

    /* Initialize the LED and DIP switch modules of the BSL */
    DSK6713_LED_init();
    DSK6713_DIP_init();
}


/******************************************************************************\
* Function: ExtINT5_ISR()
* Description: Reads sample out of 
* 	receive register and stores it in array call ad_buffer.  When the buffer 
* 	table is full, it resets the pointer to the beginning and flushing receive
*	buffers.
\******************************************************************************/

void  ExtINT5_ISR(void)
{
    pRFFT_In[i++] = (float)(((*(unsigned volatile int *)ADS7881)>>2&0x0FFF)/4096.0f)*vRef;
        	
	if (i >= N )	     	/* Reset index?			*/
	{ 
	
	i=0;

	if (nTemp == 16 || nTemp == 64 || nTemp == 256 || nTemp == 1024 || nTemp == 4096 || nTemp == 16384)
		rad = 4;
	else if (nTemp == 8 || nTemp == 32 || nTemp == 128 || nTemp == 512 || nTemp == 2048 || nTemp == 8192)
		rad = 2;
	else
	{
		printf ("%d Value of N is not supported \n", N);
		exit (0);
	}

	twiddle = (float *) w;


	DSPF_sp_fftSPxSP (N / 2, pRFFT_In, twiddle, pTemp, brev, rad, 0, N / 2);

	FFT_Split (N / 2, pTemp, A, B, pRFFT_Out);

		for(j=0; j < N; j++)

		{
			fft_mag[j] = magcalculation((double)pRFFT_Out[2*j], (double)pRFFT_Out[2*j+1]);
			fft_mag[0] = 0.0f;
		}

		mnmx[mm] = fft_mag[219];	
		mm++;
		mnmx[mm] = fft_mag[251];	
		mm++;
		mnmx[mm] = fft_mag[242];
		mm++;
		mnmx[mm] = fft_mag[273];
		mm++;


	if (FirstTime == 0)
		{
			for(ind=0; ind<4; ind++)
			{
				DSK6713_FLASH_erase(start, length);
				start = start + 0x8000;
			}
		
	length = 0x4000;
	DSK6713_FLASH_erase(start, length);
	start = start + 0x4000;
	length = 0x1000;

			for(ind=0; ind<2; ind++)
			{
				DSK6713_FLASH_erase(start, length);
				start = start + 0x1000;
			}

	length = 0x2000;
	DSK6713_FLASH_erase(start, length);

	FirstTime++;

	}

	DSK6713_FLASH_write((Uint32) fft_mag, start1, length1);
	start1 = start1 + length1;

	DSK6713_LED_toggle(0);

	if (start1 == 0x9001800F)
	
	{
		DSK6713_LED_toggle(0);
		DSK6713_LED_toggle(1);
		DSK6713_LED_toggle(2);
		DSK6713_LED_toggle(3);
		abort();
	}

		
	}    	 
}


/* Function for generating Specialized sequence of twiddle factors */
void tw_gen (float *w, int n)
{
	int i, j, k;
	double x_t, y_t, theta1, theta2, theta3;

	for (j = 1, k = 0; j <= n >> 2; j = j << 2)
	{
		for (i = 0; i < n >> 2; i += j)
		{
			theta1 = 2 * PI * i / n;
			x_t = cos (theta1);
			y_t = sin (theta1);
			w[k] = (float) x_t;
			w[k + 1] = (float) y_t;

			theta2 = 4 * PI * i / n;
			x_t = cos (theta2);
			y_t = sin (theta2);
			w[k + 2] = (float) x_t;
			w[k + 3] = (float) y_t;

			theta3 = 6 * PI * i / n;
			x_t = cos (theta3);
			y_t = sin (theta3);
			w[k + 4] = (float) x_t;
			w[k + 5] = (float) y_t;
			k += 6;
		}
	}
}


float magcalculation(double x, double y)

{
	double a1, a2, b1, b2;
	a1 = x*x;
	a2 = y*y;
	b1 = a1+a2;
	b2 = (sqrt(b1)/512.0f);
	return (float)b2;
}


