#include"nRF24L01.h"

uchar TX_ADDRESS[TX_ADR_WIDTH] = {0xb2,0xb2,0xb3,0xb4,0x01};


uchar RX_BUF[TX_PLOAD_WIDTH];
uchar TX_BUF[TX_PLOAD_WIDTH]=
{
		0x01,0x02,0x03,0x4,0x05,0x06,0x07,0x08,
		0x09,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
		0x17,0x18,0x19,0x20,0x21,0x22,0x23,0x24,
		0x25,0x26,0x27,0x28,0x29,0x30,0x31,0x32,
};
uchar flag,status;
uchar DATA = 0x01;

uchar 	sta,temp;
#define RX_DR	sta&(1<<6)
#define TX_DS	sta&(1<<5)
#define MAX_RT 	sta&(1<<4)

void init_io(void)
{
	P1DIR=CE_PIN|CSN_PIN|MOSI_PIN|SCK_PIN; // CE, CSN, MOSI and SCK outputs, else inputs (IRQ and MISO)
	CE(0);
	CSN(1);
	SCK(0);
}


void delay_ms(int ms) {
#ifdef FREQ_8MHZ
	ms*=8;
#endif
#ifdef FREQ_16MHZ
	ms*=16;
#endif
	int i;
	for(i=0;i<ms;i++) {
		__delay_cycles(1000);
	}
}


uchar SPI_RW(uchar byte)
{
	uchar i;
	for(i=0; i<8; i++)
	{
		MOSI(byte & 0x80);
		byte <<= 1;
		SCK(1);
		byte |= MISO;
		SCK(0);
	}
	return(byte);
}


uchar SPI_RW_Reg(uchar reg, uchar value)
{
	uchar status;
	CSN(0);
	status = SPI_RW(reg);
	SPI_RW(value);
	CSN(1);
	return(status);
}



uchar SPI_Read(uchar reg)
{
	uchar reg_val;
	CSN(0);
	SPI_RW(reg);
	reg_val = SPI_RW(0);
	CSN(1);
	return(reg_val);
}


uchar SPI_Read_Buf(uchar reg, uchar * pBuf, uchar bytes)
{
	uchar status, i;
	CSN(0);
	status = SPI_RW(reg);
	for(i=0; i<bytes; i++)
		pBuf[i] = SPI_RW(0);
	CSN(1);
	return(status);
}


uchar SPI_Write_Buf(uchar reg, uchar * pBuf, uchar bytes)
{
	uchar status, i;
	CSN(0);
	status = SPI_RW(reg);
	for(i=0; i<bytes; i++)
		SPI_RW(pBuf[i]);
	CSN(1);
	return(status);
}


void RX_Mode(void)
{
	CE(0);
	temp=SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH);
	temp=SPI_RW_Reg(WRITE_REG + EN_AA, 0x3f);
	temp=SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x3f);
	temp=SPI_RW_Reg(WRITE_REG + RF_CH, 40);
	temp=SPI_RW_Reg(WRITE_REG + RX_PW_P0, TX_PLOAD_WIDTH);
	temp=SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);
	temp=SPI_RW_Reg(WRITE_REG + CONFIG, 0x0f);
	CE(1);
}


void TX_Mode(uchar * BUF)
{
	CE(0);
	SPI_Write_Buf(WRITE_REG + TX_ADDR, TX_ADDRESS, TX_ADR_WIDTH);
	SPI_Write_Buf(WRITE_REG + RX_ADDR_P0, TX_ADDRESS, TX_ADR_WIDTH);
	SPI_Write_Buf(WR_TX_PLOAD, BUF, TX_PLOAD_WIDTH);
	SPI_RW_Reg(WRITE_REG + EN_AA, 0x3f);
	SPI_RW_Reg(WRITE_REG + EN_RXADDR, 0x3f);
	SPI_RW_Reg(WRITE_REG + SETUP_RETR, 0x0a);
	SPI_RW_Reg(WRITE_REG + RF_CH, 40);
	SPI_RW_Reg(WRITE_REG + RF_SETUP, 0x07);
	SPI_RW_Reg(WRITE_REG + CONFIG, 0x0e);
	CE(1);
}


uchar Check_ACK(uchar clear)
{
	while(IRQ);
	sta = SPI_RW(NOP);                    
	if(MAX_RT)
		if(clear)                         
			SPI_RW(FLUSH_TX);
	SPI_RW_Reg(WRITE_REG + STATUS, sta);  
	//IRQ = 1;
	if(TX_DS)
		return(0x00);
	else
		return(0xff);
}


//void exter0() interrupt 0
//{
//	sta = SPI_Read(STATUS);
//   if(RX_DR)
//	{
//		status=sta;
//		status&=0x0e;
//		status>>=1;
//		SPI_Read_Buf(RD_RX_PLOAD, RX_BUF, TX_PLOAD_WIDTH);  // RX FIFO
//		flag = 1;
//	}
//	SPI_RW_Reg(WRITE_REG + STATUS, sta);  // RX_DSжϱ־
//}
