/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.serial.Serial;

public class FRAM_GUI
extends PApplet {
    int FR57xxComPortFound = 0;
    int numberOfLookingDots = 0;
    Serial myPort;
    int COMPort;
    int dataRead;
    int[] inByte = new int[7];
    int[] dummy = new int[7];
    int[] fillRect = new int[8];
    int ledIndex = 0;
    int led;
    PImage backgroundStart;
    PFont fontA;
    PImage bgFind;
    PImage bg;
    String looking;
    int i;
    int j;
    int mode;
    int prevMode = 0;
    String modeName;
    float speed = 0.0f;
    float inByteCount = 0.0f;
    float timerStart = 0.0f;
    float endurance = 100.0f;
    float seconds;
    float flashAngle = -205.0f;
    float framAngle = -205.0f;
    float framSpeed;
    float flashSpeed;
    float bitEndurance;
    float speedFactor = 0.0f;
    float shiftNeedle = 580.0f;
    int enduranceFRAM = 100;
    int lastUpdate = 0;
    int test = 0;

    public void findFR57xx() {
        String string = "";
        try {
            Process process = Runtime.getRuntime().exec(String.valueOf(this.sketchPath) + "/FindAppUART.exe");
            process.waitFor();
            process.exitValue();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = bufferedReader.readLine();
            if (!string.substring(0, 3).equals("COM")) {
                string = "";
            } else {
                this.FR57xxComPortFound = 1;
                this.myPort = new Serial((PApplet)this, string, 9600);
            }
        }
        catch (Exception exception) {
            FRAM_GUI.println((Object)exception);
        }
    }

    public void promptLookingForFR57xx() {
        this.fontA = this.loadFont("Consolas-16.vlw");
        this.noStroke();
        this.textFont(this.fontA, 20.0f);
        this.textAlign(37);
        ++this.numberOfLookingDots;
        this.fill(60.0f, 60.0f, 60.0f);
        this.rect(526.0f, 162.0f, 35.0f, 10.0f);
        this.fill(255);
        if (this.numberOfLookingDots == 5) {
            this.numberOfLookingDots = 1;
        }
        switch (this.numberOfLookingDots) {
            case 1: {
                this.looking = "";
                break;
            }
            case 2: {
                this.looking = ". ";
                break;
            }
            case 3: {
                this.looking = ".. ";
                break;
            }
            case 4: {
                this.looking = "...";
            }
        }
    }

    public void setup() {
        this.background(0);
        this.size(1052, 401);
        this.smooth();
        this.fontA = this.loadFont("Arial-BoldMT-48.vlw");
        this.backgroundStart = this.loadImage("BackgroundFind.png");
        this.bg = this.loadImage("Background.png");
        this.image(this.backgroundStart, 0.0f, 0.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.textFont(this.fontA, 25.0f);
        this.textAlign(37);
        this.text("MSP-EXP430FR5739 ", 30.0f, 45.0f);
        this.fill(255);
        this.text("| FRAM User Experience Demo", 282.0f, 45.0f);
        this.textFont(this.fontA, 18.0f);
        this.text("Please plug your MSP-EXP430FR5739 FRAM Experimenter's Board to your PC with included USB cable.", 20.0f, 130.0f);
        this.frameRate(3.0f);
    }

    public void drawMainAppCanvas() {
        this.background(this.bg);
        this.fill(129);
        this.ellipse(290.0f, 170.0f, 20.0f, 20.0f);
        this.ellipse(857.0f, 170.0f, 20.0f, 20.0f);
        this.fill(this.fillRect[0]);
        this.rect(450.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[1]);
        this.rect(470.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[2]);
        this.rect(490.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[3]);
        this.rect(510.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[4]);
        this.rect(530.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[5]);
        this.rect(550.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[6]);
        this.rect(570.0f, 280.0f, 8.0f, 20.0f);
        this.fill(this.fillRect[7]);
        this.rect(590.0f, 280.0f, 8.0f, 20.0f);
        this.textFont(this.fontA, 12.0f);
        this.textAlign(37);
    }

    public void lookForFR57xx() {
        this.findFR57xx();
        if (this.FR57xxComPortFound == 0) {
            this.promptLookingForFR57xx();
            this.textFont(this.fontA, 18.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.text("Looking for MSP-EXP430FR5739 Experimenter's Board " + this.looking, 20.0f, 170.0f);
        } else {
            this.frameRate(60.0f);
            this.led = this.color(254, 169, 6);
            this.drawMainAppCanvas();
        }
    }

    public void drawCenterConsole() {
        this.stroke(255);
        this.fill(255);
        this.textFont(this.fontA, 16.0f);
        if (this.mode == 85) {
            this.text("Mode: ULP measure", 435.0f, 125.0f);
        } else {
            this.text("Mode: " + this.mode, 435.0f, 125.0f);
        }
        this.textFont(this.fontA, 12.0f);
        this.text(this.modeName, 435.0f, 140.0f);
        this.textFont(this.fontA, 16.0f);
        this.text("Remaining Endurance: ", 435.0f, 170.0f);
        this.textFont(this.fontA, 12.0f);
        this.text("(Assuming 512B mem. block)", 435.0f, 185.0f);
        if (this.mode == 2) {
            if (this.endurance <= 0.0f) {
                this.text("Endurance is depleted", 435.0f, 200.0f);
            } else {
                this.text(this.endurance, 435.0f, 200.0f);
                this.text("%", 480.0f, 200.0f);
            }
        } else if (this.mode == 1 || this.mode == 3 || this.mode == 4) {
            this.text("99.9999" + this.enduranceFRAM, 435.0f, 200.0f);
            this.text("%", 540.0f, 200.0f);
        } else if (this.mode == 85) {
            if (this.prevMode == 2) {
                this.text(this.endurance, 435.0f, 200.0f);
                this.text("%", 480.0f, 200.0f);
            } else if (this.prevMode == 1 || this.prevMode == 3 || this.prevMode == 4) {
                this.text("99.9999999" + this.enduranceFRAM, 435.0f, 200.0f);
                this.text("%", 530.0f, 200.0f);
            }
        }
        this.textFont(this.fontA, 16.0f);
        this.text(this.framSpeed, 165.0f, 316.0f);
        this.text("kB/s", 256.0f, 316.0f);
        this.text(this.flashSpeed, 184.0f + this.shiftNeedle, 316.0f);
        this.text("kB/s", 250.0f + this.shiftNeedle, 316.0f);
        if (this.timerStart != 0.0f && this.endurance > 0.0f && this.mode > 0 && this.mode < 5) {
            this.seconds = ((float)this.millis() - this.timerStart) / 1000.0f;
        }
        this.fill(255.0f, 255.0f, 255.0f);
        this.textFont(this.fontA, 16.0f);
        this.text("Time spent in mode: ", 435.0f, 230.0f);
        this.textFont(this.fontA, 12.0f);
        this.text(this.seconds, 435.0f, 245.0f);
        this.text("seconds", 490.0f, 245.0f);
    }

    public void drawSpeedometer() {
        this.stroke(0.0f, 0.0f, 0.0f);
        if (this.mode == 1 || this.mode == 3 || this.mode == 4) {
            this.fill(254.0f, 169.0f, 6.0f);
            this.ellipse(290.0f, 170.0f, 20.0f, 20.0f);
            this.fill(220);
            this.ellipse(857.0f, 170.0f, 20.0f, 20.0f);
            this.framAngle = 0.114f * this.framSpeed - 205.0f;
            if (this.framAngle > 25.0f) {
                this.framAngle = 25.0f;
            }
        }
        if (this.mode == 2) {
            this.fill(254.0f, 169.0f, 6.0f);
            this.ellipse(857.0f, 170.0f, 20.0f, 20.0f);
            this.fill(220);
            this.ellipse(290.0f, 170.0f, 20.0f, 20.0f);
            this.flashAngle = 0.114f * this.flashSpeed - 205.0f;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.pushMatrix();
        this.translate(237.0f, 251.0f);
        this.rotate(FRAM_GUI.radians((float)this.framAngle));
        this.rect(0.0f, 0.0f, 160.0f, 5.0f);
        this.popMatrix();
        this.pushMatrix();
        this.translate(237.0f + this.shiftNeedle, 251.0f);
        this.rotate(FRAM_GUI.radians((float)this.flashAngle));
        this.rect(0.0f, 0.0f, 160.0f, 5.0f);
        this.popMatrix();
    }

    public void draw() {
        if (this.FR57xxComPortFound == 0) {
            this.lookForFR57xx();
        } else {
            this.dataRead = this.myPort.read();
            if (this.dataRead == 250) {
                this.j = 1;
                while (this.j < 7) {
                    this.inByte[this.j] = this.myPort.read();
                    ++this.j;
                }
                if (this.inByte[1] == 1 || this.inByte[1] == 2 || this.inByte[1] == 3 || this.inByte[1] == 4 || this.inByte[1] == 85) {
                    this.prevMode = this.mode;
                    this.mode = this.inByte[1];
                    if (this.mode != this.prevMode) {
                        this.inByteCount = 0.0f;
                        this.timerStart = this.millis();
                    }
                    this.inByteCount += 1.0f;
                    if (this.mode == 1) {
                        this.speedFactor = 100.0f;
                        this.bitEndurance = 1.0E9f;
                        this.modeName = "FRAM high-speed write test";
                        this.enduranceFRAM = 100000000 - PApplet.parseInt((float)(this.inByteCount * 1.0f * 1.0E9f / 8.988918E8f));
                        this.framSpeed = this.inByteCount * this.speedFactor * 1000.0f / ((float)this.millis() - this.timerStart);
                        this.ledIndex = this.inByte[2];
                        if (this.ledIndex >= 0 && this.ledIndex <= 7) {
                            this.j = 0;
                            while (this.j < 8) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = 0;
                            while (this.j <= this.ledIndex) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        }
                    } else if (this.mode == 2) {
                        this.speedFactor = 2.0f;
                        this.modeName = "Flash write speed emulation";
                        this.endurance = 100.0f - this.inByteCount * 2000.0f * 100.0f / 5120000.0f;
                        this.flashSpeed = this.inByteCount * this.speedFactor * 1000.0f / ((float)this.millis() - this.timerStart);
                        this.ledIndex = this.inByte[2];
                        if (this.ledIndex >= 0 && this.ledIndex <= 7) {
                            this.j = 0;
                            while (this.j < 8) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = 0;
                            while (this.j <= this.ledIndex) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        }
                    } else if (this.mode == 3) {
                        this.speedFactor = 0.6f;
                        this.modeName = "Write accel. data to FRAM";
                        this.enduranceFRAM = 100000000 - PApplet.parseInt((float)(this.inByteCount * 1.0f * 1.0E9f / 8.988918E8f));
                        this.framSpeed = this.inByteCount * this.speedFactor * 1000.0f / ((float)this.millis() - this.timerStart);
                        this.framSpeed *= 1.4957265f;
                        this.ledIndex = this.inByte[2];
                        if (this.ledIndex < 3 && this.ledIndex >= 0) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = this.ledIndex;
                            while (this.j <= 4) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        } else if (this.ledIndex > 4 && this.ledIndex <= 7) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = 3;
                            while (this.j <= this.ledIndex) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        } else if (this.ledIndex == 52) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.fillRect[3] = this.led;
                            this.fillRect[4] = this.led;
                        }
                    } else if (this.mode == 4) {
                        this.speedFactor = 0.6f;
                        this.modeName = "Write temp. data to FRAM";
                        this.enduranceFRAM = 100000000 - PApplet.parseInt((float)(this.inByteCount * 1.0f * 1.0E9f / 8.988918E8f));
                        this.framSpeed = this.inByteCount * this.speedFactor * 1000.0f / ((float)this.millis() - this.timerStart);
                        this.framSpeed *= 1.3372092f;
                        this.ledIndex = this.inByte[2];
                        if (this.ledIndex < 3 && this.ledIndex >= 0) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = this.ledIndex;
                            while (this.j <= 4) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        } else if (this.ledIndex > 4 && this.ledIndex <= 7) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.j = 3;
                            while (this.j <= this.ledIndex) {
                                this.fillRect[this.j] = this.led;
                                ++this.j;
                            }
                        } else if (this.ledIndex == 52) {
                            this.j = 0;
                            while (this.j <= 7) {
                                this.fillRect[this.j] = 28;
                                ++this.j;
                            }
                            this.fillRect[3] = this.led;
                            this.fillRect[4] = this.led;
                        }
                    }
                    if (this.mode == 85) {
                        this.j = 0;
                        while (this.j <= 7) {
                            this.fillRect[this.j] = 28;
                            ++this.j;
                        }
                    }
                    this.drawMainAppCanvas();
                    this.drawCenterConsole();
                    this.drawSpeedometer();
                    this.textFont(this.fontA, 12.0f);
                }
            }
            this.textAlign(37);
            this.fill(38.0f, 38.0f, 38.0f);
            this.stroke(38.0f, 38.0f, 38.0f);
            this.rect(968.0f, 13.0f, 68.0f, 50.0f);
            this.fill(255);
            this.text(this.frameRate, 968.0f, 23.0f);
            this.text("fps", 1014.0f, 23.0f);
            this.test = this.myPort.available();
            this.text(this.test, 1014.0f, 40.0f);
            this.text("Buffer", 971.0f, 40.0f);
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#D4D0C8", "FRAM_GUI"});
    }
}

