/* --COPYRIGHT--,BSD
 * Copyright (c) $(CPYYEAR), Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/
/*
 *  ======== TMS320F28335.cmd ========
 *  Define the memory block start/length for the F28335
 *
 *! Revision History
 *! ================
 *! 26-May-2011 jv  created to support c28 generic platform.
 */

/* 
 *
 *  Notes: 
 *        Memory blocks on F28335 are uniform (ie same
 *        physical memory) in both PAGE 0 and PAGE 1.  
 *        That is the same memory region should not be
 *        defined for both PAGE 0 and PAGE 1.
 *        Doing so will result in corruption of program 
 *        and/or data. 
 *        
 *        L0/L1/L2 and L3 memory blocks are mirrored - that is
 *        they can be accessed in high memory or low memory.
 *        For simplicity only one instance is used in this
 *        linker file.
 */

MEMORY
{
PAGE 0:    /* Program and Data Memory */
    TFI         : origin = 0x338000, length = 0x7F80       /* first sector on-chip FLASH */
    APP         : origin = 0x300000, length = 0x37F81      /* remaining on chip flash */
    CSM_RSVD    : origin = 0x33FF80, length = 0x000076     /* Program with all 0x0000 when CSM is in use. */
    BEGIN       : origin = 0x33FFF6, length = 0x000002     /* Used for "boot to Flash" bootloader mode. */
    CSM_PWL     : origin = 0x33FFF8, length = 0x000008     /* CSM password locations in FLASH */
    OTP         : origin = 0x380400, length = 0x000400     /* on-chip OTP */
    ADC_CAL     : origin = 0x380080, length = 0x000009     /* ADC_cal function in Reserved memory */
   
    IQTABLES    : origin = 0x3FE000, length = 0x000b50     /* IQ Math Tables in Boot ROM */
    IQTABLES2   : origin = 0x3FEB50, length = 0x00008c     /* IQ Math Tables in Boot ROM */  
    FPUTABLES   : origin = 0x3FEBDC, length = 0x0006A0     /* FPU Tables in Boot ROM */
    ROM         : origin = 0x3FF27C, length = 0x000D44     /* Boot ROM */        
    RESET       : origin = 0x3FFFC0, length = 0x000002     /* part of boot ROM  */
    VECTORS     : origin = 0x3FFFC2, length = 0x00003E     /* part of boot ROM  */

    /*-------------------------------------------------------------------------*/
    /* RAM Ranges                                                              */
    /*-------------------------------------------------------------------------*/

    /* Zero wait state both program and data */
    M01SARAM    : origin = 0x000000, length = 0x000800

    /* Zero wait state for both program and data */
    L03SARAM    : origin = 0x008000, length = 0x004000

    /* Zero wait state for data reads and writes.  */
    /* One wait state for program reads and writes */
    L47SARAM    : origin = 0x00C000, length = 0x004000

 PAGE 1: /* Peripherials */
   DEV_EMU     : origin = 0x000880, length = 0x000180     /* device emulation registers */
   FLASH_REGS  : origin = 0x000A80, length = 0x000060     /* FLASH registers */
   CSM         : origin = 0x000AE0, length = 0x000010     /* code security module registers */
   ADC_MIRROR  : origin = 0x000B00, length = 0x000010     /* ADC Results register mirror */
   XINTF       : origin = 0x000B20, length = 0x000020     /* external interface registers */
   CPU_TIMER0  : origin = 0x000C00, length = 0x000008     /* CPU Timer0 registers */
   CPU_TIMER1  : origin = 0x000C08, length = 0x000008     /* CPU Timer0 registers (CPU Timer1 & Timer2 reserved TI use)*/
   CPU_TIMER2  : origin = 0x000C10, length = 0x000008     /* CPU Timer0 registers (CPU Timer1 & Timer2 reserved TI use)*/
   PIE_CTRL    : origin = 0x000CE0, length = 0x000020     /* PIE control registers */
   DMA         : origin = 0x001000, length = 0x000200     /* DMA registers */
   MCBSPA      : origin = 0x005000, length = 0x000040     /* McBSP-A registers */
   MCBSPB      : origin = 0x005040, length = 0x000040     /* McBSP-B registers */
   ECANA       : origin = 0x006000, length = 0x000040     /* eCAN-A control and status registers */
   ECANA_LAM   : origin = 0x006040, length = 0x000040     /* eCAN-A local acceptance masks */
   ECANA_MOTS  : origin = 0x006080, length = 0x000040     /* eCAN-A message object time stamps */
   ECANA_MOTO  : origin = 0x0060C0, length = 0x000040     /* eCAN-A object time-out registers */
   ECANA_MBOX  : origin = 0x006100, length = 0x000100     /* eCAN-A mailboxes */
   ECANB       : origin = 0x006200, length = 0x000040     /* eCAN-B control and status registers */
   ECANB_LAM   : origin = 0x006240, length = 0x000040     /* eCAN-B local acceptance masks */
   ECANB_MOTS  : origin = 0x006280, length = 0x000040     /* eCAN-B message object time stamps */
   ECANB_MOTO  : origin = 0x0062C0, length = 0x000040     /* eCAN-B object time-out registers */
   ECANB_MBOX  : origin = 0x006300, length = 0x000100     /* eCAN-B mailboxes */
   EPWM1       : origin = 0x006800, length = 0x000022     /* Enhanced PWM 1 registers */
   EPWM2       : origin = 0x006840, length = 0x000022     /* Enhanced PWM 2 registers */
   EPWM3       : origin = 0x006880, length = 0x000022     /* Enhanced PWM 3 registers */
   EPWM4       : origin = 0x0068C0, length = 0x000022     /* Enhanced PWM 4 registers */
   EPWM5       : origin = 0x006900, length = 0x000022     /* Enhanced PWM 5 registers */
   EPWM6       : origin = 0x006940, length = 0x000022     /* Enhanced PWM 6 registers */
   ECAP1       : origin = 0x006A00, length = 0x000020     /* Enhanced Capture 1 registers */
   ECAP2       : origin = 0x006A20, length = 0x000020     /* Enhanced Capture 2 registers */
   ECAP3       : origin = 0x006A40, length = 0x000020     /* Enhanced Capture 3 registers */
   ECAP4       : origin = 0x006A60, length = 0x000020     /* Enhanced Capture 4 registers */
   ECAP5       : origin = 0x006A80, length = 0x000020     /* Enhanced Capture 5 registers */
   ECAP6       : origin = 0x006AA0, length = 0x000020     /* Enhanced Capture 6 registers */
   EQEP1       : origin = 0x006B00, length = 0x000040     /* Enhanced QEP 1 registers */
   EQEP2       : origin = 0x006B40, length = 0x000040     /* Enhanced QEP 2 registers */
   GPIOCTRL    : origin = 0x006F80, length = 0x000040     /* GPIO control registers */
   GPIODAT     : origin = 0x006FC0, length = 0x000020     /* GPIO data registers */
   GPIOINT     : origin = 0x006FE0, length = 0x000020     /* GPIO interrupt/LPM registers */
   SYSTEM      : origin = 0x007010, length = 0x000020     /* System control registers */
   SPIA        : origin = 0x007040, length = 0x000010     /* SPI-A registers */
   SCIA        : origin = 0x007050, length = 0x000010     /* SCI-A registers */
   XINTRUPT    : origin = 0x007070, length = 0x000010     /* external interrupt registers */
   ADC         : origin = 0x007100, length = 0x000020     /* ADC registers */
   SCIB        : origin = 0x007750, length = 0x000010     /* SCI-B registers */
   SCIC        : origin = 0x007770, length = 0x000010     /* SCI-C registers */
   I2CA        : origin = 0x007900, length = 0x000040     /* I2C-A registers */
   CSM_PWL     : origin = 0x33FFF8, length = 0x000008     /* Part of FLASHA.  CSM password locations. */
   PARTID      : origin = 0x380090, length = 0x000001     /* Part ID register location */
}

/*
 *  Allocate sections to memory blocks.
 *  Note:
 *      codestart   user defined section in DSP28_CodeStartBranch.asm
 *                  used to redirect code execution when booting to flash
 */ 
SECTIONS
{
    /* Allocate program areas:                                               */
    .cinit              : > TFI       			    PAGE = 0
    .pinit              : > TFI          			PAGE = 0
    .text               : > TFI      				PAGE = 0
    codestart           : > BEGIN       			PAGE = 0
    csmpasswds          : > CSM_PWL     			PAGE = 0
    csm_rsvd            : > CSM_RSVD    			PAGE = 0
   
    /* Allocate uninitalized data sections:                                  */
    .stack              : > M01SARAM | L47SARAM | L03SARAM  PAGE = 0
    .ebss               : > M01SARAM | L47SARAM | L03SARAM  PAGE = 0
    .esysmem            : > L47SARAM | M01SARAM | L03SARAM  PAGE = 0
    .cio                : > L47SARAM | M01SARAM | L03SARAM  PAGE = 0

    /* Initalized sections go in Flash                                       */
    .econst             : > TFI       				PAGE = 0
    .switch             : > TFI      				PAGE = 0
    .args               : > TFI		       			PAGE = 0

    /*-----------------------------------------------------------------------*/
    /* Peripherials and system control                                       */
    /*-----------------------------------------------------------------------*/

	/*** The PIE Vector table is called PIEVECT by DSP/BIOS ***/
    PieVectTableFile  : > PIEVECT,     PAGE = 1,  TYPE = DSECT

	/*** Peripheral Frame 0 Register Structures ***/
    DevEmuRegsFile    : > DEV_EMU,     PAGE = 1
    FlashRegsFile     : > FLASH_REGS,  PAGE = 1
    CsmRegsFile       : > CSM,         PAGE = 1
    AdcMirrorFile     : > ADC_MIRROR,  PAGE = 1
    XintfRegsFile     : > XINTF,       PAGE = 1
    CpuTimer0RegsFile : > CPU_TIMER0,  PAGE = 1
    CpuTimer1RegsFile : > CPU_TIMER1,  PAGE = 1
    CpuTimer2RegsFile : > CPU_TIMER2,  PAGE = 1
    PieCtrlRegsFile   : > PIE_CTRL,    PAGE = 1
    DmaRegsFile       : > DMA,         PAGE = 1

	/*** Peripheral Frame 3 Register Structures ***/
    McbspaRegsFile    : > MCBSPA,      PAGE = 1
    McbspbRegsFile    : > MCBSPB,      PAGE = 1

	/*** Peripheral Frame 1 Register Structures ***/
    ECanaRegsFile     : > ECANA,       PAGE = 1
    ECanaLAMRegsFile  : > ECANA_LAM    PAGE = 1
    ECanaMboxesFile   : > ECANA_MBOX   PAGE = 1
    ECanaMOTSRegsFile : > ECANA_MOTS   PAGE = 1
    ECanaMOTORegsFile : > ECANA_MOTO   PAGE = 1

	ECanbRegsFile     : > ECANB,       PAGE = 1
    ECanbLAMRegsFile  : > ECANB_LAM    PAGE = 1
    ECanbMboxesFile   : > ECANB_MBOX   PAGE = 1
    ECanbMOTSRegsFile : > ECANB_MOTS   PAGE = 1
    ECanbMOTORegsFile : > ECANB_MOTO   PAGE = 1

	EPwm1RegsFile     : > EPWM1        PAGE = 1
	EPwm2RegsFile     : > EPWM2        PAGE = 1
	EPwm3RegsFile     : > EPWM3        PAGE = 1
	EPwm4RegsFile     : > EPWM4        PAGE = 1
	EPwm5RegsFile     : > EPWM5        PAGE = 1
	EPwm6RegsFile     : > EPWM6        PAGE = 1

	ECap1RegsFile     : > ECAP1        PAGE = 1
	ECap2RegsFile     : > ECAP2        PAGE = 1
	ECap3RegsFile     : > ECAP3        PAGE = 1
	ECap4RegsFile     : > ECAP4        PAGE = 1
	ECap5RegsFile     : > ECAP5        PAGE = 1
	ECap6RegsFile     : > ECAP6        PAGE = 1

	EQep1RegsFile     : > EQEP1        PAGE = 1
	EQep2RegsFile     : > EQEP2        PAGE = 1

	GpioCtrlRegsFile  : > GPIOCTRL     PAGE = 1
	GpioDataRegsFile  : > GPIODAT      PAGE = 1
	GpioIntRegsFile   : > GPIOINT      PAGE = 1

	/*** Peripheral Frame 2 Register Structures ***/
	SysCtrlRegsFile   : > SYSTEM,      PAGE = 1
	SpiaRegsFile      : > SPIA,        PAGE = 1
	SciaRegsFile      : > SCIA,        PAGE = 1
	XIntruptRegsFile  : > XINTRUPT,    PAGE = 1
	AdcRegsFile       : > ADC,         PAGE = 1
	ScibRegsFile      : > SCIB,        PAGE = 1
	ScicRegsFile      : > SCIC,        PAGE = 1
	I2caRegsFile      : > I2CA,        PAGE = 1

	/*** Code Security Module Register Structures ***/
	CsmPwlFile        : > CSM_PWL,     PAGE = 1

	/*** Device Part ID Register Structures ***/
	PartIdRegsFile    : > PARTID,      PAGE = 1

    /*-------------------------------------------------------------------------*/
    /*
     * Sections for placing flash api code in memmory.
	 */
    /*-------------------------------------------------------------------------*/
    FLASH_API:
    {
    	/*
    	 * This says to take take both the code and constants from the TI
    	 * provided Flash28335...lib file and place in this section. Since
    	 * this section is placed in L03 the linker will allocate contingent
    	 * space in L03 for this code and constants. It is up to us to copy
    	 * this content from Flash to ram via.
    	 *
    	 * extern Uint16 FLASH_API_LOADSTART;
		 * extern Uint16 FLASH_API_RUNSTART;
	     * extern Uint16 FLASH_API_LOADSIZE;n
    	 * memcpy(&FLASH_API_RUNSTART, &FLASH_API_LOADSTART, FLASH_API_LOADSIZE);
    	 *
    	 */
        -lFlash28335_API_V210.lib(.econst)
        -lFlash28335_API_V210.lib(.text)
	}
						  /*
						   * Store the code in flash.
						   */
						  LOAD = TFI,    PAGE = 0

						  /*
						   * Allocate space for all data/code assigned to this section in
						   * L03 ram. We will have to copy from flash to this memory range
						   * in code.
						   */
                          RUN  = L03SARAM, PAGE = 0

                          /*
                           * create a variable FLASH_API_LOADSTART which sits
                           * at the start of the FLASH_API section in flash
                           */
                          LOAD_START(_FLASH_API_LOADSTART),

                          /*
                           * create a var FLASH_API_LOADSIZE which is the size
                           * of the FLASH_API section in flash
                           */
                          LOAD_SIZE(_FLASH_API_LOADSIZE),

                          /*
                           * create a var FLASH_API_RUNSTART which sits
                           * at the allocated location in ram for the FLASH_API code.
                           */
                          RUN_START(_FLASH_API_RUNSTART)


    /*-------------------------------------------------------------------------*/
    /*
     * Sections for placing code in memmory for speed reasons as code runs
     * faster out of ram then flash.
	 */
    /*-------------------------------------------------------------------------*/
    FAST_CODE:
    {
    	/*
    	 * You can allocate individual functions in the section with
    	 * #pragma CODE_SECTION(function, "FAST_CODE") or you can allocate whole
    	 * sections of files as such
    	 * -lFlash28335_API_V210.lib(.econst)
         * -lFlash28335_API_V210.lib(.text)
         * for libraries

         * or
         * bearing.obj(.econst)
         * bearing.obj(.text)
         * for compiled sources.
		 *
    	 * At startup it is up to us to copy this content from Flash to ram via.
    	 * extern Uint16 FAST_CODE_LOADSTART;
		 * extern Uint16 FAST_CODE_RUNSTART;
	     * extern Uint16 FAST_CODE_LOADSIZE;n
    	 * memcpy(&FAST_CODE_RUNSTART, &FAST_CODE_LOADSTART, (Uint32)&FAST_CODE_LOADSIZE);
    	 *
    	 * With the variables defined below.
    	 */
	}
						  /*
						   * Store the code in flash.
						   */
						  LOAD = TFI,    PAGE = 0

						  /*
						   * Allocate space for all data/code assigned to this section in
						   * L03 ram or M01 ram. We will have to copy from flash to this
						   * memory range in code.
						   */
                          RUN  = L03SARAM, PAGE = 0

                          /*
                           * create a variable FAST_CODE_LOADSTART which sits
                           * at the start of the FAST_CODE section in flash
                           */
                          LOAD_START(_FAST_CODE_LOADSTART),

                          /*
                           * create a var FAST_CODE_LOADSIZE which is the size
                           * of the FAST_CODE section in flash
                           */
                          LOAD_SIZE(_FAST_CODE_LOADSIZE),

                          /*
                           * create a var FAST_CODE_RUNSTART which sits
                           * at the allocated location in ram for the FAST_CODE code.
                           */
                          RUN_START(_FAST_CODE_RUNSTART)
}
