#include <xdc/std.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>
#include <string.h>
#include "Flash2833x_API_Library.h"
#include "DSP2833x_Device.h"

#pragma CODE_SECTION(flashSetup, "FAST_CODE");
int flashSetup(void)
{
	int result = -1;

	//-------------------------------------------------------------------------
	// unlock code security module
	//-------------------------------------------------------------------------
	EALLOW;
	CsmRegs.KEY0 = 0xFFFF;
	CsmRegs.KEY1 = 0xFFFF;
	CsmRegs.KEY2 = 0xFFFF;
	CsmRegs.KEY3 = 0xFFFF;
	CsmRegs.KEY4 = 0xFFFF;
	CsmRegs.KEY5 = 0xFFFF;
	CsmRegs.KEY6 = 0xFFFF;
	CsmRegs.KEY7 = 0xFFFF;
	EDIS;

	//-------------------------------------------------------------------------
	// confirm unlocked
	//-------------------------------------------------------------------------
	if (CsmRegs.CSMSCR.bit.SECURE == 0)
	{
		// these are both define inside Flash28335_API...lib
		Flash_CPUScaleFactor = SCALE_FACTOR; // Init scale factor
		Flash_CallbackPtr    = NULL;         // init flash callback
		result               = 0;
	}

    //-------------------------------------------------------------------------
    // Copy flash code and constants into ram.
    //-------------------------------------------------------------------------
    {
        extern Uint16 FLASH_API_LOADSTART;
        extern Uint16 FLASH_API_LOADSIZE;
        extern Uint16 FLASH_API_RUNSTART;

        //copy into RAM before Flash operations
        memcpy(&FLASH_API_RUNSTART, &FLASH_API_LOADSTART, FLASH_API_LOADSIZE);
    }

	return result;
}

#pragma CODE_SECTION(testEraseFlashSector, "FAST_CODE");
void testEraseFlashSector(Uint16 sectorMask, char sectorLetter)
{
    FLASH_ST flashStatus;

    if(Flash28335_Erase(sectorMask, &flashStatus) != STATUS_SUCCESS)
    {
    	int x = 0;
    	x++;
    }

}

#pragma CODE_SECTION(flash_unit_test, "FAST_CODE");
int flash_unit_test(void)
{
   if(Flash28335_APIVersionHex() != 0x0210)
   {
       return -1;
   }

   if(Flash28335_APIVersion() != (float32)2.10)
   {
       return -1;
   }

   testEraseFlashSector(SECTORB, 'B');
   testEraseFlashSector(SECTORC, 'C');
   testEraseFlashSector(SECTORD, 'D');
   testEraseFlashSector(SECTORE, 'E');
   testEraseFlashSector(SECTORF, 'F');
   testEraseFlashSector(SECTORG, 'G');
   testEraseFlashSector(SECTORH, 'H');

   return 0;
}

Void main()
{
    BIOS_start();
}

void task(void)
{
	{
		extern Uint16 FAST_CODE_LOADSTART;
		extern Uint16 FAST_CODE_RUNSTART;
		extern Uint16 FAST_CODE_LOADSIZE;
		memcpy(&FAST_CODE_RUNSTART, &FAST_CODE_LOADSTART, FAST_CODE_LOADSIZE);
	}

	flashSetup();
	flash_unit_test();
}
