// Verbesserrungen / Fehler: Classcount = -1 --> Unsigned char
// Interrupts entsprechen nicht der exakten Datenblattbeschreibung
// Schoenheit: Bitmaske bei generischer zuweisung
// Interrupt theoretisch erledigt kommt aber nur 2 mal, naechste Version solls besser machen
// v 0.9 Sehr gute Implementierung, prueft fehler und Sendet durch Interrupts

// eigndlich noch nicht ganz fertig:
// weiteres vorgehen: set Data fllt einen Ringspeicher - entsprechend mit der aktuellen ObjektNr
// der Interrupt-OK Send arbeitet diesen Ringspeicher ab, bis keine Sendenachricht mehr vorhanden ist
// Optimierungspotential : Word anstatt Byte verwenden
// Auto Bus On eingeschaltet - Sendet auch nach dedektierten Fehlern unentlich weiter (Ab und Anstpseln)
// Datentypen alle auf Unsigned Char (Send and Recive)
// v 0.9
#include "cCANBus.h"
#define LAST_CATCHED 0
#define LAST_SENDET 0

#define PENDING_SEND 1
#define PENDING_CHATCH 1

#define ERROR 1
#define ALL_OK 0


//struct cCAN::B1;

Bitfield cCAN::BitfieldMSG;
CAN_DataContainer cCAN::CAN_Message[2];

cCAN::cCAN(void)
{
	EALLOW;  // This is needed to write to EALLOW protected registers (ECAN0ITNA/ECAN1INTA)
	PieVectTable.ECAN0INTA = (PINT) &ecan_Error_isr;
	PieVectTable.ECAN1INTA = (PINT) &ecan_Ok_isr;
	EDIS;    // This is needed to disable write to EALLOW protected registers
	IER |= M_INT9;
	BitfieldMSG.Error = ALL_OK;
	BitfieldMSG.StatusMbox0_Send = LAST_SENDET;
	BitfieldMSG.StatusMbox2_Send = LAST_SENDET;
	BitfieldMSG.StatusMbox1_Recive = LAST_CATCHED;
	BitfieldMSG.StatusMbox3_Recive = LAST_CATCHED;
	
	// 0 Sezen
	ECanaShadow.CANMIM.all = ECanaRegs.CANMIM.all;
	ECanaShadow.CANMIM.all = 0;
	ECanaRegs.CANMIM.all = ECanaShadow.CANMIM.all;
	BitfieldMSG.StatusMbox0_Send = LAST_SENDET;
	// Fehlerbehandlung


}

Uint16 cCAN::init(void)
{

  	EALLOW;
  	ECanaRegs.CANTIOC.bit.TXFUNC = 1;
  	ECanaRegs.CANRIOC.bit.RXFUNC = 1;
  	ECanaRegs.CANMC.bit.SCB = 1;  // HECC mode
  	ECanaRegs.CANMC.bit.ABO = 1;  // Auto Bus On --> Bus off State
 	ECanaRegs.CANME.all = 0;  //disable all mailboxes
  
  // Mailbox-Interrupt
  	ECanaShadow.CANMIM.all = ECanaRegs.CANMIM.all;	
  	ECanaShadow.CANMIM.bit.MIM0  = 1;  // MB#1  Mailbox interrupt is enabled
  	ECanaShadow.CANMIM.bit.MIM1  = 1;  // MB#5  Mailbox interrupt is enabled
  	ECanaShadow.CANMIM.bit.MIM2  = 1;  // MB#5  Mailbox interrupt is enabled
  	ECanaShadow.CANMIM.bit.MIM3  = 1;  // MB#5  Mailbox interrupt is enabled
	ECanaRegs.CANMIM.all = ECanaShadow.CANMIM.all;
  
	// Set Mailbox-Interrupt to line 1 ECanaShadow.CANMIL.bit.MIL0 = 1;
	ECanaShadow.CANMIL.all = ECanaRegs.CANMIL.all;
	ECanaShadow.CANMIL.bit.MIL0  = 1;  // Int.-Level MB#1  -> I1EN
  	ECanaShadow.CANMIL.bit.MIL1  = 1;  // Int.-Level MB#5  -> I1EN
  	ECanaShadow.CANMIL.bit.MIL2  = 1;  // Int.-Level MB#5  -> I1EN
  	ECanaShadow.CANMIL.bit.MIL3  = 1;  // Int.-Level MB#5  -> I1EN
	ECanaRegs.CANMIL.all = ECanaShadow.CANMIL.all;
    
  	ECanaShadow.CANGIM.all = 0;
 	ECanaShadow.CANGIM.bit.I1EN = 1;  // enable I1EN
  	ECanaRegs.CANGIM.all = ECanaShadow.CANGIM.all;

  	EDIS;
   // ----------- use shadow-register -------------------------------
  	ECanaShadow.CANMD.all = ECanaRegs.CANMD.all;
  	ECanaShadow.CANME.all = ECanaRegs.CANME.all;
  
    // MBX0
  	ECanaMboxes.MBOX0.MSGID.all = 0x11;
  	ECanaMboxes.MBOX0.MSGID.bit.IDE = 1;    // Extended Identifier
  	ECanaMboxes.MBOX0.MSGCTRL.all = 0;
  	ECanaMboxes.MBOX2.MSGID.all = 0x12;
  	ECanaMboxes.MBOX2.MSGID.bit.IDE = 1;    // Extended Identifier
  	ECanaMboxes.MBOX2.MSGCTRL.all = 0;
  	ECanaShadow.CANMD.bit.MD0 = 0;          // transmit
  	ECanaShadow.CANMD.bit.MD2 = 0;          // transmit
  	ECanaShadow.CANME.bit.ME0 = 1;          // enable Mailbox #0
  	ECanaShadow.CANME.bit.ME2 = 1;          // enable Mailbox #0

  	// MBX1
  	ECanaMboxes.MBOX1.MSGID.all = 0x31;
  	ECanaMboxes.MBOX1.MSGID.bit.IDE = 1;    // Extended Identifier
  	ECanaMboxes.MBOX3.MSGID.all = 0x32;
  	ECanaMboxes.MBOX3.MSGID.bit.IDE = 1;    // Extended Identifier
  	//ECanaMboxes.MBOX1.MSGID.bit.AME = 1;    // Acceptance Mask enable
  	//ECanaLAMRegs.LAM1.all = 0x00000005;  	  // 0x1100 0000,
  										  // 0x1100 0001
  										  // 0x1100 0004
										  // 0x1100 0005
  	ECanaLAMRegs.LAM1.bit.LAMI = 1;
  	ECanaShadow.CANMD.bit.MD1 = 1;          // receive
  	ECanaShadow.CANMD.bit.MD3 = 1;          // receive
  	ECanaShadow.CANME.bit.ME1 = 1;          // enable Mailbox #1
  	ECanaShadow.CANME.bit.ME3 = 1;          // enable Mailbox #1

  
   // replace shadows in original Regs
  ECanaRegs.CANMD.all = ECanaShadow.CANMD.all;
  ECanaRegs.CANME.all = ECanaShadow.CANME.all;

	// Enable Interrupt line 0 and 1 - send all errors to line 0
		EALLOW;
		ECanaShadow.CANGIM.all = ECanaRegs.CANGIM.all;
		ECanaShadow.CANGIM.bit.AAIM = 1;
		ECanaShadow.CANGIM.bit.WDIM = 1;
		ECanaShadow.CANGIM.bit.WUIM = 1;
		ECanaShadow.CANGIM.bit.BOIM = 1;
		ECanaShadow.CANGIM.bit.EPIM = 1;
		ECanaShadow.CANGIM.bit.GIL = 0;
		ECanaShadow.CANGIM.bit.MTOM = 1;
		ECanaShadow.CANGIM.bit.I1EN = 1;  //Line 1 on
		ECanaShadow.CANGIM.bit.I0EN = 1;  //Line 0 on
		//----
		ECanaShadow.CANGIM.bit.MTOM = 1;
		ECanaShadow.CANGIM.bit.TCOM = 1;
		ECanaShadow.CANGIM.bit.RMLIM = 1;
		ECanaShadow.CANGIM.bit.WLIM = 1;
		
	// -	ECanaShadow.CANGIM.bit.MTOM = 1;
	// -	ECanaShadow.CANGIM.bit.TCOM = 1;
		//ECanaShadow.CANGIM.bit.AAIM = 1;
		//ECanaShadow.CANGIM.bit.WDIM = 1;
	//	ECanaShadow.CANGIM.bit.WUIM = 1;
	// -	ECanaShadow.CANGIM.bit.RMLIM = 1;
	//	ECanaShadow.CANGIM.bit.BOIM = 1;
	//	ECanaShadow.CANGIM.bit.EPIM = 1;
	// 	-   ECanaShadow.CANGIM.bit.WLIM = 1;
	//	ECanaShadow.CANGIM.bit.GIL = 1;
	//	ECanaShadow.CANGIM.bit.I0EN = 1;
	//	ECanaShadow.CANGIM.bit.I1EN = 1;
		ECanaRegs.CANGIM.all = ECanaShadow.CANGIM.all;
		EDIS;
	
	return 0;
}

Uint16 cCAN::sendDataID11(unsigned char Data0,unsigned char Data1,unsigned char Data2,unsigned char Data3,unsigned char Data4,unsigned char Data5,unsigned char Data6,unsigned char Data7)
{
	if(BitfieldMSG.StatusMbox0_Send == LAST_SENDET && BitfieldMSG.Error != ERROR )
	{
		ECanaMboxes.MBOX0.MDL.byte.BYTE0 = Data0;
		ECanaMboxes.MBOX0.MDL.byte.BYTE1 = Data1;
		ECanaMboxes.MBOX0.MDL.byte.BYTE2 = Data2;
		ECanaMboxes.MBOX0.MDL.byte.BYTE3 = Data3;
		ECanaMboxes.MBOX0.MDH.byte.BYTE4 = Data4;
		ECanaMboxes.MBOX0.MDH.byte.BYTE5 = Data5;
		ECanaMboxes.MBOX0.MDH.byte.BYTE6 = Data6;
		ECanaMboxes.MBOX0.MDH.byte.BYTE7 = Data7;
		ECanaMboxes.MBOX0.MSGCTRL.bit.DLC = 8;
		
		ECanaShadow.CANTRS.all = 0;
	    ECanaShadow.CANTRS.bit.TRS0 = 1;
	    ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all;
	    BitfieldMSG.StatusMbox0_Send = PENDING_SEND;
	    return 0;
	}
		return 1;
	
}

Uint16 cCAN::sendDataID12(unsigned char Data0,unsigned char Data1,unsigned char Data2,unsigned char Data3,unsigned char Data4,unsigned char Data5,unsigned char Data6,unsigned char Data7)
{
	if(BitfieldMSG.StatusMbox2_Send == LAST_SENDET && BitfieldMSG.Error != ERROR )
	{
		ECanaMboxes.MBOX2.MDL.byte.BYTE0 = Data0;
		ECanaMboxes.MBOX2.MDL.byte.BYTE1 = Data1;
		ECanaMboxes.MBOX2.MDL.byte.BYTE2 = Data2;
		ECanaMboxes.MBOX2.MDL.byte.BYTE3 = Data3;
		ECanaMboxes.MBOX2.MDH.byte.BYTE4 = Data4;
		ECanaMboxes.MBOX2.MDH.byte.BYTE5 = Data5;
		ECanaMboxes.MBOX2.MDH.byte.BYTE6 = Data6;
		ECanaMboxes.MBOX2.MDH.byte.BYTE7 = Data7;
		ECanaMboxes.MBOX2.MSGCTRL.bit.DLC = 8;
		
		ECanaShadow.CANTRS.all = 0;
	    ECanaShadow.CANTRS.bit.TRS2 = 1;
	    ECanaRegs.CANTRS.all = ECanaShadow.CANTRS.all;
	    BitfieldMSG.StatusMbox2_Send = PENDING_SEND;
	    return 0;
	}
		return 1;
	
}

Uint16 cCAN::RecivedMbox1(void)
{
	if(BitfieldMSG.StatusMbox1_Recive == PENDING_CHATCH)
		return 1;
		
	return 0;
		
	
}

Uint16 cCAN::RecivedMbox3(void)
{
	if(BitfieldMSG.StatusMbox3_Recive == PENDING_CHATCH)
		return 1;
		
	return 0;
		
	
}

void cCAN::ReciveDataID031(unsigned char *Data0,unsigned char *Data1,unsigned char *Data2,unsigned char *Data3,unsigned char *Data4,unsigned char *Data5,unsigned char *Data6,unsigned char *Data7)
{

	*Data0 = CAN_Message[0].Byte0;
	*Data1 = CAN_Message[0].Byte1;
	*Data2 = CAN_Message[0].Byte2;
	*Data3 = CAN_Message[0].Byte3;
	*Data4 = CAN_Message[0].Byte4;
	*Data5 = CAN_Message[0].Byte5;
	*Data6 = CAN_Message[0].Byte6;
	*Data7 = CAN_Message[0].Byte7;
	
	
	
	
	BitfieldMSG.StatusMbox1_Recive = LAST_CATCHED;
}

void cCAN::ReciveDataID032(unsigned char *Data0,unsigned char *Data1,unsigned char *Data2,unsigned char *Data3,unsigned char *Data4,unsigned char *Data5,unsigned char *Data6,unsigned char *Data7)
{

	*Data0 = CAN_Message[1].Byte0;
	*Data1 = CAN_Message[1].Byte1;
	*Data2 = CAN_Message[1].Byte2;
	*Data3 = CAN_Message[1].Byte3;
	*Data4 = CAN_Message[1].Byte4;
	*Data5 = CAN_Message[1].Byte5;
	*Data6 = CAN_Message[1].Byte6;
	*Data7 = CAN_Message[1].Byte7;
	
	
	
	
	BitfieldMSG.StatusMbox3_Recive = LAST_CATCHED;
}

Uint16 cCAN::isCANError(void)
{
	if(BitfieldMSG.Error == ERROR)
	{
		return 1;
	}
	if(BitfieldMSG.Error == ALL_OK)
	{
	return 0;
	}
	return 1;
}

void cCAN::ClearError(void)
{
	BitfieldMSG.Error = ALL_OK;
}
		
void interrupt cCAN::ecan_Ok_isr(void)
{
struct ECAN_REGS ECanaShadow_tmp0;
struct ECAN_REGS ECanaShadow_tmp1;

	char mBoxNr = ECanaRegs.CANGIF1.bit.MIV1;
	//Status = ECanaRegs.CANGIF1.bit.MIV1;
	ECanaShadow_tmp0.CANRMP.all = 0;
	ECanaShadow_tmp0.CANRMP.all = ECanaRegs.CANRMP.all;

	if(ECanaShadow_tmp0.CANRMP.all > 0) // Recive MSG
	{
		if(mBoxNr==1)
		{
			BitfieldMSG.StatusMbox1_Recive = PENDING_CHATCH;
			
			CAN_Message[0].Byte0 = ECanaMboxes.MBOX1.MDL.byte.BYTE0;
			CAN_Message[0].Byte1 = ECanaMboxes.MBOX1.MDL.byte.BYTE1;
			CAN_Message[0].Byte2 = ECanaMboxes.MBOX1.MDL.byte.BYTE2;
			CAN_Message[0].Byte3 = ECanaMboxes.MBOX1.MDL.byte.BYTE3;
			CAN_Message[0].Byte4 = ECanaMboxes.MBOX1.MDH.byte.BYTE4;
			CAN_Message[0].Byte5 = ECanaMboxes.MBOX1.MDH.byte.BYTE5;
			CAN_Message[0].Byte6 = ECanaMboxes.MBOX1.MDH.byte.BYTE6;
			CAN_Message[0].Byte7 = ECanaMboxes.MBOX1.MDH.byte.BYTE7;

			
			ECanaRegs.CANRMP.all = ECanaShadow_tmp0.CANRMP.all; // clear all interrupt flag by writing 1 to corresponding bit
		}
		
		if(mBoxNr==3)
		{
			BitfieldMSG.StatusMbox1_Recive = PENDING_CHATCH;
			
			CAN_Message[1].Byte0 = ECanaMboxes.MBOX3.MDL.byte.BYTE0;
			CAN_Message[1].Byte1 = ECanaMboxes.MBOX3.MDL.byte.BYTE1;
			CAN_Message[1].Byte2 = ECanaMboxes.MBOX3.MDL.byte.BYTE2;
			CAN_Message[1].Byte3 = ECanaMboxes.MBOX3.MDL.byte.BYTE3;
			CAN_Message[1].Byte4 = ECanaMboxes.MBOX3.MDH.byte.BYTE4;
			CAN_Message[1].Byte5 = ECanaMboxes.MBOX3.MDH.byte.BYTE5;
			CAN_Message[1].Byte6 = ECanaMboxes.MBOX3.MDH.byte.BYTE6;
			CAN_Message[1].Byte7 = ECanaMboxes.MBOX3.MDH.byte.BYTE7;

			
			ECanaRegs.CANRMP.all = ECanaShadow_tmp0.CANRMP.all; // clear all interrupt flag by writing 1 to corresponding bit
		}
	}
	else //Send MSG
	{
		if(mBoxNr==0)
		{
			BitfieldMSG.StatusMbox0_Send = LAST_SENDET;
			ECanaShadow_tmp1.CANTA.all = 0;
			ECanaShadow_tmp1.CANTA.bit.TA0 = 1;
			ECanaRegs.CANTA.all = ECanaShadow_tmp1.CANTA.all;
		} 
		
		if(mBoxNr==2)
		{
			BitfieldMSG.StatusMbox2_Send = LAST_SENDET;
			
			ECanaShadow_tmp1.CANTA.all = 0;
			ECanaShadow_tmp1.CANTA.bit.TA2 = 1;
			ECanaRegs.CANTA.all = ECanaShadow_tmp1.CANTA.all;
		} 
	}	
  PieCtrlRegs.PIEACK.bit.ACK9 = 1; 	
}

void interrupt cCAN::ecan_Error_isr(void)
{
//  CAN Erorr
struct ECAN_REGS ECanaShadow_tmp;

	//BitfieldMSG.Error = ERROR;
	//ECanaShadow_tmp.CANRMP.all = 0;
	//ECanaShadow_tmp.CANRMP.all = ECanaRegs.CANRMP.all;
	//ECanaRegs.CANRMP.all = ECanaShadow_tmp.CANRMP.all; // clear all interrupt flag by writing 1 to corresponding bit

	ECanaShadow_tmp.CANES.all = 0;
	ECanaShadow_tmp.CANES.all = ECanaRegs.CANES.all; 	
	ECanaRegs.CANES.all = ECanaShadow_tmp.CANES.all; // clear error flag by writing 1 to corresponding bit

	ECanaShadow_tmp.CANAA.all = 0;
	ECanaShadow_tmp.CANAA.all = ECanaRegs.CANAA.all;
	ECanaRegs.CANAA.all = ECanaShadow_tmp.CANAA.all;

	ECanaShadow_tmp.CANRML.all = 0;
	ECanaShadow_tmp.CANRML.all = ECanaRegs.CANRML.all; 	
	ECanaRegs.CANRML.all = ECanaShadow_tmp.CANRML.all;

	ECanaShadow_tmp.CANGIF0.all = ECanaRegs.CANGIF0.all;
	ECanaShadow_tmp.CANGIF0.all = 0xffffffff;
	ECanaRegs.CANGIF0.all = ECanaShadow_tmp.CANGIF0.all;

	PieCtrlRegs.PIEACK.all|=0x100;      // Issue PIE ACK
}
