#ifndef CCANBUS_H_
#define CCANBUS_H_
#include "DSP28x_Project.h" 

typedef struct  {
	unsigned char StatusMbox0_Send:1;
	unsigned char StatusMbox1_Recive:1;
	unsigned char StatusMbox2_Send:1;
	unsigned char StatusMbox3_Recive:1;
	unsigned char StatusMbox4_Send:1;
	unsigned char StatusMbox5_Recive:1;
	unsigned char StatusMbox6_Send:1;
	unsigned char Error:1;

}Bitfield;
/*
typedef union
{
    struct
    {
        unsigned char Byte0:8;
        unsigned char Byte1:8;
        unsigned char Byte2:8;
        unsigned char Byte3:8;
    } Byte;
    Uint32 lWord;
} DataContainerL;

typedef union 
{
    struct
    {
        unsigned char Byte4:8;
        unsigned char Byte5:8;
        unsigned char Byte6:8;
        unsigned char Byte7:8;
    } Byte;
    Uint32 hWord;
} DataContainerH;

typedef struct 
{
	DataContainerH MDH;
	DataContainerL MDL;
}CAN_DataContainer ;
*/
typedef struct  {
	unsigned char Byte0;
	unsigned char Byte1;
	unsigned char Byte2;
	unsigned char Byte3;
	unsigned char Byte4;
	unsigned char Byte5;
	unsigned char Byte6;
	unsigned char Byte7;
} CAN_DataContainer;	


class cCAN
{
	private:
	
	static Bitfield BitfieldMSG;
	static CAN_DataContainer CAN_Message[2];
	struct ECAN_REGS ECanaShadow;

	 
	static void interrupt ecan_Error_isr(void);
	static void interrupt ecan_Ok_isr(void);
	

//static void interrupt ecap4_isr(void);
	

	public:
	cCAN(void);
	Uint16 init(void);
	

	Uint16 sendDataID11(unsigned char Data0,unsigned char Data1,unsigned char Data2,unsigned char Data3,unsigned char Data4,unsigned char Data5,unsigned char Data6,unsigned char Data7);
	Uint16 sendDataID12(unsigned char Data0,unsigned char Data1,unsigned char Data2,unsigned char Data3,unsigned char Data4,unsigned char Data5,unsigned char Data6,unsigned char Data7);
	Uint16 isCANError(void);
	Uint16 RecivedMbox1(void);
	Uint16 RecivedMbox3(void);
	void ClearError(void);
	void ReciveDataID031(unsigned char *Data0,unsigned char *Data1,unsigned char *Data2,unsigned char *Data3,unsigned char *Data4,unsigned char *Data5,unsigned char *Data6,unsigned char *Data7);
	void ReciveDataID032(unsigned char *Data0,unsigned char *Data1,unsigned char *Data2,unsigned char *Data3,unsigned char *Data4,unsigned char *Data5,unsigned char *Data6,unsigned char *Data7);
	
};

	



#endif /*CCANBUS_H_*/
