//###########################################################################
// Heiko Ruth, Evomotiv GmbH @ 2010, mailto:heiko.ruth@evomotiv.de
// $Release Date: 16.04.2010
// Version 0.9
//---------------------------------------------------------------------------
// Revision Historry, cCAP.cpp:
// Funktionsfhig und getestet
//
// 
// 10.05.2010 Statemashine eingefgt
// 
// 04.02.2011 Funktionsfaehig, Aktualisiert um Ruecklwaertslauf
// 24.02.2011 Zeit zum abarbeiten des gesammten Interrupts ca. 3.5Sec
// 			  verbesserungen vorallem in cHBridge
// 24.02.2011 geschwindigkeit Electric State als signed ? Negative geschwindigkeiten ?
//###########################################################################


#define DEBUG

#include "cQEP.h"
#include "globals.h"


cCAN cQEP::CanBus;
volatile long cQEP::IOPort = 0;
volatile unsigned char cQEP::u8s_State = 0;
volatile unsigned char cQEP::u8s_DutyPower = 127;
volatile BITFILD cQEP::bf_Status;
volatile Uint16 cQEP::ElectricRound = 0;
volatile Uint16 cQEP::ElectricRoundPerSecond = 0;
volatile unsigned char cQEP::sQEP_Direction=0;

cQEP::cQEP(void)
{
   EALLOW;  // This is needed to write to EALLOW protected registers
	PieVectTable.EQEP1_INT = (PINT) &eQEP_ISR;
   EDIS;    // This is needed to disable write to EALLOW protected registers
  // cQEP::pBridge = p;
   cQEP::bf_Status.bit.Update = 0;
   cQEP::bf_Status.bit.IndexOccoured = 0;
   
}



void cQEP::init(void)
{
	

	
	#ifdef DEBUG
	CanBus.init();	
	#endif
	
	#ifdef QEP_ERROR_ON
	EALLOW;
    GpioCtrlRegs.GPAMUX2.bit.GPIO20 = 0;   // catch Inital State A
    GpioCtrlRegs.GPAMUX2.bit.GPIO21 = 0;   // catch Inital State B
    GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 0;   // catch Inital State Strobe
    GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 0;   // catch Inital State Index
    
    InitalState = (GpioDataRegs.GPADAT.all & 0x00f00000)>> 20;
    
    GpioCtrlRegs.GPAMUX2.bit.GPIO20 = 1;   // Configure GPIO20 as EQEP1A
    GpioCtrlRegs.GPAMUX2.bit.GPIO21 = 1;   // Configure GPIO21 as EQEP1B
    GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 1;   // Configure GPIO22 as EQEP1S
    GpioCtrlRegs.GPAMUX2.bit.GPIO23 = 1;   // Configure GPIO23 as EQEP1I
    EDIS;
    #endif
    InitalState = (GpioDataRegs.GPADAT.all & 0x00f00000)>> 20;
    InitEQep1Gpio();
    
    
	
	
	EQep1Regs.QUPRD=150000000;			// Unit Timer for 1Hz at 150 MHz SYSCLKOUT
	EQep1Regs.QEPCTL.bit.UTE=1; 		// Unit Timer Enable
	EQep1Regs.QEPCTL.bit.QCLM=1; 		// Latch on unit time out
	

	EQep1Regs.QDECCTL.bit.QSRC=00;		// 0 = QEP quadrature count mode Quadratur Mode
	
	EQep1Regs.QEPCTL.bit.FREE_SOFT=0x02;	// Debug Mode
	
	EQep1Regs.QEPCTL.bit.PCRM=0x00;		// PCRM=00 mode - QPOSCNT reset on index event
										// PCRM=01 mode - QPOSCNT reset on maximum position
	//Aenderrung
	EQep1Regs.QEPCTL.bit.IEI = 0x00;	//0x02 Initializes the position counter on the rising edge of the QEPI signal (QPOSCNT =
										//0x00 Do nothing
										//0x10 Initializes the position counter on the rising edge of the QEPI signal (QPOSCNT =QPOSINIT)
										//0x11 Initializes the position counter on the falling edge of QEPI signal (QPOSCNT = QPOSINIT)

	
										
	EQep1Regs.QEPCTL.bit.QPEN = 0x01;	//eQEP position counter is enabled
	
	EQep1Regs.QEPCTL.bit.QCLM=1; 		// Latch on unit time out. Position counter, capture timer and capture period values are latched
										// into QPOSLAT, QCTMRLAT and QCPRDLAT registers on unit time out.
	//EQep1Regs.QEPCTL.bit.UTE=1; 		// Unit Timeout Enable 
	EQep1Regs.QPOSCTL.bit.PCE = 1; 		// Enable position compare unit // Achtung kann zum Ausgang werden

	EQep1Regs.QEPCTL.bit.QPEN=1; 		// QEP enable
		
//	EQep1Regs.QCAPCTL.bit.UPPS=5;   	// 1/32 for unit position 
	EQep1Regs.QCAPCTL.bit.CCPS=7;		// 1/128 for CAP clock
	EQep1Regs.QCAPCTL.bit.CEN=1; 		// QEP Capture Enable
	
	EQep1Regs.QPOSINIT = 0;				// Starting at 0
	EQep1Regs.QPOSMAX = 0xb;			// Maximal 12 Zustnde QPOSCMP
	
	EQep1Regs.QEINT.bit.PCM = 1;		// Position-compare match interrupt enable
	EQep1Regs.QEINT.bit.QDC = 1;		// Direction Interrupt Enable
	
	// Fehlerflags
	//EQep1Regs.QEINT.bit.PCO = 1;
	//EQep1Regs.QEINT.bit.PCU = 1;
	EQep1Regs.QEINT.bit.QPE = 1;
	EQep1Regs.QEINT.bit.PCE = 1;
	EQep1Regs.QEINT.bit.UTO = 1;
	// Wertigkeit A(1) B(2)I(4)S(8)
	switch(InitalState) // Table for Version ATMEGA QEP Simulator
	{
		
		case 0x8: EQep1Regs.QPOSCNT = 0x0; break;
		case 0x9: EQep1Regs.QPOSCNT = 0x1; break;
		case 0xB: EQep1Regs.QPOSCNT = 0x2; break;
		case 0x2: EQep1Regs.QPOSCNT = 0x3; break; // OK
		case 0x0: EQep1Regs.QPOSCNT = 0x4; break;
		case 0x5: EQep1Regs.QPOSCNT = 0x5; break;//hier waer 2, wegen Strobe verschoben
		case 0x7: EQep1Regs.QPOSCNT = 0x6; break;
		case 0x6: EQep1Regs.QPOSCNT = 0x7; break;
		case 0x4: EQep1Regs.QPOSCNT = 0x8; break;
		case 0x1: EQep1Regs.QPOSCNT = 0x9; break;
		case 0xA: EQep1Regs.QPOSCNT = 0xb;break;
		case 0x3: EQep1Regs.QPOSCNT = 0xa; break;
		
	}
	u8s_State =  (EQep1Regs.QPOSCNT)%12;
	 	
	/*EQep1Regs.QEINT.bit.PCR = 1;
	EQep1Regs.QEINT.bit.QDC = 1;
	EQep1Regs.QEINT.bit.QPE = 1;
	EQep1Regs.QEINT.bit.PCE = 1;*/


	

    

}

 void interrupt cQEP::eQEP_ISR(void)
{
   #ifdef DEBUG
	GpioDataRegs.GPATOGGLE.bit.GPIO29 = 1;
   #endif
	if(EQep1Regs.QFLG.bit.UTO)						// Unit Time
	{
		if(ElectricRound <= 1) // Motor Stops
			{
				//pBridge->LowSiteShortCirrut();
			}
				
		//GpioDataRegs.GPATOGGLE.bit.GPIO27 = 1;
		EQep1Regs.QCLR.bit.UTO=1;					// Clear interrupt flag
		ElectricRoundPerSecond = ElectricRound;
		ElectricRound = 0;							// Speed: Electric Round per Second
	}

// Direction 
	if(EQep1Regs.QFLG.bit.QDC)
	{	// if DirectionCAN == DirectionWheel
		cQEP::bf_Status.bit.Update = 1;	
		EQep1Regs.QCLR.bit.QDC = 1; 
	}
	
	if(EQep1Regs.QFLG.bit.PCM || cQEP::bf_Status.bit.Update == 1)
	{
		
		switch(EQep1Regs.QEPSTS.bit.QDF) //cQEP::bf_Status.bit.bit0 			// Direction Switch
		{			
			case CCW: 
					if(cQEP::bf_Status.bit.IndexOccoured < 2) // Index wird beim Richtungswechsel falsch (CCW --> 2 Zustaende freuer) Interpretiert --> Index 
					{
						EQep1Regs.QEPCTL.bit.PCRM=0x01; 
					}
					
				u8s_State =  (EQep1Regs.QPOSCNT)%12;
					if(EQep1Regs.QPOSCNT < 0x1)
				{// Neuladen des CMP Registers auf 0xB, bei einer Umdrehung 
					EQep1Regs.QPOSCMP = 0xb; //Achtung verndert
					ElectricRound++;

				}
					else
				{
					EQep1Regs.QPOSCMP = EQep1Regs.QPOSCNT - 1;
				}
				
				break;
			
			case CW: 

					u8s_State =  (EQep1Regs.QPOSCNT)%12;
					if(EQep1Regs.QPOSCNT > 0xa)
				{ // Neuladen des CMP Registers auf 0, bei einer Umdrehung 
					EQep1Regs.QPOSCMP = 0;
					cQEP::bf_Status.bit.IndexOccoured++; //kann man hier electric Round verwenden ?
					EQep1Regs.QEPCTL.bit.PCRM=0x01;
					ElectricRound++;

				}
					else
				{ // Neuladen auf naechsten Wert
					EQep1Regs.QPOSCMP = EQep1Regs.QPOSCNT + 1;

				}
				break;
		}



		EQep1Regs.QCLR.bit.PCM = 1;
		cQEP::bf_Status.bit.Update = 0;

	}
	

		
	
// Errors 
	if(	EQep1Regs.QFLG.bit.PHE || EQep1Regs.QFLG.bit.PCE )
	{
		// TI: Breakpoint A	
		EQep1Regs.QCLR.bit.PHE = 1; // simultaneous transition of QEPA and QEPB
		EQep1Regs.QCLR.bit.PCE = 1; // Position counter error
		
		#ifdef DEBUG
		// just for Debugging on the CAN 
		char ErrorStatusCAN2 = EQep1Regs.QFLG.all & 0xff;
		char ErrorStatusCAN1 = (EQep1Regs.QFLG.all >> 8) & 0xff;
		GpioDataRegs.GPATOGGLE.bit.GPIO28 = 1;
		cQEP::CanBus.sendDataID12(ErrorStatusCAN1,ErrorStatusCAN2,0x33,0x44,0x55,0x66,0x77,0x88);
		#endif
	}

	EQep1Regs.QCLR.bit.INT = 1;
	
   // Acknowledge this interrupt to receive more interrupts from group 5
   PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;
   
 

}	

unsigned char cQEP::getElektricState(void)
{
	return u8s_State;
}


	

void cQEP::setDutyPower(unsigned char DutyPower)
{
	
	
//just react on a Delta of the Values
	if(DutyPower != cQEP::u8s_DutyPower)
	{
		cQEP::u8s_DutyPower = DutyPower; 
	}	
}

Uint16 cQEP::getSpeedElectricRoundPerSecond(void)
{
	return cQEP::ElectricRoundPerSecond;
}

#ifdef TESTBRIDGE
void cQEP::Test(unsigned char BridgeState,unsigned char LowSite)
{
	pBridge->Test(BridgeState,LowSite);
}
#endif //  TESTBRIDGE


