#ifndef CCAP_H_
#define CCAP_H_
#include "DSP28x_Project.h" 
#include "cCANBus.h"

#define CCW 	 0
#define CW  	 1



#define NULL 0

union BITFILD{
    struct BIT{
        unsigned bit0:1;
        unsigned Update:1;
        unsigned IndexOccoured:1;
        unsigned bit3:1;
        unsigned bit4:1;
        unsigned bit5:1;
        unsigned bit6:1;
        unsigned bit7:1;
    } bit;
    unsigned char byte;
};

class cQEP
{
	private:
	
static void interrupt eQEP_ISR(void);
static cCAN CanBus;

static volatile unsigned char sQEP_Direction;
static volatile long IOPort;
static volatile unsigned char u8s_State;
static volatile unsigned char u8s_DutyPower;
static volatile BITFILD bf_Status;
static volatile Uint16 ElectricRound;
static volatile Uint16 ElectricRoundPerSecond;

unsigned char InitalState;

	public:
	cQEP(void);
	void init(void);
	void setDutyPower(unsigned char DutyPower);
	unsigned char getElektricState(void);
	
	void setDirectionClockwise(void);
	void setDirectionCounterClockwise(void);
	Uint16 getSpeedElectricRoundPerSecond(void);
	
	#ifdef TESTBRIDGE
	void Test(unsigned char BridgeState,unsigned char LowSite);
	#endif // TESTBRIDGE
	
};
#endif /*CCAP_H_*/
