//###########################################################################
// Heiko Ruth, Evomotiv GmbH @ 2010, mailto:heiko.ruth@evomotiv.de
// $Release Date: 16.02.2010
// 
//---------------------------------------------------------------------------
// Preufbridge, Richtungswechsel und AD Wandlung
//
// 
//###########################################################################

#include "DSP28x_Project.h" 
#include "globals.h"
#include "cCANBus.h"
#include "cQEP.h"


#define NXP_CANTRANCIVER



void startup(void);

int Fehler=0;
int main(void)
{


	// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2833x_SysCtrl.c file.
	InitSysCtrl();
   
// For this case only init GPIO for eQEP1 and ePWM1
// This function is found in DSP2833x_EQep.c
 	InitEQep1Gpio();
	InitECanaGpio();
   
// fuer NXP CAN Transiver Enable Signal
#ifdef NXP_CANTRANCIVER
	EALLOW;
	GpioCtrlRegs.GPBMUX1.bit.GPIO34 = 0;
	GpioCtrlRegs.GPBDIR.bit.GPIO34 = 1;
	EDIS;
	GpioDataRegs.GPBCLEAR.bit.GPIO34 = 1;
#endif


   InitAdc();         // init the ADC


	
// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
	DINT;

// Initialize the PIE control registers to their default state.
	InitPieCtrl();
   
// Disable CPU interrupts and clear all CPU interrupt flags:
	IER = 0x0000;
	IFR = 0x0000;
   
// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
	InitPieVectTable();

	InitECana();


	PieCtrlRegs.PIEIER5.bit.INTx1 = 1;  // EQEP Interrupt
	PieCtrlRegs.PIEIER1.bit.INTx6 = 1;	// Enable ADCINT in PIE
	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;	// Enable Timer ISR
	PieCtrlRegs.PIEIER9.bit.INTx5 = 1;   // PIE Group 9, TNT1, ECAN0INA
	PieCtrlRegs.PIEIER9.bit.INTx6 = 1;   // PIE Group 9, INT2, ECAN1INA
	PieCtrlRegs.PIECTRL.bit.ENPIE = 1;   // Enable the PIE block
	IER |= M_INT9;
	IER |= M_INT1; // Enable CPU Interrupt 1 (ADC)
	IER |= M_INT5; // Enable CPU Interrupt (EQEP)
	//cHbridge3 Bridge;

	
	cQEP QuadraturBus;
	cCAN CanBus;

	
	CanBus.init();
	QuadraturBus.init();

// Enable global Interrupts and higher priority real-time debug events:
	EINT;   // Enable Global interrupt INTM
	ERTM;   // Enable Global realtime interrupt DBGM
	
//long PortIO = 0x0;
unsigned char Data[8];
unsigned char u8_State = 0;



	while(1)
		{

			u8_State = QuadraturBus.getElektricState();

			CanBus.sendDataID11(u8_State,0x00,0x00,0x00,0x00,0x00,0x00,0x00);

		}
}
	
void startup(void)
{
	EALLOW;
    SysCtrlRegs.HISPCP.all = 0x3; // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 150/(2*3)   = 25.0 MHz
    EDIS;
}	
