/************************************************************************
*
* MODULE: link.cmd.c
*
* OWNER: 
*
* $Revision: 1.3 $
*
* $Date: 2011/02/07 20:36:04 $
*
* $RCSfile: link.cmd,v $
*
* DESCRIPTION: This file controls the linking process.
*
*************************************************************************/



MEMORY {

   PAGE 0: /* program memory */
	
	/* 5510 Memory Map	Byte Addressing (PM)	Word Addressing (DM) */
		/* Internal DARAM:	0x000000 - 0x00ffff		0x000000 - 0x007fff */
		/* Internal SARAM:	0x010000 - 0x04ffff		0x008000 - 0x027fff */
		/* External SDRAM:	0x050000 - 0xffffff		0x028000 - 0x7fffff */
		/* All linker commands are specified using byte addressing */

		MAILBOX:    origin = 0x000100,	len = 0x000400
		VECT:       origin = 0x000500,	len = 0x000100
		TEST:       origin = 0x000600,	len = 0x000100
		DARAM:      origin = 0x000700,	len = 0x00f500
		SDRAM:		origin = 0x800000,	len = 0x00ffb7
		SDRAM_6:	origin = 0x880000,	len = 0x020000
		SDRAM_7:	origin = 0x8a0000,	len = 0x020000
		
} /* MEMORY */


SECTIONS  
{
		

 
	
	.reset_code	  :> DARAM			PAGE 0 /*Matt Bivans said this is removable */
	
	
	
	.const			>> SDRAM_7 |
	                   SDRAM_6		PAGE 0
	.sect_state		:> SDRAM_6	PAGE 0
	.bss			>> SDRAM_6 |
				       SDRAM_7 | 	/* bss in external memory */
				       SDRAM PAGE 0	/* bss in external memory */	

	.vectors 		:>	VECT		PAGE 0	/* Interupt Vector table */
	vectors 		:>	VECT		PAGE 0	/* Interupt Vector table */
	
	.switch			:> SDRAM	PAGE 0	/* Switch statement tables */
	
	.cinit			:> SDRAM_7	PAGE 0	/* Auto-initialization tables */
	
	.pinit			:> SDRAM	PAGE 0	/* Initialization fn tables */
	.text			:> SDRAM	PAGE 0	/* Code */
	

	.ioport			:> 0x0000		PAGE 1
}

								 																
