/*
 *  Copyright 2008 by Spectrum Digital Incorporated.
 *  All rights reserved.  Property of Spectrum Digital Incorporated.
 */

/*
 *  EVMOMAP-L137 Linker command file
 *
 */

//-l rts64plus.lib
//-l ..\..\lib\evmomapl137bsl.lib

-heap  0x10000
-stack 0x1000
--args 0x100

MEMORY
{
    VECS:        o = 0xFFFF0000  l = 0x00000080
    ARMRAM:      o = 0xFFFF0080  l = 0x00001f80
    DSPRAM:      o = 0x11800000  l = 0x00040000
    SHAREDRAM:   o = 0x80000000  l = 0x00020000
    SDRAM:       o = 0xC0000000  l = 0x20000000
}

/* See SPRU187T section 7.1 */

SECTIONS
{
    .text       >   SDRAM

    .blob       >   SDRAM, align=0x1000
    .dllview    >   SDRAM

    .stack      >   SHAREDRAM
    .args       >   SHAREDRAM, align=0x1000

    GROUP
    {
        .neardata   /* Move .bss after .neardata and .rodata.  ELF allows */
        .rodata     /* uninitialized data to follow initialized data in a */
        .bss        /* single segment. This order facilitates a single    */
                    /* segment for the near DP sections.                  */
    }   >SHAREDRAM


    .cinit      >   SHAREDRAM
    .cio        >   SHAREDRAM
    .const      >   SHAREDRAM
    .data       >   SHAREDRAM
    .switch     >   SHAREDRAM
    .sysmem     >   SHAREDRAM
    .far        >   SHAREDRAM
    .fardata    >   SHAREDRAM
    .ppinfo     >   SHAREDRAM
    .ppdata     >   SHAREDRAM, palign(32) /* Work-around kelvin bug */
}
