/**********************************************       
 *      Filename        : Gnss_45nmLink.cmd                       *     
 *  Description         : Linker Command File.    *
 *  Project             : GNSS.                                   *     
 *  Version number      : 0.5                                     *     
 *  Date and time       : 27/09/2010 10:30:00     *     
 **********************************************/

 
/*  PRIMARY STACK SIZE is allocated within int.asm  */
-heap     0x10

/*  SPECIFY THE SYSTEM MEMORY MAP  */
MEMORY
{
        /*  ROM AREA  */
        IROM_VECS                       : origin = 0x00000,  length = 0x00100           /* ROM 0 */     
        IROM                            : origin = 0x00100,  length = 0xC4700           /* ROM 0 - ROM 6 */     

        /*  NON-VOLTILE MEMORY AREA  */ 
        SPL_RECORD          : origin = 0x108000, length = 0x7C    /* RAM 2 */
        GPS_NV_RAM_SHARED_DATA  : origin = 0x10807C, length = 0x7C    /* RAM 2 */
    /* Do not move this section. This is a hard-coded value */
        GNSS_FPU_CTRL                   : origin = 0x1080FC, length = 0x4
    GPS_NV_RAM              : origin = 0x108100, length = 0x7EFF 

        /*  SHARED_BLOCK0 : 64K  RAM AREA */  
        GPS_SRAM_BLOCK0_64K     : origin = 0x110000, length = 0xFFFF   /* RAM 4 - RAM 11 */

        /*  SHARED_BLOCK1 : 48K  RAM AREA */  
        GPS_SRAM_BLOCK1_16K         : origin = 0x120000, length = 0x3FFF   /* RAM 12 - RAM 17 */ 
        GPS_SRAM_BLOCK1_08K         : origin = 0x124000, length = 0x1FFF   /* RAM 18 - RAM 19 */
        GPS_SRAM_BLOCK1_24K         : origin = 0x126000, length = 0x5FFF   /* RAM 18 - RAM 19 */
        
        /*  EXCLUSIVE_ARM  : 100K  RAM AREA */ 
        GPS_RAM_ACTIVE         : origin = 0x12C000, length = 0x18F13  /* RAM 18 - RAM 26 */ 
        RAM_VECS               : origin = 0x144F14, length = 0x28     /* RAM 26 */ 
        XDUMP_BUFFER           : origin = 0x144F3C, length = 0xC4     /*RAM 26 */ 

                
        /*  PATCH BLK AREA  */
        PATCH_BLK1                      : origin = 0x100000, length = 0x4000            /* RAM 0 */
        PATCH_BLK2                      : origin = 0x104000, length = 0x35D0            /* RAM 1 */
        PATCH_BLK2_GEOFENCE : origin = 0x1075D0, length = 0x0A30                /* RAM 1 */
        
        
        /*  DMA BUFFER  */              
        GPS_RAM_DMA                     : origin = 0x404000, length = 0x1700    /*0x2000*/
}

/* SPECIFY THE SECTIONS ALLOCATION INTO MEMORY */
SECTIONS
{
        /*  ROM area members  */
        ROMVectors              > IROM_VECS
        ROMbuildInfo    > IROM_VECS
        RamVectors              : load > IROM_VECS, run = RAM_VECS
        CInt01                  : load = 0x100                                                          /* _C_INT01                                     */
        .text                   > IROM                                                                          /* CODE                                                 */      
        .const                  > IROM                                                                          /* CONSTANT RAM                                 */
        .cinit                  > IROM                                                                          /* INITIALIZATION TABLES                */
        .data                   > GPS_RAM_ACTIVE                                                        /* INITIALIZED RAM                              */
        JumpTable               : load >IROM , run = GPS_RAM_ACTIVE, START(_pJmpTabLoadAddr)
                        
        /* RAM area members*/
        sharedData:{
                                _sharedDataStartAddress = .;
                           } > GPS_NV_RAM_SHARED_DATA
        outsec    :{
                                _splRecordStartAddress = .;
                           } >SPL_RECORD
                           
        fpu_rts  :{
                                _fpu_rts_redirection=.;
                           }>GNSS_FPU_CTRL                 
                           
        xdumpBuffer     > XDUMP_BUFFER
        .flash                  > GPS_RAM_ACTIVE
        .stack                  > GPS_NV_RAM                                                    /* PRIMARY SYSTEM STACK                 */      
        RamCode                 : load >IROM , run = GPS_RAM_ACTIVE, align 0x4 START(_pRamCodeLoadAddr), SIZE(_pRamCodeSize), RUN_START(_pRamCodeRunAddr)
        NAVRAMCode              : load >IROM , run = GPS_NV_RAM, align 0x4 START(_pNVRamCodeLoadAddr), SIZE(_pNVRamCodeSize), RUN_START(_pNVRamCodeRunAddr)
        
        /* GLOBAL & STATIC VARS for OS, Frequently accessed variables */
        GROUP
        {
                /* comprises of MC, CC variables */
                RamActiveBlk    : {}                                                    /* OS and RTS lib variables     */
                .bss            : {}  
                .bss_mc_search  : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\mc\Build_45NM\mc_searchengine.obj(.bss)}                
                .bss_nf_KF : {C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\nf\Build_45NM\nf_kalmanfilter.obj (.bss)}
                .bss_nf_Sensor : {C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\nf\Build_45NM\nf_sensor.obj (.bss)}
                Slp_var :{}
                .bss_nf : {C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\nf\Build_45NM\nf.lib(.bss)} 
                BitEdgeGlobal   :  {} /* Bit egde global vars NBP & WBP sums for all SVs */
        } run = GPS_RAM_ACTIVE align 0x4, START(_pRamActiveBlkStartAddr), END(_pRamActiveBlkEndAddr)    
        
    GROUP
        {
        UNION 
        {
                CWScratchPad: {}
                ClosedLoopScratchPad: {}
                TcxoDriftReportScratchPad: {}
        }
        }run = GPS_SRAM_BLOCK1_24K align 0x4, START(_pSRamStartAddrBlock1_32k), END(_pSRamEndAddrBlock1_32k)
        GROUP
        {               
                        RamSwBuffer             : {}
                        .bss_pmatch : {C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\mc\Build_45NM\mc_pmatch.obj (.bss)}       
                        .bss_lp         : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\lp\Build_45NM\lp.lib(.bss)}
                        I2c2_Sensor : {}        
                        
           }run = GPS_SRAM_BLOCK1_16K align 0x4, START(_pSRamStartAddrBlock1_16k), END(_pSRamEndAddrBlock1_16k)
        

        GROUP
        {       

                .bss_cc_task    : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\cc\Build_45NM\cc_task.obj(.bss)}
                
                .bss_cd         : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\cd\Build_45NM\cd.lib(.bss)}     
                
          
        }run = GPS_SRAM_BLOCK0_64K align 0x4, START(_pSRamStartAddrBlock0), END(_pSRamEndAddrBlock0)
                  
        GROUP
        {       
                .bss_ai         : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\ai2\Build_45NM\ai_NoChksum.lib(.bss)}
                .bss_mc         : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\mc\Build_45NM\mc.lib(.bss)}
                .bss_libs       : { C:\GNSS_45nm\Private\source\product\ti\GPS_ROM\projectfiles\libs\Build_45NM\libs.lib(.bss)}         
  
                RamNvs                  : {}                    
                RamCCWaasBuff   : {}
        RamInCohLog             : {}
        RamCarrPhase    : {}
                
        }run = GPS_NV_RAM align 0x4, START(_pNvRamStartAddr), END(_pNvRamEndAddr)

        
        /*  16 KB Patch block 1  */
        patchsec: load > PATCH_BLK1, START(_p_PatchAreaStartAddress), SIZE(_pPatchBlk1Size) 


        /*  Geofence data stored at the end of the patch blk2  */
        GROUP
        {
                GeofenceData    : {}
        } run = PATCH_BLK2_GEOFENCE align 0x4, START(_pPatchBlk2GeofenceStartAddr), SIZE(_pPatchBlk2GeofenceSize)


       GROUP
        {       
                dummy_section :{}               
                
        }run = GPS_SRAM_BLOCK1_08K align 0x4, START(_pSRamStartAddrBlock1_8k), END(_pSRamEndAddrBlock1_8k)

        

        DmaSwBuffer             > GPS_RAM_DMA
        Mailboxdata     > GPS_RAM_ACTIVE align 0x4
        SlideBufferArea > GPS_SRAM_BLOCK1_16K align 0x4
        WAASSvParameterArea > GPS_SRAM_BLOCK1_16K align 0x4
        .sysmem                 > GPS_RAM_ACTIVE                        /* DYNAMIC MEMORY ALLOCATION AREA  */
   
}