/* segmentation fault code snippet */

struct module_1_params {
    int   param1;
};

struct cfg {
    int   module_id;
    int   param_length;
    void  *param;
};

#define MODULE_1                0x01
#define MODULE_2                0x02
#define MODULE_3                0x03


  
static struct cfg   config[] =  
{
    // the first definition makes the segmentation fault. Comment it and everything is fine.
    { .module_id    = MODULE_1, 
      .param_length = sizeof(struct module_1_params), 
      .param        = (struct module_1_params []){{.param1=1}} 
    }, 

    { .module_id    = MODULE_2, 
      .param_length = 5,
      .param        = (int[]){0,1,2,3,4} 
    },                                          

    { .module_id    = MODULE_3, 
      .param_length = 2,
      .param        = (int[]){0,1} 
    }                                            

};                            


struct cfg *get_config()
{
    // tell the compiler that config[] is used
    return config;
}

// comment out the get_config() function then no segmentation fault is shown.

