/**
 *  \file   mmcsd.c
 *
 *  \brief  This file contains the board specific code for enabling the use of
 *          mmcsd card driver.
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED */

/* HW Macros */
#include "hw_types.h"

/* System Defines */
#include "evmOMAPL138.h"
#include "soc_OMAPL138.h"
#include "hw_syscfg0_OMAPL138.h"

/******************************************************************************
**                      INTERNAL MACRO DEFINITIONS
*******************************************************************************/

/*
** Pin Multiplexing masks for the mandatory pins to be used to operate
** MMCSD0.
*/

#define PINMUX10_MMCSD0_CLK_ENABLE    (SYSCFG_PINMUX10_PINMUX10_3_0_MMCSD0_CLK << \
                                       SYSCFG_PINMUX10_PINMUX10_3_0_SHIFT)

#define PINMUX10_MMCSD0_CMD_ENABLE    (SYSCFG_PINMUX10_PINMUX10_7_4_MMCSD0_CMD << \
                                       SYSCFG_PINMUX10_PINMUX10_7_4_SHIFT)

#define PINMUX10_MMCSD0_DAT0_ENABLE    (SYSCFG_PINMUX10_PINMUX10_11_8_MMCSD0_DAT0 << \
                                       SYSCFG_PINMUX10_PINMUX10_11_8_SHIFT)

#define PINMUX10_MMCSD0_DAT1_ENABLE    (SYSCFG_PINMUX10_PINMUX10_15_12_MMCSD0_DAT1 << \
                                       SYSCFG_PINMUX10_PINMUX10_15_12_SHIFT)

#define PINMUX10_MMCSD0_DAT2_ENABLE    (SYSCFG_PINMUX10_PINMUX10_19_16_MMCSD0_DAT2 << \
                                       SYSCFG_PINMUX10_PINMUX10_19_16_SHIFT)

#define PINMUX10_MMCSD0_DAT3_ENABLE    (SYSCFG_PINMUX10_PINMUX10_23_20_MMCSD0_DAT3 << \
                                       SYSCFG_PINMUX10_PINMUX10_23_20_SHIFT)


/******************************************************************************
**                          FUNCTION DEFINITIONS
*******************************************************************************/

/**
 * \brief   This function selects the MMCSD0 pins for use. The MMCSD0 pins
 *          are multiplexed with pins of other peripherals in the
 *          System on Chip(SoC).
 *
 * \param   None.
 *
 * \return  None.
 *
 *
 */

void MMCSD0PinMuxSetup(void)
{
    unsigned int savePinMux = 0;

    /*
    ** Clearing the bits in context and retaining the other bit values
    ** of PINMUX10 register.
    */
    savePinMux = HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(10)) & \
                       ~(SYSCFG_PINMUX10_PINMUX10_3_0 | \
                         SYSCFG_PINMUX10_PINMUX10_7_4 | \
                         SYSCFG_PINMUX10_PINMUX10_11_8 | \
                         SYSCFG_PINMUX10_PINMUX10_15_12 | \
                         SYSCFG_PINMUX10_PINMUX10_19_16 | \
                         SYSCFG_PINMUX10_PINMUX10_23_20);

    /*
    ** Performing the actual Pin Multiplexing to select mandatory pins in
    ** PINMUX10  register.
    */
    HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(10)) = \
    		(PINMUX10_MMCSD0_CLK_ENABLE |  PINMUX10_MMCSD0_CMD_ENABLE |\
        	PINMUX10_MMCSD0_DAT0_ENABLE | PINMUX10_MMCSD0_DAT1_ENABLE |\
        	PINMUX10_MMCSD0_DAT2_ENABLE | PINMUX10_MMCSD0_DAT3_ENABLE |\
        	savePinMux);
}

/****************************** End Of File ***********************************/
