#ifndef _CSLR_EHRPWM_H_
#define _CSLR_EHRPWM_H_

#include <csl/cslr.h>
#include "tistdtypes.h"

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint16 TBCTL;
    volatile Uint16 TBSTS;
    volatile Uint16 TBPHSHR;
    volatile Uint16 TBPHS;
    volatile Uint16 TBCTR;
    volatile Uint16 TBPRD;
    volatile Uint8 RSVD0[2];
    volatile Uint16 CMPCTL;
    volatile Uint16 CMPAHR;
    volatile Uint16 CMPA;
    volatile Uint16 CMPB;
    volatile Uint16 AQCTLA;
    volatile Uint16 AQCTLB;
    volatile Uint16 AQSFRC;
    volatile Uint16 AQCSFRC;
    volatile Uint16 DBCTL;
    volatile Uint16 DBRED;
    volatile Uint16 DBFED;
    volatile Uint16 TZSEL;
    volatile Uint8 RSVD1[2];
    volatile Uint16 TZCTL;
    volatile Uint16 TZEINT;
    volatile Uint16 TZFLG;
    volatile Uint16 TZCLR;
    volatile Uint16 TZFRC;
    volatile Uint16 ETSEL;
    volatile Uint16 ETPS;
    volatile Uint16 ETFLG;
    volatile Uint16 ETCLR;
    volatile Uint16 ETFRC;
    volatile Uint16 PCCTL;
    volatile Uint8 RSVD2[30];
    volatile Uint32 REVID;
    volatile Uint8 RSVD3[4064];
    volatile Uint16 HRCTL;
} CSL_EhrpwmRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_EhrpwmRegs         *CSL_EhrpwmRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TBCTL */

#define CSL_EHRPWM_TBCTL_FREE_SOFT_MASK  (0xC000u)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_SHIFT (0x000Eu)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_STOPNEXT (0x0000u)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_STOPONFULLCYCLE (0x0001u)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_RUNFREE (0x0002u)
#define CSL_EHRPWM_TBCTL_FREE_SOFT_RUNFREE (0x0003u)

#define CSL_EHRPWM_TBCTL_PHSDIR_MASK     (0x2000u)
#define CSL_EHRPWM_TBCTL_PHSDIR_SHIFT    (0x000Du)
#define CSL_EHRPWM_TBCTL_PHSDIR_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBCTL_PHSDIR_DOWN     (0x0000u)
#define CSL_EHRPWM_TBCTL_PHSDIR_UP       (0x0001u)

#define CSL_EHRPWM_TBCTL_CLKDIV_MASK     (0x1C00u)
#define CSL_EHRPWM_TBCTL_CLKDIV_SHIFT    (0x000Au)
#define CSL_EHRPWM_TBCTL_CLKDIV_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY1   (0x0000u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY2   (0x0001u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY4   (0x0002u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY8   (0x0003u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY16  (0x0004u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY32  (0x0005u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY64  (0x0006u)
#define CSL_EHRPWM_TBCTL_CLKDIV_DIVBY128 (0x0007u)

#define CSL_EHRPWM_TBCTL_HSPCLKDIV_MASK  (0x0380u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_SHIFT (0x0007u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_RESETVAL (0x0001u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY1 (0x0000u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY2 (0x0001u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY4 (0x0002u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY6 (0x0003u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY8 (0x0004u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY10 (0x0005u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY10 (0x0006u)
#define CSL_EHRPWM_TBCTL_HSPCLKDIV_DIVBY14 (0x0007u)

#define CSL_EHRPWM_TBCTL_SWFSYNC_MASK    (0x0040u)
#define CSL_EHRPWM_TBCTL_SWFSYNC_SHIFT   (0x0006u)
#define CSL_EHRPWM_TBCTL_SWFSYNC_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBCTL_SWFSYNC_NOEFFECT (0x0000u)
#define CSL_EHRPWM_TBCTL_SWFSYNC_SYNCPULSE (0x0001u)

#define CSL_EHRPWM_TBCTL_SYNCOSEL_MASK   (0x0030u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_SHIFT  (0x0004u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_EPWMXSYNCI (0x0000u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_TBCTRZERO (0x0001u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_TBCTRCMPB (0x0002u)
#define CSL_EHRPWM_TBCTL_SYNCOSEL_DISABLE (0x0003u)

#define CSL_EHRPWM_TBCTL_PRDLD_MASK      (0x0008u)
#define CSL_EHRPWM_TBCTL_PRDLD_SHIFT     (0x0003u)
#define CSL_EHRPWM_TBCTL_PRDLD_RESETVAL  (0x0000u)
#define CSL_EHRPWM_TBCTL_PRDLD_FROMSHADOW (0x0000u)
#define CSL_EHRPWM_TBCTL_PRDLD_NOSHADOW  (0x0001u)

#define CSL_EHRPWM_TBCTL_PHSEN_MASK      (0x0004u)
#define CSL_EHRPWM_TBCTL_PHSEN_SHIFT     (0x0002u)
#define CSL_EHRPWM_TBCTL_PHSEN_RESETVAL  (0x0000u)
#define CSL_EHRPWM_TBCTL_PHSEN_DISABLE   (0x0000u)
#define CSL_EHRPWM_TBCTL_PHSEN_ENABLE    (0x0001u)

#define CSL_EHRPWM_TBCTL_CTRMODE_MASK    (0x0003u)
#define CSL_EHRPWM_TBCTL_CTRMODE_SHIFT   (0x0000u)
#define CSL_EHRPWM_TBCTL_CTRMODE_RESETVAL (0x0003u)
#define CSL_EHRPWM_TBCTL_CTRMODE_UP      (0x0000u)
#define CSL_EHRPWM_TBCTL_CTRMODE_DOWN    (0x0001u)
#define CSL_EHRPWM_TBCTL_CTRMODE_UPDOWN  (0x0002u)
#define CSL_EHRPWM_TBCTL_CTRMODE_STOPFREEZE (0x0003u)

#define CSL_EHRPWM_TBCTL_RESETVAL        (0x0083u)

/* TBSTS */


#define CSL_EHRPWM_TBSTS_CTRMAX_MASK     (0x0004u)
#define CSL_EHRPWM_TBSTS_CTRMAX_SHIFT    (0x0002u)
#define CSL_EHRPWM_TBSTS_CTRMAX_RESETVAL (0x0000u)
#define CSL_EHRPWM_TBSTS_CTRMAX_NOEFFECT (0x0000u)
#define CSL_EHRPWM_TBSTS_CTRMAX_CLEAR    (0x0001u)

#define CSL_EHRPWM_TBSTS_SYNCI_MASK      (0x0002u)
#define CSL_EHRPWM_TBSTS_SYNCI_SHIFT     (0x0001u)
#define CSL_EHRPWM_TBSTS_SYNCI_RESETVAL  (0x0000u)
#define CSL_EHRPWM_TBSTS_SYNCI_NOEFFECT  (0x0000u)
#define CSL_EHRPWM_TBSTS_SYNCI_CLEAR     (0x0001u)

#define CSL_EHRPWM_TBSTS_CTRDIR_MASK     (0x0001u)
#define CSL_EHRPWM_TBSTS_CTRDIR_SHIFT    (0x0000u)
#define CSL_EHRPWM_TBSTS_CTRDIR_RESETVAL (0x0001u)
#define CSL_EHRPWM_TBSTS_CTRDIR_DOWN     (0x0000u)
#define CSL_EHRPWM_TBSTS_CTRDIR_UP       (0x0001u)

#define CSL_EHRPWM_TBSTS_RESETVAL        (0x0001u)

/* TBPHSHR */

#define CSL_EHRPWM_TBPHSHR_TBPHSHR_MASK  (0xFF00u)
#define CSL_EHRPWM_TBPHSHR_TBPHSHR_SHIFT (0x0008u)
#define CSL_EHRPWM_TBPHSHR_TBPHSHR_RESETVAL (0x0000u)


#define CSL_EHRPWM_TBPHSHR_RESETVAL      (0x0000u)

/* TBPHS */

#define CSL_EHRPWM_TBPHS_TBPHS_MASK      (0xFFFFu)
#define CSL_EHRPWM_TBPHS_TBPHS_SHIFT     (0x0000u)
#define CSL_EHRPWM_TBPHS_TBPHS_RESETVAL  (0x0000u)

#define CSL_EHRPWM_TBPHS_RESETVAL        (0x0000u)

/* TBCTR */

#define CSL_EHRPWM_TBCTR_TBCTR_MASK      (0xFFFFu)
#define CSL_EHRPWM_TBCTR_TBCTR_SHIFT     (0x0000u)
#define CSL_EHRPWM_TBCTR_TBCTR_RESETVAL  (0x0000u)

#define CSL_EHRPWM_TBCTR_RESETVAL        (0x0000u)

/* TBPRD */

#define CSL_EHRPWM_TBPRD_TBPRD_MASK      (0xFFFFu)
#define CSL_EHRPWM_TBPRD_TBPRD_SHIFT     (0x0000u)
#define CSL_EHRPWM_TBPRD_TBPRD_RESETVAL  (0x0000u)

#define CSL_EHRPWM_TBPRD_RESETVAL        (0x0000u)

/* CMPCTL */


#define CSL_EHRPWM_CMPCTL_SHDWBFULL_MASK (0x0200u)
#define CSL_EHRPWM_CMPCTL_SHDWBFULL_SHIFT (0x0009u)
#define CSL_EHRPWM_CMPCTL_SHDWBFULL_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWBFULL_NOTFULL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWBFULL_FULL (0x0001u)

#define CSL_EHRPWM_CMPCTL_SHDWAFULL_MASK (0x0100u)
#define CSL_EHRPWM_CMPCTL_SHDWAFULL_SHIFT (0x0008u)
#define CSL_EHRPWM_CMPCTL_SHDWAFULL_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWAFULL_NOTFULL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWAFULL_FULL (0x0001u)


#define CSL_EHRPWM_CMPCTL_SHDWBMODE_MASK (0x0040u)
#define CSL_EHRPWM_CMPCTL_SHDWBMODE_SHIFT (0x0006u)
#define CSL_EHRPWM_CMPCTL_SHDWBMODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWBMODE_SHADOW (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWBMODE_IMMEDIATE (0x0001u)


#define CSL_EHRPWM_CMPCTL_SHDWAMODE_MASK (0x0010u)
#define CSL_EHRPWM_CMPCTL_SHDWAMODE_SHIFT (0x0004u)
#define CSL_EHRPWM_CMPCTL_SHDWAMODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWAMODE_SHADOW (0x0000u)
#define CSL_EHRPWM_CMPCTL_SHDWAMODE_IMMEDIATE (0x0001u)

#define CSL_EHRPWM_CMPCTL_LOADBMODE_MASK (0x000Cu)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_SHIFT (0x0002u)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_TBCTRZERO (0x0000u)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_TBCTRPRD (0x0001u)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_ZEROORPRD (0x0002u)
#define CSL_EHRPWM_CMPCTL_LOADBMODE_FREEZE (0x0003u)

#define CSL_EHRPWM_CMPCTL_LOADAMODE_MASK (0x0003u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_SHIFT (0x0000u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_TBCTRZERO (0x0000u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_TBCTRPRD (0x0001u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_ZEROORPRD (0x0002u)
#define CSL_EHRPWM_CMPCTL_LOADAMODE_FREEZE (0x0003u)

#define CSL_EHRPWM_CMPCTL_RESETVAL       (0x0000u)

/* CMPAHR */

#define CSL_EHRPWM_CMPAHR_CMPAHR_MASK    (0xFF00u)
#define CSL_EHRPWM_CMPAHR_CMPAHR_SHIFT   (0x0008u)
#define CSL_EHRPWM_CMPAHR_CMPAHR_RESETVAL (0x0000u)


#define CSL_EHRPWM_CMPAHR_RESETVAL       (0x0000u)

/* CMPA */

#define CSL_EHRPWM_CMPA_CMPA_MASK        (0xFFFFu)
#define CSL_EHRPWM_CMPA_CMPA_SHIFT       (0x0000u)
#define CSL_EHRPWM_CMPA_CMPA_RESETVAL    (0x0000u)

#define CSL_EHRPWM_CMPA_RESETVAL         (0x0000u)

/* CMPB */

#define CSL_EHRPWM_CMPB_CMPB_MASK        (0xFFFFu)
#define CSL_EHRPWM_CMPB_CMPB_SHIFT       (0x0000u)
#define CSL_EHRPWM_CMPB_CMPB_RESETVAL    (0x0000u)

#define CSL_EHRPWM_CMPB_RESETVAL         (0x0000u)

/* AQCTLA */


#define CSL_EHRPWM_AQCTLA_CBD_MASK       (0x0C00u)
#define CSL_EHRPWM_AQCTLA_CBD_SHIFT      (0x000Au)
#define CSL_EHRPWM_AQCTLA_CBD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_CBD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_CBD_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_CBD_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_CBD_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_CBU_MASK       (0x0300u)
#define CSL_EHRPWM_AQCTLA_CBU_SHIFT      (0x0008u)
#define CSL_EHRPWM_AQCTLA_CBU_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_CBU_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_CBU_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_CBU_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_CBU_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_CAD_MASK       (0x00C0u)
#define CSL_EHRPWM_AQCTLA_CAD_SHIFT      (0x0006u)
#define CSL_EHRPWM_AQCTLA_CAD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_CAD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_CAD_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_CAD_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_CAD_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_CAU_MASK       (0x0030u)
#define CSL_EHRPWM_AQCTLA_CAU_SHIFT      (0x0004u)
#define CSL_EHRPWM_AQCTLA_CAU_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_CAU_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_CAU_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_CAU_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_CAU_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_PRD_MASK       (0x000Cu)
#define CSL_EHRPWM_AQCTLA_PRD_SHIFT      (0x0002u)
#define CSL_EHRPWM_AQCTLA_PRD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_PRD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_PRD_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_PRD_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_PRD_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_ZRO_MASK       (0x0003u)
#define CSL_EHRPWM_AQCTLA_ZRO_SHIFT      (0x0000u)
#define CSL_EHRPWM_AQCTLA_ZRO_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLA_ZRO_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLA_ZRO_EPWMXALOW  (0x0001u)
#define CSL_EHRPWM_AQCTLA_ZRO_EPWMXAHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLA_ZRO_EPWMXATOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLA_RESETVAL       (0x0000u)

/* AQCTLB */


#define CSL_EHRPWM_AQCTLB_CBD_MASK       (0x0C00u)
#define CSL_EHRPWM_AQCTLB_CBD_SHIFT      (0x000Au)
#define CSL_EHRPWM_AQCTLB_CBD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_CBD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_CBD_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_CBD_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_CBD_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_CBU_MASK       (0x0300u)
#define CSL_EHRPWM_AQCTLB_CBU_SHIFT      (0x0008u)
#define CSL_EHRPWM_AQCTLB_CBU_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_CBU_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_CBU_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_CBU_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_CBU_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_CAD_MASK       (0x00C0u)
#define CSL_EHRPWM_AQCTLB_CAD_SHIFT      (0x0006u)
#define CSL_EHRPWM_AQCTLB_CAD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_CAD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_CAD_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_CAD_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_CAD_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_CAU_MASK       (0x0030u)
#define CSL_EHRPWM_AQCTLB_CAU_SHIFT      (0x0004u)
#define CSL_EHRPWM_AQCTLB_CAU_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_CAU_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_CAU_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_CAU_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_CAU_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_PRD_MASK       (0x000Cu)
#define CSL_EHRPWM_AQCTLB_PRD_SHIFT      (0x0002u)
#define CSL_EHRPWM_AQCTLB_PRD_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_PRD_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_PRD_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_PRD_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_PRD_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_ZRO_MASK       (0x0003u)
#define CSL_EHRPWM_AQCTLB_ZRO_SHIFT      (0x0000u)
#define CSL_EHRPWM_AQCTLB_ZRO_RESETVAL   (0x0000u)
#define CSL_EHRPWM_AQCTLB_ZRO_DONOTHING  (0x0000u)
#define CSL_EHRPWM_AQCTLB_ZRO_EPWMXBLOW  (0x0001u)
#define CSL_EHRPWM_AQCTLB_ZRO_EPWMXBHIGH (0x0002u)
#define CSL_EHRPWM_AQCTLB_ZRO_EPWMXBTOGGLE (0x0003u)

#define CSL_EHRPWM_AQCTLB_RESETVAL       (0x0000u)

/* AQSFRC */


#define CSL_EHRPWM_AQSFRC_RLDCSF_MASK    (0x00C0u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_SHIFT   (0x0006u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_EVTCTRZERO (0x0000u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_EVTCTRPRD (0x0001u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_ZEROORPRD (0x0002u)
#define CSL_EHRPWM_AQSFRC_RLDCSF_IMMEDIATE (0x0003u)

#define CSL_EHRPWM_AQSFRC_OTSFB_MASK     (0x0020u)
#define CSL_EHRPWM_AQSFRC_OTSFB_SHIFT    (0x0005u)
#define CSL_EHRPWM_AQSFRC_OTSFB_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQSFRC_OTSFB_NOEFFECT (0x0000u)
#define CSL_EHRPWM_AQSFRC_OTSFB_EVENT    (0x0001u)

#define CSL_EHRPWM_AQSFRC_ACTSFB_MASK    (0x0018u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_SHIFT   (0x0003u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_DONOTHING (0x0000u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_CLEAR   (0x0001u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_SET     (0x0002u)
#define CSL_EHRPWM_AQSFRC_ACTSFB_TOGGLE  (0x0003u)

#define CSL_EHRPWM_AQSFRC_OTSFA_MASK     (0x0004u)
#define CSL_EHRPWM_AQSFRC_OTSFA_SHIFT    (0x0002u)
#define CSL_EHRPWM_AQSFRC_OTSFA_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQSFRC_OTSFA_NOEFFECT (0x0000u)
#define CSL_EHRPWM_AQSFRC_OTSFA_EVENT    (0x0001u)

#define CSL_EHRPWM_AQSFRC_ACTSFA_MASK    (0x0003u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_SHIFT   (0x0000u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_DONOTHING (0x0000u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_CLEAR   (0x0001u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_SET     (0x0002u)
#define CSL_EHRPWM_AQSFRC_ACTSFA_TOGGLE  (0x0003u)

#define CSL_EHRPWM_AQSFRC_RESETVAL       (0x0000u)

/* AQCSFRC */


#define CSL_EHRPWM_AQCSFRC_CSFB_MASK     (0x000Cu)
#define CSL_EHRPWM_AQCSFRC_CSFB_SHIFT    (0x0002u)
#define CSL_EHRPWM_AQCSFRC_CSFB_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQCSFRC_CSFB_DISABLED (0x0000u)
#define CSL_EHRPWM_AQCSFRC_CSFB_LOW      (0x0001u)
#define CSL_EHRPWM_AQCSFRC_CSFB_HIGH     (0x0002u)
#define CSL_EHRPWM_AQCSFRC_CSFB_DISABLED (0x0003u)

#define CSL_EHRPWM_AQCSFRC_CSFA_MASK     (0x0003u)
#define CSL_EHRPWM_AQCSFRC_CSFA_SHIFT    (0x0000u)
#define CSL_EHRPWM_AQCSFRC_CSFA_RESETVAL (0x0000u)
#define CSL_EHRPWM_AQCSFRC_CSFA_DISABLED (0x0000u)
#define CSL_EHRPWM_AQCSFRC_CSFA_LOW      (0x0001u)
#define CSL_EHRPWM_AQCSFRC_CSFA_HIGH     (0x0002u)
#define CSL_EHRPWM_AQCSFRC_CSFA_DISABLED (0x0003u)

#define CSL_EHRPWM_AQCSFRC_RESETVAL      (0x0000u)

/* DBCTL */


#define CSL_EHRPWM_DBCTL_IN_MODE_MASK    (0x0030u)
#define CSL_EHRPWM_DBCTL_IN_MODE_SHIFT   (0x0004u)
#define CSL_EHRPWM_DBCTL_IN_MODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_DBCTL_IN_MODE_AREDAFED (0x0000u)
#define CSL_EHRPWM_DBCTL_IN_MODE_BREDAFED (0x0001u)
#define CSL_EHRPWM_DBCTL_IN_MODE_AREDBFED (0x0002u)
#define CSL_EHRPWM_DBCTL_IN_MODE_BREDBFED (0x0003u)

#define CSL_EHRPWM_DBCTL_POLSEL_MASK     (0x000Cu)
#define CSL_EHRPWM_DBCTL_POLSEL_SHIFT    (0x0002u)
#define CSL_EHRPWM_DBCTL_POLSEL_RESETVAL (0x0000u)
#define CSL_EHRPWM_DBCTL_POLSEL_ACTIVEHIGH (0x0000u)
#define CSL_EHRPWM_DBCTL_POLSEL_ALC      (0x0001u)
#define CSL_EHRPWM_DBCTL_POLSEL_AHC      (0x0002u)
#define CSL_EHRPWM_DBCTL_POLSEL_ACTIVELOW (0x0003u)

#define CSL_EHRPWM_DBCTL_OUT_MODE_MASK   (0x0003u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_SHIFT  (0x0000u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_BYPASS (0x0000u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_NOREDBFED (0x0001u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_AREDNOFED (0x0002u)
#define CSL_EHRPWM_DBCTL_OUT_MODE_AREDBFED (0x0003u)

#define CSL_EHRPWM_DBCTL_RESETVAL        (0x0000u)

/* DBRED */


#define CSL_EHRPWM_DBRED_DEL_MASK        (0x03FFu)
#define CSL_EHRPWM_DBRED_DEL_SHIFT       (0x0000u)
#define CSL_EHRPWM_DBRED_DEL_RESETVAL    (0x0000u)

#define CSL_EHRPWM_DBRED_RESETVAL        (0x0000u)

/* DBFED */


#define CSL_EHRPWM_DBFED_DEL_MASK        (0x03FFu)
#define CSL_EHRPWM_DBFED_DEL_SHIFT       (0x0000u)
#define CSL_EHRPWM_DBFED_DEL_RESETVAL    (0x0000u)

#define CSL_EHRPWM_DBFED_RESETVAL        (0x0000u)

/* TZSEL */


#define CSL_EHRPWM_TZSEL_OSHT1_MASK      (0x0100u)
#define CSL_EHRPWM_TZSEL_OSHT1_SHIFT     (0x0008u)
#define CSL_EHRPWM_TZSEL_OSHT1_RESETVAL  (0x0000u)
#define CSL_EHRPWM_TZSEL_OSHT1_DISABLE   (0x0000u)
#define CSL_EHRPWM_TZSEL_OSHT1_ENABLE    (0x0001u)


#define CSL_EHRPWM_TZSEL_CBC1_MASK       (0x0001u)
#define CSL_EHRPWM_TZSEL_CBC1_SHIFT      (0x0000u)
#define CSL_EHRPWM_TZSEL_CBC1_RESETVAL   (0x0000u)
#define CSL_EHRPWM_TZSEL_CBC1_DISABLE    (0x0000u)
#define CSL_EHRPWM_TZSEL_CBC1_ENABLE     (0x0001u)

#define CSL_EHRPWM_TZSEL_RESETVAL        (0x0000u)

/* TZCTL */


#define CSL_EHRPWM_TZCTL_TZB_MASK        (0x000Cu)
#define CSL_EHRPWM_TZCTL_TZB_SHIFT       (0x0002u)
#define CSL_EHRPWM_TZCTL_TZB_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZCTL_TZB_TRISTATE    (0x0000u)
#define CSL_EHRPWM_TZCTL_TZB_FORCEHIGH   (0x0001u)
#define CSL_EHRPWM_TZCTL_TZB_FORCELOW    (0x0002u)
#define CSL_EHRPWM_TZCTL_TZB_DONOTHING   (0x0003u)

#define CSL_EHRPWM_TZCTL_TZA_MASK        (0x0003u)
#define CSL_EHRPWM_TZCTL_TZA_SHIFT       (0x0000u)
#define CSL_EHRPWM_TZCTL_TZA_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZCTL_TZA_TRISTATE    (0x0000u)
#define CSL_EHRPWM_TZCTL_TZA_FORCEHIGH   (0x0001u)
#define CSL_EHRPWM_TZCTL_TZA_FORCELOW    (0x0002u)
#define CSL_EHRPWM_TZCTL_TZA_DONOTHING   (0x0003u)

#define CSL_EHRPWM_TZCTL_RESETVAL        (0x0000u)

/* TZEINT */


#define CSL_EHRPWM_TZEINT_OST_MASK       (0x0004u)
#define CSL_EHRPWM_TZEINT_OST_SHIFT      (0x0002u)
#define CSL_EHRPWM_TZEINT_OST_RESETVAL   (0x0000u)
#define CSL_EHRPWM_TZEINT_OST_DISABLE    (0x0000u)
#define CSL_EHRPWM_TZEINT_OST_ENABLE     (0x0001u)

#define CSL_EHRPWM_TZEINT_CBC_MASK       (0x0002u)
#define CSL_EHRPWM_TZEINT_CBC_SHIFT      (0x0001u)
#define CSL_EHRPWM_TZEINT_CBC_RESETVAL   (0x0000u)
#define CSL_EHRPWM_TZEINT_CBC_DISABLE    (0x0000u)
#define CSL_EHRPWM_TZEINT_CBC_ENABLE     (0x0001u)


#define CSL_EHRPWM_TZEINT_RESETVAL       (0x0000u)

/* TZFLG */


#define CSL_EHRPWM_TZFLG_OST_MASK        (0x0004u)
#define CSL_EHRPWM_TZFLG_OST_SHIFT       (0x0002u)
#define CSL_EHRPWM_TZFLG_OST_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZFLG_OST_NOEVENT     (0x0000u)
#define CSL_EHRPWM_TZFLG_OST_EVENT       (0x0001u)

#define CSL_EHRPWM_TZFLG_CBC_MASK        (0x0002u)
#define CSL_EHRPWM_TZFLG_CBC_SHIFT       (0x0001u)
#define CSL_EHRPWM_TZFLG_CBC_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZFLG_CBC_NOEVENT     (0x0000u)
#define CSL_EHRPWM_TZFLG_CBC_EVENT       (0x0001u)

#define CSL_EHRPWM_TZFLG_INT_MASK        (0x0001u)
#define CSL_EHRPWM_TZFLG_INT_SHIFT       (0x0000u)
#define CSL_EHRPWM_TZFLG_INT_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZFLG_INT_NOINT       (0x0000u)
#define CSL_EHRPWM_TZFLG_INT_INT         (0x0001u)

#define CSL_EHRPWM_TZFLG_RESETVAL        (0x0000u)

/* TZCLR */


#define CSL_EHRPWM_TZCLR_OST_MASK        (0x0004u)
#define CSL_EHRPWM_TZCLR_OST_SHIFT       (0x0002u)
#define CSL_EHRPWM_TZCLR_OST_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZCLR_OST_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_TZCLR_OST_CLEAR       (0x0001u)

#define CSL_EHRPWM_TZCLR_CBC_MASK        (0x0002u)
#define CSL_EHRPWM_TZCLR_CBC_SHIFT       (0x0001u)
#define CSL_EHRPWM_TZCLR_CBC_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZCLR_CBC_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_TZCLR_CBC_CLEAR       (0x0001u)

#define CSL_EHRPWM_TZCLR_INT_MASK        (0x0001u)
#define CSL_EHRPWM_TZCLR_INT_SHIFT       (0x0000u)
#define CSL_EHRPWM_TZCLR_INT_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZCLR_INT_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_TZCLR_INT_CLEAR       (0x0001u)

#define CSL_EHRPWM_TZCLR_RESETVAL        (0x0000u)

/* TZFRC */


#define CSL_EHRPWM_TZFRC_OST_MASK        (0x0004u)
#define CSL_EHRPWM_TZFRC_OST_SHIFT       (0x0002u)
#define CSL_EHRPWM_TZFRC_OST_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZFRC_OST_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_TZFRC_OST_FORCE       (0x0001u)

#define CSL_EHRPWM_TZFRC_CBC_MASK        (0x0002u)
#define CSL_EHRPWM_TZFRC_CBC_SHIFT       (0x0001u)
#define CSL_EHRPWM_TZFRC_CBC_RESETVAL    (0x0000u)
#define CSL_EHRPWM_TZFRC_CBC_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_TZFRC_CBC_FORCE       (0x0001u)


#define CSL_EHRPWM_TZFRC_RESETVAL        (0x0000u)

/* ETSEL */


#define CSL_EHRPWM_ETSEL_INTEN_MASK      (0x0008u)
#define CSL_EHRPWM_ETSEL_INTEN_SHIFT     (0x0003u)
#define CSL_EHRPWM_ETSEL_INTEN_RESETVAL  (0x0000u)
#define CSL_EHRPWM_ETSEL_INTEN_DISABLE   (0x0000u)
#define CSL_EHRPWM_ETSEL_INTEN_ENABLE    (0x0001u)

#define CSL_EHRPWM_ETSEL_INTSEL_MASK     (0x0007u)
#define CSL_EHRPWM_ETSEL_INTSEL_SHIFT    (0x0000u)
#define CSL_EHRPWM_ETSEL_INTSEL_RESETVAL (0x0000u)
#define CSL_EHRPWM_ETSEL_INTSEL_RESERVED (0x0000u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUZERO (0x0001u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUPRD (0x0002u)
#define CSL_EHRPWM_ETSEL_INTSEL_RESERVED (0x0003u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUCMPAINC (0x0004u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUCMPADEC (0x0005u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUCMPBINC (0x0006u)
#define CSL_EHRPWM_ETSEL_INTSEL_TBCTREQUCMPBDEC (0x0007u)

#define CSL_EHRPWM_ETSEL_RESETVAL        (0x0000u)

/* ETPS */


#define CSL_EHRPWM_ETPS_INTCNT_MASK      (0x000Cu)
#define CSL_EHRPWM_ETPS_INTCNT_SHIFT     (0x0002u)
#define CSL_EHRPWM_ETPS_INTCNT_RESETVAL  (0x0000u)
#define CSL_EHRPWM_ETPS_INTCNT_NOEVENTS  (0x0000u)
#define CSL_EHRPWM_ETPS_INTCNT_ONEEVENT  (0x0001u)
#define CSL_EHRPWM_ETPS_INTCNT_TWOEVENTS (0x0002u)
#define CSL_EHRPWM_ETPS_INTCNT_THREEEVENTS (0x0003u)

#define CSL_EHRPWM_ETPS_INTPRD_MASK      (0x0003u)
#define CSL_EHRPWM_ETPS_INTPRD_SHIFT     (0x0000u)
#define CSL_EHRPWM_ETPS_INTPRD_RESETVAL  (0x0000u)
#define CSL_EHRPWM_ETPS_INTPRD_DISABLE   (0x0000u)
#define CSL_EHRPWM_ETPS_INTPRD_FIRSTEVENT (0x0001u)
#define CSL_EHRPWM_ETPS_INTPRD_SECONDEVENT (0x0002u)
#define CSL_EHRPWM_ETPS_INTPRD_THIRDEVENT (0x0003u)

#define CSL_EHRPWM_ETPS_RESETVAL         (0x0000u)

/* ETFLG */


#define CSL_EHRPWM_ETFLG_INT_MASK        (0x0001u)
#define CSL_EHRPWM_ETFLG_INT_SHIFT       (0x0000u)
#define CSL_EHRPWM_ETFLG_INT_RESETVAL    (0x0000u)
#define CSL_EHRPWM_ETFLG_INT_NOINT       (0x0000u)
#define CSL_EHRPWM_ETFLG_INT_INT         (0x0001u)

#define CSL_EHRPWM_ETFLG_RESETVAL        (0x0000u)

/* ETCLR */


#define CSL_EHRPWM_ETCLR_INT_MASK        (0x0001u)
#define CSL_EHRPWM_ETCLR_INT_SHIFT       (0x0000u)
#define CSL_EHRPWM_ETCLR_INT_RESETVAL    (0x0000u)
#define CSL_EHRPWM_ETCLR_INT_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_ETCLR_INT_CLEAR       (0x0001u)

#define CSL_EHRPWM_ETCLR_RESETVAL        (0x0000u)

/* ETFRC */


#define CSL_EHRPWM_ETFRC_INT_MASK        (0x0001u)
#define CSL_EHRPWM_ETFRC_INT_SHIFT       (0x0000u)
#define CSL_EHRPWM_ETFRC_INT_RESETVAL    (0x0000u)
#define CSL_EHRPWM_ETFRC_INT_NOEFFECT    (0x0000u)
#define CSL_EHRPWM_ETFRC_INT_FORCE       (0x0001u)

#define CSL_EHRPWM_ETFRC_RESETVAL        (0x0000u)

/* PCCTL */


#define CSL_EHRPWM_PCCTL_CHPDUTY_MASK    (0x0700u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_SHIFT   (0x0008u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_RESETVAL (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_1DIV8   (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_2DIV8   (0x0001u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_3DIV8   (0x0002u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_4DIV8   (0x0003u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_5DIV8   (0x0004u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_6DIV8   (0x0005u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_7DIV8   (0x0006u)
#define CSL_EHRPWM_PCCTL_CHPDUTY_RESERVED (0x0007u)

#define CSL_EHRPWM_PCCTL_CHPFREQ_MASK    (0x00E0u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_SHIFT   (0x0005u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_RESETVAL (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY1  (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY2  (0x0001u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY3  (0x0002u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY4  (0x0003u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY5  (0x0004u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY6  (0x0005u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY7  (0x0006u)
#define CSL_EHRPWM_PCCTL_CHPFREQ_DIVBY8  (0x0007u)

#define CSL_EHRPWM_PCCTL_OSHTWTH_MASK    (0x001Eu)
#define CSL_EHRPWM_PCCTL_OSHTWTH_SHIFT   (0x0001u)
#define CSL_EHRPWM_PCCTL_OSHTWTH_RESETVAL (0x0000u)

#define CSL_EHRPWM_PCCTL_CHPEN_MASK      (0x0001u)
#define CSL_EHRPWM_PCCTL_CHPEN_SHIFT     (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPEN_RESETVAL  (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPEN_DISABLE   (0x0000u)
#define CSL_EHRPWM_PCCTL_CHPEN_ENABLE    (0x0001u)

#define CSL_EHRPWM_PCCTL_RESETVAL        (0x0000u)

/* REVID */

#define CSL_EHRPWM_REVID_REV_MASK        (0xFFFFFFFFu)
#define CSL_EHRPWM_REVID_REV_SHIFT       (0x00000000u)
#define CSL_EHRPWM_REVID_REV_RESETVAL    (0x44D10903u)

#define CSL_EHRPWM_REVID_RESETVAL        (0x44D10903u)

/* HRCTL */


#define CSL_EHRPWM_HRCTL_PULSESEL_MASK   (0x0008u)
#define CSL_EHRPWM_HRCTL_PULSESEL_SHIFT  (0x0003u)
#define CSL_EHRPWM_HRCTL_PULSESEL_RESETVAL (0x0000u)
#define CSL_EHRPWM_HRCTL_PULSESEL_CTREQUZERO (0x0000u)
#define CSL_EHRPWM_HRCTL_PULSESEL_CTREQUPRD (0x0001u)

#define CSL_EHRPWM_HRCTL_DELBUSSEL_MASK  (0x0004u)
#define CSL_EHRPWM_HRCTL_DELBUSSEL_SHIFT (0x0002u)
#define CSL_EHRPWM_HRCTL_DELBUSSEL_RESETVAL (0x0000u)
#define CSL_EHRPWM_HRCTL_DELBUSSEL_CMPAHR (0x0000u)
#define CSL_EHRPWM_HRCTL_DELBUSSEL_TBPHSHR (0x0001u)

#define CSL_EHRPWM_HRCTL_DELMODE_MASK    (0x0003u)
#define CSL_EHRPWM_HRCTL_DELMODE_SHIFT   (0x0000u)
#define CSL_EHRPWM_HRCTL_DELMODE_RESETVAL (0x0000u)
#define CSL_EHRPWM_HRCTL_DELMODE_DISABLED (0x0000u)
#define CSL_EHRPWM_HRCTL_DELMODE_RISINGEDGE (0x0001u)
#define CSL_EHRPWM_HRCTL_DELMODE_FALLINGEDGE (0x0002u)
#define CSL_EHRPWM_HRCTL_DELMODE_BOTHEDGES (0x0003u)

#define CSL_EHRPWM_HRCTL_RESETVAL        (0x0000u)

#endif
