/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006, 2007
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
/** ============================================================================
 *   @file  cslr_gpio.h
 *
 *   @path  $(CSLPATH)\
 *
 *   @desc  This file contains the Register Descriptions for GPIO
 *
 *  ============================================================================
 */
#ifndef _CSLR_GPIO_H_
#define _CSLR_GPIO_H_

//#include <csl/cslr.h>
//#include "tistdtypes.h"


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
#if defined(CHIP_C6747) || defined(CHIP_OMPL137)
#define CSL_GPIO_NUM_PINS           (128)
#define CSL_GPIO_NUM_BANKS        (CSL_GPIO_NUM_PINS + 15)/16
#endif

#if defined(CHIP_C6748) || defined(CHIP_OMPL138)
#define 
#define CSL_GPIO_NUM_PINS           (144)
#define CSL_GPIO_NUM_BANKS        (CSL_GPIO_NUM_PINS + 15)/16
#endif

/**************************************************************************\
* Register Overlay Structure for BANK
\**************************************************************************/
typedef struct  {
    volatile Uint32 DIR;
    volatile Uint32 OUT_DATA;
    volatile Uint32 SET_DATA;
    volatile Uint32 CLR_DATA;
    volatile Uint32 IN_DATA;
    volatile Uint32 SET_RIS_TRIG;
    volatile Uint32 CLR_RIS_TRIG;
    volatile Uint32 SET_FAL_TRIG;
    volatile Uint32 CLR_FAL_TRIG;
    volatile Uint32 INTSTAT;
} CSL_GpioBankRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint8 RSVD0[4];
    volatile Uint32 BINTEN;
    volatile Uint8 RSVD1[4];
    CSL_GpioBankRegs BANK[4];
} CSL_GpioRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_GpioRegs         *CSL_GpioRegsOvly;

/**************************************************************************\
* Bank and Pin Tokens
\**************************************************************************/
#define GP0  0
#define GP1  0
#define GP2  1
#define GP3  1
#define GP4  2
#define GP5  2
#define GP6  3
#define GP7  3
#define GP8  4

#define GP0P0  (1 <<  0)
#define GP0P1  (1 <<  1)
#define GP0P2  (1 <<  2)
#define GP0P3  (1 <<  3)
#define GP0P4  (1 <<  4)
#define GP0P5  (1 <<  5)
#define GP0P6  (1 <<  6)
#define GP0P7  (1 <<  7)
#define GP0P8  (1 <<  8)
#define GP0P9  (1 <<  9)
#define GP0P10 (1 << 10)
#define GP0P11 (1 << 11)
#define GP0P12 (1 << 12)
#define GP0P13 (1 << 13)
#define GP0P14 (1 << 14)
#define GP0P15 (1 << 15)
#define GP1P0  (1 << 16)
#define GP1P1  (1 << 17)
#define GP1P2  (1 << 18)
#define GP1P3  (1 << 19)
#define GP1P4  (1 << 20)
#define GP1P5  (1 << 21)
#define GP1P6  (1 << 22)
#define GP1P7  (1 << 23)
#define GP1P8  (1 << 24)
#define GP1P9  (1 << 25)
#define GP1P10 (1 << 26)
#define GP1P11 (1 << 27)
#define GP1P12 (1 << 28)
#define GP1P13 (1 << 29)
#define GP1P14 (1 << 30)
#define GP1P15 (1 << 31)

#define GP2P0  (1 <<  0)
#define GP2P1  (1 <<  1)
#define GP2P2  (1 <<  2)
#define GP2P3  (1 <<  3)
#define GP2P4  (1 <<  4)
#define GP2P5  (1 <<  5)
#define GP2P6  (1 <<  6)
#define GP2P7  (1 <<  7)
#define GP2P8  (1 <<  8)
#define GP2P9  (1 <<  9)
#define GP2P10 (1 << 10)
#define GP2P11 (1 << 11)
#define GP2P12 (1 << 12)
#define GP2P13 (1 << 13)
#define GP2P14 (1 << 14)
#define GP2P15 (1 << 15)
#define GP3P0  (1 << 16)
#define GP3P1  (1 << 17)
#define GP3P2  (1 << 18)
#define GP3P3  (1 << 19)
#define GP3P4  (1 << 20)
#define GP3P5  (1 << 21)
#define GP3P6  (1 << 22)
#define GP3P7  (1 << 23)
#define GP3P8  (1 << 24)
#define GP3P9  (1 << 25)
#define GP3P10 (1 << 26)
#define GP3P11 (1 << 27)
#define GP3P12 (1 << 28)
#define GP3P13 (1 << 29)
#define GP3P14 (1 << 30)
#define GP3P15 (1 << 31)

#define GP4P0  (1 <<  0)
#define GP4P1  (1 <<  1)
#define GP4P2  (1 <<  2)
#define GP4P3  (1 <<  3)
#define GP4P4  (1 <<  4)
#define GP4P5  (1 <<  5)
#define GP4P6  (1 <<  6)
#define GP4P7  (1 <<  7)
#define GP4P8  (1 <<  8)
#define GP4P9  (1 <<  9)
#define GP4P10 (1 << 10)
#define GP4P11 (1 << 11)
#define GP4P12 (1 << 12)
#define GP4P13 (1 << 13)
#define GP4P14 (1 << 14)
#define GP4P15 (1 << 15)
#define GP5P0  (1 << 16)
#define GP5P1  (1 << 17)
#define GP5P2  (1 << 18)
#define GP5P3  (1 << 19)
#define GP5P4  (1 << 20)
#define GP5P5  (1 << 21)
#define GP5P6  (1 << 22)
#define GP5P7  (1 << 23)
#define GP5P8  (1 << 24)
#define GP5P9  (1 << 25)
#define GP5P10 (1 << 26)
#define GP5P11 (1 << 27)
#define GP5P12 (1 << 28)
#define GP5P13 (1 << 29)
#define GP5P14 (1 << 30)
#define GP5P15 (1 << 31)

#define GP6P0  (1 <<  0)
#define GP6P1  (1 <<  1)
#define GP6P2  (1 <<  2)
#define GP6P3  (1 <<  3)
#define GP6P4  (1 <<  4)
#define GP6P5  (1 <<  5)
#define GP6P6  (1 <<  6)
#define GP6P7  (1 <<  7)
#define GP6P8  (1 <<  8)
#define GP6P9  (1 <<  9)
#define GP6P10 (1 << 10)
#define GP6P11 (1 << 11)
#define GP6P12 (1 << 12)
#define GP6P13 (1 << 13)
#define GP6P14 (1 << 14)
#define GP6P15 (1 << 15)
#define GP7P0  (1 << 16)
#define GP7P1  (1 << 17)
#define GP7P2  (1 << 18)
#define GP7P3  (1 << 19)
#define GP7P4  (1 << 20)
#define GP7P5  (1 << 21)
#define GP7P6  (1 << 22)
#define GP7P7  (1 << 23)
#define GP7P8  (1 << 24)
#define GP7P9  (1 << 25)
#define GP7P10 (1 << 26)
#define GP7P11 (1 << 27)
#define GP7P12 (1 << 28)
#define GP7P13 (1 << 29)
#define GP7P14 (1 << 30)
#define GP7P15 (1 << 31)

#if defined(CHIP_C6748) || defined(CHIP_OMPL138)
#define GP8P0  (1 <<  0)
#define GP8P1  (1 <<  1)
#define GP8P2  (1 <<  2)
#define GP8P3  (1 <<  3)
#define GP8P4  (1 <<  4)
#define GP8P5  (1 <<  5)
#define GP8P6  (1 <<  6)
#define GP8P7  (1 <<  7)
#define GP8P8  (1 <<  8)
#define GP8P9  (1 <<  9)
#define GP8P10 (1 << 10)
#define GP8P11 (1 << 11)
#define GP8P12 (1 << 12)
#define GP8P13 (1 << 13)
#define GP8P14 (1 << 14)
#define GP8P15 (1 << 15)
#endif


/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_GPIO_REVID_REV_MASK          (0xFFFFFFFFu)
#define CSL_GPIO_REVID_REV_SHIFT         (0x00000000u)
#define CSL_GPIO_REVID_REV_RESETVAL      (0x44830105u)

#define CSL_GPIO_REVID_RESETVAL          (0x44830105u)

/* BINTEN */

#define CSL_GPIO_BINTEN_EN7_MASK         (0x00000080u)
#define CSL_GPIO_BINTEN_EN7_SHIFT        (0x00000007u)
#define CSL_GPIO_BINTEN_EN7_RESETVAL     (0x00000000u)
/*----EN7 Tokens----*/
#define CSL_GPIO_BINTEN_EN7_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN7_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN6_MASK         (0x00000040u)
#define CSL_GPIO_BINTEN_EN6_SHIFT        (0x00000006u)
#define CSL_GPIO_BINTEN_EN6_RESETVAL     (0x00000000u)
/*----EN6 Tokens----*/
#define CSL_GPIO_BINTEN_EN6_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN6_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN5_MASK         (0x00000020u)
#define CSL_GPIO_BINTEN_EN5_SHIFT        (0x00000005u)
#define CSL_GPIO_BINTEN_EN5_RESETVAL     (0x00000000u)
/*----EN5 Tokens----*/
#define CSL_GPIO_BINTEN_EN5_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN5_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN4_MASK         (0x00000010u)
#define CSL_GPIO_BINTEN_EN4_SHIFT        (0x00000004u)
#define CSL_GPIO_BINTEN_EN4_RESETVAL     (0x00000000u)
/*----EN4 Tokens----*/
#define CSL_GPIO_BINTEN_EN4_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN4_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN3_MASK         (0x00000008u)
#define CSL_GPIO_BINTEN_EN3_SHIFT        (0x00000003u)
#define CSL_GPIO_BINTEN_EN3_RESETVAL     (0x00000000u)
/*----EN3 Tokens----*/
#define CSL_GPIO_BINTEN_EN3_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN3_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN2_MASK         (0x00000004u)
#define CSL_GPIO_BINTEN_EN2_SHIFT        (0x00000002u)
#define CSL_GPIO_BINTEN_EN2_RESETVAL     (0x00000000u)
/*----EN2 Tokens----*/
#define CSL_GPIO_BINTEN_EN2_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN2_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN1_MASK         (0x00000002u)
#define CSL_GPIO_BINTEN_EN1_SHIFT        (0x00000001u)
#define CSL_GPIO_BINTEN_EN1_RESETVAL     (0x00000000u)
/*----EN1 Tokens----*/
#define CSL_GPIO_BINTEN_EN1_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN1_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_EN0_MASK         (0x00000001u)
#define CSL_GPIO_BINTEN_EN0_SHIFT        (0x00000000u)
#define CSL_GPIO_BINTEN_EN0_RESETVAL     (0x00000000u)
/*----EN0 Tokens----*/
#define CSL_GPIO_BINTEN_EN0_DISABLE      (0x00000000u)
#define CSL_GPIO_BINTEN_EN0_ENABLE       (0x00000001u)

#define CSL_GPIO_BINTEN_RESETVAL         (0x00000000u)

/* DIR */

#define CSL_GPIO_DIR_DIR31_MASK          (0x80000000u)
#define CSL_GPIO_DIR_DIR31_SHIFT         (0x0000001Fu)
#define CSL_GPIO_DIR_DIR31_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR30_MASK          (0x40000000u)
#define CSL_GPIO_DIR_DIR30_SHIFT         (0x0000001Eu)
#define CSL_GPIO_DIR_DIR30_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR29_MASK          (0x20000000u)
#define CSL_GPIO_DIR_DIR29_SHIFT         (0x0000001Du)
#define CSL_GPIO_DIR_DIR29_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR28_MASK          (0x10000000u)
#define CSL_GPIO_DIR_DIR28_SHIFT         (0x0000001Cu)
#define CSL_GPIO_DIR_DIR28_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR27_MASK          (0x08000000u)
#define CSL_GPIO_DIR_DIR27_SHIFT         (0x0000001Bu)
#define CSL_GPIO_DIR_DIR27_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR26_MASK          (0x04000000u)
#define CSL_GPIO_DIR_DIR26_SHIFT         (0x0000001Au)
#define CSL_GPIO_DIR_DIR26_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR25_MASK          (0x02000000u)
#define CSL_GPIO_DIR_DIR25_SHIFT         (0x00000019u)
#define CSL_GPIO_DIR_DIR25_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR24_MASK          (0x01000000u)
#define CSL_GPIO_DIR_DIR24_SHIFT         (0x00000018u)
#define CSL_GPIO_DIR_DIR24_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR23_MASK          (0x00800000u)
#define CSL_GPIO_DIR_DIR23_SHIFT         (0x00000017u)
#define CSL_GPIO_DIR_DIR23_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR22_MASK          (0x00400000u)
#define CSL_GPIO_DIR_DIR22_SHIFT         (0x00000016u)
#define CSL_GPIO_DIR_DIR22_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR21_MASK          (0x00200000u)
#define CSL_GPIO_DIR_DIR21_SHIFT         (0x00000015u)
#define CSL_GPIO_DIR_DIR21_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR20_MASK          (0x00100000u)
#define CSL_GPIO_DIR_DIR20_SHIFT         (0x00000014u)
#define CSL_GPIO_DIR_DIR20_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR19_MASK          (0x00080000u)
#define CSL_GPIO_DIR_DIR19_SHIFT         (0x00000013u)
#define CSL_GPIO_DIR_DIR19_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR18_MASK          (0x00040000u)
#define CSL_GPIO_DIR_DIR18_SHIFT         (0x00000012u)
#define CSL_GPIO_DIR_DIR18_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR17_MASK          (0x00020000u)
#define CSL_GPIO_DIR_DIR17_SHIFT         (0x00000011u)
#define CSL_GPIO_DIR_DIR17_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR16_MASK          (0x00010000u)
#define CSL_GPIO_DIR_DIR16_SHIFT         (0x00000010u)
#define CSL_GPIO_DIR_DIR16_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR15_MASK          (0x00008000u)
#define CSL_GPIO_DIR_DIR15_SHIFT         (0x0000000Fu)
#define CSL_GPIO_DIR_DIR15_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR14_MASK          (0x00004000u)
#define CSL_GPIO_DIR_DIR14_SHIFT         (0x0000000Eu)
#define CSL_GPIO_DIR_DIR14_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR13_MASK          (0x00002000u)
#define CSL_GPIO_DIR_DIR13_SHIFT         (0x0000000Du)
#define CSL_GPIO_DIR_DIR13_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR12_MASK          (0x00001000u)
#define CSL_GPIO_DIR_DIR12_SHIFT         (0x0000000Cu)
#define CSL_GPIO_DIR_DIR12_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR11_MASK          (0x00000800u)
#define CSL_GPIO_DIR_DIR11_SHIFT         (0x0000000Bu)
#define CSL_GPIO_DIR_DIR11_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR10_MASK          (0x00000400u)
#define CSL_GPIO_DIR_DIR10_SHIFT         (0x0000000Au)
#define CSL_GPIO_DIR_DIR10_RESETVAL      (0x00000001u)

#define CSL_GPIO_DIR_DIR9_MASK           (0x00000200u)
#define CSL_GPIO_DIR_DIR9_SHIFT          (0x00000009u)
#define CSL_GPIO_DIR_DIR9_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR8_MASK           (0x00000100u)
#define CSL_GPIO_DIR_DIR8_SHIFT          (0x00000008u)
#define CSL_GPIO_DIR_DIR8_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR7_MASK           (0x00000080u)
#define CSL_GPIO_DIR_DIR7_SHIFT          (0x00000007u)
#define CSL_GPIO_DIR_DIR7_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR6_MASK           (0x00000040u)
#define CSL_GPIO_DIR_DIR6_SHIFT          (0x00000006u)
#define CSL_GPIO_DIR_DIR6_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR5_MASK           (0x00000020u)
#define CSL_GPIO_DIR_DIR5_SHIFT          (0x00000005u)
#define CSL_GPIO_DIR_DIR5_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR4_MASK           (0x00000010u)
#define CSL_GPIO_DIR_DIR4_SHIFT          (0x00000004u)
#define CSL_GPIO_DIR_DIR4_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR3_MASK           (0x00000008u)
#define CSL_GPIO_DIR_DIR3_SHIFT          (0x00000003u)
#define CSL_GPIO_DIR_DIR3_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR2_MASK           (0x00000004u)
#define CSL_GPIO_DIR_DIR2_SHIFT          (0x00000002u)
#define CSL_GPIO_DIR_DIR2_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR1_MASK           (0x00000002u)
#define CSL_GPIO_DIR_DIR1_SHIFT          (0x00000001u)
#define CSL_GPIO_DIR_DIR1_RESETVAL       (0x00000001u)

#define CSL_GPIO_DIR_DIR0_MASK           (0x00000001u)
#define CSL_GPIO_DIR_DIR0_SHIFT          (0x00000000u)
#define CSL_GPIO_DIR_DIR0_RESETVAL       (0x00000001u)

/*----DIR Tokens----*/
#define CSL_GPIO_DIR_DIR_OUT             (0x00000000u)
#define CSL_GPIO_DIR_DIR_IN              (0x00000001u)

#define CSL_GPIO_DIR_RESETVAL            (0x00000001u)

/* OUT_DATA */

#define CSL_GPIO_OUT_DATA_OUT31_MASK     (0x80000000u)
#define CSL_GPIO_OUT_DATA_OUT31_SHIFT    (0x0000001Fu)
#define CSL_GPIO_OUT_DATA_OUT31_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT30_MASK     (0x40000000u)
#define CSL_GPIO_OUT_DATA_OUT30_SHIFT    (0x0000001Eu)
#define CSL_GPIO_OUT_DATA_OUT30_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT29_MASK     (0x20000000u)
#define CSL_GPIO_OUT_DATA_OUT29_SHIFT    (0x0000001Du)
#define CSL_GPIO_OUT_DATA_OUT29_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT28_MASK     (0x10000000u)
#define CSL_GPIO_OUT_DATA_OUT28_SHIFT    (0x0000001Cu)
#define CSL_GPIO_OUT_DATA_OUT28_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT27_MASK     (0x08000000u)
#define CSL_GPIO_OUT_DATA_OUT27_SHIFT    (0x0000001Bu)
#define CSL_GPIO_OUT_DATA_OUT27_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT26_MASK     (0x04000000u)
#define CSL_GPIO_OUT_DATA_OUT26_SHIFT    (0x0000001Au)
#define CSL_GPIO_OUT_DATA_OUT26_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT25_MASK     (0x02000000u)
#define CSL_GPIO_OUT_DATA_OUT25_SHIFT    (0x00000019u)
#define CSL_GPIO_OUT_DATA_OUT25_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT24_MASK     (0x01000000u)
#define CSL_GPIO_OUT_DATA_OUT24_SHIFT    (0x00000018u)
#define CSL_GPIO_OUT_DATA_OUT24_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT23_MASK     (0x00800000u)
#define CSL_GPIO_OUT_DATA_OUT23_SHIFT    (0x00000017u)
#define CSL_GPIO_OUT_DATA_OUT23_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT22_MASK     (0x00400000u)
#define CSL_GPIO_OUT_DATA_OUT22_SHIFT    (0x00000016u)
#define CSL_GPIO_OUT_DATA_OUT22_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT21_MASK     (0x00200000u)
#define CSL_GPIO_OUT_DATA_OUT21_SHIFT    (0x00000015u)
#define CSL_GPIO_OUT_DATA_OUT21_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT20_MASK     (0x00100000u)
#define CSL_GPIO_OUT_DATA_OUT20_SHIFT    (0x00000014u)
#define CSL_GPIO_OUT_DATA_OUT20_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT19_MASK     (0x00080000u)
#define CSL_GPIO_OUT_DATA_OUT19_SHIFT    (0x00000013u)
#define CSL_GPIO_OUT_DATA_OUT19_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT18_MASK     (0x00040000u)
#define CSL_GPIO_OUT_DATA_OUT18_SHIFT    (0x00000012u)
#define CSL_GPIO_OUT_DATA_OUT18_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT17_MASK     (0x00020000u)
#define CSL_GPIO_OUT_DATA_OUT17_SHIFT    (0x00000011u)
#define CSL_GPIO_OUT_DATA_OUT17_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT16_MASK     (0x00010000u)
#define CSL_GPIO_OUT_DATA_OUT16_SHIFT    (0x00000010u)
#define CSL_GPIO_OUT_DATA_OUT16_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT15_MASK     (0x00008000u)
#define CSL_GPIO_OUT_DATA_OUT15_SHIFT    (0x0000000Fu)
#define CSL_GPIO_OUT_DATA_OUT15_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT14_MASK     (0x00004000u)
#define CSL_GPIO_OUT_DATA_OUT14_SHIFT    (0x0000000Eu)
#define CSL_GPIO_OUT_DATA_OUT14_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT13_MASK     (0x00002000u)
#define CSL_GPIO_OUT_DATA_OUT13_SHIFT    (0x0000000Du)
#define CSL_GPIO_OUT_DATA_OUT13_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT12_MASK     (0x00001000u)
#define CSL_GPIO_OUT_DATA_OUT12_SHIFT    (0x0000000Cu)
#define CSL_GPIO_OUT_DATA_OUT12_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT11_MASK     (0x00000800u)
#define CSL_GPIO_OUT_DATA_OUT11_SHIFT    (0x0000000Bu)
#define CSL_GPIO_OUT_DATA_OUT11_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT10_MASK     (0x00000400u)
#define CSL_GPIO_OUT_DATA_OUT10_SHIFT    (0x0000000Au)
#define CSL_GPIO_OUT_DATA_OUT10_RESETVAL (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT9_MASK      (0x00000200u)
#define CSL_GPIO_OUT_DATA_OUT9_SHIFT     (0x00000009u)
#define CSL_GPIO_OUT_DATA_OUT9_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT8_MASK      (0x00000100u)
#define CSL_GPIO_OUT_DATA_OUT8_SHIFT     (0x00000008u)
#define CSL_GPIO_OUT_DATA_OUT8_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT7_MASK      (0x00000080u)
#define CSL_GPIO_OUT_DATA_OUT7_SHIFT     (0x00000007u)
#define CSL_GPIO_OUT_DATA_OUT7_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT6_MASK      (0x00000040u)
#define CSL_GPIO_OUT_DATA_OUT6_SHIFT     (0x00000006u)
#define CSL_GPIO_OUT_DATA_OUT6_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT5_MASK      (0x00000020u)
#define CSL_GPIO_OUT_DATA_OUT5_SHIFT     (0x00000005u)
#define CSL_GPIO_OUT_DATA_OUT5_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT4_MASK      (0x00000010u)
#define CSL_GPIO_OUT_DATA_OUT4_SHIFT     (0x00000004u)
#define CSL_GPIO_OUT_DATA_OUT4_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT3_MASK      (0x00000008u)
#define CSL_GPIO_OUT_DATA_OUT3_SHIFT     (0x00000003u)
#define CSL_GPIO_OUT_DATA_OUT3_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT2_MASK      (0x00000004u)
#define CSL_GPIO_OUT_DATA_OUT2_SHIFT     (0x00000002u)
#define CSL_GPIO_OUT_DATA_OUT2_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT1_MASK      (0x00000002u)
#define CSL_GPIO_OUT_DATA_OUT1_SHIFT     (0x00000001u)
#define CSL_GPIO_OUT_DATA_OUT1_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_OUT0_MASK      (0x00000001u)
#define CSL_GPIO_OUT_DATA_OUT0_SHIFT     (0x00000000u)
#define CSL_GPIO_OUT_DATA_OUT0_RESETVAL  (0x00000000u)

#define CSL_GPIO_OUT_DATA_RESETVAL       (0x00000000u)

/* SET_DATA */

#define CSL_GPIO_SET_DATA_SET31_MASK     (0x80000000u)
#define CSL_GPIO_SET_DATA_SET31_SHIFT    (0x0000001Fu)
#define CSL_GPIO_SET_DATA_SET31_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET30_MASK     (0x40000000u)
#define CSL_GPIO_SET_DATA_SET30_SHIFT    (0x0000001Eu)
#define CSL_GPIO_SET_DATA_SET30_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET29_MASK     (0x20000000u)
#define CSL_GPIO_SET_DATA_SET29_SHIFT    (0x0000001Du)
#define CSL_GPIO_SET_DATA_SET29_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET28_MASK     (0x10000000u)
#define CSL_GPIO_SET_DATA_SET28_SHIFT    (0x0000001Cu)
#define CSL_GPIO_SET_DATA_SET28_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET27_MASK     (0x08000000u)
#define CSL_GPIO_SET_DATA_SET27_SHIFT    (0x0000001Bu)
#define CSL_GPIO_SET_DATA_SET27_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET26_MASK     (0x04000000u)
#define CSL_GPIO_SET_DATA_SET26_SHIFT    (0x0000001Au)
#define CSL_GPIO_SET_DATA_SET26_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET25_MASK     (0x02000000u)
#define CSL_GPIO_SET_DATA_SET25_SHIFT    (0x00000019u)
#define CSL_GPIO_SET_DATA_SET25_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET24_MASK     (0x01000000u)
#define CSL_GPIO_SET_DATA_SET24_SHIFT    (0x00000018u)
#define CSL_GPIO_SET_DATA_SET24_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET23_MASK     (0x00800000u)
#define CSL_GPIO_SET_DATA_SET23_SHIFT    (0x00000017u)
#define CSL_GPIO_SET_DATA_SET23_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET22_MASK     (0x00400000u)
#define CSL_GPIO_SET_DATA_SET22_SHIFT    (0x00000016u)
#define CSL_GPIO_SET_DATA_SET22_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET21_MASK     (0x00200000u)
#define CSL_GPIO_SET_DATA_SET21_SHIFT    (0x00000015u)
#define CSL_GPIO_SET_DATA_SET21_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET20_MASK     (0x00100000u)
#define CSL_GPIO_SET_DATA_SET20_SHIFT    (0x00000014u)
#define CSL_GPIO_SET_DATA_SET20_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET19_MASK     (0x00080000u)
#define CSL_GPIO_SET_DATA_SET19_SHIFT    (0x00000013u)
#define CSL_GPIO_SET_DATA_SET19_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET18_MASK     (0x00040000u)
#define CSL_GPIO_SET_DATA_SET18_SHIFT    (0x00000012u)
#define CSL_GPIO_SET_DATA_SET18_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET17_MASK     (0x00020000u)
#define CSL_GPIO_SET_DATA_SET17_SHIFT    (0x00000011u)
#define CSL_GPIO_SET_DATA_SET17_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET16_MASK     (0x00010000u)
#define CSL_GPIO_SET_DATA_SET16_SHIFT    (0x00000010u)
#define CSL_GPIO_SET_DATA_SET16_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET15_MASK     (0x00008000u)
#define CSL_GPIO_SET_DATA_SET15_SHIFT    (0x0000000Fu)
#define CSL_GPIO_SET_DATA_SET15_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET14_MASK     (0x00004000u)
#define CSL_GPIO_SET_DATA_SET14_SHIFT    (0x0000000Eu)
#define CSL_GPIO_SET_DATA_SET14_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET13_MASK     (0x00002000u)
#define CSL_GPIO_SET_DATA_SET13_SHIFT    (0x0000000Du)
#define CSL_GPIO_SET_DATA_SET13_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET12_MASK     (0x00001000u)
#define CSL_GPIO_SET_DATA_SET12_SHIFT    (0x0000000Cu)
#define CSL_GPIO_SET_DATA_SET12_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET11_MASK     (0x00000800u)
#define CSL_GPIO_SET_DATA_SET11_SHIFT    (0x0000000Bu)
#define CSL_GPIO_SET_DATA_SET11_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET10_MASK     (0x00000400u)
#define CSL_GPIO_SET_DATA_SET10_SHIFT    (0x0000000Au)
#define CSL_GPIO_SET_DATA_SET10_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_DATA_SET9_MASK      (0x00000200u)
#define CSL_GPIO_SET_DATA_SET9_SHIFT     (0x00000009u)
#define CSL_GPIO_SET_DATA_SET9_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET8_MASK      (0x00000100u)
#define CSL_GPIO_SET_DATA_SET8_SHIFT     (0x00000008u)
#define CSL_GPIO_SET_DATA_SET8_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET7_MASK      (0x00000080u)
#define CSL_GPIO_SET_DATA_SET7_SHIFT     (0x00000007u)
#define CSL_GPIO_SET_DATA_SET7_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET6_MASK      (0x00000040u)
#define CSL_GPIO_SET_DATA_SET6_SHIFT     (0x00000006u)
#define CSL_GPIO_SET_DATA_SET6_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET5_MASK      (0x00000020u)
#define CSL_GPIO_SET_DATA_SET5_SHIFT     (0x00000005u)
#define CSL_GPIO_SET_DATA_SET5_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET4_MASK      (0x00000010u)
#define CSL_GPIO_SET_DATA_SET4_SHIFT     (0x00000004u)
#define CSL_GPIO_SET_DATA_SET4_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET3_MASK      (0x00000008u)
#define CSL_GPIO_SET_DATA_SET3_SHIFT     (0x00000003u)
#define CSL_GPIO_SET_DATA_SET3_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET2_MASK      (0x00000004u)
#define CSL_GPIO_SET_DATA_SET2_SHIFT     (0x00000002u)
#define CSL_GPIO_SET_DATA_SET2_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET1_MASK      (0x00000002u)
#define CSL_GPIO_SET_DATA_SET1_SHIFT     (0x00000001u)
#define CSL_GPIO_SET_DATA_SET1_RESETVAL  (0x00000000u)

#define CSL_GPIO_SET_DATA_SET0_MASK      (0x00000001u)
#define CSL_GPIO_SET_DATA_SET0_SHIFT     (0x00000000u)
#define CSL_GPIO_SET_DATA_SET0_RESETVAL  (0x00000000u)

/*----SET Tokens----*/
#define CSL_GPIO_SET_DATA_SET_SET        (0x00000001u)

#define CSL_GPIO_SET_DATA_RESETVAL       (0x00000000u)

/* CLR_DATA */

#define CSL_GPIO_CLR_DATA_CLR31_MASK     (0x80000000u)
#define CSL_GPIO_CLR_DATA_CLR31_SHIFT    (0x0000001Fu)
#define CSL_GPIO_CLR_DATA_CLR31_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR30_MASK     (0x40000000u)
#define CSL_GPIO_CLR_DATA_CLR30_SHIFT    (0x0000001Eu)
#define CSL_GPIO_CLR_DATA_CLR30_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR29_MASK     (0x20000000u)
#define CSL_GPIO_CLR_DATA_CLR29_SHIFT    (0x0000001Du)
#define CSL_GPIO_CLR_DATA_CLR29_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR28_MASK     (0x10000000u)
#define CSL_GPIO_CLR_DATA_CLR28_SHIFT    (0x0000001Cu)
#define CSL_GPIO_CLR_DATA_CLR28_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR27_MASK     (0x08000000u)
#define CSL_GPIO_CLR_DATA_CLR27_SHIFT    (0x0000001Bu)
#define CSL_GPIO_CLR_DATA_CLR27_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR26_MASK     (0x04000000u)
#define CSL_GPIO_CLR_DATA_CLR26_SHIFT    (0x0000001Au)
#define CSL_GPIO_CLR_DATA_CLR26_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR25_MASK     (0x02000000u)
#define CSL_GPIO_CLR_DATA_CLR25_SHIFT    (0x00000019u)
#define CSL_GPIO_CLR_DATA_CLR25_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR24_MASK     (0x01000000u)
#define CSL_GPIO_CLR_DATA_CLR24_SHIFT    (0x00000018u)
#define CSL_GPIO_CLR_DATA_CLR24_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR23_MASK     (0x00800000u)
#define CSL_GPIO_CLR_DATA_CLR23_SHIFT    (0x00000017u)
#define CSL_GPIO_CLR_DATA_CLR23_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR22_MASK     (0x00400000u)
#define CSL_GPIO_CLR_DATA_CLR22_SHIFT    (0x00000016u)
#define CSL_GPIO_CLR_DATA_CLR22_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR21_MASK     (0x00200000u)
#define CSL_GPIO_CLR_DATA_CLR21_SHIFT    (0x00000015u)
#define CSL_GPIO_CLR_DATA_CLR21_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR20_MASK     (0x00100000u)
#define CSL_GPIO_CLR_DATA_CLR20_SHIFT    (0x00000014u)
#define CSL_GPIO_CLR_DATA_CLR20_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR19_MASK     (0x00080000u)
#define CSL_GPIO_CLR_DATA_CLR19_SHIFT    (0x00000013u)
#define CSL_GPIO_CLR_DATA_CLR19_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR18_MASK     (0x00040000u)
#define CSL_GPIO_CLR_DATA_CLR18_SHIFT    (0x00000012u)
#define CSL_GPIO_CLR_DATA_CLR18_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR17_MASK     (0x00020000u)
#define CSL_GPIO_CLR_DATA_CLR17_SHIFT    (0x00000011u)
#define CSL_GPIO_CLR_DATA_CLR17_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR16_MASK     (0x00010000u)
#define CSL_GPIO_CLR_DATA_CLR16_SHIFT    (0x00000010u)
#define CSL_GPIO_CLR_DATA_CLR16_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR15_MASK     (0x00008000u)
#define CSL_GPIO_CLR_DATA_CLR15_SHIFT    (0x0000000Fu)
#define CSL_GPIO_CLR_DATA_CLR15_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR14_MASK     (0x00004000u)
#define CSL_GPIO_CLR_DATA_CLR14_SHIFT    (0x0000000Eu)
#define CSL_GPIO_CLR_DATA_CLR14_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR13_MASK     (0x00002000u)
#define CSL_GPIO_CLR_DATA_CLR13_SHIFT    (0x0000000Du)
#define CSL_GPIO_CLR_DATA_CLR13_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR12_MASK     (0x00001000u)
#define CSL_GPIO_CLR_DATA_CLR12_SHIFT    (0x0000000Cu)
#define CSL_GPIO_CLR_DATA_CLR12_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR11_MASK     (0x00000800u)
#define CSL_GPIO_CLR_DATA_CLR11_SHIFT    (0x0000000Bu)
#define CSL_GPIO_CLR_DATA_CLR11_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR10_MASK     (0x00000400u)
#define CSL_GPIO_CLR_DATA_CLR10_SHIFT    (0x0000000Au)
#define CSL_GPIO_CLR_DATA_CLR10_RESETVAL (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR9_MASK      (0x00000200u)
#define CSL_GPIO_CLR_DATA_CLR9_SHIFT     (0x00000009u)
#define CSL_GPIO_CLR_DATA_CLR9_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR8_MASK      (0x00000100u)
#define CSL_GPIO_CLR_DATA_CLR8_SHIFT     (0x00000008u)
#define CSL_GPIO_CLR_DATA_CLR8_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR7_MASK      (0x00000080u)
#define CSL_GPIO_CLR_DATA_CLR7_SHIFT     (0x00000007u)
#define CSL_GPIO_CLR_DATA_CLR7_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR6_MASK      (0x00000040u)
#define CSL_GPIO_CLR_DATA_CLR6_SHIFT     (0x00000006u)
#define CSL_GPIO_CLR_DATA_CLR6_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR5_MASK      (0x00000020u)
#define CSL_GPIO_CLR_DATA_CLR5_SHIFT     (0x00000005u)
#define CSL_GPIO_CLR_DATA_CLR5_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR4_MASK      (0x00000010u)
#define CSL_GPIO_CLR_DATA_CLR4_SHIFT     (0x00000004u)
#define CSL_GPIO_CLR_DATA_CLR4_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR3_MASK      (0x00000008u)
#define CSL_GPIO_CLR_DATA_CLR3_SHIFT     (0x00000003u)
#define CSL_GPIO_CLR_DATA_CLR3_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR2_MASK      (0x00000004u)
#define CSL_GPIO_CLR_DATA_CLR2_SHIFT     (0x00000002u)
#define CSL_GPIO_CLR_DATA_CLR2_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR1_MASK      (0x00000002u)
#define CSL_GPIO_CLR_DATA_CLR1_SHIFT     (0x00000001u)
#define CSL_GPIO_CLR_DATA_CLR1_RESETVAL  (0x00000000u)

#define CSL_GPIO_CLR_DATA_CLR0_MASK      (0x00000001u)
#define CSL_GPIO_CLR_DATA_CLR0_SHIFT     (0x00000000u)
#define CSL_GPIO_CLR_DATA_CLR0_RESETVAL  (0x00000000u)

/*----CLR Tokens----*/
#define CSL_GPIO_CLR_DATA_CLR_CLR        (0x00000001u)

#define CSL_GPIO_CLR_DATA_RESETVAL       (0x00000000u)

/* IN_DATA */

#define CSL_GPIO_IN_DATA_IN31_MASK       (0x80000000u)
#define CSL_GPIO_IN_DATA_IN31_SHIFT      (0x0000001Fu)
#define CSL_GPIO_IN_DATA_IN31_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN30_MASK       (0x40000000u)
#define CSL_GPIO_IN_DATA_IN30_SHIFT      (0x0000001Eu)
#define CSL_GPIO_IN_DATA_IN30_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN29_MASK       (0x20000000u)
#define CSL_GPIO_IN_DATA_IN29_SHIFT      (0x0000001Du)
#define CSL_GPIO_IN_DATA_IN29_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN28_MASK       (0x10000000u)
#define CSL_GPIO_IN_DATA_IN28_SHIFT      (0x0000001Cu)
#define CSL_GPIO_IN_DATA_IN28_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN27_MASK       (0x08000000u)
#define CSL_GPIO_IN_DATA_IN27_SHIFT      (0x0000001Bu)
#define CSL_GPIO_IN_DATA_IN27_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN26_MASK       (0x04000000u)
#define CSL_GPIO_IN_DATA_IN26_SHIFT      (0x0000001Au)
#define CSL_GPIO_IN_DATA_IN26_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN25_MASK       (0x02000000u)
#define CSL_GPIO_IN_DATA_IN25_SHIFT      (0x00000019u)
#define CSL_GPIO_IN_DATA_IN25_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN24_MASK       (0x01000000u)
#define CSL_GPIO_IN_DATA_IN24_SHIFT      (0x00000018u)
#define CSL_GPIO_IN_DATA_IN24_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN23_MASK       (0x00800000u)
#define CSL_GPIO_IN_DATA_IN23_SHIFT      (0x00000017u)
#define CSL_GPIO_IN_DATA_IN23_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN22_MASK       (0x00400000u)
#define CSL_GPIO_IN_DATA_IN22_SHIFT      (0x00000016u)
#define CSL_GPIO_IN_DATA_IN22_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN21_MASK       (0x00200000u)
#define CSL_GPIO_IN_DATA_IN21_SHIFT      (0x00000015u)
#define CSL_GPIO_IN_DATA_IN21_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN20_MASK       (0x00100000u)
#define CSL_GPIO_IN_DATA_IN20_SHIFT      (0x00000014u)
#define CSL_GPIO_IN_DATA_IN20_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN19_MASK       (0x00080000u)
#define CSL_GPIO_IN_DATA_IN19_SHIFT      (0x00000013u)
#define CSL_GPIO_IN_DATA_IN19_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN18_MASK       (0x00040000u)
#define CSL_GPIO_IN_DATA_IN18_SHIFT      (0x00000012u)
#define CSL_GPIO_IN_DATA_IN18_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN17_MASK       (0x00020000u)
#define CSL_GPIO_IN_DATA_IN17_SHIFT      (0x00000011u)
#define CSL_GPIO_IN_DATA_IN17_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN16_MASK       (0x00010000u)
#define CSL_GPIO_IN_DATA_IN16_SHIFT      (0x00000010u)
#define CSL_GPIO_IN_DATA_IN16_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN15_MASK       (0x00008000u)
#define CSL_GPIO_IN_DATA_IN15_SHIFT      (0x0000000Fu)
#define CSL_GPIO_IN_DATA_IN15_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN14_MASK       (0x00004000u)
#define CSL_GPIO_IN_DATA_IN14_SHIFT      (0x0000000Eu)
#define CSL_GPIO_IN_DATA_IN14_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN13_MASK       (0x00002000u)
#define CSL_GPIO_IN_DATA_IN13_SHIFT      (0x0000000Du)
#define CSL_GPIO_IN_DATA_IN13_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN12_MASK       (0x00001000u)
#define CSL_GPIO_IN_DATA_IN12_SHIFT      (0x0000000Cu)
#define CSL_GPIO_IN_DATA_IN12_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN11_MASK       (0x00000800u)
#define CSL_GPIO_IN_DATA_IN11_SHIFT      (0x0000000Bu)
#define CSL_GPIO_IN_DATA_IN11_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN10_MASK       (0x00000400u)
#define CSL_GPIO_IN_DATA_IN10_SHIFT      (0x0000000Au)
#define CSL_GPIO_IN_DATA_IN10_RESETVAL   (0x00000000u)

#define CSL_GPIO_IN_DATA_IN9_MASK        (0x00000200u)
#define CSL_GPIO_IN_DATA_IN9_SHIFT       (0x00000009u)
#define CSL_GPIO_IN_DATA_IN9_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN8_MASK        (0x00000100u)
#define CSL_GPIO_IN_DATA_IN8_SHIFT       (0x00000008u)
#define CSL_GPIO_IN_DATA_IN8_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN7_MASK        (0x00000080u)
#define CSL_GPIO_IN_DATA_IN7_SHIFT       (0x00000007u)
#define CSL_GPIO_IN_DATA_IN7_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN6_MASK        (0x00000040u)
#define CSL_GPIO_IN_DATA_IN6_SHIFT       (0x00000006u)
#define CSL_GPIO_IN_DATA_IN6_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN5_MASK        (0x00000020u)
#define CSL_GPIO_IN_DATA_IN5_SHIFT       (0x00000005u)
#define CSL_GPIO_IN_DATA_IN5_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN4_MASK        (0x00000010u)
#define CSL_GPIO_IN_DATA_IN4_SHIFT       (0x00000004u)
#define CSL_GPIO_IN_DATA_IN4_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN3_MASK        (0x00000008u)
#define CSL_GPIO_IN_DATA_IN3_SHIFT       (0x00000003u)
#define CSL_GPIO_IN_DATA_IN3_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN2_MASK        (0x00000004u)
#define CSL_GPIO_IN_DATA_IN2_SHIFT       (0x00000002u)
#define CSL_GPIO_IN_DATA_IN2_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN1_MASK        (0x00000002u)
#define CSL_GPIO_IN_DATA_IN1_SHIFT       (0x00000001u)
#define CSL_GPIO_IN_DATA_IN1_RESETVAL    (0x00000000u)

#define CSL_GPIO_IN_DATA_IN0_MASK        (0x00000001u)
#define CSL_GPIO_IN_DATA_IN0_SHIFT       (0x00000000u)
#define CSL_GPIO_IN_DATA_IN0_RESETVAL    (0x00000000u)

/*----IN Tokens----*/
#define CSL_GPIO_IN_DATA_IN_SET          (0x00000001u)
#define CSL_GPIO_IN_DATA_IN_CLR          (0x00000000u)

#define CSL_GPIO_IN_DATA_RESETVAL        (0x00000000u)

/* SET_RIS_TRIG */

#define CSL_GPIO_SET_RIS_TRIG_SETRIS31_MASK (0x80000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS31_SHIFT (0x0000001Fu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS31_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS30_MASK (0x40000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS30_SHIFT (0x0000001Eu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS30_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS29_MASK (0x20000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS29_SHIFT (0x0000001Du)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS29_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS28_MASK (0x10000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS28_SHIFT (0x0000001Cu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS28_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS27_MASK (0x08000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS27_SHIFT (0x0000001Bu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS27_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS26_MASK (0x04000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS26_SHIFT (0x0000001Au)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS26_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS25_MASK (0x02000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS25_SHIFT (0x00000019u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS25_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS24_MASK (0x01000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS24_SHIFT (0x00000018u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS24_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS23_MASK (0x00800000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS23_SHIFT (0x00000017u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS23_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS22_MASK (0x00400000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS22_SHIFT (0x00000016u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS22_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS21_MASK (0x00200000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS21_SHIFT (0x00000015u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS21_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS20_MASK (0x00100000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS20_SHIFT (0x00000014u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS20_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS19_MASK (0x00080000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS19_SHIFT (0x00000013u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS19_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS18_MASK (0x00040000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS18_SHIFT (0x00000012u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS18_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS17_MASK (0x00020000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS17_SHIFT (0x00000011u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS17_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS16_MASK (0x00010000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS16_SHIFT (0x00000010u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS16_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS15_MASK (0x00008000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS15_SHIFT (0x0000000Fu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS15_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS14_MASK (0x00004000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS14_SHIFT (0x0000000Eu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS14_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS13_MASK (0x00002000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS13_SHIFT (0x0000000Du)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS13_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS12_MASK (0x00001000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS12_SHIFT (0x0000000Cu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS12_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS11_MASK (0x00000800u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS11_SHIFT (0x0000000Bu)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS11_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS10_MASK (0x00000400u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS10_SHIFT (0x0000000Au)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS10_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS9_MASK (0x00000200u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS9_SHIFT (0x00000009u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS9_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS8_MASK (0x00000100u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS8_SHIFT (0x00000008u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS8_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS7_MASK (0x00000080u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS7_SHIFT (0x00000007u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS7_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS6_MASK (0x00000040u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS6_SHIFT (0x00000006u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS6_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS5_MASK (0x00000020u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS5_SHIFT (0x00000005u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS5_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS4_MASK (0x00000010u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS4_SHIFT (0x00000004u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS4_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS3_MASK (0x00000008u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS3_SHIFT (0x00000003u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS3_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS2_MASK (0x00000004u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS2_SHIFT (0x00000002u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS2_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS1_MASK (0x00000002u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS1_SHIFT (0x00000001u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS1_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_RIS_TRIG_SETRIS0_MASK (0x00000001u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS0_SHIFT (0x00000000u)
#define CSL_GPIO_SET_RIS_TRIG_SETRIS0_RESETVAL (0x00000000u)

/*----SETRIS Tokens----*/
#define CSL_GPIO_SET_RIS_TRIG_SETRIS_ENABLE (0x00000001u)

#define CSL_GPIO_SET_RIS_TRIG_RESETVAL   (0x00000000u)

/* CLR_RIS_TRIG */

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS31_MASK (0x80000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS31_SHIFT (0x0000001Fu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS31_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS30_MASK (0x40000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS30_SHIFT (0x0000001Eu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS30_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS29_MASK (0x20000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS29_SHIFT (0x0000001Du)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS29_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS28_MASK (0x10000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS28_SHIFT (0x0000001Cu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS28_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS27_MASK (0x08000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS27_SHIFT (0x0000001Bu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS27_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS26_MASK (0x04000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS26_SHIFT (0x0000001Au)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS26_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS25_MASK (0x02000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS25_SHIFT (0x00000019u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS25_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS24_MASK (0x01000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS24_SHIFT (0x00000018u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS24_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS23_MASK (0x00800000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS23_SHIFT (0x00000017u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS23_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS22_MASK (0x00400000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS22_SHIFT (0x00000016u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS22_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS21_MASK (0x00200000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS21_SHIFT (0x00000015u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS21_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS20_MASK (0x00100000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS20_SHIFT (0x00000014u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS20_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS19_MASK (0x00080000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS19_SHIFT (0x00000013u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS19_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS18_MASK (0x00040000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS18_SHIFT (0x00000012u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS18_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS17_MASK (0x00020000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS17_SHIFT (0x00000011u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS17_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS16_MASK (0x00010000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS16_SHIFT (0x00000010u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS16_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS15_MASK (0x00008000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS15_SHIFT (0x0000000Fu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS15_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS14_MASK (0x00004000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS14_SHIFT (0x0000000Eu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS14_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS13_MASK (0x00002000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS13_SHIFT (0x0000000Du)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS13_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS12_MASK (0x00001000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS12_SHIFT (0x0000000Cu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS12_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS11_MASK (0x00000800u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS11_SHIFT (0x0000000Bu)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS11_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS10_MASK (0x00000400u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS10_SHIFT (0x0000000Au)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS10_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS9_MASK (0x00000200u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS9_SHIFT (0x00000009u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS9_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS8_MASK (0x00000100u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS8_SHIFT (0x00000008u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS8_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS7_MASK (0x00000080u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS7_SHIFT (0x00000007u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS7_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS6_MASK (0x00000040u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS6_SHIFT (0x00000006u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS6_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS5_MASK (0x00000020u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS5_SHIFT (0x00000005u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS5_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS4_MASK (0x00000010u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS4_SHIFT (0x00000004u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS4_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS3_MASK (0x00000008u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS3_SHIFT (0x00000003u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS3_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS2_MASK (0x00000004u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS2_SHIFT (0x00000002u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS2_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS1_MASK (0x00000002u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS1_SHIFT (0x00000001u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS1_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS0_MASK (0x00000001u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS0_SHIFT (0x00000000u)
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS0_RESETVAL (0x00000001u)

/*----CLRRIS Tokens----*/
#define CSL_GPIO_CLR_RIS_TRIG_CLRRIS_DISABLE (0x00000000u)

#define CSL_GPIO_CLR_RIS_TRIG_RESETVAL   (0x00000001u)

/* SET_FAL_TRIG */

#define CSL_GPIO_SET_FAL_TRIG_SETFAL31_MASK (0x80000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL31_SHIFT (0x0000001Fu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL31_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL30_MASK (0x40000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL30_SHIFT (0x0000001Eu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL30_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL29_MASK (0x20000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL29_SHIFT (0x0000001Du)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL29_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL28_MASK (0x10000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL28_SHIFT (0x0000001Cu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL28_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL27_MASK (0x08000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL27_SHIFT (0x0000001Bu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL27_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL26_MASK (0x04000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL26_SHIFT (0x0000001Au)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL26_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL25_MASK (0x02000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL25_SHIFT (0x00000019u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL25_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL24_MASK (0x01000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL24_SHIFT (0x00000018u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL24_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL23_MASK (0x00800000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL23_SHIFT (0x00000017u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL23_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL22_MASK (0x00400000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL22_SHIFT (0x00000016u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL22_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL21_MASK (0x00200000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL21_SHIFT (0x00000015u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL21_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL20_MASK (0x00100000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL20_SHIFT (0x00000014u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL20_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL19_MASK (0x00080000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL19_SHIFT (0x00000013u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL19_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL18_MASK (0x00040000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL18_SHIFT (0x00000012u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL18_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL17_MASK (0x00020000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL17_SHIFT (0x00000011u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL17_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL16_MASK (0x00010000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL16_SHIFT (0x00000010u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL16_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL15_MASK (0x00008000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL15_SHIFT (0x0000000Fu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL15_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL14_MASK (0x00004000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL14_SHIFT (0x0000000Eu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL14_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL13_MASK (0x00002000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL13_SHIFT (0x0000000Du)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL13_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL12_MASK (0x00001000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL12_SHIFT (0x0000000Cu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL12_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL11_MASK (0x00000800u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL11_SHIFT (0x0000000Bu)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL11_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL10_MASK (0x00000400u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL10_SHIFT (0x0000000Au)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL10_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL9_MASK (0x00000200u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL9_SHIFT (0x00000009u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL9_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL8_MASK (0x00000100u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL8_SHIFT (0x00000008u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL8_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL7_MASK (0x00000080u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL7_SHIFT (0x00000007u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL7_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL6_MASK (0x00000040u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL6_SHIFT (0x00000006u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL6_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL5_MASK (0x00000020u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL5_SHIFT (0x00000005u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL5_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL4_MASK (0x00000010u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL4_SHIFT (0x00000004u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL4_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL3_MASK (0x00000008u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL3_SHIFT (0x00000003u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL3_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL2_MASK (0x00000004u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL2_SHIFT (0x00000002u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL2_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL1_MASK (0x00000002u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL1_SHIFT (0x00000001u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL1_RESETVAL (0x00000000u)

#define CSL_GPIO_SET_FAL_TRIG_SETFAL0_MASK (0x00000001u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL0_SHIFT (0x00000000u)
#define CSL_GPIO_SET_FAL_TRIG_SETFAL0_RESETVAL (0x00000000u)

/*----SETFAL Tokens----*/
#define CSL_GPIO_SET_FAL_TRIG_SETFAL_ENABLE (0x00000001u)

#define CSL_GPIO_SET_FAL_TRIG_RESETVAL   (0x00000000u)

/* CLR_FAL_TRIG */

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL31_MASK (0x80000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL31_SHIFT (0x0000001Fu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL31_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL30_MASK (0x40000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL30_SHIFT (0x0000001Eu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL30_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL29_MASK (0x20000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL29_SHIFT (0x0000001Du)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL29_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL28_MASK (0x10000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL28_SHIFT (0x0000001Cu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL28_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL27_MASK (0x08000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL27_SHIFT (0x0000001Bu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL27_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL26_MASK (0x04000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL26_SHIFT (0x0000001Au)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL26_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL25_MASK (0x02000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL25_SHIFT (0x00000019u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL25_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL24_MASK (0x01000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL24_SHIFT (0x00000018u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL24_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL23_MASK (0x00800000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL23_SHIFT (0x00000017u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL23_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL22_MASK (0x00400000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL22_SHIFT (0x00000016u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL22_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL21_MASK (0x00200000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL21_SHIFT (0x00000015u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL21_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL20_MASK (0x00100000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL20_SHIFT (0x00000014u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL20_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL19_MASK (0x00080000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL19_SHIFT (0x00000013u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL19_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL18_MASK (0x00040000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL18_SHIFT (0x00000012u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL18_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL17_MASK (0x00020000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL17_SHIFT (0x00000011u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL17_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL16_MASK (0x00010000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL16_SHIFT (0x00000010u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL16_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL15_MASK (0x00008000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL15_SHIFT (0x0000000Fu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL15_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL14_MASK (0x00004000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL14_SHIFT (0x0000000Eu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL14_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL13_MASK (0x00002000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL13_SHIFT (0x0000000Du)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL13_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL12_MASK (0x00001000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL12_SHIFT (0x0000000Cu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL12_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL11_MASK (0x00000800u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL11_SHIFT (0x0000000Bu)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL11_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL10_MASK (0x00000400u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL10_SHIFT (0x0000000Au)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL10_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL9_MASK (0x00000200u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL9_SHIFT (0x00000009u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL9_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL8_MASK (0x00000100u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL8_SHIFT (0x00000008u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL8_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL7_MASK (0x00000080u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL7_SHIFT (0x00000007u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL7_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL6_MASK (0x00000040u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL6_SHIFT (0x00000006u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL6_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL5_MASK (0x00000020u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL5_SHIFT (0x00000005u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL5_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL4_MASK (0x00000010u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL4_SHIFT (0x00000004u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL4_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL3_MASK (0x00000008u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL3_SHIFT (0x00000003u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL3_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL2_MASK (0x00000004u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL2_SHIFT (0x00000002u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL2_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL1_MASK (0x00000002u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL1_SHIFT (0x00000001u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL1_RESETVAL (0x00000001u)

#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL0_MASK (0x00000001u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL0_SHIFT (0x00000000u)
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL0_RESETVAL (0x00000001u)

/*----CLRFAL Tokens----*/
#define CSL_GPIO_CLR_FAL_TRIG_CLRFAL_DISABLE (0x00000000u)

#define CSL_GPIO_CLR_FAL_TRIG_RESETVAL   (0x00000001u)

/* INTSTAT */

#define CSL_GPIO_INTSTAT_STAT31_MASK     (0x80000000u)
#define CSL_GPIO_INTSTAT_STAT31_SHIFT    (0x0000001Fu)
#define CSL_GPIO_INTSTAT_STAT31_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT30_MASK     (0x40000000u)
#define CSL_GPIO_INTSTAT_STAT30_SHIFT    (0x0000001Eu)
#define CSL_GPIO_INTSTAT_STAT30_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT29_MASK     (0x20000000u)
#define CSL_GPIO_INTSTAT_STAT29_SHIFT    (0x0000001Du)
#define CSL_GPIO_INTSTAT_STAT29_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT28_MASK     (0x10000000u)
#define CSL_GPIO_INTSTAT_STAT28_SHIFT    (0x0000001Cu)
#define CSL_GPIO_INTSTAT_STAT28_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT27_MASK     (0x08000000u)
#define CSL_GPIO_INTSTAT_STAT27_SHIFT    (0x0000001Bu)
#define CSL_GPIO_INTSTAT_STAT27_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT26_MASK     (0x04000000u)
#define CSL_GPIO_INTSTAT_STAT26_SHIFT    (0x0000001Au)
#define CSL_GPIO_INTSTAT_STAT26_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT25_MASK     (0x02000000u)
#define CSL_GPIO_INTSTAT_STAT25_SHIFT    (0x00000019u)
#define CSL_GPIO_INTSTAT_STAT25_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT24_MASK     (0x01000000u)
#define CSL_GPIO_INTSTAT_STAT24_SHIFT    (0x00000018u)
#define CSL_GPIO_INTSTAT_STAT24_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT23_MASK     (0x00800000u)
#define CSL_GPIO_INTSTAT_STAT23_SHIFT    (0x00000017u)
#define CSL_GPIO_INTSTAT_STAT23_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT22_MASK     (0x00400000u)
#define CSL_GPIO_INTSTAT_STAT22_SHIFT    (0x00000016u)
#define CSL_GPIO_INTSTAT_STAT22_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT21_MASK     (0x00200000u)
#define CSL_GPIO_INTSTAT_STAT21_SHIFT    (0x00000015u)
#define CSL_GPIO_INTSTAT_STAT21_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT20_MASK     (0x00100000u)
#define CSL_GPIO_INTSTAT_STAT20_SHIFT    (0x00000014u)
#define CSL_GPIO_INTSTAT_STAT20_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT19_MASK     (0x00080000u)
#define CSL_GPIO_INTSTAT_STAT19_SHIFT    (0x00000013u)
#define CSL_GPIO_INTSTAT_STAT19_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT18_MASK     (0x00040000u)
#define CSL_GPIO_INTSTAT_STAT18_SHIFT    (0x00000012u)
#define CSL_GPIO_INTSTAT_STAT18_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT17_MASK     (0x00020000u)
#define CSL_GPIO_INTSTAT_STAT17_SHIFT    (0x00000011u)
#define CSL_GPIO_INTSTAT_STAT17_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT16_MASK     (0x00010000u)
#define CSL_GPIO_INTSTAT_STAT16_SHIFT    (0x00000010u)
#define CSL_GPIO_INTSTAT_STAT16_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT15_MASK     (0x00008000u)
#define CSL_GPIO_INTSTAT_STAT15_SHIFT    (0x0000000Fu)
#define CSL_GPIO_INTSTAT_STAT15_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT14_MASK     (0x00004000u)
#define CSL_GPIO_INTSTAT_STAT14_SHIFT    (0x0000000Eu)
#define CSL_GPIO_INTSTAT_STAT14_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT13_MASK     (0x00002000u)
#define CSL_GPIO_INTSTAT_STAT13_SHIFT    (0x0000000Du)
#define CSL_GPIO_INTSTAT_STAT13_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT12_MASK     (0x00001000u)
#define CSL_GPIO_INTSTAT_STAT12_SHIFT    (0x0000000Cu)
#define CSL_GPIO_INTSTAT_STAT12_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT11_MASK     (0x00000800u)
#define CSL_GPIO_INTSTAT_STAT11_SHIFT    (0x0000000Bu)
#define CSL_GPIO_INTSTAT_STAT11_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT10_MASK     (0x00000400u)
#define CSL_GPIO_INTSTAT_STAT10_SHIFT    (0x0000000Au)
#define CSL_GPIO_INTSTAT_STAT10_RESETVAL (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT9_MASK      (0x00000200u)
#define CSL_GPIO_INTSTAT_STAT9_SHIFT     (0x00000009u)
#define CSL_GPIO_INTSTAT_STAT9_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT8_MASK      (0x00000100u)
#define CSL_GPIO_INTSTAT_STAT8_SHIFT     (0x00000008u)
#define CSL_GPIO_INTSTAT_STAT8_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT7_MASK      (0x00000080u)
#define CSL_GPIO_INTSTAT_STAT7_SHIFT     (0x00000007u)
#define CSL_GPIO_INTSTAT_STAT7_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT6_MASK      (0x00000040u)
#define CSL_GPIO_INTSTAT_STAT6_SHIFT     (0x00000006u)
#define CSL_GPIO_INTSTAT_STAT6_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT5_MASK      (0x00000020u)
#define CSL_GPIO_INTSTAT_STAT5_SHIFT     (0x00000005u)
#define CSL_GPIO_INTSTAT_STAT5_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT4_MASK      (0x00000010u)
#define CSL_GPIO_INTSTAT_STAT4_SHIFT     (0x00000004u)
#define CSL_GPIO_INTSTAT_STAT4_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT3_MASK      (0x00000008u)
#define CSL_GPIO_INTSTAT_STAT3_SHIFT     (0x00000003u)
#define CSL_GPIO_INTSTAT_STAT3_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT2_MASK      (0x00000004u)
#define CSL_GPIO_INTSTAT_STAT2_SHIFT     (0x00000002u)
#define CSL_GPIO_INTSTAT_STAT2_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT1_MASK      (0x00000002u)
#define CSL_GPIO_INTSTAT_STAT1_SHIFT     (0x00000001u)
#define CSL_GPIO_INTSTAT_STAT1_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_STAT0_MASK      (0x00000001u)
#define CSL_GPIO_INTSTAT_STAT0_SHIFT     (0x00000000u)
#define CSL_GPIO_INTSTAT_STAT0_RESETVAL  (0x00000000u)

#define CSL_GPIO_INTSTAT_RESETVAL        (0x00000000u)

#endif
