/* --------------------------------------------------------------------------
  FILE        : util.h
  PROJECT     : DA8xx/OMAP-L138 ROM Boot Loader
  AUTHOR      : Urmil Parikh, Daniel Allred
  DESC        : Boot loader util functions
 ----------------------------------------------------------------------------- */

#ifndef _UTIL_H_
#define _UTIL_H_

/************************************************************
* Include Files                                             *
************************************************************/

#include "tistdtypes.h"

// Prevent C++ name mangling
#ifdef __cplusplus
extern far "c" {
#endif


/***********************************************************
* Global Macro Declarations                                *
***********************************************************/


/***********************************************************
* Global Typedef declarations                              *
***********************************************************/


/***********************************************************
* Global Variable Declarations                             *
***********************************************************/


/***********************************************************
* Global Function Declarations                             *
***********************************************************/

void UTIL_memcpy (Uint32 dst, Uint32 src, Uint32 cnt);
void UTIL_memset (Uint32 dst, Uint32 val, Uint32 cnt);
void UTIL_waitLoop (Uint32 cycles);
void UTIL_waitLoopAccurate (Uint32 cycles);


/***********************************************************
* End file                                                 *
***********************************************************/

#ifdef __cplusplus
}
#endif

#endif  // _UTIL_H_
