/****************************************************************************/
/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *  ============================================================================
 */
 
-c
-heap  0x1000
-stack 0x3000


/* Symmetric Memory Map */
MEMORY
{
   CACHE_L2    : origin = 0x8c0000,    len = 0x40000
   CACHE_L1P   : origin = 0xe04000,    len = 0x4000
   CACHE_L1D   : origin = 0xf04000,    len = 0x4000
   DDR2        : origin = 0x80000000,  len = 0x10000000
   L2          : origin = 0x800000,    len = 0xc0000
   L1P         : origin = 0xe00000,    len = 0x4000
   L1D         : origin = 0xf00000,    len = 0x4000
   GEM0L2      : origin = 0x10800000,  len = 0xc0000
   GEM1L2      : origin = 0x11800000,  len = 0xc0000
   GEM2L2      : origin = 0x12800000,  len = 0xc0000
} 

SECTIONS
{
    .csl_vect   >       L2
    .text       >       L2
    .stack      >       L2
    .bss        >       L2
    .cinit      >       L2
    .cio        >       L2
    .const      >       L2
    .data       >       L2
    .switch     >       L2
    .sysmem     >       L2
    .far        >       L2
    .far:ICCRam >       DDR2
    .G0L2		>		GEM0L2
    .G1L2		>		GEM1L2
}

-l csl_c6474e.lib
-l csl_c64xplus_intce.lib

