/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_emac.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for EMAC
 *
 */
#ifndef _CSLR_EMAC_H_
#define _CSLR_EMAC_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 TXIDVER;
    volatile Uint32 TXCONTROL;
    volatile Uint32 TXTEARDOWN;
    volatile Uint8 RSVD0[4];
    volatile Uint32 RXIDVER;
    volatile Uint32 RXCONTROL;
    volatile Uint32 RXTEARDOWN;
    volatile Uint8 RSVD1[100];
    volatile Uint32 TXINTSTATRAW;
    volatile Uint32 TXINTSTATMASKED;
    volatile Uint32 TXINTMASKSET;
    volatile Uint32 TXINTMASKCLEAR;
    volatile Uint32 MACINVECTOR;
    volatile Uint32 MACEOIVECTOR;
    volatile Uint8 RSVD2[8];
    volatile Uint32 RXINTSTATRAW;
    volatile Uint32 RXINTSTATMASKED;
    volatile Uint32 RXINTMASKSET;
    volatile Uint32 RXINTMASKCLEAR;
    volatile Uint32 MACINTSTATRAW;
    volatile Uint32 MACINTSTATMASKED;
    volatile Uint32 MACINTMASKSET;
    volatile Uint32 MACINTMASKCLEAR;
    volatile Uint8 RSVD3[64];
    volatile Uint32 RXMBPENABLE;
    volatile Uint32 RXUNICASTSET;
    volatile Uint32 RXUNICASTCLEAR;
    volatile Uint32 RXMAXLEN;
    volatile Uint32 RXBUFFEROFFSET;
    volatile Uint32 RXFILTERLOWTHRESH;
    volatile Uint8 RSVD4[8];
    volatile Uint32 RX0FLOWTHRESH;
    volatile Uint32 RX1FLOWTHRESH;
    volatile Uint32 RX2FLOWTHRESH;
    volatile Uint32 RX3FLOWTHRESH;
    volatile Uint32 RX4FLOWTHRESH;
    volatile Uint32 RX5FLOWTHRESH;
    volatile Uint32 RX6FLOWTHRESH;
    volatile Uint32 RX7FLOWTHRESH;
    volatile Uint32 RX0FREEBUFFER;
    volatile Uint32 RX1FREEBUFFER;
    volatile Uint32 RX2FREEBUFFER;
    volatile Uint32 RX3FREEBUFFER;
    volatile Uint32 RX4FREEBUFFER;
    volatile Uint32 RX5FREEBUFFER;
    volatile Uint32 RX6FREEBUFFER;
    volatile Uint32 RX7FREEBUFFER;
    volatile Uint32 MACCONTROL;
    volatile Uint32 MACSTATUS;
    volatile Uint32 EMCONTROL;
    volatile Uint32 FIFOCONTROL;
    volatile Uint32 MACCONFIG;
    volatile Uint32 SOFTRESET;
    volatile Uint8 RSVD5[88];
    volatile Uint32 MACSRCADDRLO;
    volatile Uint32 MACSRCADDRHI;
    volatile Uint32 MACHASH1;
    volatile Uint32 MACHASH2;
    volatile Uint32 BOFFTEST;
    volatile Uint32 TPACETEST;
    volatile Uint32 RXPAUSE;
    volatile Uint32 TXPAUSE;
    volatile Uint8 RSVD6[16];
    volatile Uint32 RXGOODFRAMES;
    volatile Uint32 RXBCASTFRAMES;
    volatile Uint32 RXMCASTFRAMES;
    volatile Uint32 RXPAUSEFRAMES;
    volatile Uint32 RXCRCERRORS;
    volatile Uint32 RXALIGNCODEERRORS;
    volatile Uint32 RXOVERSIZED;
    volatile Uint32 RXJABBER;
    volatile Uint32 RXUNDERSIZED;
    volatile Uint32 RXFRAGMENTS;
    volatile Uint32 RXFILTERED;
    volatile Uint32 RXQOSFILTERED;
    volatile Uint32 RXOCTETS;
    volatile Uint32 TXGOODFRAMES;
    volatile Uint32 TXBCASTFRAMES;
    volatile Uint32 TXMCASTFRAMES;
    volatile Uint32 TXPAUSEFRAMES;
    volatile Uint32 TXDEFERRED;
    volatile Uint32 TXCOLLISION;
    volatile Uint32 TXSINGLECOLL;
    volatile Uint32 TXMULTICOLL;
    volatile Uint32 TXEXCESSIVECOLL;
    volatile Uint32 TXLATECOLL;
    volatile Uint32 TXUNDERRUN;
    volatile Uint32 TXCARRIERSENSE;
    volatile Uint32 TXOCTETS;
    volatile Uint32 FRAME64;
    volatile Uint32 FRAME65T127;
    volatile Uint32 FRAME128T255;
    volatile Uint32 FRAME256T511;
    volatile Uint32 FRAME512T1023;
    volatile Uint32 FRAME1024TUP;
    volatile Uint32 NETOCTETS;
    volatile Uint32 RXSOFOVERRUNS;
    volatile Uint32 RXMOFOVERRUNS;
    volatile Uint32 RXDMAOVERRUNS;
    volatile Uint8 RSVD7[624];
    volatile Uint32 MACADDRLO;
    volatile Uint32 MACADDRHI;
    volatile Uint32 MACINDEX;
    volatile Uint8 RSVD8[244];
    volatile Uint32 TX0HDP;
    volatile Uint32 TX1HDP;
    volatile Uint32 TX2HDP;
    volatile Uint32 TX3HDP;
    volatile Uint32 TX4HDP;
    volatile Uint32 TX5HDP;
    volatile Uint32 TX6HDP;
    volatile Uint32 TX7HDP;
    volatile Uint32 RX0HDP;
    volatile Uint32 RX1HDP;
    volatile Uint32 RX2HDP;
    volatile Uint32 RX3HDP;
    volatile Uint32 RX4HDP;
    volatile Uint32 RX5HDP;
    volatile Uint32 RX6HDP;
    volatile Uint32 RX7HDP;
    volatile Uint32 TX0CP;
    volatile Uint32 TX1CP;
    volatile Uint32 TX2CP;
    volatile Uint32 TX3CP;
    volatile Uint32 TX4CP;
    volatile Uint32 TX5CP;
    volatile Uint32 TX6CP;
    volatile Uint32 TX7CP;
    volatile Uint32 RX0CP;
    volatile Uint32 RX1CP;
    volatile Uint32 RX2CP;
    volatile Uint32 RX3CP;
    volatile Uint32 RX4CP;
    volatile Uint32 RX5CP;
    volatile Uint32 RX6CP;
    volatile Uint32 RX7CP;
} CSL_EmacRegs;


/***********************************************************************
 * EMAC Descriptor
 *
 * The following is the format of a single buffer descriptor
 * on the EMAC.
 ***********************************************************************/
typedef struct _EMAC_Desc {
  struct _EMAC_Desc *pNext;     /* Pointer to next descriptor in chain */
  Uint8             *pBuffer;   /* Pointer to data buffer              */
  Uint32            BufOffLen;  /* Buffer Offset(MSW) and Length(LSW)  */
  Uint32            PktFlgLen;  /* Packet Flags(MSW) and Length(LSW)   */
} EMAC_Desc;


/* ------------------------ */
/* DESCRIPTOR ACCESS MACROS */
/* ------------------------ */

/* Packet Flags */
#define EMAC_DSC_FLAG_SOP                       0x80000000u
#define EMAC_DSC_FLAG_EOP                       0x40000000u
#define EMAC_DSC_FLAG_OWNER                     0x20000000u
#define EMAC_DSC_FLAG_EOQ                       0x10000000u
#define EMAC_DSC_FLAG_TDOWNCMPLT                0x08000000u
#define EMAC_DSC_FLAG_PASSCRC                   0x04000000u

/* The following flags are RX only */
#define EMAC_DSC_FLAG_JABBER                    0x02000000u
#define EMAC_DSC_FLAG_OVERSIZE                  0x01000000u
#define EMAC_DSC_FLAG_FRAGMENT                  0x00800000u
#define EMAC_DSC_FLAG_UNDERSIZED                0x00400000u
#define EMAC_DSC_FLAG_CONTROL                   0x00200000u
#define EMAC_DSC_FLAG_OVERRUN                   0x00100000u
#define EMAC_DSC_FLAG_CODEERROR                 0x00080000u
#define EMAC_DSC_FLAG_ALIGNERROR                0x00040000u
#define EMAC_DSC_FLAG_CRCERROR                  0x00020000u
#define EMAC_DSC_FLAG_NOMATCH                   0x00010000u



/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TXIDVER */

#define CSL_EMAC_TXIDVER_TXIDENT_MASK    (0xFFFF0000u)
#define CSL_EMAC_TXIDVER_TXIDENT_SHIFT   (0x00000010u)
#define CSL_EMAC_TXIDVER_TXIDENT_RESETVAL (0x0000000Cu)

#define CSL_EMAC_TXIDVER_TXMAJORVER_MASK (0x0000FF00u)
#define CSL_EMAC_TXIDVER_TXMAJORVER_SHIFT (0x00000008u)
#define CSL_EMAC_TXIDVER_TXMAJORVER_RESETVAL (0x0000000Au)

#define CSL_EMAC_TXIDVER_TXMINORVER_MASK (0x000000FFu)
#define CSL_EMAC_TXIDVER_TXMINORVER_SHIFT (0x00000000u)
#define CSL_EMAC_TXIDVER_TXMINORVER_RESETVAL (0x0000000Bu)

#define CSL_EMAC_TXIDVER_RESETVAL        (0x000C0A0Bu)

/* TXCONTROL */

#define CSL_EMAC_TXCONTROL_TXEN_MASK     (0x00000001u)
#define CSL_EMAC_TXCONTROL_TXEN_SHIFT    (0x00000000u)
#define CSL_EMAC_TXCONTROL_TXEN_RESETVAL (0x00000000u)

/*----TXEN Tokens----*/
#define CSL_EMAC_TXCONTROL_TXEN_DISABLE  (0x00000000u)
#define CSL_EMAC_TXCONTROL_TXEN_ENABLE   (0x00000001u)

#define CSL_EMAC_TXCONTROL_RESETVAL      (0x00000000u)

/* TXTEARDOWN */

#define CSL_EMAC_TXTEARDOWN_TXTDNCH_MASK (0x00000007u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_SHIFT (0x00000000u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_RESETVAL (0x00000000u)

/*----TXTDNCH Tokens----*/
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA0 (0x00000000u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA1 (0x00000001u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA2 (0x00000002u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA3 (0x00000003u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA4 (0x00000004u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA5 (0x00000005u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA6 (0x00000006u)
#define CSL_EMAC_TXTEARDOWN_TXTDNCH_CHA7 (0x00000007u)

#define CSL_EMAC_TXTEARDOWN_RESETVAL     (0x00000000u)

/* RXIDVER */

#define CSL_EMAC_RXIDVER_RXIDENT_MASK    (0xFFFF0000u)
#define CSL_EMAC_RXIDVER_RXIDENT_SHIFT   (0x00000010u)
#define CSL_EMAC_RXIDVER_RXIDENT_RESETVAL (0x0000000Cu)

#define CSL_EMAC_RXIDVER_RXMAJORVER_MASK (0x0000FF00u)
#define CSL_EMAC_RXIDVER_RXMAJORVER_SHIFT (0x00000008u)
#define CSL_EMAC_RXIDVER_RXMAJORVER_RESETVAL (0x0000000Au)

#define CSL_EMAC_RXIDVER_RXMINORVER_MASK (0x000000FFu)
#define CSL_EMAC_RXIDVER_RXMINORVER_SHIFT (0x00000000u)
#define CSL_EMAC_RXIDVER_RXMINORVER_RESETVAL (0x0000000Bu)

#define CSL_EMAC_RXIDVER_RESETVAL        (0x000C0A0Bu)

/* RXCONTROL */

#define CSL_EMAC_RXCONTROL_RXEN_MASK     (0x00000001u)
#define CSL_EMAC_RXCONTROL_RXEN_SHIFT    (0x00000000u)
#define CSL_EMAC_RXCONTROL_RXEN_RESETVAL (0x00000000u)

/*----RXEN Tokens----*/
#define CSL_EMAC_RXCONTROL_RXEN_DISABLE  (0x00000000u)
#define CSL_EMAC_RXCONTROL_RXEN_ENABLE   (0x00000001u)

#define CSL_EMAC_RXCONTROL_RESETVAL      (0x00000000u)

/* RXTEARDOWN */

#define CSL_EMAC_RXTEARDOWN_RXTDNCH_MASK (0x00000007u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_SHIFT (0x00000000u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_RESETVAL (0x00000000u)

/*----RXTDNCH Tokens----*/
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA0 (0x00000000u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA1 (0x00000001u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA2 (0x00000002u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA3 (0x00000003u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA4 (0x00000004u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA5 (0x00000005u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA6 (0x00000006u)
#define CSL_EMAC_RXTEARDOWN_RXTDNCH_CHA7 (0x00000007u)

#define CSL_EMAC_RXTEARDOWN_RESETVAL     (0x00000000u)

/* TXINTSTATRAW */

#define CSL_EMAC_TXINTSTATRAW_TX7PEND_MASK (0x00000080u)
#define CSL_EMAC_TXINTSTATRAW_TX7PEND_SHIFT (0x00000007u)
#define CSL_EMAC_TXINTSTATRAW_TX7PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX6PEND_MASK (0x00000040u)
#define CSL_EMAC_TXINTSTATRAW_TX6PEND_SHIFT (0x00000006u)
#define CSL_EMAC_TXINTSTATRAW_TX6PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX5PEND_MASK (0x00000020u)
#define CSL_EMAC_TXINTSTATRAW_TX5PEND_SHIFT (0x00000005u)
#define CSL_EMAC_TXINTSTATRAW_TX5PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX4PEND_MASK (0x00000010u)
#define CSL_EMAC_TXINTSTATRAW_TX4PEND_SHIFT (0x00000004u)
#define CSL_EMAC_TXINTSTATRAW_TX4PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX3PEND_MASK (0x00000008u)
#define CSL_EMAC_TXINTSTATRAW_TX3PEND_SHIFT (0x00000003u)
#define CSL_EMAC_TXINTSTATRAW_TX3PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX2PEND_MASK (0x00000004u)
#define CSL_EMAC_TXINTSTATRAW_TX2PEND_SHIFT (0x00000002u)
#define CSL_EMAC_TXINTSTATRAW_TX2PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX1PEND_MASK (0x00000002u)
#define CSL_EMAC_TXINTSTATRAW_TX1PEND_SHIFT (0x00000001u)
#define CSL_EMAC_TXINTSTATRAW_TX1PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_TX0PEND_MASK (0x00000001u)
#define CSL_EMAC_TXINTSTATRAW_TX0PEND_SHIFT (0x00000000u)
#define CSL_EMAC_TXINTSTATRAW_TX0PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATRAW_RESETVAL   (0x00000000u)

/* TXINTSTATMASKED */

#define CSL_EMAC_TXINTSTATMASKED_TX7PEND_MASK (0x00000080u)
#define CSL_EMAC_TXINTSTATMASKED_TX7PEND_SHIFT (0x00000007u)
#define CSL_EMAC_TXINTSTATMASKED_TX7PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX6PEND_MASK (0x00000040u)
#define CSL_EMAC_TXINTSTATMASKED_TX6PEND_SHIFT (0x00000006u)
#define CSL_EMAC_TXINTSTATMASKED_TX6PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX5PEND_MASK (0x00000020u)
#define CSL_EMAC_TXINTSTATMASKED_TX5PEND_SHIFT (0x00000005u)
#define CSL_EMAC_TXINTSTATMASKED_TX5PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX4PEND_MASK (0x00000010u)
#define CSL_EMAC_TXINTSTATMASKED_TX4PEND_SHIFT (0x00000004u)
#define CSL_EMAC_TXINTSTATMASKED_TX4PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX3PEND_MASK (0x00000008u)
#define CSL_EMAC_TXINTSTATMASKED_TX3PEND_SHIFT (0x00000003u)
#define CSL_EMAC_TXINTSTATMASKED_TX3PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX2PEND_MASK (0x00000004u)
#define CSL_EMAC_TXINTSTATMASKED_TX2PEND_SHIFT (0x00000002u)
#define CSL_EMAC_TXINTSTATMASKED_TX2PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX1PEND_MASK (0x00000002u)
#define CSL_EMAC_TXINTSTATMASKED_TX1PEND_SHIFT (0x00000001u)
#define CSL_EMAC_TXINTSTATMASKED_TX1PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_TX0PEND_MASK (0x00000001u)
#define CSL_EMAC_TXINTSTATMASKED_TX0PEND_SHIFT (0x00000000u)
#define CSL_EMAC_TXINTSTATMASKED_TX0PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTSTATMASKED_RESETVAL (0x00000000u)

/* TXINTMASKSET */

#define CSL_EMAC_TXINTMASKSET_TX7MASK_MASK (0x00000080u)
#define CSL_EMAC_TXINTMASKSET_TX7MASK_SHIFT (0x00000007u)
#define CSL_EMAC_TXINTMASKSET_TX7MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX6MASK_MASK (0x00000040u)
#define CSL_EMAC_TXINTMASKSET_TX6MASK_SHIFT (0x00000006u)
#define CSL_EMAC_TXINTMASKSET_TX6MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX5MASK_MASK (0x00000020u)
#define CSL_EMAC_TXINTMASKSET_TX5MASK_SHIFT (0x00000005u)
#define CSL_EMAC_TXINTMASKSET_TX5MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX4MASK_MASK (0x00000010u)
#define CSL_EMAC_TXINTMASKSET_TX4MASK_SHIFT (0x00000004u)
#define CSL_EMAC_TXINTMASKSET_TX4MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX3MASK_MASK (0x00000008u)
#define CSL_EMAC_TXINTMASKSET_TX3MASK_SHIFT (0x00000003u)
#define CSL_EMAC_TXINTMASKSET_TX3MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX2MASK_MASK (0x00000004u)
#define CSL_EMAC_TXINTMASKSET_TX2MASK_SHIFT (0x00000002u)
#define CSL_EMAC_TXINTMASKSET_TX2MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX1MASK_MASK (0x00000002u)
#define CSL_EMAC_TXINTMASKSET_TX1MASK_SHIFT (0x00000001u)
#define CSL_EMAC_TXINTMASKSET_TX1MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_TX0MASK_MASK (0x00000001u)
#define CSL_EMAC_TXINTMASKSET_TX0MASK_SHIFT (0x00000000u)
#define CSL_EMAC_TXINTMASKSET_TX0MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKSET_RESETVAL   (0x00000000u)

/* TXINTMASKCLEAR */

#define CSL_EMAC_TXINTMASKCLEAR_TX7MASK_MASK (0x00000080u)
#define CSL_EMAC_TXINTMASKCLEAR_TX7MASK_SHIFT (0x00000007u)
#define CSL_EMAC_TXINTMASKCLEAR_TX7MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX6MASK_MASK (0x00000040u)
#define CSL_EMAC_TXINTMASKCLEAR_TX6MASK_SHIFT (0x00000006u)
#define CSL_EMAC_TXINTMASKCLEAR_TX6MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX5MASK_MASK (0x00000020u)
#define CSL_EMAC_TXINTMASKCLEAR_TX5MASK_SHIFT (0x00000005u)
#define CSL_EMAC_TXINTMASKCLEAR_TX5MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX4MASK_MASK (0x00000010u)
#define CSL_EMAC_TXINTMASKCLEAR_TX4MASK_SHIFT (0x00000004u)
#define CSL_EMAC_TXINTMASKCLEAR_TX4MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX3MASK_MASK (0x00000008u)
#define CSL_EMAC_TXINTMASKCLEAR_TX3MASK_SHIFT (0x00000003u)
#define CSL_EMAC_TXINTMASKCLEAR_TX3MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX2MASK_MASK (0x00000004u)
#define CSL_EMAC_TXINTMASKCLEAR_TX2MASK_SHIFT (0x00000002u)
#define CSL_EMAC_TXINTMASKCLEAR_TX2MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX1MASK_MASK (0x00000002u)
#define CSL_EMAC_TXINTMASKCLEAR_TX1MASK_SHIFT (0x00000001u)
#define CSL_EMAC_TXINTMASKCLEAR_TX1MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_TX0MASK_MASK (0x00000001u)
#define CSL_EMAC_TXINTMASKCLEAR_TX0MASK_SHIFT (0x00000000u)
#define CSL_EMAC_TXINTMASKCLEAR_TX0MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_TXINTMASKCLEAR_RESETVAL (0x00000000u)

/* MACINVECTOR */

#define CSL_EMAC_MACINVECTOR_STATPEND_MASK (0x08000000u)
#define CSL_EMAC_MACINVECTOR_STATPEND_SHIFT (0x0000001Bu)
#define CSL_EMAC_MACINVECTOR_STATPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_HOSTPEND_MASK (0x04000000u)
#define CSL_EMAC_MACINVECTOR_HOSTPEND_SHIFT (0x0000001Au)
#define CSL_EMAC_MACINVECTOR_HOSTPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_LINKINT_MASK (0x02000000u)
#define CSL_EMAC_MACINVECTOR_LINKINT_SHIFT (0x00000019u)
#define CSL_EMAC_MACINVECTOR_LINKINT_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_USERINT_MASK (0x01000000u) // Mdio_
#define CSL_EMAC_MACINVECTOR_USERINT_SHIFT (0x00000018u)
#define CSL_EMAC_MACINVECTOR_USERINT_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_TXPEND_MASK (0x00FF0000u)
#define CSL_EMAC_MACINVECTOR_TXPEND_SHIFT (0x00000010u)
#define CSL_EMAC_MACINVECTOR_TXPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_RXTHRE_MASK (0x0000FF00u)
#define CSL_EMAC_MACINVECTOR_RXTHRE_SHIFT (0x00000008u)
#define CSL_EMAC_MACINVECTOR_RXTHRE_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_RXPEND_MASK (0x000000FFu)
#define CSL_EMAC_MACINVECTOR_RXPEND_SHIFT (0x00000000u)
#define CSL_EMAC_MACINVECTOR_RXPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINVECTOR_RESETVAL    (0x00000000u)

/* RXINTSTATRAW */
#define CSL_EMAC_RXINTSTATRAW_RX7THRESHPEND_MASK (0x00008000u)
#define CSL_EMAC_RXINTSTATRAW_RX7THRESHPEND_SHIFT (0x0000000Fu)
#define CSL_EMAC_RXINTSTATRAW_RX7THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX6THRESHPEND_MASK (0x00004000u)
#define CSL_EMAC_RXINTSTATRAW_RX6THRESHPEND_SHIFT (0x0000000Eu)
#define CSL_EMAC_RXINTSTATRAW_RX6THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX5THRESHPEND_MASK (0x00002000u)
#define CSL_EMAC_RXINTSTATRAW_RX5THRESHPEND_SHIFT (0x0000000Du)
#define CSL_EMAC_RXINTSTATRAW_RX5THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX4THRESHPEND_MASK (0x00001000u)
#define CSL_EMAC_RXINTSTATRAW_RX4THRESHPEND_SHIFT (0x0000000Cu)
#define CSL_EMAC_RXINTSTATRAW_RX4THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX3THRESHPEND_MASK (0x00000800u)
#define CSL_EMAC_RXINTSTATRAW_RX3THRESHPEND_SHIFT (0x0000000Bu)
#define CSL_EMAC_RXINTSTATRAW_RX3THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX2THRESHPEND_MASK (0x00000400u)
#define CSL_EMAC_RXINTSTATRAW_RX2THRESHPEND_SHIFT (0x0000000Au)
#define CSL_EMAC_RXINTSTATRAW_RX2THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX1THRESHPEND_MASK (0x00000200u)
#define CSL_EMAC_RXINTSTATRAW_RX1THRESHPEND_SHIFT (0x00000009u)
#define CSL_EMAC_RXINTSTATRAW_RX1THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX0THRESHPEND_MASK (0x00000100u)
#define CSL_EMAC_RXINTSTATRAW_RX0THRESHPEND_SHIFT (0x00000008u)
#define CSL_EMAC_RXINTSTATRAW_RX0THRESHPEND_RESETVAL (0x00000001u)

#define CSL_EMAC_RXINTSTATRAW_RX7PEND_MASK (0x00000080u)
#define CSL_EMAC_RXINTSTATRAW_RX7PEND_SHIFT (0x00000007u)
#define CSL_EMAC_RXINTSTATRAW_RX7PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX6PEND_MASK (0x00000040u)
#define CSL_EMAC_RXINTSTATRAW_RX6PEND_SHIFT (0x00000006u)
#define CSL_EMAC_RXINTSTATRAW_RX6PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX5PEND_MASK (0x00000020u)
#define CSL_EMAC_RXINTSTATRAW_RX5PEND_SHIFT (0x00000005u)
#define CSL_EMAC_RXINTSTATRAW_RX5PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX4PEND_MASK (0x00000010u)
#define CSL_EMAC_RXINTSTATRAW_RX4PEND_SHIFT (0x00000004u)
#define CSL_EMAC_RXINTSTATRAW_RX4PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX3PEND_MASK (0x00000008u)
#define CSL_EMAC_RXINTSTATRAW_RX3PEND_SHIFT (0x00000003u)
#define CSL_EMAC_RXINTSTATRAW_RX3PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX2PEND_MASK (0x00000004u)
#define CSL_EMAC_RXINTSTATRAW_RX2PEND_SHIFT (0x00000002u)
#define CSL_EMAC_RXINTSTATRAW_RX2PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX1PEND_MASK (0x00000002u)
#define CSL_EMAC_RXINTSTATRAW_RX1PEND_SHIFT (0x00000001u)
#define CSL_EMAC_RXINTSTATRAW_RX1PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RX0PEND_MASK (0x00000001u)
#define CSL_EMAC_RXINTSTATRAW_RX0PEND_SHIFT (0x00000000u)
#define CSL_EMAC_RXINTSTATRAW_RX0PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATRAW_RESETVAL   (0x0000FF00u)

/* RXINTSTATMASKED */

#define CSL_EMAC_RXINTSTATMASKED_RX7PEND_MASK (0x00000080u)
#define CSL_EMAC_RXINTSTATMASKED_RX7PEND_SHIFT (0x00000007u)
#define CSL_EMAC_RXINTSTATMASKED_RX7PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX6PEND_MASK (0x00000040u)
#define CSL_EMAC_RXINTSTATMASKED_RX6PEND_SHIFT (0x00000006u)
#define CSL_EMAC_RXINTSTATMASKED_RX6PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX5PEND_MASK (0x00000020u)
#define CSL_EMAC_RXINTSTATMASKED_RX5PEND_SHIFT (0x00000005u)
#define CSL_EMAC_RXINTSTATMASKED_RX5PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX4PEND_MASK (0x00000010u)
#define CSL_EMAC_RXINTSTATMASKED_RX4PEND_SHIFT (0x00000004u)
#define CSL_EMAC_RXINTSTATMASKED_RX4PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX3PEND_MASK (0x00000008u)
#define CSL_EMAC_RXINTSTATMASKED_RX3PEND_SHIFT (0x00000003u)
#define CSL_EMAC_RXINTSTATMASKED_RX3PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX2PEND_MASK (0x00000004u)
#define CSL_EMAC_RXINTSTATMASKED_RX2PEND_SHIFT (0x00000002u)
#define CSL_EMAC_RXINTSTATMASKED_RX2PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX1PEND_MASK (0x00000002u)
#define CSL_EMAC_RXINTSTATMASKED_RX1PEND_SHIFT (0x00000001u)
#define CSL_EMAC_RXINTSTATMASKED_RX1PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RX0PEND_MASK (0x00000001u)
#define CSL_EMAC_RXINTSTATMASKED_RX0PEND_SHIFT (0x00000000u)
#define CSL_EMAC_RXINTSTATMASKED_RX0PEND_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTSTATMASKED_RESETVAL (0x00000000u)

/* RXINTMASKSET */

#define CSL_EMAC_RXINTMASKSET_RX7MASK_MASK (0x00000080u)
#define CSL_EMAC_RXINTMASKSET_RX7MASK_SHIFT (0x00000007u)
#define CSL_EMAC_RXINTMASKSET_RX7MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX6MASK_MASK (0x00000040u)
#define CSL_EMAC_RXINTMASKSET_RX6MASK_SHIFT (0x00000006u)
#define CSL_EMAC_RXINTMASKSET_RX6MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX5MASK_MASK (0x00000020u)
#define CSL_EMAC_RXINTMASKSET_RX5MASK_SHIFT (0x00000005u)
#define CSL_EMAC_RXINTMASKSET_RX5MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX4MASK_MASK (0x00000010u)
#define CSL_EMAC_RXINTMASKSET_RX4MASK_SHIFT (0x00000004u)
#define CSL_EMAC_RXINTMASKSET_RX4MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX3MASK_MASK (0x00000008u)
#define CSL_EMAC_RXINTMASKSET_RX3MASK_SHIFT (0x00000003u)
#define CSL_EMAC_RXINTMASKSET_RX3MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX2MASK_MASK (0x00000004u)
#define CSL_EMAC_RXINTMASKSET_RX2MASK_SHIFT (0x00000002u)
#define CSL_EMAC_RXINTMASKSET_RX2MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX1MASK_MASK (0x00000002u)
#define CSL_EMAC_RXINTMASKSET_RX1MASK_SHIFT (0x00000001u)
#define CSL_EMAC_RXINTMASKSET_RX1MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RX0MASK_MASK (0x00000001u)
#define CSL_EMAC_RXINTMASKSET_RX0MASK_SHIFT (0x00000000u)
#define CSL_EMAC_RXINTMASKSET_RX0MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKSET_RESETVAL   (0x00000000u)

/* RXINTMASKCLEAR */

#define CSL_EMAC_RXINTMASKCLEAR_RX7MASK_MASK (0x00000080u)
#define CSL_EMAC_RXINTMASKCLEAR_RX7MASK_SHIFT (0x00000007u)
#define CSL_EMAC_RXINTMASKCLEAR_RX7MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX6MASK_MASK (0x00000040u)
#define CSL_EMAC_RXINTMASKCLEAR_RX6MASK_SHIFT (0x00000006u)
#define CSL_EMAC_RXINTMASKCLEAR_RX6MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX5MASK_MASK (0x00000020u)
#define CSL_EMAC_RXINTMASKCLEAR_RX5MASK_SHIFT (0x00000005u)
#define CSL_EMAC_RXINTMASKCLEAR_RX5MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX4MASK_MASK (0x00000010u)
#define CSL_EMAC_RXINTMASKCLEAR_RX4MASK_SHIFT (0x00000004u)
#define CSL_EMAC_RXINTMASKCLEAR_RX4MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX3MASK_MASK (0x00000008u)
#define CSL_EMAC_RXINTMASKCLEAR_RX3MASK_SHIFT (0x00000003u)
#define CSL_EMAC_RXINTMASKCLEAR_RX3MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX2MASK_MASK (0x00000004u)
#define CSL_EMAC_RXINTMASKCLEAR_RX2MASK_SHIFT (0x00000002u)
#define CSL_EMAC_RXINTMASKCLEAR_RX2MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX1MASK_MASK (0x00000002u)
#define CSL_EMAC_RXINTMASKCLEAR_RX1MASK_SHIFT (0x00000001u)
#define CSL_EMAC_RXINTMASKCLEAR_RX1MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RX0MASK_MASK (0x00000001u)
#define CSL_EMAC_RXINTMASKCLEAR_RX0MASK_SHIFT (0x00000000u)
#define CSL_EMAC_RXINTMASKCLEAR_RX0MASK_RESETVAL (0x00000000u)

#define CSL_EMAC_RXINTMASKCLEAR_RESETVAL (0x00000000u)

/* MACINTSTATRAW */

#define CSL_EMAC_MACINTSTATRAW_HOSTPEND_MASK (0x00000002u)
#define CSL_EMAC_MACINTSTATRAW_HOSTPEND_SHIFT (0x00000001u)
#define CSL_EMAC_MACINTSTATRAW_HOSTPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTSTATRAW_STATPEND_MASK (0x00000001u)
#define CSL_EMAC_MACINTSTATRAW_STATPEND_SHIFT (0x00000000u)
#define CSL_EMAC_MACINTSTATRAW_STATPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTSTATRAW_RESETVAL  (0x00000000u)

/* MACINTSTATMASKED */

#define CSL_EMAC_MACINTSTATMASKED_HOSTPEND_MASK (0x00000002u)
#define CSL_EMAC_MACINTSTATMASKED_HOSTPEND_SHIFT (0x00000001u)
#define CSL_EMAC_MACINTSTATMASKED_HOSTPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTSTATMASKED_STATPEND_MASK (0x00000001u)
#define CSL_EMAC_MACINTSTATMASKED_STATPEND_SHIFT (0x00000000u)
#define CSL_EMAC_MACINTSTATMASKED_STATPEND_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTSTATMASKED_RESETVAL (0x00000000u)

/* MACINTMASKSET */

#define CSL_EMAC_MACINTMASKSET_HOSTMASK_MASK (0x00000002u)
#define CSL_EMAC_MACINTMASKSET_HOSTMASK_SHIFT (0x00000001u)
#define CSL_EMAC_MACINTMASKSET_HOSTMASK_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTMASKSET_STATMASK_MASK (0x00000001u)
#define CSL_EMAC_MACINTMASKSET_STATMASK_SHIFT (0x00000000u)
#define CSL_EMAC_MACINTMASKSET_STATMASK_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTMASKSET_RESETVAL  (0x00000000u)

/* MACINTMASKCLEAR */

#define CSL_EMAC_MACINTMASKCLEAR_HOSTMASK_MASK (0x00000002u)
#define CSL_EMAC_MACINTMASKCLEAR_HOSTMASK_SHIFT (0x00000001u)
#define CSL_EMAC_MACINTMASKCLEAR_HOSTMASK_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTMASKCLEAR_STATMASK_MASK (0x00000001u)
#define CSL_EMAC_MACINTMASKCLEAR_STATMASK_SHIFT (0x00000000u)
#define CSL_EMAC_MACINTMASKCLEAR_STATMASK_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINTMASKCLEAR_RESETVAL (0x00000000u)

/* RXMBPENABLE */

#define CSL_EMAC_RXMBPENABLE_RXPASSCRC_MASK (0x40000000u)
#define CSL_EMAC_RXMBPENABLE_RXPASSCRC_SHIFT (0x0000001Eu)
#define CSL_EMAC_RXMBPENABLE_RXPASSCRC_RESETVAL (0x00000000u)

/*----RXPASSCRC Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXPASSCRC_DISCARD (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXPASSCRC_INCLUDE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXQOSEN_MASK (0x20000000u)
#define CSL_EMAC_RXMBPENABLE_RXQOSEN_SHIFT (0x0000001Du)
#define CSL_EMAC_RXMBPENABLE_RXQOSEN_RESETVAL (0x00000000u)

/*----RXQOSEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXQOSEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXQOSEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXNOCHAIN_MASK (0x10000000u)
#define CSL_EMAC_RXMBPENABLE_RXNOCHAIN_SHIFT (0x0000001Cu)
#define CSL_EMAC_RXMBPENABLE_RXNOCHAIN_RESETVAL (0x00000000u)

/*----RXNOCHAIN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXNOCHAIN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXNOCHAIN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXCMFEN_MASK (0x01000000u)
#define CSL_EMAC_RXMBPENABLE_RXCMFEN_SHIFT (0x00000018u)
#define CSL_EMAC_RXMBPENABLE_RXCMFEN_RESETVAL (0x00000000u)

/*----RXCMFEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXCMFEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXCMFEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXCSFEN_MASK (0x00800000u)
#define CSL_EMAC_RXMBPENABLE_RXCSFEN_SHIFT (0x00000017u)
#define CSL_EMAC_RXMBPENABLE_RXCSFEN_RESETVAL (0x00000000u)

/*----RXCSFEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXCSFEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXCSFEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXCEFEN_MASK (0x00400000u)
#define CSL_EMAC_RXMBPENABLE_RXCEFEN_SHIFT (0x00000016u)
#define CSL_EMAC_RXMBPENABLE_RXCEFEN_RESETVAL (0x00000000u)

/*----RXCEFEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXCEFEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXCEFEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXCAFEN_MASK (0x00200000u)
#define CSL_EMAC_RXMBPENABLE_RXCAFEN_SHIFT (0x00000015u)
#define CSL_EMAC_RXMBPENABLE_RXCAFEN_RESETVAL (0x00000000u)

/*----RXCAFEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXCAFEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXCAFEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXPROMCH_MASK (0x00070000u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_SHIFT (0x00000010u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_RESETVAL (0x00000000u)

/*----RXPROMCH Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA0 (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA1 (0x00000001u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA2 (0x00000002u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA3 (0x00000003u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA4 (0x00000004u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA5 (0x00000005u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA6 (0x00000006u)
#define CSL_EMAC_RXMBPENABLE_RXPROMCH_CHA7 (0x00000007u)

#define CSL_EMAC_RXMBPENABLE_RXBROADEN_MASK (0x00002000u)
#define CSL_EMAC_RXMBPENABLE_RXBROADEN_SHIFT (0x0000000Du)
#define CSL_EMAC_RXMBPENABLE_RXBROADEN_RESETVAL (0x00000000u)

/*----RXBROADEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXBROADEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXBROADEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXBROADCH_MASK (0x00000700u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_SHIFT (0x00000008u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_RESETVAL (0x00000000u)

/*----RXBROADCH Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA0 (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA1 (0x00000001u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA2 (0x00000002u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA3 (0x00000003u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA4 (0x00000004u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA5 (0x00000005u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA6 (0x00000006u)
#define CSL_EMAC_RXMBPENABLE_RXBROADCH_CHA7 (0x00000007u)

#define CSL_EMAC_RXMBPENABLE_RXMULTEN_MASK (0x00000020u)
#define CSL_EMAC_RXMBPENABLE_RXMULTEN_SHIFT (0x00000005u)
#define CSL_EMAC_RXMBPENABLE_RXMULTEN_RESETVAL (0x00000000u)

/*----RXMULTEN Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXMULTEN_DISABLE (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXMULTEN_ENABLE (0x00000001u)

#define CSL_EMAC_RXMBPENABLE_RXMULTCH_MASK (0x00000007u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_SHIFT (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_RESETVAL (0x00000000u)

/*----RXMULTCH Tokens----*/
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA0 (0x00000000u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA1 (0x00000001u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA2 (0x00000002u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA3 (0x00000003u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA4 (0x00000004u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA5 (0x00000005u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA6 (0x00000006u)
#define CSL_EMAC_RXMBPENABLE_RXMULTCH_CHA7 (0x00000007u)

#define CSL_EMAC_RXMBPENABLE_RESETVAL    (0x00000000u)

/* RXUNICASTSET */

#define CSL_EMAC_RXUNICASTSET_RXCH7EN_MASK (0x00000080u)
#define CSL_EMAC_RXUNICASTSET_RXCH7EN_SHIFT (0x00000007u)
#define CSL_EMAC_RXUNICASTSET_RXCH7EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH6EN_MASK (0x00000040u)
#define CSL_EMAC_RXUNICASTSET_RXCH6EN_SHIFT (0x00000006u)
#define CSL_EMAC_RXUNICASTSET_RXCH6EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH5EN_MASK (0x00000020u)
#define CSL_EMAC_RXUNICASTSET_RXCH5EN_SHIFT (0x00000005u)
#define CSL_EMAC_RXUNICASTSET_RXCH5EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH4EN_MASK (0x00000010u)
#define CSL_EMAC_RXUNICASTSET_RXCH4EN_SHIFT (0x00000004u)
#define CSL_EMAC_RXUNICASTSET_RXCH4EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH3EN_MASK (0x00000008u)
#define CSL_EMAC_RXUNICASTSET_RXCH3EN_SHIFT (0x00000003u)
#define CSL_EMAC_RXUNICASTSET_RXCH3EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH2EN_MASK (0x00000004u)
#define CSL_EMAC_RXUNICASTSET_RXCH2EN_SHIFT (0x00000002u)
#define CSL_EMAC_RXUNICASTSET_RXCH2EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH1EN_MASK (0x00000002u)
#define CSL_EMAC_RXUNICASTSET_RXCH1EN_SHIFT (0x00000001u)
#define CSL_EMAC_RXUNICASTSET_RXCH1EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RXCH0EN_MASK (0x00000001u)
#define CSL_EMAC_RXUNICASTSET_RXCH0EN_SHIFT (0x00000000u)
#define CSL_EMAC_RXUNICASTSET_RXCH0EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTSET_RESETVAL   (0x00000000u)

/* RXUNICASTCLEAR */

#define CSL_EMAC_RXUNICASTCLEAR_RXCH7EN_MASK (0x00000080u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH7EN_SHIFT (0x00000007u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH7EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH6EN_MASK (0x00000040u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH6EN_SHIFT (0x00000006u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH6EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH5EN_MASK (0x00000020u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH5EN_SHIFT (0x00000005u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH5EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH4EN_MASK (0x00000010u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH4EN_SHIFT (0x00000004u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH4EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH3EN_MASK (0x00000008u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH3EN_SHIFT (0x00000003u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH3EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH2EN_MASK (0x00000004u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH2EN_SHIFT (0x00000002u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH2EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH1EN_MASK (0x00000002u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH1EN_SHIFT (0x00000001u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH1EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RXCH0EN_MASK (0x00000001u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH0EN_SHIFT (0x00000000u)
#define CSL_EMAC_RXUNICASTCLEAR_RXCH0EN_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNICASTCLEAR_RESETVAL (0x00000000u)

/* RXMAXLEN */

#define CSL_EMAC_RXMAXLEN_RXMAXLEN_MASK  (0x0000FFFFu)
#define CSL_EMAC_RXMAXLEN_RXMAXLEN_SHIFT (0x00000000u)
#define CSL_EMAC_RXMAXLEN_RXMAXLEN_RESETVAL (0x000005EEu)

#define CSL_EMAC_RXMAXLEN_RESETVAL       (0x000005EEu)

/* RXBUFFEROFFSET */

#define CSL_EMAC_RXBUFFEROFFSET_RXBUFFEROFFSET_MASK (0x0000FFFFu)
#define CSL_EMAC_RXBUFFEROFFSET_RXBUFFEROFFSET_SHIFT (0x00000000u)
#define CSL_EMAC_RXBUFFEROFFSET_RXBUFFEROFFSET_RESETVAL (0x00000000u)

#define CSL_EMAC_RXBUFFEROFFSET_RESETVAL (0x00000000u)

/* RXFILTERLOWTHRESH */

#define CSL_EMAC_RXFILTERLOWTHRESH_RXFILTERTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RXFILTERLOWTHRESH_RXFILTERTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RXFILTERLOWTHRESH_RXFILTERTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RXFILTERLOWTHRESH_RESETVAL (0x00000000u)

/* RX0FLOWTHRESH */

#define CSL_EMAC_RX0FLOWTHRESH_RX0FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX0FLOWTHRESH_RX0FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX0FLOWTHRESH_RX0FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX0FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX1FLOWTHRESH */

#define CSL_EMAC_RX1FLOWTHRESH_RX1FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX1FLOWTHRESH_RX1FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX1FLOWTHRESH_RX1FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX1FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX2FLOWTHRESH */

#define CSL_EMAC_RX2FLOWTHRESH_RX2FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX2FLOWTHRESH_RX2FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX2FLOWTHRESH_RX2FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX2FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX3FLOWTHRESH */

#define CSL_EMAC_RX3FLOWTHRESH_RX3FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX3FLOWTHRESH_RX3FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX3FLOWTHRESH_RX3FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX3FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX4FLOWTHRESH */

#define CSL_EMAC_RX4FLOWTHRESH_RX4FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX4FLOWTHRESH_RX4FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX4FLOWTHRESH_RX4FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX4FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX5FLOWTHRESH */

#define CSL_EMAC_RX5FLOWTHRESH_RX5FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX5FLOWTHRESH_RX5FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX5FLOWTHRESH_RX5FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX5FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX6FLOWTHRESH */

#define CSL_EMAC_RX6FLOWTHRESH_RX6FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX6FLOWTHRESH_RX6FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX6FLOWTHRESH_RX6FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX6FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX7FLOWTHRESH */

#define CSL_EMAC_RX7FLOWTHRESH_RX7FLOWTHRESH_MASK (0x000000FFu)
#define CSL_EMAC_RX7FLOWTHRESH_RX7FLOWTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_RX7FLOWTHRESH_RX7FLOWTHRESH_RESETVAL (0x00000000u)

#define CSL_EMAC_RX7FLOWTHRESH_RESETVAL  (0x00000000u)

/* RX0FREEBUFFER */

#define CSL_EMAC_RX0FREEBUFFER_RX0FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX0FREEBUFFER_RX0FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX0FREEBUFFER_RX0FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX0FREEBUFFER_RESETVAL  (0x00000000u)

/* RX1FREEBUFFER */

#define CSL_EMAC_RX1FREEBUFFER_RX1FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX1FREEBUFFER_RX1FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX1FREEBUFFER_RX1FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX1FREEBUFFER_RESETVAL  (0x00000000u)

/* RX2FREEBUFFER */

#define CSL_EMAC_RX2FREEBUFFER_RX2FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX2FREEBUFFER_RX2FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX2FREEBUFFER_RX2FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX2FREEBUFFER_RESETVAL  (0x00000000u)

/* RX3FREEBUFFER */

#define CSL_EMAC_RX3FREEBUFFER_RX3FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX3FREEBUFFER_RX3FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX3FREEBUFFER_RX3FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX3FREEBUFFER_RESETVAL  (0x00000000u)

/* RX4FREEBUFFER */

#define CSL_EMAC_RX4FREEBUFFER_RX4FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX4FREEBUFFER_RX4FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX4FREEBUFFER_RX4FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX4FREEBUFFER_RESETVAL  (0x00000000u)

/* RX5FREEBUFFER */

#define CSL_EMAC_RX5FREEBUFFER_RX5FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX5FREEBUFFER_RX5FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX5FREEBUFFER_RX5FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX5FREEBUFFER_RESETVAL  (0x00000000u)

/* RX6FREEBUFFER */

#define CSL_EMAC_RX6FREEBUFFER_RX6FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX6FREEBUFFER_RX6FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX6FREEBUFFER_RX6FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX6FREEBUFFER_RESETVAL  (0x00000000u)

/* RX7FREEBUFFER */

#define CSL_EMAC_RX7FREEBUFFER_RX7FREEBUF_MASK (0x0000FFFFu)
#define CSL_EMAC_RX7FREEBUFFER_RX7FREEBUF_SHIFT (0x00000000u)
#define CSL_EMAC_RX7FREEBUFFER_RX7FREEBUF_RESETVAL (0x00000000u)

#define CSL_EMAC_RX7FREEBUFFER_RESETVAL  (0x00000000u)

/* MACCONTROL */

#define CSL_EMAC_MACCONTROL_EXTEN_MASK (0x00040000u)
#define CSL_EMAC_MACCONTROL_EXTEN_SHIFT (0x00000012u)
#define CSL_EMAC_MACCONTROL_EXTEN_RESETVAL (0x00000000u)

/*----RGMIIEN Tokens----*/
#define CSL_EMAC_MACCONTROL_EXTEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_EXTEN_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_GIGFORCE_MASK (0x00020000u)
#define CSL_EMAC_MACCONTROL_GIGFORCE_SHIFT (0x00000011u)
#define CSL_EMAC_MACCONTROL_GIGFORCE_RESETVAL (0x00000000u)

#define CSL_EMAC_MACCONTROL_RMIIDUPLEXMODE_MASK (0x00010000u)
#define CSL_EMAC_MACCONTROL_RMIIDUPLEXMODE_SHIFT (0x00000010u)
#define CSL_EMAC_MACCONTROL_RMIIDUPLEXMODE_RESETVAL (0x00000000u)

/*----RMIIDUPLEXMODE Tokens----*/
#define CSL_EMAC_MACCONTROL_RMIIDUPLEXMODE_HALFDUPLEX (0x00000000u)
#define CSL_EMAC_MACCONTROL_RMIIDUPLEXMODE_FULLDUPLEX (0x00000001u)

#define CSL_EMAC_MACCONTROL_RMIISPEED_MASK (0x00008000u)
#define CSL_EMAC_MACCONTROL_RMIISPEED_SHIFT (0x0000000Fu)
#define CSL_EMAC_MACCONTROL_RMIISPEED_RESETVAL (0x00000000u)

/*----RMIISPEED Tokens----*/
#define CSL_EMAC_MACCONTROL_RMIISPEED_2_5MHZ (0x00000000u)
#define CSL_EMAC_MACCONTROL_RMIISPEED_25MHZ (0x00000001u)

#define CSL_EMAC_MACCONTROL_RXOFFLENBLOCK_MASK (0x00004000u)
#define CSL_EMAC_MACCONTROL_RXOFFLENBLOCK_SHIFT (0x0000000Eu)
#define CSL_EMAC_MACCONTROL_RXOFFLENBLOCK_RESETVAL (0x00000000u)

/*----RXOFFLENBLOCK Tokens----*/
#define CSL_EMAC_MACCONTROL_RXOFFLENBLOCK_NOBLOCK (0x00000000u)
#define CSL_EMAC_MACCONTROL_RXOFFLENBLOCK_BLOCK (0x00000001u)

#define CSL_EMAC_MACCONTROL_RXOWNERSHIP_MASK (0x00002000u)
#define CSL_EMAC_MACCONTROL_RXOWNERSHIP_SHIFT (0x0000000Du)
#define CSL_EMAC_MACCONTROL_RXOWNERSHIP_RESETVAL (0x00000000u)

/*----RXOWNERSHIP Tokens----*/
#define CSL_EMAC_MACCONTROL_RXOWNERSHIP_ZERO (0x00000000u)
#define CSL_EMAC_MACCONTROL_RXOWNERSHIP_ONE (0x00000001u)

#define CSL_EMAC_MACCONTROL_RXFIFOFLOWEN_MASK (0x00001000u)
#define CSL_EMAC_MACCONTROL_RXFIFOFLOWEN_SHIFT (0x0000000Cu)
#define CSL_EMAC_MACCONTROL_RXFIFOFLOWEN_RESETVAL (0x00000000u)

/*----RXFIFOFLOWEN Tokens----*/
#define CSL_EMAC_MACCONTROL_RXFIFOFLOWEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_RXFIFOFLOWEN_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_CMDIDLE_MASK (0x00000800u)
#define CSL_EMAC_MACCONTROL_CMDIDLE_SHIFT (0x0000000Bu)
#define CSL_EMAC_MACCONTROL_CMDIDLE_RESETVAL (0x00000000u)

/*----CMDIDLE Tokens----*/
#define CSL_EMAC_MACCONTROL_CMDIDLE_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_CMDIDLE_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_TXSHORTGAPEN_MASK (0x00000400u)
#define CSL_EMAC_MACCONTROL_TXSHORTGAPEN_SHIFT (0x0000000Au)
#define CSL_EMAC_MACCONTROL_TXSHORTGAPEN_RESETVAL (0x00000000u)

/*----CMDIDLE Tokens----*/
#define CSL_EMAC_MACCONTROL_TXSHORTGAPEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_TXSHORTGAPEN_ENABLE (0x00000001u)


#define CSL_EMAC_MACCONTROL_TXPTYPE_MASK (0x00000200u)
#define CSL_EMAC_MACCONTROL_TXPTYPE_SHIFT (0x00000009u)
#define CSL_EMAC_MACCONTROL_TXPTYPE_RESETVAL (0x00000000u)

/*----TXPTYPE Tokens----*/
#define CSL_EMAC_MACCONTROL_TXPTYPE_RROBIN (0x00000000u)
#define CSL_EMAC_MACCONTROL_TXPTYPE_CHANNELPRI (0x00000001u)

#define CSL_EMAC_MACCONTROL_GIG_MASK     (0x00000080u)
#define CSL_EMAC_MACCONTROL_GIG_SHIFT    (0x00000007u)
#define CSL_EMAC_MACCONTROL_GIG_RESETVAL (0x00000000u)

/*----GIG Tokens----*/
#define CSL_EMAC_MACCONTROL_GIG_DISABLE  (0x00000000u)
#define CSL_EMAC_MACCONTROL_GIG_ENABLE   (0x00000001u)

#define CSL_EMAC_MACCONTROL_TXPACE_MASK  (0x00000040u)
#define CSL_EMAC_MACCONTROL_TXPACE_SHIFT (0x00000006u)
#define CSL_EMAC_MACCONTROL_TXPACE_RESETVAL (0x00000000u)

/*----TXPACE Tokens----*/
#define CSL_EMAC_MACCONTROL_TXPACE_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_TXPACE_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_GMIIEN_MASK  (0x00000020u)
#define CSL_EMAC_MACCONTROL_GMIIEN_SHIFT (0x00000005u)
#define CSL_EMAC_MACCONTROL_GMIIEN_RESETVAL (0x00000000u)

/*----GMIIEN Tokens----*/
#define CSL_EMAC_MACCONTROL_GMIIEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_GMIIEN_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_TXFLOWEN_MASK (0x00000010u)
#define CSL_EMAC_MACCONTROL_TXFLOWEN_SHIFT (0x00000004u)
#define CSL_EMAC_MACCONTROL_TXFLOWEN_RESETVAL (0x00000000u)

/*----TXFLOWEN Tokens----*/
#define CSL_EMAC_MACCONTROL_TXFLOWEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_TXFLOWEN_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_RXBUFFERFLOWEN_MASK (0x00000008u)
#define CSL_EMAC_MACCONTROL_RXBUFFERFLOWEN_SHIFT (0x00000003u)
#define CSL_EMAC_MACCONTROL_RXBUFFERFLOWEN_RESETVAL (0x00000000u)

/*----RXBUFFERFLOWEN Tokens----*/
#define CSL_EMAC_MACCONTROL_RXBUFFERFLOWEN_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_RXBUFFERFLOWEN_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_LOOPBACK_MASK (0x00000002u)
#define CSL_EMAC_MACCONTROL_LOOPBACK_SHIFT (0x00000001u)
#define CSL_EMAC_MACCONTROL_LOOPBACK_RESETVAL (0x00000000u)

/*----LOOPBACK Tokens----*/
#define CSL_EMAC_MACCONTROL_LOOPBACK_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_LOOPBACK_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_FULLDUPLEX_MASK (0x00000001u)
#define CSL_EMAC_MACCONTROL_FULLDUPLEX_SHIFT (0x00000000u)
#define CSL_EMAC_MACCONTROL_FULLDUPLEX_RESETVAL (0x00000000u)

/*----FULLDUPLEX Tokens----*/
#define CSL_EMAC_MACCONTROL_FULLDUPLEX_DISABLE (0x00000000u)
#define CSL_EMAC_MACCONTROL_FULLDUPLEX_ENABLE (0x00000001u)

#define CSL_EMAC_MACCONTROL_RESETVAL     (0x00000000u)

/* MACSTATUS */

#define CSL_EMAC_MACSTATUS_IDLE_MASK     (0x80000000u)
#define CSL_EMAC_MACSTATUS_IDLE_SHIFT    (0x0000001Fu)
#define CSL_EMAC_MACSTATUS_IDLE_RESETVAL (0x00000001u)

/*----IDLE Tokens----*/
#define CSL_EMAC_MACSTATUS_IDLE_NOIDLE   (0x00000000u)
#define CSL_EMAC_MACSTATUS_IDLE_IDLE     (0x00000001u)

#define CSL_EMAC_MACSTATUS_TXERRCODE_MASK (0x00F00000u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_SHIFT (0x00000014u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_RESETVAL (0x00000000u)

/*----TXERRCODE Tokens----*/
#define CSL_EMAC_MACSTATUS_TXERRCODE_NOERROR (0x00000000u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_SOPERROR (0x00000001u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_OWNERSHIP (0x00000002u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_NOEOP (0x00000003u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_NULLPTR (0x00000004u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_NULLEN (0x00000005u)
#define CSL_EMAC_MACSTATUS_TXERRCODE_LENRRROR (0x00000006u)

#define CSL_EMAC_MACSTATUS_TXERRCH_MASK  (0x00070000u)
#define CSL_EMAC_MACSTATUS_TXERRCH_SHIFT (0x00000010u)
#define CSL_EMAC_MACSTATUS_TXERRCH_RESETVAL (0x00000000u)

/*----TXERRCH Tokens----*/
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA0  (0x00000000u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA1  (0x00000001u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA2  (0x00000002u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA3  (0x00000003u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA4  (0x00000004u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA5  (0x00000005u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA6  (0x00000006u)
#define CSL_EMAC_MACSTATUS_TXERRCH_CHA7  (0x00000007u)

#define CSL_EMAC_MACSTATUS_RXERRCODE_MASK (0x0000F000u)
#define CSL_EMAC_MACSTATUS_RXERRCODE_SHIFT (0x0000000Cu)
#define CSL_EMAC_MACSTATUS_RXERRCODE_RESETVAL (0x00000000u)

/*----RXERRCODE Tokens----*/
#define CSL_EMAC_MACSTATUS_RXERRCODE_NOERROR (0x00000000u)
#define CSL_EMAC_MACSTATUS_RXERRCODE_OWNERSHIP (0x00000002u)
#define CSL_EMAC_MACSTATUS_RXERRCODE_NULLPTR (0x00000004u)

#define CSL_EMAC_MACSTATUS_RXERRCH_MASK  (0x00000700u)
#define CSL_EMAC_MACSTATUS_RXERRCH_SHIFT (0x00000008u)
#define CSL_EMAC_MACSTATUS_RXERRCH_RESETVAL (0x00000000u)

/*----RXERRCH Tokens----*/
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA0  (0x00000000u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA1  (0x00000001u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA2  (0x00000002u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA3  (0x00000003u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA4  (0x00000004u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA5  (0x00000005u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA6  (0x00000006u)
#define CSL_EMAC_MACSTATUS_RXERRCH_CHA7  (0x00000007u)

#define CSL_EMAC_MACSTATUS_RGMIIGIG_MASK (0x00000010u)
#define CSL_EMAC_MACSTATUS_RGMIIGIG_SHIFT (0x00000004u)
#define CSL_EMAC_MACSTATUS_RGMIIGIG_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSTATUS_RGMIIFULLDUPLEX_MASK (0x00000008u)
#define CSL_EMAC_MACSTATUS_RGMIIFULLDUPLEX_SHIFT (0x00000003u)
#define CSL_EMAC_MACSTATUS_RGMIIFULLDUPLEX_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSTATUS_RXQOSACT_MASK (0x00000004u)
#define CSL_EMAC_MACSTATUS_RXQOSACT_SHIFT (0x00000002u)
#define CSL_EMAC_MACSTATUS_RXQOSACT_RESETVAL (0x00000000u)

/*----RXQOSACT Tokens----*/
#define CSL_EMAC_MACSTATUS_RXQOSACT_DISABLE (0x00000000u)
#define CSL_EMAC_MACSTATUS_RXQOSACT_ENABLE (0x00000001u)

#define CSL_EMAC_MACSTATUS_RXFLOWACT_MASK (0x00000002u)
#define CSL_EMAC_MACSTATUS_RXFLOWACT_SHIFT (0x00000001u)
#define CSL_EMAC_MACSTATUS_RXFLOWACT_RESETVAL (0x00000000u)

/*----RXFLOWACT Tokens----*/
#define CSL_EMAC_MACSTATUS_RXFLOWACT_INACTIVE (0x00000000u)
#define CSL_EMAC_MACSTATUS_RXFLOWACT_ACTIVE (0x00000001u)

#define CSL_EMAC_MACSTATUS_TXFLOWACT_MASK (0x00000001u)
#define CSL_EMAC_MACSTATUS_TXFLOWACT_SHIFT (0x00000000u)
#define CSL_EMAC_MACSTATUS_TXFLOWACT_RESETVAL (0x00000000u)

/*----TXFLOWACT Tokens----*/
#define CSL_EMAC_MACSTATUS_TXFLOWACT_INACTIVE (0x00000000u)
#define CSL_EMAC_MACSTATUS_TXFLOWACT_ACTIVE (0x00000001u)

#define CSL_EMAC_MACSTATUS_RESETVAL      (0x80000000u)

/* EMCONTROL */

#define CSL_EMAC_EMCONTROL_SOFT_MASK     (0x00000002u)
#define CSL_EMAC_EMCONTROL_SOFT_SHIFT    (0x00000001u)
#define CSL_EMAC_EMCONTROL_SOFT_RESETVAL (0x00000000u)

#define CSL_EMAC_EMCONTROL_FREE_MASK     (0x00000001u)
#define CSL_EMAC_EMCONTROL_FREE_SHIFT    (0x00000000u)
#define CSL_EMAC_EMCONTROL_FREE_RESETVAL (0x00000000u)

#define CSL_EMAC_EMCONTROL_RESETVAL      (0x00000000u)

/* FIFOCONTROL */

#define CSL_EMAC_FIFOCONTROL_RXFIFOFLOWTHRESH_MASK (0x007F0000u)
#define CSL_EMAC_FIFOCONTROL_RXFIFOFLOWTHRESH_SHIFT (0x00000010u)
#define CSL_EMAC_FIFOCONTROL_RXFIFOFLOWTHRESH_RESETVAL (0x00000002u)

#define CSL_EMAC_FIFOCONTROL_TXCELLTHRESH_MASK (0x0000001Fu)
#define CSL_EMAC_FIFOCONTROL_TXCELLTHRESH_SHIFT (0x00000000u)
#define CSL_EMAC_FIFOCONTROL_TXCELLTHRESH_RESETVAL (0x00000018u)

#define CSL_EMAC_FIFOCONTROL_RESETVAL    (0x00020018u)

/* MACCONFIG */

#define CSL_EMAC_MACCONFIG_TXCELLDEPTH_MASK (0xFF000000u)
#define CSL_EMAC_MACCONFIG_TXCELLDEPTH_SHIFT (0x00000018u)
#define CSL_EMAC_MACCONFIG_TXCELLDEPTH_RESETVAL (0x00000018u)

#define CSL_EMAC_MACCONFIG_RXCELLDEPTH_MASK (0x00FF0000u)
#define CSL_EMAC_MACCONFIG_RXCELLDEPTH_SHIFT (0x00000010u)
#define CSL_EMAC_MACCONFIG_RXCELLDEPTH_RESETVAL (0x00000044u)

#define CSL_EMAC_MACCONFIG_ADDRESSTYPE_MASK (0x0000FF00u)
#define CSL_EMAC_MACCONFIG_ADDRESSTYPE_SHIFT (0x00000008u)
#define CSL_EMAC_MACCONFIG_ADDRESSTYPE_RESETVAL (0x00000002u)

#define CSL_EMAC_MACCONFIG_MACCFIG_MASK  (0x000000FFu)
#define CSL_EMAC_MACCONFIG_MACCFIG_SHIFT (0x00000000u)
#define CSL_EMAC_MACCONFIG_MACCFIG_RESETVAL (0x00000003u)

#define CSL_EMAC_MACCONFIG_RESETVAL      (0x18440203u)

/* SOFTRESET */

#define CSL_EMAC_SOFTRESET_SOFTRESET_MASK (0x00000001u)
#define CSL_EMAC_SOFTRESET_SOFTRESET_SHIFT (0x00000000u)
#define CSL_EMAC_SOFTRESET_SOFTRESET_RESETVAL (0x00000000u)

/*----SOFTRESET Tokens----*/
#define CSL_EMAC_SOFTRESET_SOFTRESET_NORESET (0x00000000u)
#define CSL_EMAC_SOFTRESET_SOFTRESET_RESET (0x00000001u)

#define CSL_EMAC_SOFTRESET_RESETVAL      (0x00000000u)

/* MACSRCADDRLO */

#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR0_MASK (0x0000FF00u)
#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR0_SHIFT (0x00000008u)
#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR0_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR1_MASK (0x000000FFu)
#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR1_SHIFT (0x00000000u)
#define CSL_EMAC_MACSRCADDRLO_MACSRCADDR1_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRLO_RESETVAL   (0x00000000u)

/* MACSRCADDRHI */

#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR2_MASK (0xFF000000u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR2_SHIFT (0x00000018u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR2_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR3_MASK (0x00FF0000u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR3_SHIFT (0x00000010u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR3_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR4_MASK (0x0000FF00u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR4_SHIFT (0x00000008u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR4_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR5_MASK (0x000000FFu)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR5_SHIFT (0x00000000u)
#define CSL_EMAC_MACSRCADDRHI_MACSRCADDR5_RESETVAL (0x00000000u)

#define CSL_EMAC_MACSRCADDRHI_RESETVAL   (0x00000000u)

/* MACHASH1 */

#define CSL_EMAC_MACHASH1_MACHASH1_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_MACHASH1_MACHASH1_SHIFT (0x00000000u)
#define CSL_EMAC_MACHASH1_MACHASH1_RESETVAL (0x00000000u)

#define CSL_EMAC_MACHASH1_RESETVAL       (0x00000000u)

/* MACHASH2 */

#define CSL_EMAC_MACHASH2_MACHASH2_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_MACHASH2_MACHASH2_SHIFT (0x00000000u)
#define CSL_EMAC_MACHASH2_MACHASH2_RESETVAL (0x00000000u)

#define CSL_EMAC_MACHASH2_RESETVAL       (0x00000000u)

/* BOFFTEST */

#define CSL_EMAC_BOFFTEST_RNDNUM_MASK    (0x03FF0000u)
#define CSL_EMAC_BOFFTEST_RNDNUM_SHIFT   (0x00000010u)
#define CSL_EMAC_BOFFTEST_RNDNUM_RESETVAL (0x00000000u)

#define CSL_EMAC_BOFFTEST_COLLCOUNT_MASK (0x0000F000u)
#define CSL_EMAC_BOFFTEST_COLLCOUNT_SHIFT (0x0000000Cu)
#define CSL_EMAC_BOFFTEST_COLLCOUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_BOFFTEST_TXBACKOFF_MASK (0x000003FFu)
#define CSL_EMAC_BOFFTEST_TXBACKOFF_SHIFT (0x00000000u)
#define CSL_EMAC_BOFFTEST_TXBACKOFF_RESETVAL (0x00000000u)

#define CSL_EMAC_BOFFTEST_RESETVAL       (0x00000000u)

/* TPACETEST */

#define CSL_EMAC_TPACETEST_PACEVAL_MASK  (0x0000001Fu)
#define CSL_EMAC_TPACETEST_PACEVAL_SHIFT (0x00000000u)
#define CSL_EMAC_TPACETEST_PACEVAL_RESETVAL (0x00000000u)

#define CSL_EMAC_TPACETEST_RESETVAL      (0x00000000u)

/* RXPAUSE */

#define CSL_EMAC_RXPAUSE_PAUSETIMER_MASK (0x0000FFFFu)
#define CSL_EMAC_RXPAUSE_PAUSETIMER_SHIFT (0x00000000u)
#define CSL_EMAC_RXPAUSE_PAUSETIMER_RESETVAL (0x00000000u)

#define CSL_EMAC_RXPAUSE_RESETVAL        (0x00000000u)

/* TXPAUSE */

#define CSL_EMAC_TXPAUSE_PAUSETIMER_MASK (0x0000FFFFu)
#define CSL_EMAC_TXPAUSE_PAUSETIMER_SHIFT (0x00000000u)
#define CSL_EMAC_TXPAUSE_PAUSETIMER_RESETVAL (0x00000000u)

#define CSL_EMAC_TXPAUSE_RESETVAL        (0x00000000u)

/* RXGOODFRAMES */

#define CSL_EMAC_RXGOODFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXGOODFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXGOODFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXGOODFRAMES_RESETVAL   (0x00000000u)

/* RXBCASTFRAMES */

#define CSL_EMAC_RXBCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXBCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXBCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXBCASTFRAMES_RESETVAL  (0x00000000u)

/* RXMCASTFRAMES */

#define CSL_EMAC_RXMCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXMCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXMCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXMCASTFRAMES_RESETVAL  (0x00000000u)

/* RXPAUSEFRAMES */

#define CSL_EMAC_RXPAUSEFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXPAUSEFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXPAUSEFRAMES_RESETVAL  (0x00000000u)

/* RXCRCERRORS */

#define CSL_EMAC_RXCRCERRORS_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_RXCRCERRORS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXCRCERRORS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXCRCERRORS_RESETVAL    (0x00000000u)

/* RXALIGNCODEERRORS */

#define CSL_EMAC_RXALIGNCODEERRORS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXALIGNCODEERRORS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXALIGNCODEERRORS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXALIGNCODEERRORS_RESETVAL (0x00000000u)

/* RXOVERSIZED */

#define CSL_EMAC_RXOVERSIZED_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_RXOVERSIZED_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXOVERSIZED_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXOVERSIZED_RESETVAL    (0x00000000u)

/* RXJABBER */

#define CSL_EMAC_RXJABBER_COUNT_MASK     (0xFFFFFFFFu)
#define CSL_EMAC_RXJABBER_COUNT_SHIFT    (0x00000000u)
#define CSL_EMAC_RXJABBER_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXJABBER_RESETVAL       (0x00000000u)

/* RXUNDERSIZED */

#define CSL_EMAC_RXUNDERSIZED_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXUNDERSIZED_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXUNDERSIZED_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXUNDERSIZED_RESETVAL   (0x00000000u)

/* RXFRAGMENTS */

#define CSL_EMAC_RXFRAGMENTS_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_RXFRAGMENTS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXFRAGMENTS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXFRAGMENTS_RESETVAL    (0x00000000u)

/* RXFILTERED */

#define CSL_EMAC_RXFILTERED_COUNT_MASK   (0xFFFFFFFFu)
#define CSL_EMAC_RXFILTERED_COUNT_SHIFT  (0x00000000u)
#define CSL_EMAC_RXFILTERED_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXFILTERED_RESETVAL     (0x00000000u)

/* RXQOSFILTERED */

#define CSL_EMAC_RXQOSFILTERED_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXQOSFILTERED_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXQOSFILTERED_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXQOSFILTERED_RESETVAL  (0x00000000u)

/* RXOCTETS */

#define CSL_EMAC_RXOCTETS_COUNT_MASK     (0xFFFFFFFFu)
#define CSL_EMAC_RXOCTETS_COUNT_SHIFT    (0x00000000u)
#define CSL_EMAC_RXOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXOCTETS_RESETVAL       (0x00000000u)

/* TXGOODFRAMES */

#define CSL_EMAC_TXGOODFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXGOODFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXGOODFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXGOODFRAMES_RESETVAL   (0x00000000u)

/* TXBCASTFRAMES */

#define CSL_EMAC_TXBCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXBCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXBCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXBCASTFRAMES_RESETVAL  (0x00000000u)

/* TXMCASTFRAMES */

#define CSL_EMAC_TXMCASTFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXMCASTFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXMCASTFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXMCASTFRAMES_RESETVAL  (0x00000000u)

/* TXPAUSEFRAMES */

#define CSL_EMAC_TXPAUSEFRAMES_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXPAUSEFRAMES_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXPAUSEFRAMES_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXPAUSEFRAMES_RESETVAL  (0x00000000u)

/* TXDEFERRED */

#define CSL_EMAC_TXDEFERRED_COUNT_MASK   (0xFFFFFFFFu)
#define CSL_EMAC_TXDEFERRED_COUNT_SHIFT  (0x00000000u)
#define CSL_EMAC_TXDEFERRED_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXDEFERRED_RESETVAL     (0x00000000u)

/* TXCOLLISION */

#define CSL_EMAC_TXCOLLISION_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_TXCOLLISION_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXCOLLISION_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXCOLLISION_RESETVAL    (0x00000000u)

/* TXSINGLECOLL */

#define CSL_EMAC_TXSINGLECOLL_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXSINGLECOLL_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXSINGLECOLL_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXSINGLECOLL_RESETVAL   (0x00000000u)

/* TXMULTICOLL */

#define CSL_EMAC_TXMULTICOLL_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_TXMULTICOLL_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXMULTICOLL_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXMULTICOLL_RESETVAL    (0x00000000u)

/* TXEXCESSIVECOLL */

#define CSL_EMAC_TXEXCESSIVECOLL_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXEXCESSIVECOLL_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXEXCESSIVECOLL_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXEXCESSIVECOLL_RESETVAL (0x00000000u)

/* TXLATECOLL */

#define CSL_EMAC_TXLATECOLL_COUNT_MASK   (0xFFFFFFFFu)
#define CSL_EMAC_TXLATECOLL_COUNT_SHIFT  (0x00000000u)
#define CSL_EMAC_TXLATECOLL_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXLATECOLL_RESETVAL     (0x00000000u)

/* TXUNDERRUN */

#define CSL_EMAC_TXUNDERRUN_COUNT_MASK   (0xFFFFFFFFu)
#define CSL_EMAC_TXUNDERRUN_COUNT_SHIFT  (0x00000000u)
#define CSL_EMAC_TXUNDERRUN_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXUNDERRUN_RESETVAL     (0x00000000u)

/* TXCARRIERSENSE */

#define CSL_EMAC_TXCARRIERSENSE_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_TXCARRIERSENSE_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_TXCARRIERSENSE_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXCARRIERSENSE_RESETVAL (0x00000000u)

/* TXOCTETS */

#define CSL_EMAC_TXOCTETS_COUNT_MASK     (0xFFFFFFFFu)
#define CSL_EMAC_TXOCTETS_COUNT_SHIFT    (0x00000000u)
#define CSL_EMAC_TXOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_TXOCTETS_RESETVAL       (0x00000000u)

/* FRAME64 */

#define CSL_EMAC_FRAME64_COUNT_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_FRAME64_COUNT_SHIFT     (0x00000000u)
#define CSL_EMAC_FRAME64_COUNT_RESETVAL  (0x00000000u)

#define CSL_EMAC_FRAME64_RESETVAL        (0x00000000u)

/* FRAME65T127 */

#define CSL_EMAC_FRAME65T127_COUNT_MASK  (0xFFFFFFFFu)
#define CSL_EMAC_FRAME65T127_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_FRAME65T127_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_FRAME65T127_RESETVAL    (0x00000000u)

/* FRAME128T255 */

#define CSL_EMAC_FRAME128T255_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_FRAME128T255_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_FRAME128T255_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_FRAME128T255_RESETVAL   (0x00000000u)

/* FRAME256T511 */

#define CSL_EMAC_FRAME256T511_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_FRAME256T511_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_FRAME256T511_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_FRAME256T511_RESETVAL   (0x00000000u)

/* FRAME512T1023 */

#define CSL_EMAC_FRAME512T1023_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_FRAME512T1023_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_FRAME512T1023_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_FRAME512T1023_RESETVAL  (0x00000000u)

/* FRAME1024TUP */

#define CSL_EMAC_FRAME1024TUP_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_FRAME1024TUP_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_FRAME1024TUP_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_FRAME1024TUP_RESETVAL   (0x00000000u)

/* NETOCTETS */

#define CSL_EMAC_NETOCTETS_COUNT_MASK    (0xFFFFFFFFu)
#define CSL_EMAC_NETOCTETS_COUNT_SHIFT   (0x00000000u)
#define CSL_EMAC_NETOCTETS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_NETOCTETS_RESETVAL      (0x00000000u)

/* RXSOFOVERRUNS */

#define CSL_EMAC_RXSOFOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXSOFOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXSOFOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXSOFOVERRUNS_RESETVAL  (0x00000000u)

/* RXMOFOVERRUNS */

#define CSL_EMAC_RXMOFOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXMOFOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXMOFOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXMOFOVERRUNS_RESETVAL  (0x00000000u)

/* RXDMAOVERRUNS */

#define CSL_EMAC_RXDMAOVERRUNS_COUNT_MASK (0xFFFFFFFFu)
#define CSL_EMAC_RXDMAOVERRUNS_COUNT_SHIFT (0x00000000u)
#define CSL_EMAC_RXDMAOVERRUNS_COUNT_RESETVAL (0x00000000u)

#define CSL_EMAC_RXDMAOVERRUNS_RESETVAL  (0x00000000u)

/* MACADDRLO */

#define CSL_EMAC_MACADDRLO_VALID_MASK    (0x00100000u)
#define CSL_EMAC_MACADDRLO_VALID_SHIFT   (0x00000014u)
#define CSL_EMAC_MACADDRLO_VALID_RESETVAL (0x00000000u)

/*----VALID Tokens----*/
#define CSL_EMAC_MACADDRLO_VALID_INVALID (0x00000000u)
#define CSL_EMAC_MACADDRLO_VALID_VALID   (0x00000001u)

#define CSL_EMAC_MACADDRLO_MATCHFILT_MASK (0x00080000u)
#define CSL_EMAC_MACADDRLO_MATCHFILT_SHIFT (0x00000013u)
#define CSL_EMAC_MACADDRLO_MATCHFILT_RESETVAL (0x00000000u)

/*----MATCHFILT Tokens----*/
#define CSL_EMAC_MACADDRLO_MATCHFILT_FILTER (0x00000000u)
#define CSL_EMAC_MACADDRLO_MATCHFILT_MATCH (0x00000001u)

#define CSL_EMAC_MACADDRLO_CHANNEL_MASK  (0x00070000u)
#define CSL_EMAC_MACADDRLO_CHANNEL_SHIFT (0x00000010u)
#define CSL_EMAC_MACADDRLO_CHANNEL_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRLO_MACADDR0_MASK (0x0000FF00u)
#define CSL_EMAC_MACADDRLO_MACADDR0_SHIFT (0x00000008u)
#define CSL_EMAC_MACADDRLO_MACADDR0_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRLO_MACADDR1_MASK (0x000000FFu)
#define CSL_EMAC_MACADDRLO_MACADDR1_SHIFT (0x00000000u)
#define CSL_EMAC_MACADDRLO_MACADDR1_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRLO_RESETVAL      (0x00000000u)

/* MACADDRHI */

#define CSL_EMAC_MACADDRHI_MACADDR2_MASK (0xFF000000u)
#define CSL_EMAC_MACADDRHI_MACADDR2_SHIFT (0x00000018u)
#define CSL_EMAC_MACADDRHI_MACADDR2_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRHI_MACADDR3_MASK (0x00FF0000u)
#define CSL_EMAC_MACADDRHI_MACADDR3_SHIFT (0x00000010u)
#define CSL_EMAC_MACADDRHI_MACADDR3_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRHI_MACADDR4_MASK (0x0000FF00u)
#define CSL_EMAC_MACADDRHI_MACADDR4_SHIFT (0x00000008u)
#define CSL_EMAC_MACADDRHI_MACADDR4_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRHI_MACADDR5_MASK (0x000000FFu)
#define CSL_EMAC_MACADDRHI_MACADDR5_SHIFT (0x00000000u)
#define CSL_EMAC_MACADDRHI_MACADDR5_RESETVAL (0x00000000u)

#define CSL_EMAC_MACADDRHI_RESETVAL      (0x00000000u)

/* MACINDEX */

#define CSL_EMAC_MACINDEX_MACINDEX_MASK  (0x0000001Fu)
#define CSL_EMAC_MACINDEX_MACINDEX_SHIFT (0x00000000u)
#define CSL_EMAC_MACINDEX_MACINDEX_RESETVAL (0x00000000u)

#define CSL_EMAC_MACINDEX_RESETVAL       (0x00000000u)

/* TX0HDP */

#define CSL_EMAC_TX0HDP_TX0HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX0HDP_TX0HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX0HDP_TX0HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX0HDP_RESETVAL         (0x00000000u)

/* TX1HDP */

#define CSL_EMAC_TX1HDP_TX1HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX1HDP_TX1HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX1HDP_TX1HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX1HDP_RESETVAL         (0x00000000u)

/* TX2HDP */

#define CSL_EMAC_TX2HDP_TX2HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX2HDP_TX2HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX2HDP_TX2HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX2HDP_RESETVAL         (0x00000000u)

/* TX3HDP */

#define CSL_EMAC_TX3HDP_TX3HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX3HDP_TX3HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX3HDP_TX3HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX3HDP_RESETVAL         (0x00000000u)

/* TX4HDP */

#define CSL_EMAC_TX4HDP_TX4HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX4HDP_TX4HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX4HDP_TX4HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX4HDP_RESETVAL         (0x00000000u)

/* TX5HDP */

#define CSL_EMAC_TX5HDP_TX5HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX5HDP_TX5HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX5HDP_TX5HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX5HDP_RESETVAL         (0x00000000u)

/* TX6HDP */

#define CSL_EMAC_TX6HDP_TX6HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX6HDP_TX6HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX6HDP_TX6HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX6HDP_RESETVAL         (0x00000000u)

/* TX7HDP */

#define CSL_EMAC_TX7HDP_TX7HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_TX7HDP_TX7HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_TX7HDP_TX7HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_TX7HDP_RESETVAL         (0x00000000u)

/* RX0HDP */

#define CSL_EMAC_RX0HDP_RX0HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX0HDP_RX0HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX0HDP_RX0HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX0HDP_RESETVAL         (0x00000000u)

/* RX1HDP */

#define CSL_EMAC_RX1HDP_RX1HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX1HDP_RX1HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX1HDP_RX1HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX1HDP_RESETVAL         (0x00000000u)

/* RX2HDP */

#define CSL_EMAC_RX2HDP_RX2HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX2HDP_RX2HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX2HDP_RX2HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX2HDP_RESETVAL         (0x00000000u)

/* RX3HDP */

#define CSL_EMAC_RX3HDP_RX3HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX3HDP_RX3HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX3HDP_RX3HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX3HDP_RESETVAL         (0x00000000u)

/* RX4HDP */

#define CSL_EMAC_RX4HDP_RX4HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX4HDP_RX4HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX4HDP_RX4HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX4HDP_RESETVAL         (0x00000000u)

/* RX5HDP */

#define CSL_EMAC_RX5HDP_RX5HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX5HDP_RX5HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX5HDP_RX5HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX5HDP_RESETVAL         (0x00000000u)

/* RX6HDP */

#define CSL_EMAC_RX6HDP_RX6HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX6HDP_RX6HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX6HDP_RX6HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX6HDP_RESETVAL         (0x00000000u)

/* RX7HDP */

#define CSL_EMAC_RX7HDP_RX7HDP_MASK      (0xFFFFFFFFu)
#define CSL_EMAC_RX7HDP_RX7HDP_SHIFT     (0x00000000u)
#define CSL_EMAC_RX7HDP_RX7HDP_RESETVAL  (0x00000000u)

#define CSL_EMAC_RX7HDP_RESETVAL         (0x00000000u)

/* TX0CP */

#define CSL_EMAC_TX0CP_TX0CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX0CP_TX0CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX0CP_TX0CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX0CP_RESETVAL          (0x00000000u)

/* TX1CP */

#define CSL_EMAC_TX1CP_TX1CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX1CP_TX1CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX1CP_TX1CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX1CP_RESETVAL          (0x00000000u)

/* TX2CP */

#define CSL_EMAC_TX2CP_TX2CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX2CP_TX2CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX2CP_TX2CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX2CP_RESETVAL          (0x00000000u)

/* TX3CP */

#define CSL_EMAC_TX3CP_TX3CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX3CP_TX3CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX3CP_TX3CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX3CP_RESETVAL          (0x00000000u)

/* TX4CP */

#define CSL_EMAC_TX4CP_TX4CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX4CP_TX4CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX4CP_TX4CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX4CP_RESETVAL          (0x00000000u)

/* TX5CP */

#define CSL_EMAC_TX5CP_TX5CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX5CP_TX5CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX5CP_TX5CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX5CP_RESETVAL          (0x00000000u)

/* TX6CP */

#define CSL_EMAC_TX6CP_TX6CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX6CP_TX6CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX6CP_TX6CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX6CP_RESETVAL          (0x00000000u)

/* TX7CP */

#define CSL_EMAC_TX7CP_TX7CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_TX7CP_TX7CP_SHIFT       (0x00000000u)
#define CSL_EMAC_TX7CP_TX7CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_TX7CP_RESETVAL          (0x00000000u)

/* RX0CP */

#define CSL_EMAC_RX0CP_RX0CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX0CP_RX0CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX0CP_RX0CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX0CP_RESETVAL          (0x00000000u)

/* RX1CP */

#define CSL_EMAC_RX1CP_RX1CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX1CP_RX1CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX1CP_RX1CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX1CP_RESETVAL          (0x00000000u)

/* RX2CP */

#define CSL_EMAC_RX2CP_RX2CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX2CP_RX2CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX2CP_RX2CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX2CP_RESETVAL          (0x00000000u)

/* RX3CP */

#define CSL_EMAC_RX3CP_RX3CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX3CP_RX3CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX3CP_RX3CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX3CP_RESETVAL          (0x00000000u)

/* RX4CP */

#define CSL_EMAC_RX4CP_RX4CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX4CP_RX4CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX4CP_RX4CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX4CP_RESETVAL          (0x00000000u)

/* RX5CP */

#define CSL_EMAC_RX5CP_RX5CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX5CP_RX5CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX5CP_RX5CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX5CP_RESETVAL          (0x00000000u)

/* RX6CP */

#define CSL_EMAC_RX6CP_RX6CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX6CP_RX6CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX6CP_RX6CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX6CP_RESETVAL          (0x00000000u)

/* RX7CP */

#define CSL_EMAC_RX7CP_RX7CP_MASK        (0xFFFFFFFFu)
#define CSL_EMAC_RX7CP_RX7CP_SHIFT       (0x00000000u)
#define CSL_EMAC_RX7CP_RX7CP_RESETVAL    (0x00000000u)

#define CSL_EMAC_RX7CP_RESETVAL          (0x00000000u)

#endif
