/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_fsync.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for FSYNC
 *
 */

#ifndef _CSLR_FSYNC_H_
#define _CSLR_FSYNC_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for RP3TC_RAM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 RP3TC;
} CSL_FsyncRp3tc_ramRegs;

/**************************************************************************\
* Register Overlay Structure for SYSTC_RAM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 SYSTC;
} CSL_FsyncSystc_ramRegs;

/**************************************************************************\
* Register Overlay Structure for EGM_CTRL 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EGMCTRL;
} CSL_FsyncEgm_ctrlRegs;

/**************************************************************************\
* Register Overlay Structure for EGC_CTRL 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EGCCTRL;
} CSL_FsyncEgc_ctrlRegs;

/**************************************************************************\
* Register Overlay Structure for EGM_MASK 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EGMMASK;
} CSL_FsyncEgm_maskRegs;

/**************************************************************************\
* Register Overlay Structure for EGM_COMPARE 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EGMCOMPARE;
} CSL_FsyncEgm_compareRegs;

/**************************************************************************\
* Register Overlay Structure for EGC_COUNTER 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EGCTCOUNT;
} CSL_FsyncEgc_counterRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint8 RSVD0[124];
    volatile Uint32 ERR_INT_SRC_RAW;
    volatile Uint32 ERR_MASK_STAT_0;
    volatile Uint32 ERR_MASK_STAT_1;
    volatile Uint32 ERR_SET_MASK_0;
    volatile Uint32 ERR_SET_MASK_1;
    volatile Uint32 ERR_CLEAR_MASK_0;
    volatile Uint32 ERR_CLEAR_MASK_1;
    volatile Uint32 ERR_INT_MASK_0;
    volatile Uint32 ERR_INT_MASK_1;
    volatile Uint32 ERR_INT_SET;
    volatile Uint32 ERR_INT_CLEAR;
    volatile Uint32 ERR_END_OF_INT;
    volatile Uint32 SCRATCH;
    volatile Uint32 CTL1;
    volatile Uint32 CTL2;
    volatile Uint32 EMUCTL;
    volatile Uint32 EMUMASK;
    volatile Uint32 RP1TS;
    volatile Uint32 UPDATE;
    volatile Uint32 RP3INIT;
    volatile Uint32 SYSINIT;
    volatile Uint8 RSVD1[44];
    CSL_FsyncRp3tc_ramRegs RP3TC_RAM[10];
    volatile Uint32 TOD1;
    volatile Uint32 TOD2;
    volatile Uint32 RP31;
    volatile Uint32 RP32;
    volatile Uint32 SYS1;
    volatile Uint32 SYS2;
    CSL_FsyncSystc_ramRegs SYSTC_RAM[10];
    volatile Uint32 SYSTC;
    volatile Uint32 RP3TC;
    volatile Uint32 TYPE;
    volatile Uint32 TODVAL;
    volatile Uint32 RP3VAL;
    volatile Uint32 SYSVAL;
    volatile Uint8 RSVD2[128];
    CSL_FsyncEgm_ctrlRegs EGM_CTRL[22];
    CSL_FsyncEgc_ctrlRegs EGC_CTRL[8];
    volatile Uint8 RSVD3[8];
    CSL_FsyncEgm_maskRegs EGM_MASK[22];
    volatile Uint8 RSVD4[40];
    CSL_FsyncEgm_compareRegs EGM_COMPARE[22];
    CSL_FsyncEgc_counterRegs EGC_COUNTER[8];
    volatile Uint8 RSVD5[8];
    volatile Uint32 EVTFORCE;
} CSL_FsyncRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_FsyncRegs *CSL_FsyncRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_FSYNC_PID_REG_MASK           (0xFFFFFFFFu)
#define CSL_FSYNC_PID_REG_SHIFT          (0x00000000u)
#define CSL_FSYNC_PID_REG_RESETVAL       (0x00000000u)

#define CSL_FSYNC_PID_RESETVAL           (0x00000000u)

/* SCRATCH */

#define CSL_FSYNC_SCRATCH_SCRATCH_MASK   (0xFFFFFFFFu)
#define CSL_FSYNC_SCRATCH_SCRATCH_SHIFT  (0x00000000u)
#define CSL_FSYNC_SCRATCH_SCRATCH_RESETVAL (0x00000000u)

#define CSL_FSYNC_SCRATCH_RESETVAL       (0x00000000u)

/* CTL1 */

#define CSL_FSYNC_CTL1_CRC_INVERT_MASK   (0x20000000u)
#define CSL_FSYNC_CTL1_CRC_INVERT_SHIFT  (0x0000001Du)
#define CSL_FSYNC_CTL1_CRC_INVERT_RESETVAL (0x00000000u)

/*----CRC_INVERT Tokens----*/
#define CSL_FSYNC_CTL1_CRC_INVERT_DISABLE (0x00000000u)
#define CSL_FSYNC_CTL1_CRC_INVERT_ENABLE (0x00000001u)

#define CSL_FSYNC_CTL1_CRC_INIT_ONE_MASK (0x10000000u)
#define CSL_FSYNC_CTL1_CRC_INIT_ONE_SHIFT (0x0000001Cu)
#define CSL_FSYNC_CTL1_CRC_INIT_ONE_RESETVAL (0x00000000u)

/*----CRC_INIT_ONE Tokens----*/
#define CSL_FSYNC_CTL1_CRC_INIT_ONE_DISABLE (0x00000000u)
#define CSL_FSYNC_CTL1_CRC_INIT_ONE_ENABLE (0x00000001u)

#define CSL_FSYNC_CTL1_CRC_FLIP_MASK     (0x08000000u)
#define CSL_FSYNC_CTL1_CRC_FLIP_SHIFT    (0x0000001Bu)
#define CSL_FSYNC_CTL1_CRC_FLIP_RESETVAL (0x00000000u)

/*----CRC_FLIP Tokens----*/
#define CSL_FSYNC_CTL1_CRC_FLIP_MS_1ST   (0x00000000u)
#define CSL_FSYNC_CTL1_CRC_FLIP_LS_1ST   (0x00000001u)

#define CSL_FSYNC_CTL1_ADD_LEAPSEC_MASK  (0x04000000u)
#define CSL_FSYNC_CTL1_ADD_LEAPSEC_SHIFT (0x0000001Au)
#define CSL_FSYNC_CTL1_ADD_LEAPSEC_RESETVAL (0x00000000u)

/*----ADD_LEAPSEC Tokens----*/
#define CSL_FSYNC_CTL1_ADD_LEAPSEC_NO_ADD (0x00000000u)
#define CSL_FSYNC_CTL1_ADD_LEAPSEC_ADD   (0x00000001u)

#define CSL_FSYNC_CTL1_CRC_USE_MASK      (0x02000000u)
#define CSL_FSYNC_CTL1_CRC_USE_SHIFT     (0x00000019u)
#define CSL_FSYNC_CTL1_CRC_USE_RESETVAL  (0x00000000u)

/*----CRC_USE Tokens----*/
#define CSL_FSYNC_CTL1_CRC_USE_DISABLE   (0x00000000u)
#define CSL_FSYNC_CTL1_CRC_USE_ENABLE    (0x00000001u)

#define CSL_FSYNC_CTL1_AUTO_RESYNC_MASK  (0x01000000u)
#define CSL_FSYNC_CTL1_AUTO_RESYNC_SHIFT (0x00000018u)
#define CSL_FSYNC_CTL1_AUTO_RESYNC_RESETVAL (0x00000000u)

/*----AUTO_RESYNC Tokens----*/
#define CSL_FSYNC_CTL1_AUTO_RESYNC_DISABLE (0x00000000u)
#define CSL_FSYNC_CTL1_AUTO_RESYNC_ENABLE (0x00000001u)

#define CSL_FSYNC_CTL1_RP1_MODE_MASK     (0x00800000u)
#define CSL_FSYNC_CTL1_RP1_MODE_SHIFT    (0x00000017u)
#define CSL_FSYNC_CTL1_RP1_MODE_RESETVAL (0x00000000u)

/*----RP1_MODE Tokens----*/
#define CSL_FSYNC_CTL1_RP1_MODE_DISABLE  (0x00000000u)
#define CSL_FSYNC_CTL1_RP1_MODE_ENABLE   (0x00000001u)

#define CSL_FSYNC_CTL1_RP3_EQUAL_SYS_MASK (0x00400000u)
#define CSL_FSYNC_CTL1_RP3_EQUAL_SYS_SHIFT (0x00000016u)
#define CSL_FSYNC_CTL1_RP3_EQUAL_SYS_RESETVAL (0x00000000u)

/*----RP3_EQUAL_SYS Tokens----*/
#define CSL_FSYNC_CTL1_RP3_EQUAL_SYS_FALSE (0x00000000u)
#define CSL_FSYNC_CTL1_RP3_EQUAL_SYS_TRUE (0x00000001u)

#define CSL_FSYNC_CTL1_TOD_FRAME_DLY_MASK (0x003C0000u)
#define CSL_FSYNC_CTL1_TOD_FRAME_DLY_SHIFT (0x00000012u)
#define CSL_FSYNC_CTL1_TOD_FRAME_DLY_RESETVAL (0x00000000u)

#define CSL_FSYNC_CTL1_SYS_FRAME_DLY_MASK (0x0003C000u)
#define CSL_FSYNC_CTL1_SYS_FRAME_DLY_SHIFT (0x0000000Eu)
#define CSL_FSYNC_CTL1_SYS_FRAME_DLY_RESETVAL (0x00000000u)

#define CSL_FSYNC_CTL1_RP3_FRAME_DLY_MASK (0x00003C00u)
#define CSL_FSYNC_CTL1_RP3_FRAME_DLY_SHIFT (0x0000000Au)
#define CSL_FSYNC_CTL1_RP3_FRAME_DLY_RESETVAL (0x00000000u)

#define CSL_FSYNC_CTL1_SYS_CLK_SEL_MASK  (0x00000380u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_SHIFT (0x00000007u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_RESETVAL (0x00000000u)

/*----SYS_CLK_SEL Tokens----*/
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_MOD_CLK (0x00000000u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_MOD_CLK3 (0x00000001u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_FSYNC_CLK (0x00000002u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_UMTS_CLK (0x00000003u)
#define CSL_FSYNC_CTL1_SYS_CLK_SEL_TRT_CLK (0x00000004u)

#define CSL_FSYNC_CTL1_RP3_CLK_SEL_MASK  (0x00000070u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_SHIFT (0x00000004u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_RESETVAL (0x00000000u)

/*----RP3_CLK_SEL Tokens----*/
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_MOD_CLK (0x00000000u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_MOD_CLK3 (0x00000001u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_FSYNC_CLK (0x00000002u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_UMTS_CLK (0x00000003u)
#define CSL_FSYNC_CTL1_RP3_CLK_SEL_TRT_CLK (0x00000004u)

#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_MASK (0x0000000Cu)
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_SHIFT (0x00000002u)
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_RESETVAL (0x00000000u)

/*----SYS_SYNC_SEL Tokens----*/
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_FRAME_BURST (0x00000000u)
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_UMTS_SYNC (0x00000001u)
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_TRT  (0x00000002u)
#define CSL_FSYNC_CTL1_SYS_SYNC_SEL_SYS_TEST (0x00000003u)

#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_MASK (0x00000003u)
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_SHIFT (0x00000000u)
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_RESETVAL (0x00000000u)

/*----RP3_SYNC_SEL Tokens----*/
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_FRAME_BURST (0x00000000u)
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_UMTS_SYNC (0x00000001u)
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_TRT  (0x00000002u)
#define CSL_FSYNC_CTL1_RP3_SYNC_SEL_SYS_TEST (0x00000003u)

#define CSL_FSYNC_CTL1_RESETVAL          (0x00000000u)

/* CTL2 */

#define CSL_FSYNC_CTL2_FS_RUN_MASK       (0x00000080u)
#define CSL_FSYNC_CTL2_FS_RUN_SHIFT      (0x00000007u)
#define CSL_FSYNC_CTL2_FS_RUN_RESETVAL   (0x00000000u)

/*----FS_RUN Tokens----*/
#define CSL_FSYNC_CTL2_FS_RUN_NO_RUN     (0x00000000u)
#define CSL_FSYNC_CTL2_FS_RUN_RUN        (0x00000001u)

#define CSL_FSYNC_CTL2_SYS_TEST_SYNC_MASK (0x00000040u)
#define CSL_FSYNC_CTL2_SYS_TEST_SYNC_SHIFT (0x00000006u)
#define CSL_FSYNC_CTL2_SYS_TEST_SYNC_RESETVAL (0x00000000u)

/*----SYS_TEST_SYNC Tokens----*/
#define CSL_FSYNC_CTL2_SYS_TEST_SYNC_NO_PULSE (0x00000000u)
#define CSL_FSYNC_CTL2_SYS_TEST_SYNC_PULSE (0x00000001u)

#define CSL_FSYNC_CTL2_ARM_TIMER_MASK    (0x00000004u)
#define CSL_FSYNC_CTL2_ARM_TIMER_SHIFT   (0x00000002u)
#define CSL_FSYNC_CTL2_ARM_TIMER_RESETVAL (0x00000000u)

/*----ARM_TIMER Tokens----*/
#define CSL_FSYNC_CTL2_ARM_TIMER_NO_ARM  (0x00000000u)
#define CSL_FSYNC_CTL2_ARM_TIMER_ARM     (0x00000001u)

#define CSL_FSYNC_CTL2_TIMER_HALT_MASK   (0x00000001u)
#define CSL_FSYNC_CTL2_TIMER_HALT_SHIFT  (0x00000000u)
#define CSL_FSYNC_CTL2_TIMER_HALT_RESETVAL (0x00000000u)

/*----TIMER_HALT Tokens----*/
#define CSL_FSYNC_CTL2_TIMER_HALT_NO_HALT (0x00000000u)
#define CSL_FSYNC_CTL2_TIMER_HALT_HALT   (0x00000001u)

#define CSL_FSYNC_CTL2_RESETVAL          (0x00000000u)

/* SYSTC */

#define CSL_FSYNC_SYSTC_WRAPADDR_MASK    (0x00001E00u)
#define CSL_FSYNC_SYSTC_WRAPADDR_SHIFT   (0x00000009u)
#define CSL_FSYNC_SYSTC_WRAPADDR_RESETVAL (0x00000000u)

#define CSL_FSYNC_SYSTC_SLOT_MASK        (0x000001E0u)
#define CSL_FSYNC_SYSTC_SLOT_SHIFT       (0x00000005u)
#define CSL_FSYNC_SYSTC_SLOT_RESETVAL    (0x00000000u)

#define CSL_FSYNC_SYSTC_SUBCHIP_MASK     (0x0000001Fu)
#define CSL_FSYNC_SYSTC_SUBCHIP_SHIFT    (0x00000000u)
#define CSL_FSYNC_SYSTC_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_SYSTC_RESETVAL         (0x00000000u)

/* RP3TC */

#define CSL_FSYNC_RP3TC_WRAPADDR_MASK    (0x00001E00u)
#define CSL_FSYNC_RP3TC_WRAPADDR_SHIFT   (0x00000009u)
#define CSL_FSYNC_RP3TC_WRAPADDR_RESETVAL (0x00000000u)

#define CSL_FSYNC_RP3TC_SLOT_MASK        (0x000001E0u)
#define CSL_FSYNC_RP3TC_SLOT_SHIFT       (0x00000005u)
#define CSL_FSYNC_RP3TC_SLOT_RESETVAL    (0x00000000u)

#define CSL_FSYNC_RP3TC_SUBCHIP_MASK     (0x0000001Fu)
#define CSL_FSYNC_RP3TC_SUBCHIP_SHIFT    (0x00000000u)
#define CSL_FSYNC_RP3TC_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_RP3TC_RESETVAL         (0x00000000u)

/* RP3TC */

#define CSL_FSYNC_RP3TC_TCOUNT_MASK      (0x00000FFFu)
#define CSL_FSYNC_RP3TC_TCOUNT_SHIFT     (0x00000000u)
#define CSL_FSYNC_RP3TC_TCOUNT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_RP3TC_RESETVAL         (0x00000000u)

/* SYSTC */

#define CSL_FSYNC_SYSTC_TCOUNT_MASK      (0x00000FFFu)
#define CSL_FSYNC_SYSTC_TCOUNT_SHIFT     (0x00000000u)
#define CSL_FSYNC_SYSTC_TCOUNT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_SYSTC_RESETVAL         (0x00000000u)

/* RP1TS */

#define CSL_FSYNC_RP1TS_RP1_TYPE_MASK    (0x000000FFu)
#define CSL_FSYNC_RP1TS_RP1_TYPE_SHIFT   (0x00000000u)
#define CSL_FSYNC_RP1TS_RP1_TYPE_RESETVAL (0x00000000u)

/*----RP1_TYPE Tokens----*/
#define CSL_FSYNC_RP1TS_RP1_TYPE_WCDMA_FDD (0x00000002u)
#define CSL_FSYNC_RP1TS_RP1_TYPE_CDMA2000 (0x00000007u)

#define CSL_FSYNC_RP1TS_RESETVAL         (0x00000000u)

/* UPDATE */

#define CSL_FSYNC_UPDATE_TOD_RATE_MASK   (0x00FF0000u)
#define CSL_FSYNC_UPDATE_TOD_RATE_SHIFT  (0x00000010u)
#define CSL_FSYNC_UPDATE_TOD_RATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_UPDATE_RP3_RATE_MASK   (0x0000FF00u)
#define CSL_FSYNC_UPDATE_RP3_RATE_SHIFT  (0x00000008u)
#define CSL_FSYNC_UPDATE_RP3_RATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_UPDATE_SYS_RATE_MASK   (0x000000FFu)
#define CSL_FSYNC_UPDATE_SYS_RATE_SHIFT  (0x00000000u)
#define CSL_FSYNC_UPDATE_SYS_RATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_UPDATE_RESETVAL        (0x00000000u)

/* TYPE */

#define CSL_FSYNC_TYPE_TYPE_MASK         (0x000000FFu)
#define CSL_FSYNC_TYPE_TYPE_SHIFT        (0x00000000u)
#define CSL_FSYNC_TYPE_TYPE_RESETVAL     (0x00000000u)

#define CSL_FSYNC_TYPE_RESETVAL          (0x00000000u)

/* TOD1 */

#define CSL_FSYNC_TOD1_TOD_LS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_TOD1_TOD_LS_SHIFT      (0x00000000u)
#define CSL_FSYNC_TOD1_TOD_LS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_TOD1_RESETVAL          (0x00000000u)

/* TOD2 */

#define CSL_FSYNC_TOD2_TOD_MS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_TOD2_TOD_MS_SHIFT      (0x00000000u)
#define CSL_FSYNC_TOD2_TOD_MS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_TOD2_RESETVAL          (0x00000000u)

/* RP31 */

#define CSL_FSYNC_RP31_RP3_LS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_RP31_RP3_LS_SHIFT      (0x00000000u)
#define CSL_FSYNC_RP31_RP3_LS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_RP31_RESETVAL          (0x00000000u)

/* RP32 */

#define CSL_FSYNC_RP32_RP3_MS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_RP32_RP3_MS_SHIFT      (0x00000000u)
#define CSL_FSYNC_RP32_RP3_MS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_RP32_RESETVAL          (0x00000000u)

/* SYS1 */

#define CSL_FSYNC_SYS1_SYS_LS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_SYS1_SYS_LS_SHIFT      (0x00000000u)
#define CSL_FSYNC_SYS1_SYS_LS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_SYS1_RESETVAL          (0x00000000u)

/* SYS2 */

#define CSL_FSYNC_SYS2_SYS_MS_MASK       (0xFFFFFFFFu)
#define CSL_FSYNC_SYS2_SYS_MS_SHIFT      (0x00000000u)
#define CSL_FSYNC_SYS2_SYS_MS_RESETVAL   (0x00000000u)

#define CSL_FSYNC_SYS2_RESETVAL          (0x00000000u)

/* TODVAL */

#define CSL_FSYNC_TODVAL_VALUE_MASK      (0xFFFFFFFFu)
#define CSL_FSYNC_TODVAL_VALUE_SHIFT     (0x00000000u)
#define CSL_FSYNC_TODVAL_VALUE_RESETVAL  (0x00000000u)

#define CSL_FSYNC_TODVAL_RESETVAL        (0x00000000u)

/* RP3VAL */

#define CSL_FSYNC_RP3VAL_FRAME_MASK      (0x0FFF0000u)
#define CSL_FSYNC_RP3VAL_FRAME_SHIFT     (0x00000010u)
#define CSL_FSYNC_RP3VAL_FRAME_RESETVAL  (0x00000000u)

#define CSL_FSYNC_RP3VAL_SLOT_MASK       (0x0000F000u)
#define CSL_FSYNC_RP3VAL_SLOT_SHIFT      (0x0000000Cu)
#define CSL_FSYNC_RP3VAL_SLOT_RESETVAL   (0x00000000u)

#define CSL_FSYNC_RP3VAL_CHIP_MASK       (0x00000FFFu)
#define CSL_FSYNC_RP3VAL_CHIP_SHIFT      (0x00000000u)
#define CSL_FSYNC_RP3VAL_CHIP_RESETVAL   (0x00000000u)

#define CSL_FSYNC_RP3VAL_RESETVAL        (0x00000000u)

/* SYSVAL */

#define CSL_FSYNC_SYSVAL_FRAME_MASK      (0x0FFF0000u)
#define CSL_FSYNC_SYSVAL_FRAME_SHIFT     (0x00000010u)
#define CSL_FSYNC_SYSVAL_FRAME_RESETVAL  (0x00000000u)

#define CSL_FSYNC_SYSVAL_SLOT_MASK       (0x0000F000u)
#define CSL_FSYNC_SYSVAL_SLOT_SHIFT      (0x0000000Cu)
#define CSL_FSYNC_SYSVAL_SLOT_RESETVAL   (0x00000000u)

#define CSL_FSYNC_SYSVAL_CHIP_MASK       (0x00000FFFu)
#define CSL_FSYNC_SYSVAL_CHIP_SHIFT      (0x00000000u)
#define CSL_FSYNC_SYSVAL_CHIP_RESETVAL   (0x00000000u)

#define CSL_FSYNC_SYSVAL_RESETVAL        (0x00000000u)

/* RP3INIT */

#define CSL_FSYNC_RP3INIT_FRAME_MASK     (0x0FFF0000u)
#define CSL_FSYNC_RP3INIT_FRAME_SHIFT    (0x00000010u)
#define CSL_FSYNC_RP3INIT_FRAME_RESETVAL (0x00000000u)

#define CSL_FSYNC_RP3INIT_SLOT_MASK      (0x0000F000u)
#define CSL_FSYNC_RP3INIT_SLOT_SHIFT     (0x0000000Cu)
#define CSL_FSYNC_RP3INIT_SLOT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_RP3INIT_CHIP_MASK      (0x00000FFFu)
#define CSL_FSYNC_RP3INIT_CHIP_SHIFT     (0x00000000u)
#define CSL_FSYNC_RP3INIT_CHIP_RESETVAL  (0x00000000u)

#define CSL_FSYNC_RP3INIT_RESETVAL       (0x00000000u)

/* SYSINIT */

#define CSL_FSYNC_SYSINIT_FRAME_MASK     (0x0FFF0000u)
#define CSL_FSYNC_SYSINIT_FRAME_SHIFT    (0x00000010u)
#define CSL_FSYNC_SYSINIT_FRAME_RESETVAL (0x00000000u)

#define CSL_FSYNC_SYSINIT_SLOT_MASK      (0x0000F000u)
#define CSL_FSYNC_SYSINIT_SLOT_SHIFT     (0x0000000Cu)
#define CSL_FSYNC_SYSINIT_SLOT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_SYSINIT_CHIP_MASK      (0x00000FFFu)
#define CSL_FSYNC_SYSINIT_CHIP_SHIFT     (0x00000000u)
#define CSL_FSYNC_SYSINIT_CHIP_RESETVAL  (0x00000000u)

#define CSL_FSYNC_SYSINIT_RESETVAL       (0x00000000u)

/* EMUCTL */

#define CSL_FSYNC_EMUCTL_FREE_MASK       (0x00000002u)
#define CSL_FSYNC_EMUCTL_FREE_SHIFT      (0x00000001u)
#define CSL_FSYNC_EMUCTL_FREE_RESETVAL   (0x00000000u)

/*----FREE Tokens----*/
#define CSL_FSYNC_EMUCTL_FREE_SUSPEND    (0x00000000u)
#define CSL_FSYNC_EMUCTL_FREE_FREERUN    (0x00000001u)

#define CSL_FSYNC_EMUCTL_SOFT_MASK       (0x00000001u)
#define CSL_FSYNC_EMUCTL_SOFT_SHIFT      (0x00000000u)
#define CSL_FSYNC_EMUCTL_SOFT_RESETVAL   (0x00000000u)

/*----SOFT Tokens----*/
#define CSL_FSYNC_EMUCTL_SOFT_SOFTHALT   (0x00000000u)
#define CSL_FSYNC_EMUCTL_SOFT_HARDHALT   (0x00000001u)

#define CSL_FSYNC_EMUCTL_RESETVAL        (0x00000000u)

/* EMUMASK */

#define CSL_FSYNC_EMUMASK_MASK29_MASK    (0x20000000u)
#define CSL_FSYNC_EMUMASK_MASK29_SHIFT   (0x0000001Du)
#define CSL_FSYNC_EMUMASK_MASK29_RESETVAL (0x00000000u)

/*----MASK29 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK29_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK29_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK28_MASK    (0x10000000u)
#define CSL_FSYNC_EMUMASK_MASK28_SHIFT   (0x0000001Cu)
#define CSL_FSYNC_EMUMASK_MASK28_RESETVAL (0x00000000u)

/*----MASK28 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK28_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK28_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK27_MASK    (0x08000000u)
#define CSL_FSYNC_EMUMASK_MASK27_SHIFT   (0x0000001Bu)
#define CSL_FSYNC_EMUMASK_MASK27_RESETVAL (0x00000000u)

/*----MASK27 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK27_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK27_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK26_MASK    (0x04000000u)
#define CSL_FSYNC_EMUMASK_MASK26_SHIFT   (0x0000001Au)
#define CSL_FSYNC_EMUMASK_MASK26_RESETVAL (0x00000000u)

/*----MASK26 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK26_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK26_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK25_MASK    (0x02000000u)
#define CSL_FSYNC_EMUMASK_MASK25_SHIFT   (0x00000019u)
#define CSL_FSYNC_EMUMASK_MASK25_RESETVAL (0x00000000u)

/*----MASK25 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK25_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK25_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK24_MASK    (0x01000000u)
#define CSL_FSYNC_EMUMASK_MASK24_SHIFT   (0x00000018u)
#define CSL_FSYNC_EMUMASK_MASK24_RESETVAL (0x00000000u)

/*----MASK24 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK24_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK24_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK23_MASK    (0x00800000u)
#define CSL_FSYNC_EMUMASK_MASK23_SHIFT   (0x00000017u)
#define CSL_FSYNC_EMUMASK_MASK23_RESETVAL (0x00000000u)

/*----MASK23 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK23_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK23_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK22_MASK    (0x00400000u)
#define CSL_FSYNC_EMUMASK_MASK22_SHIFT   (0x00000016u)
#define CSL_FSYNC_EMUMASK_MASK22_RESETVAL (0x00000000u)

/*----MASK22 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK22_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK22_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK21_MASK    (0x00200000u)
#define CSL_FSYNC_EMUMASK_MASK21_SHIFT   (0x00000015u)
#define CSL_FSYNC_EMUMASK_MASK21_RESETVAL (0x00000000u)

/*----MASK21 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK21_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK21_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK20_MASK    (0x00100000u)
#define CSL_FSYNC_EMUMASK_MASK20_SHIFT   (0x00000014u)
#define CSL_FSYNC_EMUMASK_MASK20_RESETVAL (0x00000000u)

/*----MASK20 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK20_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK20_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK19_MASK    (0x00080000u)
#define CSL_FSYNC_EMUMASK_MASK19_SHIFT   (0x00000013u)
#define CSL_FSYNC_EMUMASK_MASK19_RESETVAL (0x00000000u)

/*----MASK19 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK19_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK19_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK18_MASK    (0x00040000u)
#define CSL_FSYNC_EMUMASK_MASK18_SHIFT   (0x00000012u)
#define CSL_FSYNC_EMUMASK_MASK18_RESETVAL (0x00000000u)

/*----MASK18 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK18_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK18_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK17_MASK    (0x00020000u)
#define CSL_FSYNC_EMUMASK_MASK17_SHIFT   (0x00000011u)
#define CSL_FSYNC_EMUMASK_MASK17_RESETVAL (0x00000000u)

/*----MASK17 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK17_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK17_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK16_MASK    (0x00010000u)
#define CSL_FSYNC_EMUMASK_MASK16_SHIFT   (0x00000010u)
#define CSL_FSYNC_EMUMASK_MASK16_RESETVAL (0x00000000u)

/*----MASK16 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK16_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK16_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK15_MASK    (0x00008000u)
#define CSL_FSYNC_EMUMASK_MASK15_SHIFT   (0x0000000Fu)
#define CSL_FSYNC_EMUMASK_MASK15_RESETVAL (0x00000000u)

/*----MASK15 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK15_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK15_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK14_MASK    (0x00004000u)
#define CSL_FSYNC_EMUMASK_MASK14_SHIFT   (0x0000000Eu)
#define CSL_FSYNC_EMUMASK_MASK14_RESETVAL (0x00000000u)

/*----MASK14 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK14_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK14_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK13_MASK    (0x00002000u)
#define CSL_FSYNC_EMUMASK_MASK13_SHIFT   (0x0000000Du)
#define CSL_FSYNC_EMUMASK_MASK13_RESETVAL (0x00000000u)

/*----MASK13 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK13_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK13_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK12_MASK    (0x00001000u)
#define CSL_FSYNC_EMUMASK_MASK12_SHIFT   (0x0000000Cu)
#define CSL_FSYNC_EMUMASK_MASK12_RESETVAL (0x00000000u)

/*----MASK12 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK12_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK12_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK11_MASK    (0x00000800u)
#define CSL_FSYNC_EMUMASK_MASK11_SHIFT   (0x0000000Bu)
#define CSL_FSYNC_EMUMASK_MASK11_RESETVAL (0x00000000u)

/*----MASK11 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK11_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK11_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK10_MASK    (0x00000400u)
#define CSL_FSYNC_EMUMASK_MASK10_SHIFT   (0x0000000Au)
#define CSL_FSYNC_EMUMASK_MASK10_RESETVAL (0x00000000u)

/*----MASK10 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK10_FALSE   (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK10_TRUE    (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK9_MASK     (0x00000200u)
#define CSL_FSYNC_EMUMASK_MASK9_SHIFT    (0x00000009u)
#define CSL_FSYNC_EMUMASK_MASK9_RESETVAL (0x00000000u)

/*----MASK9 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK9_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK9_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK8_MASK     (0x00000100u)
#define CSL_FSYNC_EMUMASK_MASK8_SHIFT    (0x00000008u)
#define CSL_FSYNC_EMUMASK_MASK8_RESETVAL (0x00000000u)

/*----MASK8 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK8_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK8_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK7_MASK     (0x00000080u)
#define CSL_FSYNC_EMUMASK_MASK7_SHIFT    (0x00000007u)
#define CSL_FSYNC_EMUMASK_MASK7_RESETVAL (0x00000000u)

/*----MASK7 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK7_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK7_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK6_MASK     (0x00000040u)
#define CSL_FSYNC_EMUMASK_MASK6_SHIFT    (0x00000006u)
#define CSL_FSYNC_EMUMASK_MASK6_RESETVAL (0x00000000u)

/*----MASK6 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK6_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK6_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK5_MASK     (0x00000020u)
#define CSL_FSYNC_EMUMASK_MASK5_SHIFT    (0x00000005u)
#define CSL_FSYNC_EMUMASK_MASK5_RESETVAL (0x00000000u)

/*----MASK5 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK5_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK5_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK4_MASK     (0x00000010u)
#define CSL_FSYNC_EMUMASK_MASK4_SHIFT    (0x00000004u)
#define CSL_FSYNC_EMUMASK_MASK4_RESETVAL (0x00000000u)

/*----MASK4 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK4_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK4_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK3_MASK     (0x00000008u)
#define CSL_FSYNC_EMUMASK_MASK3_SHIFT    (0x00000003u)
#define CSL_FSYNC_EMUMASK_MASK3_RESETVAL (0x00000000u)

/*----MASK3 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK3_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK3_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK2_MASK     (0x00000004u)
#define CSL_FSYNC_EMUMASK_MASK2_SHIFT    (0x00000002u)
#define CSL_FSYNC_EMUMASK_MASK2_RESETVAL (0x00000000u)

/*----MASK2 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK2_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK2_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK1_MASK     (0x00000002u)
#define CSL_FSYNC_EMUMASK_MASK1_SHIFT    (0x00000001u)
#define CSL_FSYNC_EMUMASK_MASK1_RESETVAL (0x00000000u)

/*----MASK1 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK1_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK1_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_MASK0_MASK     (0x00000001u)
#define CSL_FSYNC_EMUMASK_MASK0_SHIFT    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK0_RESETVAL (0x00000000u)

/*----MASK0 Tokens----*/
#define CSL_FSYNC_EMUMASK_MASK0_FALSE    (0x00000000u)
#define CSL_FSYNC_EMUMASK_MASK0_TRUE     (0x00000001u)

#define CSL_FSYNC_EMUMASK_RESETVAL       (0x00000000u)

/* EVTFORCE */

#define CSL_FSYNC_EVTFORCE_RESERVED_MASK (0xC0000000u)
#define CSL_FSYNC_EVTFORCE_RESERVED_SHIFT (0x0000001Eu)
#define CSL_FSYNC_EVTFORCE_RESERVED_RESETVAL (0x00000000u)

#define CSL_FSYNC_EVTFORCE_EVT29_MASK    (0x20000000u)
#define CSL_FSYNC_EVTFORCE_EVT29_SHIFT   (0x0000001Du)
#define CSL_FSYNC_EVTFORCE_EVT29_RESETVAL (0x00000000u)

/*----EVT29 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT29_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT29_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT28_MASK    (0x10000000u)
#define CSL_FSYNC_EVTFORCE_EVT28_SHIFT   (0x0000001Cu)
#define CSL_FSYNC_EVTFORCE_EVT28_RESETVAL (0x00000000u)

/*----EVT28 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT28_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT28_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT27_MASK    (0x08000000u)
#define CSL_FSYNC_EVTFORCE_EVT27_SHIFT   (0x0000001Bu)
#define CSL_FSYNC_EVTFORCE_EVT27_RESETVAL (0x00000000u)

/*----EVT27 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT27_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT27_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT26_MASK    (0x04000000u)
#define CSL_FSYNC_EVTFORCE_EVT26_SHIFT   (0x0000001Au)
#define CSL_FSYNC_EVTFORCE_EVT26_RESETVAL (0x00000000u)

/*----EVT26 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT26_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT26_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT25_MASK    (0x02000000u)
#define CSL_FSYNC_EVTFORCE_EVT25_SHIFT   (0x00000019u)
#define CSL_FSYNC_EVTFORCE_EVT25_RESETVAL (0x00000000u)

/*----EVT25 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT25_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT25_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT24_MASK    (0x01000000u)
#define CSL_FSYNC_EVTFORCE_EVT24_SHIFT   (0x00000018u)
#define CSL_FSYNC_EVTFORCE_EVT24_RESETVAL (0x00000000u)

/*----EVT24 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT24_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT24_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT23_MASK    (0x00800000u)
#define CSL_FSYNC_EVTFORCE_EVT23_SHIFT   (0x00000017u)
#define CSL_FSYNC_EVTFORCE_EVT23_RESETVAL (0x00000000u)

/*----EVT23 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT23_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT23_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT22_MASK    (0x00400000u)
#define CSL_FSYNC_EVTFORCE_EVT22_SHIFT   (0x00000016u)
#define CSL_FSYNC_EVTFORCE_EVT22_RESETVAL (0x00000000u)

/*----EVT22 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT22_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT22_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT21_MASK    (0x00200000u)
#define CSL_FSYNC_EVTFORCE_EVT21_SHIFT   (0x00000015u)
#define CSL_FSYNC_EVTFORCE_EVT21_RESETVAL (0x00000000u)

/*----EVT21 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT21_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT21_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT20_MASK    (0x00100000u)
#define CSL_FSYNC_EVTFORCE_EVT20_SHIFT   (0x00000014u)
#define CSL_FSYNC_EVTFORCE_EVT20_RESETVAL (0x00000000u)

/*----EVT20 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT20_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT20_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT19_MASK    (0x00080000u)
#define CSL_FSYNC_EVTFORCE_EVT19_SHIFT   (0x00000013u)
#define CSL_FSYNC_EVTFORCE_EVT19_RESETVAL (0x00000000u)

/*----EVT19 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT19_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT19_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT18_MASK    (0x00040000u)
#define CSL_FSYNC_EVTFORCE_EVT18_SHIFT   (0x00000012u)
#define CSL_FSYNC_EVTFORCE_EVT18_RESETVAL (0x00000000u)

/*----EVT18 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT18_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT18_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT17_MASK    (0x00020000u)
#define CSL_FSYNC_EVTFORCE_EVT17_SHIFT   (0x00000011u)
#define CSL_FSYNC_EVTFORCE_EVT17_RESETVAL (0x00000000u)

/*----EVT17 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT17_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT17_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT16_MASK    (0x00010000u)
#define CSL_FSYNC_EVTFORCE_EVT16_SHIFT   (0x00000010u)
#define CSL_FSYNC_EVTFORCE_EVT16_RESETVAL (0x00000000u)

/*----EVT16 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT16_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT16_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT15_MASK    (0x00008000u)
#define CSL_FSYNC_EVTFORCE_EVT15_SHIFT   (0x0000000Fu)
#define CSL_FSYNC_EVTFORCE_EVT15_RESETVAL (0x00000000u)

/*----EVT15 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT15_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT15_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT14_MASK    (0x00004000u)
#define CSL_FSYNC_EVTFORCE_EVT14_SHIFT   (0x0000000Eu)
#define CSL_FSYNC_EVTFORCE_EVT14_RESETVAL (0x00000000u)

/*----EVT14 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT14_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT14_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT13_MASK    (0x00002000u)
#define CSL_FSYNC_EVTFORCE_EVT13_SHIFT   (0x0000000Du)
#define CSL_FSYNC_EVTFORCE_EVT13_RESETVAL (0x00000000u)

/*----EVT13 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT13_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT13_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT12_MASK    (0x00001000u)
#define CSL_FSYNC_EVTFORCE_EVT12_SHIFT   (0x0000000Cu)
#define CSL_FSYNC_EVTFORCE_EVT12_RESETVAL (0x00000000u)

/*----EVT12 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT12_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT12_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT11_MASK    (0x00000800u)
#define CSL_FSYNC_EVTFORCE_EVT11_SHIFT   (0x0000000Bu)
#define CSL_FSYNC_EVTFORCE_EVT11_RESETVAL (0x00000000u)

/*----EVT11 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT11_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT11_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT10_MASK    (0x00000400u)
#define CSL_FSYNC_EVTFORCE_EVT10_SHIFT   (0x0000000Au)
#define CSL_FSYNC_EVTFORCE_EVT10_RESETVAL (0x00000000u)

/*----EVT10 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT10_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT10_FORCE   (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT9_MASK     (0x00000200u)
#define CSL_FSYNC_EVTFORCE_EVT9_SHIFT    (0x00000009u)
#define CSL_FSYNC_EVTFORCE_EVT9_RESETVAL (0x00000000u)

/*----EVT9 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT9_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT9_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT8_MASK     (0x00000100u)
#define CSL_FSYNC_EVTFORCE_EVT8_SHIFT    (0x00000008u)
#define CSL_FSYNC_EVTFORCE_EVT8_RESETVAL (0x00000000u)

/*----EVT8 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT8_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT8_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT7_MASK     (0x00000080u)
#define CSL_FSYNC_EVTFORCE_EVT7_SHIFT    (0x00000007u)
#define CSL_FSYNC_EVTFORCE_EVT7_RESETVAL (0x00000000u)

/*----EVT7 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT7_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT7_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT6_MASK     (0x00000040u)
#define CSL_FSYNC_EVTFORCE_EVT6_SHIFT    (0x00000006u)
#define CSL_FSYNC_EVTFORCE_EVT6_RESETVAL (0x00000000u)

/*----EVT6 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT6_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT6_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT5_MASK     (0x00000020u)
#define CSL_FSYNC_EVTFORCE_EVT5_SHIFT    (0x00000005u)
#define CSL_FSYNC_EVTFORCE_EVT5_RESETVAL (0x00000000u)

/*----EVT5 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT5_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT5_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT4_MASK     (0x00000010u)
#define CSL_FSYNC_EVTFORCE_EVT4_SHIFT    (0x00000004u)
#define CSL_FSYNC_EVTFORCE_EVT4_RESETVAL (0x00000000u)

/*----EVT4 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT4_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT4_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT3_MASK     (0x00000008u)
#define CSL_FSYNC_EVTFORCE_EVT3_SHIFT    (0x00000003u)
#define CSL_FSYNC_EVTFORCE_EVT3_RESETVAL (0x00000000u)

/*----EVT3 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT3_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT3_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT2_MASK     (0x00000004u)
#define CSL_FSYNC_EVTFORCE_EVT2_SHIFT    (0x00000002u)
#define CSL_FSYNC_EVTFORCE_EVT2_RESETVAL (0x00000000u)

/*----EVT2 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT2_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT2_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT1_MASK     (0x00000002u)
#define CSL_FSYNC_EVTFORCE_EVT1_SHIFT    (0x00000001u)
#define CSL_FSYNC_EVTFORCE_EVT1_RESETVAL (0x00000000u)

/*----EVT1 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT1_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT1_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_EVT0_MASK     (0x00000001u)
#define CSL_FSYNC_EVTFORCE_EVT0_SHIFT    (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT0_RESETVAL (0x00000000u)

/*----EVT0 Tokens----*/
#define CSL_FSYNC_EVTFORCE_EVT0_NO_FORCE (0x00000000u)
#define CSL_FSYNC_EVTFORCE_EVT0_FORCE    (0x00000001u)

#define CSL_FSYNC_EVTFORCE_RESETVAL      (0x00000000u)

/* EGMCOMPARE */

#define CSL_FSYNC_EGMCOMPARE_FRAME_MASK  (0x06000000u)
#define CSL_FSYNC_EGMCOMPARE_FRAME_SHIFT (0x00000019u)
#define CSL_FSYNC_EGMCOMPARE_FRAME_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCOMPARE_SLOT_MASK   (0x01E00000u)
#define CSL_FSYNC_EGMCOMPARE_SLOT_SHIFT  (0x00000015u)
#define CSL_FSYNC_EGMCOMPARE_SLOT_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCOMPARE_TCSTATE_MASK (0x001E0000u)
#define CSL_FSYNC_EGMCOMPARE_TCSTATE_SHIFT (0x00000011u)
#define CSL_FSYNC_EGMCOMPARE_TCSTATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCOMPARE_CHIP_MASK   (0x0001FFE0u)
#define CSL_FSYNC_EGMCOMPARE_CHIP_SHIFT  (0x00000005u)
#define CSL_FSYNC_EGMCOMPARE_CHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCOMPARE_SUBCHIP_MASK (0x0000001Fu)
#define CSL_FSYNC_EGMCOMPARE_SUBCHIP_SHIFT (0x00000000u)
#define CSL_FSYNC_EGMCOMPARE_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCOMPARE_RESETVAL    (0x00000000u)

/* EGMMASK */

#define CSL_FSYNC_EGMMASK_FRAME_MASK     (0x06000000u)
#define CSL_FSYNC_EGMMASK_FRAME_SHIFT    (0x00000019u)
#define CSL_FSYNC_EGMMASK_FRAME_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMMASK_SLOT_MASK      (0x01E00000u)
#define CSL_FSYNC_EGMMASK_SLOT_SHIFT     (0x00000015u)
#define CSL_FSYNC_EGMMASK_SLOT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGMMASK_TCSTATE_MASK   (0x001E0000u)
#define CSL_FSYNC_EGMMASK_TCSTATE_SHIFT  (0x00000011u)
#define CSL_FSYNC_EGMMASK_TCSTATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMMASK_CHIP_MASK      (0x0001FFE0u)
#define CSL_FSYNC_EGMMASK_CHIP_SHIFT     (0x00000005u)
#define CSL_FSYNC_EGMMASK_CHIP_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGMMASK_SUBCHIP_MASK   (0x0000001Fu)
#define CSL_FSYNC_EGMMASK_SUBCHIP_SHIFT  (0x00000000u)
#define CSL_FSYNC_EGMMASK_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMMASK_RESETVAL       (0x00000000u)

/* EGMCTRL */

#define CSL_FSYNC_EGMCTRL_SOURCE_MASK    (0x04000000u)
#define CSL_FSYNC_EGMCTRL_SOURCE_SHIFT   (0x0000001Au)
#define CSL_FSYNC_EGMCTRL_SOURCE_RESETVAL (0x00000000u)

/*----SOURCE Tokens----*/
#define CSL_FSYNC_EGMCTRL_SOURCE_SYS     (0x00000000u)
#define CSL_FSYNC_EGMCTRL_SOURCE_RP3     (0x00000001u)

#define CSL_FSYNC_EGMCTRL_ENABLE_MASK    (0x02000000u)
#define CSL_FSYNC_EGMCTRL_ENABLE_SHIFT   (0x00000019u)
#define CSL_FSYNC_EGMCTRL_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_FSYNC_EGMCTRL_ENABLE_DISABLE (0x00000000u)
#define CSL_FSYNC_EGMCTRL_ENABLE_ENABLE  (0x00000001u)

#define CSL_FSYNC_EGMCTRL_SLOT_MASK      (0x01E00000u)
#define CSL_FSYNC_EGMCTRL_SLOT_SHIFT     (0x00000015u)
#define CSL_FSYNC_EGMCTRL_SLOT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGMCTRL_TCSTATE_MASK   (0x001E0000u)
#define CSL_FSYNC_EGMCTRL_TCSTATE_SHIFT  (0x00000011u)
#define CSL_FSYNC_EGMCTRL_TCSTATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCTRL_CHIP_MASK      (0x0001FFE0u)
#define CSL_FSYNC_EGMCTRL_CHIP_SHIFT     (0x00000005u)
#define CSL_FSYNC_EGMCTRL_CHIP_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGMCTRL_SUBCHIP_MASK   (0x0000001Fu)
#define CSL_FSYNC_EGMCTRL_SUBCHIP_SHIFT  (0x00000000u)
#define CSL_FSYNC_EGMCTRL_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGMCTRL_RESETVAL       (0x00000000u)

/* EGCTCOUNT */

#define CSL_FSYNC_EGCTCOUNT_TCOUNT_MASK  (0x07FFFFFFu)
#define CSL_FSYNC_EGCTCOUNT_TCOUNT_SHIFT (0x00000000u)
#define CSL_FSYNC_EGCTCOUNT_TCOUNT_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGCTCOUNT_RESETVAL     (0x00000000u)

/* EGCCTRL */

#define CSL_FSYNC_EGCCTRL_SOURCE_MASK    (0x04000000u)
#define CSL_FSYNC_EGCCTRL_SOURCE_SHIFT   (0x0000001Au)
#define CSL_FSYNC_EGCCTRL_SOURCE_RESETVAL (0x00000000u)

/*----SOURCE Tokens----*/
#define CSL_FSYNC_EGCCTRL_SOURCE_SYS     (0x00000000u)
#define CSL_FSYNC_EGCCTRL_SOURCE_RP3     (0x00000001u)

#define CSL_FSYNC_EGCCTRL_ENABLE_MASK    (0x02000000u)
#define CSL_FSYNC_EGCCTRL_ENABLE_SHIFT   (0x00000019u)
#define CSL_FSYNC_EGCCTRL_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_FSYNC_EGCCTRL_ENABLE_DISABLE (0x00000000u)
#define CSL_FSYNC_EGCCTRL_ENABLE_ENABLE  (0x00000001u)

#define CSL_FSYNC_EGCCTRL_SLOT_MASK      (0x01E00000u)
#define CSL_FSYNC_EGCCTRL_SLOT_SHIFT     (0x00000015u)
#define CSL_FSYNC_EGCCTRL_SLOT_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGCCTRL_TCSTATE_MASK   (0x001E0000u)
#define CSL_FSYNC_EGCCTRL_TCSTATE_SHIFT  (0x00000011u)
#define CSL_FSYNC_EGCCTRL_TCSTATE_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGCCTRL_CHIP_MASK      (0x0001FFE0u)
#define CSL_FSYNC_EGCCTRL_CHIP_SHIFT     (0x00000005u)
#define CSL_FSYNC_EGCCTRL_CHIP_RESETVAL  (0x00000000u)

#define CSL_FSYNC_EGCCTRL_SUBCHIP_MASK   (0x0000001Fu)
#define CSL_FSYNC_EGCCTRL_SUBCHIP_SHIFT  (0x00000000u)
#define CSL_FSYNC_EGCCTRL_SUBCHIP_RESETVAL (0x00000000u)

#define CSL_FSYNC_EGCCTRL_RESETVAL       (0x00000000u)

/* ERR_INT_SRC_RAW */

#define CSL_FSYNC_ERR_INT_SRC_RAW_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_INT_SRC_RAW_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_INT_SRC_RAW_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_INT_SRC_RAW_RESETVAL (0x00000000u)

/* ERR_MASK_STAT_0 */

#define CSL_FSYNC_ERR_MASK_STAT_0_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_MASK_STAT_0_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_MASK_STAT_0_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_MASK_STAT_0_RESETVAL (0x00000000u)

/* ERR_MASK_STAT_1 */

#define CSL_FSYNC_ERR_MASK_STAT_1_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_MASK_STAT_1_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_MASK_STAT_1_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_MASK_STAT_1_RESETVAL (0x00000000u)

/* ERR_SET_MASK_0 */

#define CSL_FSYNC_ERR_SET_MASK_0_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_SET_MASK_0_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_SET_MASK_0_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_SET_MASK_0_RESETVAL (0x00000000u)

/* ERR_SET_MASK_1 */

#define CSL_FSYNC_ERR_SET_MASK_1_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_SET_MASK_1_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_SET_MASK_1_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_SET_MASK_1_RESETVAL (0x00000000u)

/* ERR_CLEAR_MASK_0 */

#define CSL_FSYNC_ERR_CLEAR_MASK_0_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_CLEAR_MASK_0_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_CLEAR_MASK_0_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_CLEAR_MASK_0_RESETVAL (0x00000000u)

/* ERR_CLEAR_MASK_1 */

#define CSL_FSYNC_ERR_CLEAR_MASK_1_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_CLEAR_MASK_1_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_CLEAR_MASK_1_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_CLEAR_MASK_1_RESETVAL (0x00000000u)

/* ERR_INT_MASK_0 */

#define CSL_FSYNC_ERR_INT_MASK_0_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_INT_MASK_0_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_INT_MASK_0_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_INT_MASK_0_RESETVAL (0x00000000u)

/* ERR_INT_MASK_1 */

#define CSL_FSYNC_ERR_INT_MASK_1_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_INT_MASK_1_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_INT_MASK_1_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_INT_MASK_1_RESETVAL (0x00000000u)

/* ERR_INT_SET */

#define CSL_FSYNC_ERR_INT_SET_ERR_MASK   (0x00007FFFu)
#define CSL_FSYNC_ERR_INT_SET_ERR_SHIFT  (0x00000000u)
#define CSL_FSYNC_ERR_INT_SET_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_INT_SET_RESETVAL   (0x00000000u)

/* ERR_INT_CLEAR */

#define CSL_FSYNC_ERR_INT_CLEAR_ERR_MASK (0x00007FFFu)
#define CSL_FSYNC_ERR_INT_CLEAR_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_INT_CLEAR_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_INT_CLEAR_RESETVAL (0x00000000u)

/* ERR_END_OF_INT */

#define CSL_FSYNC_ERR_END_OF_INT_ERR_MASK (0x00000003u)
#define CSL_FSYNC_ERR_END_OF_INT_ERR_SHIFT (0x00000000u)
#define CSL_FSYNC_ERR_END_OF_INT_ERR_RESETVAL (0x00000000u)

#define CSL_FSYNC_ERR_END_OF_INT_RESETVAL (0x00000000u)

#endif
