/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_gccp_cfg.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for GCCP_CFG
 *
 */

#ifndef _CSLR_GCCP_CFG_2_H_
#define _CSLR_GCCP_CFG_2_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for TPM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 TPM_FD_W0;
    volatile Uint32 TPM_FD_W1;
    volatile Uint32 TPM_FD_W2;
    volatile Uint32 TPM_FD_W3;
} CSL_Gccp_cfgTpmRegs;

/**************************************************************************\
* Register Overlay Structure for MTPM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 MTPM_FD_W0;
    volatile Uint32 MTPM_FD_W1;
    volatile Uint32 MTPM_FD_W2;
    volatile Uint32 MTPM_FD_W3;
    volatile Uint32 MTPM_FD_W4;
    volatile Uint32 RSVD0[3];
} CSL_Gccp_cfgMtpmRegs;

/**************************************************************************\
* Register Overlay Structure for TRM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 TRM_W0;
    volatile Uint32 TRM_W1;
} CSL_Gccp_cfgTrmRegs;

/**************************************************************************\
* Register Overlay Structure for PRT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PRT_W0;
    volatile Uint32 PRT_W1;
    volatile Uint32 PRT_W2;
    volatile Uint32 PRT_W3;
    volatile Uint32 PRT_W4;
    volatile Uint32 RSVD0[3];
} CSL_Gccp_cfgPrtRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    CSL_Gccp_cfgTpmRegs TPM[3072];
    volatile Uint32 RSVD0[4096];
    CSL_Gccp_cfgMtpmRegs MTPM[768];
    volatile Uint32 RSVD1[2048];
    volatile Uint32 TAM[3072];
    volatile Uint32 RSVD2[1024];
    CSL_Gccp_cfgTrmRegs TRM[1536];
    volatile Uint32 GCCP_SEQ_ENA;
    volatile Uint32 GCCP_SEQ_ACT;
    volatile Uint32 GCCP_SEQ_CYC;
    volatile Uint32 GCCP_CYC_OVER;
    volatile Uint32 GCCP_FIFO_OVER;
    volatile Uint32 GCCP_FIFO_RESET;
    volatile Uint32 GCCP_RD_SYS_TIME;
    volatile Uint32 RSVD3;
    volatile Uint32 TRA_CTL;
    volatile Uint32 TRA_STAT;
    volatile Uint32 TRA_IN[2];
    volatile Uint32 TRA_REF[2];
    volatile Uint32 TRA_ADD[2];
    volatile Uint32 TRA_INTA;
    volatile Uint32 TRA_INTB;
    volatile Uint32 TRA_ROTA;
    volatile Uint32 TRA_ROTB;
    volatile Uint32 TRA_COH[2];
    volatile Uint32 TRA_COHC;
    volatile Uint32 TRA_AMP;
    volatile Uint32 TRA_NCOH;
    volatile Uint32 TRA_ACC;
    volatile Uint32 TRA_TPM[4];
    volatile Uint32 TRA_MTPM[5];
    volatile Uint32 RSVD4[29];
    CSL_Gccp_cfgPrtRegs PRT[24];
    volatile Uint32 RSVD5[64];
    volatile Uint32 TSM[48];
    volatile Uint32 RSVD6[16];
    volatile Uint32 PAT[3];
    volatile Uint32 RSVD7[61];
    volatile Uint32 INT_COEF[5];
    volatile Uint32 RSVD8[59];
    volatile Uint32 HCQ_CURR_LVL;
    volatile Uint32 HCQ_WTMK_LVL;
    volatile Uint32 HDQ_CURR_LVL;
    volatile Uint32 HDQ_WTMK_LVL;
    volatile Uint32 LCQ_CURR_LVL;
    volatile Uint32 LCQ_WTMK_LVL;
    volatile Uint32 LDQ_CURR_LVL;
    volatile Uint32 LDQ_WTMK_LVL;
    volatile Uint32 RSVD9[56];
    volatile Uint32 CGT[16];
    volatile Uint32 RSVD10[432];
} CSL_Gccp_cfgRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* TPM_FD_W0 */

#define CSL_GCCP_CFG_TPM_FD_W0_IB_RD_ITE_MASK (0x38000000u)
#define CSL_GCCP_CFG_TPM_FD_W0_IB_RD_ITE_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TPM_FD_W0_IB_RD_ITE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_FD_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_FD_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_SAMP_OFF_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_FD_W0_SAMP_OFF_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_FD_W0_SAMP_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_FR_OFF_MASK (0x00030000u)
#define CSL_GCCP_CFG_TPM_FD_W0_FR_OFF_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TPM_FD_W0_FR_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_SL_OFF_MASK (0x0000F000u)
#define CSL_GCCP_CFG_TPM_FD_W0_SL_OFF_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TPM_FD_W0_SL_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_CH_OFF_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TPM_FD_W0_CH_OFF_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W0_CH_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W0_RESETVAL  (0x00000000u)

/* TPM_FD_W1 */

#define CSL_GCCP_CFG_TPM_FD_W1_SYM2_FLG_MASK (0x00000400u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM2_FLG_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM2_FLG_RESETVAL (0x00000000u)

/*----SYM2_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FD_W1_SYM2_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM2_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FD_W1_SYM1_FLG_MASK (0x00000200u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM1_FLG_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM1_FLG_RESETVAL (0x00000000u)

/*----SYM1_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FD_W1_SYM1_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM1_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FD_W1_SYM0_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM0_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM0_FLG_RESETVAL (0x00000000u)

/*----SYM0_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FD_W1_SYM0_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W1_SYM0_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FD_W1_OBH_F0_MASK (0x000000C0u)
#define CSL_GCCP_CFG_TPM_FD_W1_OBH_F0_SHIFT (0x00000006u)
#define CSL_GCCP_CFG_TPM_FD_W1_OBH_F0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W1_OUT_TSK_ID_MASK (0x0000003Fu)
#define CSL_GCCP_CFG_TPM_FD_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W1_RESETVAL  (0x00000000u)

/* TPM_FD_W2 */

#define CSL_GCCP_CFG_TPM_FD_W2_OBH_F1_MASK (0xC0000000u)
#define CSL_GCCP_CFG_TPM_FD_W2_OBH_F1_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_FD_W2_OBH_F1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W2_AMP_ADJ_MASK (0x3FC00000u)
#define CSL_GCCP_CFG_TPM_FD_W2_AMP_ADJ_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_TPM_FD_W2_AMP_ADJ_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W2_PH_VALUE_MASK (0x003FF800u)
#define CSL_GCCP_CFG_TPM_FD_W2_PH_VALUE_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_FD_W2_PH_VALUE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W2_PH_INCR_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_FD_W2_PH_INCR_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W2_PH_INCR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W2_RESETVAL  (0x00000000u)

/* TPM_FD_W3 */

#define CSL_GCCP_CFG_TPM_FD_W3_OBH_F2_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_FD_W3_OBH_F2_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_FD_W3_OBH_F2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_FD_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FD_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FD_W3_RESETVAL  (0x00000000u)

/* TPM_FT_W0 */

#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_MASK (0xC0000000u)
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_RESETVAL (0x00000000u)

/*----EOL_DIST Tokens----*/
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_ONE_EIGHTH (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_ONE_QUARTER (0x00000001u)
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_ONE_HALF (0x00000002u)
#define CSL_GCCP_CFG_TPM_FT_W0_EOL_DIST_THREE_QUARTERS (0x00000003u)

#define CSL_GCCP_CFG_TPM_FT_W0_IB_RD_ITE_MASK (0x38000000u)
#define CSL_GCCP_CFG_TPM_FT_W0_IB_RD_ITE_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TPM_FT_W0_IB_RD_ITE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_FT_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_FT_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_SAMP_OFF_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_FT_W0_SAMP_OFF_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_FT_W0_SAMP_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_FR_OFF_MASK (0x00030000u)
#define CSL_GCCP_CFG_TPM_FT_W0_FR_OFF_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TPM_FT_W0_FR_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_SL_OFF_MASK (0x0000F000u)
#define CSL_GCCP_CFG_TPM_FT_W0_SL_OFF_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TPM_FT_W0_SL_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_CH_OFF_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TPM_FT_W0_CH_OFF_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W0_CH_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W0_RESETVAL  (0x00000000u)

/* TPM_FT_W1 */

#define CSL_GCCP_CFG_TPM_FT_W1_ACC_OFF_MASK (0xFFFFFE00u)
#define CSL_GCCP_CFG_TPM_FT_W1_ACC_OFF_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_TPM_FT_W1_ACC_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W1_OBD_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_FT_W1_OBD_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_FT_W1_OBD_FLG_RESETVAL (0x00000000u)

/*----OBD_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FT_W1_OBD_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W1_OBD_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FT_W1_OBH_F0_MASK (0x000000C0u)
#define CSL_GCCP_CFG_TPM_FT_W1_OBH_F0_SHIFT (0x00000006u)
#define CSL_GCCP_CFG_TPM_FT_W1_OBH_F0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W1_OUT_TSK_ID_MASK (0x0000003Fu)
#define CSL_GCCP_CFG_TPM_FT_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W1_RESETVAL  (0x00000000u)

/* TPM_FT_W2 */

#define CSL_GCCP_CFG_TPM_FT_W2_OBH_F1_MASK (0xC0000000u)
#define CSL_GCCP_CFG_TPM_FT_W2_OBH_F1_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_FT_W2_OBH_F1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W2_AMP_ADJ_MASK (0x3FC00000u)
#define CSL_GCCP_CFG_TPM_FT_W2_AMP_ADJ_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_TPM_FT_W2_AMP_ADJ_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W2_PH_VALUE_MASK (0x003FF800u)
#define CSL_GCCP_CFG_TPM_FT_W2_PH_VALUE_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_FT_W2_PH_VALUE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W2_PH_INCR_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_FT_W2_PH_INCR_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W2_PH_INCR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W2_RESETVAL  (0x00000000u)

/* TPM_FT_W3 */

#define CSL_GCCP_CFG_TPM_FT_W3_OBH_F2_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_FT_W3_OBH_F2_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_FT_W3_OBH_F2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W3_NCOH_ADD_MASK (0x007FF800u)
#define CSL_GCCP_CFG_TPM_FT_W3_NCOH_ADD_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_FT_W3_NCOH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_FT_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FT_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FT_W3_RESETVAL  (0x00000000u)

/* TPM_FPE_W0 */

#define CSL_GCCP_CFG_TPM_FPE_W0_IB_RD_ITE_MASK (0x38000000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_IB_RD_ITE_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TPM_FPE_W0_IB_RD_ITE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_FPE_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_SAMP_OFF_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_SAMP_OFF_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_FPE_W0_SAMP_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_FR_OFF_MASK (0x00030000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_FR_OFF_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TPM_FPE_W0_FR_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_SL_OFF_MASK (0x0000F000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_SL_OFF_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TPM_FPE_W0_SL_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_CH_OFF_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TPM_FPE_W0_CH_OFF_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W0_CH_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W0_RESETVAL (0x00000000u)

/* TPM_FPE_W1 */

#define CSL_GCCP_CFG_TPM_FPE_W1_SYM2_FLG_MASK (0x00000400u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM2_FLG_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM2_FLG_RESETVAL (0x00000000u)

/*----SYM2_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM2_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM2_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FPE_W1_SYM1_FLG_MASK (0x00000200u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM1_FLG_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM1_FLG_RESETVAL (0x00000000u)

/*----SYM1_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM1_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM1_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FPE_W1_SYM0_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM0_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM0_FLG_RESETVAL (0x00000000u)

/*----SYM0_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM0_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W1_SYM0_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_FPE_W1_OBH_F0_MASK (0x000000C0u)
#define CSL_GCCP_CFG_TPM_FPE_W1_OBH_F0_SHIFT (0x00000006u)
#define CSL_GCCP_CFG_TPM_FPE_W1_OBH_F0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W1_OUT_TSK_ID_MASK (0x0000003Fu)
#define CSL_GCCP_CFG_TPM_FPE_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W1_RESETVAL (0x00000000u)

/* TPM_FPE_W2 */

#define CSL_GCCP_CFG_TPM_FPE_W2_OBH_F1_MASK (0xC0000000u)
#define CSL_GCCP_CFG_TPM_FPE_W2_OBH_F1_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_FPE_W2_OBH_F1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W2_RESETVAL (0x00000000u)

/* TPM_FPE_W3 */

#define CSL_GCCP_CFG_TPM_FPE_W3_OBH_F2_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_FPE_W3_OBH_F2_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_FPE_W3_OBH_F2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_FPE_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_FPE_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_FPE_W3_RESETVAL (0x00000000u)

/* TPM_PM_W0 */

#define CSL_GCCP_CFG_TPM_PM_W0_IB_RD_ITE_MASK (0x38000000u)
#define CSL_GCCP_CFG_TPM_PM_W0_IB_RD_ITE_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TPM_PM_W0_IB_RD_ITE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_PM_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_PM_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_SAMP_MODE_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_PM_W0_SAMP_MODE_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_PM_W0_SAMP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_FR_OFF_MASK (0x00030000u)
#define CSL_GCCP_CFG_TPM_PM_W0_FR_OFF_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TPM_PM_W0_FR_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_SL_OFF_MASK (0x0000F000u)
#define CSL_GCCP_CFG_TPM_PM_W0_SL_OFF_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TPM_PM_W0_SL_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_CH_OFF_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TPM_PM_W0_CH_OFF_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W0_CH_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W0_RESETVAL  (0x00000000u)

/* TPM_PM_W1 */

#define CSL_GCCP_CFG_TPM_PM_W1_ACC_OFF_MASK (0xFFFFFE00u)
#define CSL_GCCP_CFG_TPM_PM_W1_ACC_OFF_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_TPM_PM_W1_ACC_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W1_OBD_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_PM_W1_OBD_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_PM_W1_OBD_FLG_RESETVAL (0x00000000u)

/*----OBD_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_PM_W1_OBD_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W1_OBD_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PM_W1_OUT_TSK_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TPM_PM_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W1_RESETVAL  (0x00000000u)

/* TPM_PM_W2 */

#define CSL_GCCP_CFG_TPM_PM_W2_NC_DUMP_MASK (0x80000000u)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_DUMP_SHIFT (0x0000001Fu)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_DUMP_RESETVAL (0x00000000u)

/*----NC_DUMP Tokens----*/
#define CSL_GCCP_CFG_TPM_PM_W2_NC_DUMP_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_DUMP_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PM_W2_NC_RESET_MASK (0x40000000u)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_RESET_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_RESET_RESETVAL (0x00000000u)

/*----NC_RESET Tokens----*/
#define CSL_GCCP_CFG_TPM_PM_W2_NC_RESET_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W2_NC_RESET_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PM_W2_AMP_ADJ_MASK (0x3FC00000u)
#define CSL_GCCP_CFG_TPM_PM_W2_AMP_ADJ_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_TPM_PM_W2_AMP_ADJ_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W2_PH_VALUE_MASK (0x003FF800u)
#define CSL_GCCP_CFG_TPM_PM_W2_PH_VALUE_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_PM_W2_PH_VALUE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W2_PH_INCR_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_PM_W2_PH_INCR_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W2_PH_INCR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W2_RESETVAL  (0x00000000u)

/* TPM_PM_W3 */

#define CSL_GCCP_CFG_TPM_PM_W3_OBH_F_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_PM_W3_OBH_F_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_PM_W3_OBH_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W3_NCOH_ADD_MASK (0x007FF800u)
#define CSL_GCCP_CFG_TPM_PM_W3_NCOH_ADD_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_PM_W3_NCOH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_PM_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PM_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PM_W3_RESETVAL  (0x00000000u)

/* TPM_PD_W0 */

#define CSL_GCCP_CFG_TPM_PD_W0_IB_RD_ITE_MASK (0x38000000u)
#define CSL_GCCP_CFG_TPM_PD_W0_IB_RD_ITE_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TPM_PD_W0_IB_RD_ITE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_PD_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_PD_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_SAMP_MODE_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_PD_W0_SAMP_MODE_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_PD_W0_SAMP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_FR_OFF_MASK (0x00030000u)
#define CSL_GCCP_CFG_TPM_PD_W0_FR_OFF_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TPM_PD_W0_FR_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_SL_OFF_MASK (0x0000F000u)
#define CSL_GCCP_CFG_TPM_PD_W0_SL_OFF_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TPM_PD_W0_SL_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_CH_OFF_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TPM_PD_W0_CH_OFF_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W0_CH_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W0_RESETVAL  (0x00000000u)

/* TPM_PD_W1 */

#define CSL_GCCP_CFG_TPM_PD_W1_ACC_OFF_MASK (0xFFFFFE00u)
#define CSL_GCCP_CFG_TPM_PD_W1_ACC_OFF_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_TPM_PD_W1_ACC_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W1_OBD_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_PD_W1_OBD_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_PD_W1_OBD_FLG_RESETVAL (0x00000000u)

/*----OBD_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_PD_W1_OBD_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W1_OBD_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PD_W1_OUT_TSK_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TPM_PD_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W1_RESETVAL  (0x00000000u)

/* TPM_PD_W2 */

#define CSL_GCCP_CFG_TPM_PD_W2_NC_DUMP_MASK (0x80000000u)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_DUMP_SHIFT (0x0000001Fu)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_DUMP_RESETVAL (0x00000000u)

/*----NC_DUMP Tokens----*/
#define CSL_GCCP_CFG_TPM_PD_W2_NC_DUMP_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_DUMP_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PD_W2_NC_RESET_MASK (0x40000000u)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_RESET_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_RESET_RESETVAL (0x00000000u)

/*----NC_RESET Tokens----*/
#define CSL_GCCP_CFG_TPM_PD_W2_NC_RESET_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W2_NC_RESET_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_PD_W2_AMP_ADJ_MASK (0x3FC00000u)
#define CSL_GCCP_CFG_TPM_PD_W2_AMP_ADJ_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_TPM_PD_W2_AMP_ADJ_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W2_PH_VALUE_MASK (0x003FF800u)
#define CSL_GCCP_CFG_TPM_PD_W2_PH_VALUE_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_PD_W2_PH_VALUE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W2_PH_INCR_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_PD_W2_PH_INCR_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W2_PH_INCR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W2_RESETVAL  (0x00000000u)

/* TPM_PD_W3 */

#define CSL_GCCP_CFG_TPM_PD_W3_OBH_F_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_PD_W3_OBH_F_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_PD_W3_OBH_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W3_NCOH_ADD_MASK (0x007FF800u)
#define CSL_GCCP_CFG_TPM_PD_W3_NCOH_ADD_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_PD_W3_NCOH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_PD_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_PD_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_PD_W3_RESETVAL  (0x00000000u)

/* TPM_SPE_W0 */

#define CSL_GCCP_CFG_TPM_SPE_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_SPE_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_SPE_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SPE_W0_SAMP_OFF_MASK (0x00100000u)
#define CSL_GCCP_CFG_TPM_SPE_W0_SAMP_OFF_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_TPM_SPE_W0_SAMP_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SPE_W0_RESETVAL (0x00000000u)

/* TPM_SPE_W1 */

#define CSL_GCCP_CFG_TPM_SPE_W1_OBD_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_SPE_W1_OBD_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_SPE_W1_OBD_FLG_RESETVAL (0x00000000u)

/*----OBD_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_SPE_W1_OBD_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_SPE_W1_OBD_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_SPE_W1_OUT_TSK_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TPM_SPE_W1_OUT_TSK_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_SPE_W1_OUT_TSK_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SPE_W1_RESETVAL (0x00000000u)

/* TPM_SPE_W2 */

#define CSL_GCCP_CFG_TPM_SPE_W2_RESETVAL (0x00000000u)

/* TPM_SPE_W3 */

#define CSL_GCCP_CFG_TPM_SPE_W3_OBH_F_MASK (0x7F800000u)
#define CSL_GCCP_CFG_TPM_SPE_W3_OBH_F_SHIFT (0x00000017u)
#define CSL_GCCP_CFG_TPM_SPE_W3_OBH_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SPE_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_SPE_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_SPE_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SPE_W3_RESETVAL (0x00000000u)

/* TPM_SIP_W0 */

#define CSL_GCCP_CFG_TPM_SIP_W0_STR_ID_MASK (0x07E00000u)
#define CSL_GCCP_CFG_TPM_SIP_W0_STR_ID_SHIFT (0x00000015u)
#define CSL_GCCP_CFG_TPM_SIP_W0_STR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W0_SAMP_OFF_MASK (0x001C0000u)
#define CSL_GCCP_CFG_TPM_SIP_W0_SAMP_OFF_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_TPM_SIP_W0_SAMP_OFF_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W0_RESETVAL (0x00000000u)

/* TPM_SIP_W1 */

#define CSL_GCCP_CFG_TPM_SIP_W1_OBD_FLG_MASK (0x00000100u)
#define CSL_GCCP_CFG_TPM_SIP_W1_OBD_FLG_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TPM_SIP_W1_OBD_FLG_RESETVAL (0x00000000u)

/*----OBD_FLG Tokens----*/
#define CSL_GCCP_CFG_TPM_SIP_W1_OBD_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TPM_SIP_W1_OBD_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TPM_SIP_W1_RESETVAL (0x00000000u)

/* TPM_SIP_W2 */

#define CSL_GCCP_CFG_TPM_SIP_W2_AMP_ADJ_MASK (0x3FC00000u)
#define CSL_GCCP_CFG_TPM_SIP_W2_AMP_ADJ_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_TPM_SIP_W2_AMP_ADJ_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W2_PH_VALUE_MASK (0x003FF800u)
#define CSL_GCCP_CFG_TPM_SIP_W2_PH_VALUE_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TPM_SIP_W2_PH_VALUE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W2_PH_INCR_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_SIP_W2_PH_INCR_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_SIP_W2_PH_INCR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W2_RESETVAL (0x00000000u)

/* TPM_SIP_W3 */

#define CSL_GCCP_CFG_TPM_SIP_W3_COH_ADD_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TPM_SIP_W3_COH_ADD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TPM_SIP_W3_COH_ADD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TPM_SIP_W3_RESETVAL (0x00000000u)

/* MTPM_FD_W0 */

#define CSL_GCCP_CFG_MTPM_FD_W0_PHY_CHAN_MASK (0x00040000u)
#define CSL_GCCP_CFG_MTPM_FD_W0_PHY_CHAN_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_MTPM_FD_W0_PHY_CHAN_RESETVAL (0x00000000u)

/*----PHY_CHAN Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W0_PHY_CHAN_DATA (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W0_PHY_CHAN_CTRL (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W0_SLOT_MSK_MASK (0x0003FFF8u)
#define CSL_GCCP_CFG_MTPM_FD_W0_SLOT_MSK_SHIFT (0x00000003u)
#define CSL_GCCP_CFG_MTPM_FD_W0_SLOT_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_FD_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W0_RESETVAL (0x00000000u)

/* MTPM_FD_W1 */

#define CSL_GCCP_CFG_MTPM_FD_W1_CGT_PTR_MASK (0x3C000000u)
#define CSL_GCCP_CFG_MTPM_FD_W1_CGT_PTR_SHIFT (0x0000001Au)
#define CSL_GCCP_CFG_MTPM_FD_W1_CGT_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_BYP_MASK (0x02000000u)
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_BYP_SHIFT (0x00000019u)
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_BYP_RESETVAL (0x00000000u)

/*----SCR_BYP Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_BYP_NORMAL (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_BYP_BYPASSED (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_ID_MASK (0x01FFFFFFu)
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W1_SCR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W1_RESETVAL (0x00000000u)

/* MTPM_FD_W2 */

#define CSL_GCCP_CFG_MTPM_FD_W2_BIT_MODE_MASK (0x00400000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_BIT_MODE_SHIFT (0x00000016u)
#define CSL_GCCP_CFG_MTPM_FD_W2_BIT_MODE_RESETVAL (0x00000000u)

/*----BIT_MODE Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W2_BIT_MODE_8BITS (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_BIT_MODE_16BITS (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W2_SF_MASK  (0x00380000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SHIFT (0x00000013u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_RESETVAL (0x00000000u)

/*----SF Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF256 (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF128 (0x00000001u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF64  (0x00000002u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF32  (0x00000003u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF16  (0x00000004u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF8   (0x00000005u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF4   (0x00000006u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SF_SF2   (0x00000007u)

#define CSL_GCCP_CFG_MTPM_FD_W2_PRT_ID_MASK (0x0007C000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_PRT_ID_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_FD_W2_PRT_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_FD_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FD_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_SH_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_SH_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_SH_RESETVAL (0x00000000u)

/*----SCR_SH Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_SH_NO_SC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_SH_SC_SHIFT (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_TYPE_MASK (0x00000100u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_TYPE_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_TYPE_RESETVAL (0x00000000u)

/*----SCR_TYPE Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_TYPE_SHORT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_SCR_TYPE_LONG (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W2_CH_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_MTPM_FD_W2_CH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W2_CH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W2_RESETVAL (0x00000000u)

/* MTPM_FD_W3 */

#define CSL_GCCP_CFG_MTPM_FD_W3_TSK_CNT_MASK (0x3F000000u)
#define CSL_GCCP_CFG_MTPM_FD_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_FD_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_FD_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_FD_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W3_SYM_PRIO_MASK (0x00000800u)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM_PRIO_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM_PRIO_RESETVAL (0x00000000u)

/*----SYM_PRIO Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM_PRIO_LOW (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM_PRIO_HIGH (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W3_SYM0_MSK_MASK (0x00000400u)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM0_MSK_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM0_MSK_RESETVAL (0x00000000u)

/*----SYM0_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM0_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W3_SYM0_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_FD_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W3_RESETVAL (0x00000000u)

/* MTPM_FD_W4 */

#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_MSK_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_MSK_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_MSK_RESETVAL (0x00000000u)

/*----SYM2_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_ID_MASK (0x000001E0u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_ID_SHIFT (0x00000005u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM2_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_MSK_MASK (0x00000010u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_MSK_SHIFT (0x00000004u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_MSK_RESETVAL (0x00000000u)

/*----SYM1_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_ID_MASK (0x0000000Fu)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FD_W4_SYM1_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FD_W4_RESETVAL (0x00000000u)

/* MTPM_FT_W0 */

#define CSL_GCCP_CFG_MTPM_FT_W0_PIL_MSK_MASK (0x0FFC0000u)
#define CSL_GCCP_CFG_MTPM_FT_W0_PIL_MSK_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_MTPM_FT_W0_PIL_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W0_SLOT_MSK_MASK (0x0003FFF8u)
#define CSL_GCCP_CFG_MTPM_FT_W0_SLOT_MSK_SHIFT (0x00000003u)
#define CSL_GCCP_CFG_MTPM_FT_W0_SLOT_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_FT_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W0_RESETVAL (0x00000000u)

/* MTPM_FT_W1 */

#define CSL_GCCP_CFG_MTPM_FT_W1_CGT_PTR_MASK (0x3C000000u)
#define CSL_GCCP_CFG_MTPM_FT_W1_CGT_PTR_SHIFT (0x0000001Au)
#define CSL_GCCP_CFG_MTPM_FT_W1_CGT_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_BYP_MASK (0x02000000u)
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_BYP_SHIFT (0x00000019u)
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_BYP_RESETVAL (0x00000000u)

/*----SCR_BYP Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_BYP_NORMAL (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_BYP_BYPASSED (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_ID_MASK (0x01FFFFFFu)
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W1_SCR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W1_RESETVAL (0x00000000u)

/* MTPM_FT_W2 */

#define CSL_GCCP_CFG_MTPM_FT_W2_NC_ENA_MASK (0x00100000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_NC_ENA_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_MTPM_FT_W2_NC_ENA_RESETVAL (0x00000000u)

/*----NC_ENA Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W2_NC_ENA_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_NC_ENA_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W2_STATS_FLG_MASK (0x00080000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_STATS_FLG_SHIFT (0x00000013u)
#define CSL_GCCP_CFG_MTPM_FT_W2_STATS_FLG_RESETVAL (0x00000000u)

/*----STATS_FLG Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W2_STATS_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_STATS_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W2_PRT_ID_MASK (0x0007C000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_PRT_ID_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_FT_W2_PRT_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_FT_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FT_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_SH_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_SH_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_SH_RESETVAL (0x00000000u)

/*----SCR_SH Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_SH_NO_SC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_SH_SC_SHIFT (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_TYPE_MASK (0x00000100u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_TYPE_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_TYPE_RESETVAL (0x00000000u)

/*----SCR_TYPE Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_TYPE_SHORT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_SCR_TYPE_LONG (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W2_CH_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_MTPM_FT_W2_CH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W2_CH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W2_RESETVAL (0x00000000u)

/* MTPM_FT_W3 */

#define CSL_GCCP_CFG_MTPM_FT_W3_TSK_CNT_MASK (0x3F000000u)
#define CSL_GCCP_CFG_MTPM_FT_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_FT_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_FT_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_FT_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_FT_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W3_RESETVAL (0x00000000u)

/* MTPM_FT_W4 */

#define CSL_GCCP_CFG_MTPM_FT_W4_ACC_MODE_MASK (0x00002000u)
#define CSL_GCCP_CFG_MTPM_FT_W4_ACC_MODE_SHIFT (0x0000000Du)
#define CSL_GCCP_CFG_MTPM_FT_W4_ACC_MODE_RESETVAL (0x00000000u)

/*----ACC_MODE Tokens----*/
#define CSL_GCCP_CFG_MTPM_FT_W4_ACC_MODE_SYMBOL_MODE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W4_ACC_MODE_SLOT_MODE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FT_W4_NNCA_MASK (0x00001FE0u)
#define CSL_GCCP_CFG_MTPM_FT_W4_NNCA_SHIFT (0x00000005u)
#define CSL_GCCP_CFG_MTPM_FT_W4_NNCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W4_NCA_MASK (0x0000001Fu)
#define CSL_GCCP_CFG_MTPM_FT_W4_NCA_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FT_W4_NCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FT_W4_RESETVAL (0x00000000u)

/* MTPM_FPE_W0 */

#define CSL_GCCP_CFG_MTPM_FPE_W0_SLOT_MSK_MASK (0x0003FFF8u)
#define CSL_GCCP_CFG_MTPM_FPE_W0_SLOT_MSK_SHIFT (0x00000003u)
#define CSL_GCCP_CFG_MTPM_FPE_W0_SLOT_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_FPE_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W0_RESETVAL (0x00000000u)

/* MTPM_FPE_W1 */

#define CSL_GCCP_CFG_MTPM_FPE_W1_CGT_PTR_MASK (0x3C000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W1_CGT_PTR_SHIFT (0x0000001Au)
#define CSL_GCCP_CFG_MTPM_FPE_W1_CGT_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_BYP_MASK (0x02000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_BYP_SHIFT (0x00000019u)
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_BYP_RESETVAL (0x00000000u)

/*----SCR_BYP Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_BYP_NORMAL (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_BYP_BYPASSED (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_ID_MASK (0x01FFFFFFu)
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W1_SCR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W1_RESETVAL (0x00000000u)

/* MTPM_FPE_W2 */

#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_MASK (0x00380000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SHIFT (0x00000013u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_RESETVAL (0x00000000u)

/*----SF Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF256 (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF128 (0x00000001u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF64 (0x00000002u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF32 (0x00000003u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF16 (0x00000004u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF8  (0x00000005u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF4  (0x00000006u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SF_SF2  (0x00000007u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_POW_SHIFT_MASK (0x0003C000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_POW_SHIFT_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_FPE_W2_POW_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FPE_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_SH_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_SH_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_SH_RESETVAL (0x00000000u)

/*----SCR_SH Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_SH_NO_SC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_SH_SC_SHIFT (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_TYPE_MASK (0x00000100u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_TYPE_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_TYPE_RESETVAL (0x00000000u)

/*----SCR_TYPE Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_TYPE_SHORT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_SCR_TYPE_LONG (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_CH_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_MTPM_FPE_W2_CH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W2_CH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W2_RESETVAL (0x00000000u)

/* MTPM_FPE_W3 */

#define CSL_GCCP_CFG_MTPM_FPE_W3_TSK_CNT_MASK (0x3F000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W3_FPE_PRIO_MASK (0x00000800u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_FPE_PRIO_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_MTPM_FPE_W3_FPE_PRIO_RESETVAL (0x00000000u)

/*----FPE_PRIO Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W3_FPE_PRIO_LOW (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_FPE_PRIO_HIGH (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W3_SYM0_MSK_MASK (0x00000400u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_SYM0_MSK_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FPE_W3_SYM0_MSK_RESETVAL (0x00000000u)

/*----SYM0_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W3_SYM0_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_SYM0_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_FPE_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W3_RESETVAL (0x00000000u)

/* MTPM_FPE_W4 */

#define CSL_GCCP_CFG_MTPM_FPE_W4_COH_DUR_MASK (0x00000400u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_COH_DUR_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_FPE_W4_COH_DUR_RESETVAL (0x00000000u)

/*----COH_DUR Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W4_COH_DUR_16_CHIPS (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_COH_DUR_32_CHIPS (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_MSK_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_MSK_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_MSK_RESETVAL (0x00000000u)

/*----SYM2_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_ID_MASK (0x000001E0u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_ID_SHIFT (0x00000005u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM2_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_MSK_MASK (0x00000010u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_MSK_SHIFT (0x00000004u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_MSK_RESETVAL (0x00000000u)

/*----SYM1_MSK Tokens----*/
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_MSK_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_MSK_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_ID_MASK (0x0000000Fu)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_FPE_W4_SYM1_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_FPE_W4_RESETVAL (0x00000000u)

/* MTPM_PM_W0 */

#define CSL_GCCP_CFG_MTPM_PM_W0_PIL_MSK_MASK (0x0FFC0000u)
#define CSL_GCCP_CFG_MTPM_PM_W0_PIL_MSK_SHIFT (0x00000012u)
#define CSL_GCCP_CFG_MTPM_PM_W0_PIL_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W0_SLOT_MSK_MASK (0x0003FFF8u)
#define CSL_GCCP_CFG_MTPM_PM_W0_SLOT_MSK_SHIFT (0x00000003u)
#define CSL_GCCP_CFG_MTPM_PM_W0_SLOT_MSK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_PM_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W0_RESETVAL (0x00000000u)

/* MTPM_PM_W1 */

#define CSL_GCCP_CFG_MTPM_PM_W1_CGT_PTR_MASK (0x3C000000u)
#define CSL_GCCP_CFG_MTPM_PM_W1_CGT_PTR_SHIFT (0x0000001Au)
#define CSL_GCCP_CFG_MTPM_PM_W1_CGT_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_BYP_MASK (0x02000000u)
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_BYP_SHIFT (0x00000019u)
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_BYP_RESETVAL (0x00000000u)

/*----SCR_BYP Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_BYP_NORMAL (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_BYP_BYPASSED (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_ID_MASK (0x01FFFFFFu)
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W1_SCR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W1_RESETVAL (0x00000000u)

/* MTPM_PM_W2 */

#define CSL_GCCP_CFG_MTPM_PM_W2_NC_ENA_MASK (0x00100000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_NC_ENA_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_MTPM_PM_W2_NC_ENA_RESETVAL (0x00000000u)

/*----NC_ENA Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W2_NC_ENA_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_NC_ENA_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W2_STATS_FLG_MASK (0x00080000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_STATS_FLG_SHIFT (0x00000013u)
#define CSL_GCCP_CFG_MTPM_PM_W2_STATS_FLG_RESETVAL (0x00000000u)

/*----STATS_FLG Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W2_STATS_FLG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_STATS_FLG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W2_PRT_ID_MASK (0x0007C000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_PRT_ID_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_PM_W2_PRT_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_PM_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_PM_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_SH_MASK (0x00000200u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_SH_SHIFT (0x00000009u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_SH_RESETVAL (0x00000000u)

/*----SCR_SH Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_SH_NO_SC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_SH_SC_SHIFT (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_TYPE_MASK (0x00000100u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_TYPE_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_TYPE_RESETVAL (0x00000000u)

/*----SCR_TYPE Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_TYPE_SHORT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_SCR_TYPE_LONG (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W2_CH_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_MTPM_PM_W2_CH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W2_CH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W2_RESETVAL (0x00000000u)

/* MTPM_PM_W3 */

#define CSL_GCCP_CFG_MTPM_PM_W3_TSK_CNT_MASK (0xFF000000u)
#define CSL_GCCP_CFG_MTPM_PM_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_PM_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_PM_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_PM_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_PM_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W3_RESETVAL (0x00000000u)

/* MTPM_PM_W4 */

#define CSL_GCCP_CFG_MTPM_PM_W4_DA_MASK  (0x00FFC000u)
#define CSL_GCCP_CFG_MTPM_PM_W4_DA_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_PM_W4_DA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W4_ACC_MODE_MASK (0x00002000u)
#define CSL_GCCP_CFG_MTPM_PM_W4_ACC_MODE_SHIFT (0x0000000Du)
#define CSL_GCCP_CFG_MTPM_PM_W4_ACC_MODE_RESETVAL (0x00000000u)

/*----ACC_MODE Tokens----*/
#define CSL_GCCP_CFG_MTPM_PM_W4_ACC_MODE_SYMBOL_MODE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W4_ACC_MODE_SLOT_MODE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PM_W4_NNCA_MASK (0x00001FE0u)
#define CSL_GCCP_CFG_MTPM_PM_W4_NNCA_SHIFT (0x00000005u)
#define CSL_GCCP_CFG_MTPM_PM_W4_NNCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W4_NCA_MASK (0x0000001Fu)
#define CSL_GCCP_CFG_MTPM_PM_W4_NCA_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PM_W4_NCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PM_W4_RESETVAL (0x00000000u)

/* MTPM_PD_W0 */

#define CSL_GCCP_CFG_MTPM_PD_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_PD_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W0_RESETVAL (0x00000000u)

/* MTPM_PD_W1 */

#define CSL_GCCP_CFG_MTPM_PD_W1_CGT_PTR_MASK (0x3C000000u)
#define CSL_GCCP_CFG_MTPM_PD_W1_CGT_PTR_SHIFT (0x0000001Au)
#define CSL_GCCP_CFG_MTPM_PD_W1_CGT_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_BYP_MASK (0x02000000u)
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_BYP_SHIFT (0x00000019u)
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_BYP_RESETVAL (0x00000000u)

/*----SCR_BYP Tokens----*/
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_BYP_NORMAL (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_BYP_BYPASSED (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_ID_MASK (0x01FFFFFFu)
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W1_SCR_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W1_RESETVAL (0x00000000u)

/* MTPM_PD_W2 */

#define CSL_GCCP_CFG_MTPM_PD_W2_NC_ENA_MASK (0x00100000u)
#define CSL_GCCP_CFG_MTPM_PD_W2_NC_ENA_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_MTPM_PD_W2_NC_ENA_RESETVAL (0x00000000u)

/*----NC_ENA Tokens----*/
#define CSL_GCCP_CFG_MTPM_PD_W2_NC_ENA_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W2_NC_ENA_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_MTPM_PD_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_PD_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_PD_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W2_SIG_ID_MASK (0x000000FFu)
#define CSL_GCCP_CFG_MTPM_PD_W2_SIG_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W2_SIG_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W2_RESETVAL (0x00000000u)

/* MTPM_PD_W3 */

#define CSL_GCCP_CFG_MTPM_PD_W3_TSK_CNT_MASK (0xFF000000u)
#define CSL_GCCP_CFG_MTPM_PD_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_PD_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_PD_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_PD_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_PD_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W3_RESETVAL (0x00000000u)

/* MTPM_PD_W4 */

#define CSL_GCCP_CFG_MTPM_PD_W4_NNCA_MASK (0x00001FE0u)
#define CSL_GCCP_CFG_MTPM_PD_W4_NNCA_SHIFT (0x00000005u)
#define CSL_GCCP_CFG_MTPM_PD_W4_NNCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W4_NCA_MASK (0x0000001Fu)
#define CSL_GCCP_CFG_MTPM_PD_W4_NCA_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_PD_W4_NCA_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_PD_W4_RESETVAL (0x00000000u)

/* MTPM_SPE_W0 */

#define CSL_GCCP_CFG_MTPM_SPE_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_SPE_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_SPE_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W0_RESETVAL (0x00000000u)

/* MTPM_SPE_W1 */

#define CSL_GCCP_CFG_MTPM_SPE_W1_RESETVAL (0x00000000u)

/* MTPM_SPE_W2 */

#define CSL_GCCP_CFG_MTPM_SPE_W2_POW_SHIFT_MASK (0x0003C000u)
#define CSL_GCCP_CFG_MTPM_SPE_W2_POW_SHIFT_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_MTPM_SPE_W2_POW_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W2_ACC_SHIFT_MASK (0x00003C00u)
#define CSL_GCCP_CFG_MTPM_SPE_W2_ACC_SHIFT_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_MTPM_SPE_W2_ACC_SHIFT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W2_RESETVAL (0x00000000u)

/* MTPM_SPE_W3 */

#define CSL_GCCP_CFG_MTPM_SPE_W3_TSK_CNT_MASK (0xFF000000u)
#define CSL_GCCP_CFG_MTPM_SPE_W3_TSK_CNT_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_MTPM_SPE_W3_TSK_CNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_SPE_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_SPE_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_SPE_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_SPE_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SPE_W3_RESETVAL (0x00000000u)

/* MTPM_SPE_W4 */

#define CSL_GCCP_CFG_MTPM_SPE_W4_RESETVAL (0x00000000u)

/* MTPM_SIP_W0 */

#define CSL_GCCP_CFG_MTPM_SIP_W0_GCCP_MODE_MASK (0x00000007u)
#define CSL_GCCP_CFG_MTPM_SIP_W0_GCCP_MODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_SIP_W0_GCCP_MODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SIP_W0_RESETVAL (0x00000000u)

/* MTPM_SIP_W1 */

#define CSL_GCCP_CFG_MTPM_SIP_W1_RESETVAL (0x00000000u)

/* MTPM_SIP_W2 */

#define CSL_GCCP_CFG_MTPM_SIP_W2_RESETVAL (0x00000000u)

/* MTPM_SIP_W3 */

#define CSL_GCCP_CFG_MTPM_SIP_W3_OBD_F_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_MTPM_SIP_W3_OBD_F_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_MTPM_SIP_W3_OBD_F_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SIP_W3_OCH_ID_MASK (0x000003FFu)
#define CSL_GCCP_CFG_MTPM_SIP_W3_OCH_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_MTPM_SIP_W3_OCH_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_MTPM_SIP_W3_RESETVAL (0x00000000u)

/* MTPM_SIP_W4 */

#define CSL_GCCP_CFG_MTPM_SIP_W4_RESETVAL (0x00000000u)

/* TAM */

#define CSL_GCCP_CFG_TAM_CAN_MASK        (0x0FC00000u)
#define CSL_GCCP_CFG_TAM_CAN_SHIFT       (0x00000016u)
#define CSL_GCCP_CFG_TAM_CAN_RESETVAL    (0x00000000u)

#define CSL_GCCP_CFG_TAM_MTPM_PTR_MASK   (0x003FF000u)
#define CSL_GCCP_CFG_TAM_MTPM_PTR_SHIFT  (0x0000000Cu)
#define CSL_GCCP_CFG_TAM_MTPM_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TAM_TPM_PTR_MASK    (0x00000FFFu)
#define CSL_GCCP_CFG_TAM_TPM_PTR_SHIFT   (0x00000000u)
#define CSL_GCCP_CFG_TAM_TPM_PTR_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TAM_RESETVAL        (0x00000000u)

/* TRM_W0 */

#define CSL_GCCP_CFG_TRM_W0_RESET_ENA2_MASK (0x20000000u)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA2_SHIFT (0x0000001Du)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA2_RESETVAL (0x00000000u)

/*----RESET_ENA2 Tokens----*/
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA2_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA2_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_MASK (0x18000000u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_SHIFT (0x0000001Bu)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_RESETVAL (0x00000000u)

/*----REQ_ID2 Tokens----*/
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_GOTO_0 (0x00000000u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_GOTO_A (0x00000001u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_GOTO_2 (0x00000002u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID2_GOTO_B (0x00000003u)

#define CSL_GCCP_CFG_TRM_W0_ITE_ID2_P1_MASK (0x07FF0000u)
#define CSL_GCCP_CFG_TRM_W0_ITE_ID2_P1_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRM_W0_ITE_ID2_P1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W0_RESET_ENA1_MASK (0x00002000u)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA1_SHIFT (0x0000000Du)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA1_RESETVAL (0x00000000u)

/*----RESET_ENA1 Tokens----*/
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA1_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TRM_W0_RESET_ENA1_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_MASK (0x00001800u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_RESETVAL (0x00000000u)

/*----REQ_ID1 Tokens----*/
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_GOTO_0 (0x00000000u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_GOTO_A (0x00000001u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_GOTO_2 (0x00000002u)
#define CSL_GCCP_CFG_TRM_W0_REQ_ID1_GOTO_B (0x00000003u)

#define CSL_GCCP_CFG_TRM_W0_ITE_ID1_P1_MASK (0x000007FFu)
#define CSL_GCCP_CFG_TRM_W0_ITE_ID1_P1_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRM_W0_ITE_ID1_P1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W0_RESETVAL     (0x00000000u)

/* TRM_W1 */

#define CSL_GCCP_CFG_TRM_W1_RESERVED_MASK (0x0FFFC000u)
#define CSL_GCCP_CFG_TRM_W1_RESERVED_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_TRM_W1_RESERVED_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W1_ITE_ID2_P2_MASK (0x00002000u)
#define CSL_GCCP_CFG_TRM_W1_ITE_ID2_P2_SHIFT (0x0000000Du)
#define CSL_GCCP_CFG_TRM_W1_ITE_ID2_P2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W1_ITE_ID1_P2_MASK (0x00001000u)
#define CSL_GCCP_CFG_TRM_W1_ITE_ID1_P2_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TRM_W1_ITE_ID1_P2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W1_FRAME_ID_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_TRM_W1_FRAME_ID_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRM_W1_FRAME_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRM_W1_RESETVAL     (0x00000000u)

/* GCCP_SEQ_ENA */

#define CSL_GCCP_CFG_GCCP_SEQ_ENA_ENABLE_MASK (0x00000001u)
#define CSL_GCCP_CFG_GCCP_SEQ_ENA_ENABLE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_SEQ_ENA_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_GCCP_CFG_GCCP_SEQ_ENA_ENABLE_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_GCCP_SEQ_ENA_ENABLE_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_GCCP_SEQ_ENA_RESETVAL (0x00000000u)

/* GCCP_SEQ_ACT */

#define CSL_GCCP_CFG_GCCP_SEQ_ACT_ACT_COUNT_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_GCCP_SEQ_ACT_ACT_COUNT_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_SEQ_ACT_ACT_COUNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_SEQ_ACT_RESETVAL (0x00000000u)

/* GCCP_SEQ_CYC */

#define CSL_GCCP_CFG_GCCP_SEQ_CYC_SEQ_COUNT_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_GCCP_SEQ_CYC_SEQ_COUNT_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_SEQ_CYC_SEQ_COUNT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_SEQ_CYC_RESETVAL (0x00000000u)

/* GCCP_CYC_OVER */

#define CSL_GCCP_CFG_GCCP_CYC_OVER_ITE_NB_MASK (0x007FF000u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_ITE_NB_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_ITE_NB_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_CYC_OVER_CYC_OVER_FLG_MASK (0x00000800u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_CYC_OVER_FLG_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_CYC_OVER_FLG_RESETVAL (0x00000000u)

/*----CYC_OVER_FLG Tokens----*/
#define CSL_GCCP_CFG_GCCP_CYC_OVER_CYC_OVER_FLG_NO_ERROR (0x00000000u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_CYC_OVER_FLG_ERROR_OCCURED (0x00000001u)

#define CSL_GCCP_CFG_GCCP_CYC_OVER_PAGE_IDX_MASK (0x000007F0u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_PAGE_IDX_SHIFT (0x00000004u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_PAGE_IDX_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_CYC_OVER_TASK_IDX_MASK (0x0000000Fu)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_TASK_IDX_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_CYC_OVER_TASK_IDX_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_CYC_OVER_RESETVAL (0x00000000u)

/* GCCP_FIFO_OVER */

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_ITE_NB_MASK (0x01FFC000u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_ITE_NB_SHIFT (0x0000000Eu)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_ITE_NB_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_MASK (0x00003000u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_RESETVAL (0x00000000u)

/*----FIFO_ID Tokens----*/
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_HIGH_DATA (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_HIGH_CTRL (0x00000001u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_LOW_DATA (0x00000002u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_FIFO_ID_LOW_CTRL (0x00000003u)

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_CYC_OVER_FLG_MASK (0x00000800u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_CYC_OVER_FLG_SHIFT (0x0000000Bu)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_CYC_OVER_FLG_RESETVAL (0x00000000u)

/*----CYC_OVER_FLG Tokens----*/
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_CYC_OVER_FLG_NO_ERROR (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_CYC_OVER_FLG_ERROR_OCCURED (0x00000001u)

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_PAGE_IDX_MASK (0x000007F0u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_PAGE_IDX_SHIFT (0x00000004u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_PAGE_IDX_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_TASK_IDX_MASK (0x0000000Fu)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_TASK_IDX_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_OVER_TASK_IDX_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_GCCP_FIFO_OVER_RESETVAL (0x00000000u)

/* GCCP_FIFO_RESET */

#define CSL_GCCP_CFG_GCCP_FIFO_RESET_LOW_RESET_MASK (0x00000002u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_LOW_RESET_SHIFT (0x00000001u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_LOW_RESET_RESETVAL (0x00000000u)

/*----LOW_RESET Tokens----*/
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_LOW_RESET_NO_RESET (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_LOW_RESET_RESET (0x00000001u)

#define CSL_GCCP_CFG_GCCP_FIFO_RESET_HIGH_RESET_MASK (0x00000001u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_HIGH_RESET_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_HIGH_RESET_RESETVAL (0x00000000u)

/*----HIGH_RESET Tokens----*/
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_HIGH_RESET_NO_RESET (0x00000000u)
#define CSL_GCCP_CFG_GCCP_FIFO_RESET_HIGH_RESET_RESET (0x00000001u)

#define CSL_GCCP_CFG_GCCP_FIFO_RESET_RESETVAL (0x00000000u)

/* TRA_CTL */

#define CSL_GCCP_CFG_TRA_CTL_DEVENT_FLAG_MASK (0x40000000u)
#define CSL_GCCP_CFG_TRA_CTL_DEVENT_FLAG_SHIFT (0x0000001Eu)
#define CSL_GCCP_CFG_TRA_CTL_DEVENT_FLAG_RESETVAL (0x00000000u)

/*----DEVENT_FLAG Tokens----*/
#define CSL_GCCP_CFG_TRA_CTL_DEVENT_FLAG_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TRA_CTL_DEVENT_FLAG_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TRA_CTL_CYCLE_ID_MASK (0x3F000000u)
#define CSL_GCCP_CFG_TRA_CTL_CYCLE_ID_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_TRA_CTL_CYCLE_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_CTL_REQ_ID_MASK (0x00FFE000u)
#define CSL_GCCP_CFG_TRA_CTL_REQ_ID_SHIFT (0x0000000Du)
#define CSL_GCCP_CFG_TRA_CTL_REQ_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_CTL_ITE_ID_MASK (0x00001FFCu)
#define CSL_GCCP_CFG_TRA_CTL_ITE_ID_SHIFT (0x00000002u)
#define CSL_GCCP_CFG_TRA_CTL_ITE_ID_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_CTL_TRA_MODE_MASK (0x00000002u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_MODE_SHIFT (0x00000001u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_MODE_RESETVAL (0x00000000u)

/*----TRA_MODE Tokens----*/
#define CSL_GCCP_CFG_TRA_CTL_TRA_MODE_CONTINUOUS (0x00000000u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_MODE_DATED (0x00000001u)

#define CSL_GCCP_CFG_TRA_CTL_TRA_ENA_MASK (0x00000001u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_ENA_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_ENA_RESETVAL (0x00000000u)

/*----TRA_ENA Tokens----*/
#define CSL_GCCP_CFG_TRA_CTL_TRA_ENA_DISABLE (0x00000000u)
#define CSL_GCCP_CFG_TRA_CTL_TRA_ENA_ENABLE (0x00000001u)

#define CSL_GCCP_CFG_TRA_CTL_RESETVAL    (0x00000000u)

/* TRA_STAT */

#define CSL_GCCP_CFG_TRA_STAT_LOCAL_TIME_MASK (0x007FF000u)
#define CSL_GCCP_CFG_TRA_STAT_LOCAL_TIME_SHIFT (0x0000000Cu)
#define CSL_GCCP_CFG_TRA_STAT_LOCAL_TIME_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_STAT_SYS_TIME_MASK (0x00000FFEu)
#define CSL_GCCP_CFG_TRA_STAT_SYS_TIME_SHIFT (0x00000001u)
#define CSL_GCCP_CFG_TRA_STAT_SYS_TIME_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_STAT_TASK_STATUS_MASK (0x00000001u)
#define CSL_GCCP_CFG_TRA_STAT_TASK_STATUS_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_STAT_TASK_STATUS_RESETVAL (0x00000000u)

/*----TASK_STATUS Tokens----*/
#define CSL_GCCP_CFG_TRA_STAT_TASK_STATUS_INACTIVE (0x00000000u)
#define CSL_GCCP_CFG_TRA_STAT_TASK_STATUS_ACTIVE (0x00000001u)

#define CSL_GCCP_CFG_TRA_STAT_RESETVAL   (0x00000000u)

/* TRA_IN */

#define CSL_GCCP_CFG_TRA_IN_SAMP1_Q_MASK (0xFF000000u)
#define CSL_GCCP_CFG_TRA_IN_SAMP1_Q_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_TRA_IN_SAMP1_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_IN_SAMP1_I_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_TRA_IN_SAMP1_I_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_IN_SAMP1_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_IN_SAMP0_Q_MASK (0x0000FF00u)
#define CSL_GCCP_CFG_TRA_IN_SAMP0_Q_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TRA_IN_SAMP0_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_IN_SAMP0_I_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TRA_IN_SAMP0_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_IN_SAMP0_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_IN_RESETVAL     (0x00000000u)

/* TRA_REF */

#define CSL_GCCP_CFG_TRA_REF_REF_CODE_MASK (0xFFFFFFFFu)
#define CSL_GCCP_CFG_TRA_REF_REF_CODE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_REF_REF_CODE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_REF_RESETVAL    (0x00000000u)

/* TRA_ADD */

#define CSL_GCCP_CFG_TRA_ADD_CORR_Q_MASK (0xFFFF0000u)
#define CSL_GCCP_CFG_TRA_ADD_CORR_Q_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_ADD_CORR_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ADD_CORR_I_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_ADD_CORR_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_ADD_CORR_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ADD_RESETVAL    (0x00000000u)

/* TRA_INTA */

#define CSL_GCCP_CFG_TRA_INTA_COEFF3_MASK (0xFF000000u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF3_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF3_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTA_COEFF2_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF2_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTA_COEFF1_MASK (0x0000FF00u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF1_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTA_COEFF0_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TRA_INTA_COEFF0_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_INTA_COEFF0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTA_RESETVAL   (0x00000000u)

/* TRA_INTB */

#define CSL_GCCP_CFG_TRA_INTB_INT_Q_MASK (0xFFFF0000u)
#define CSL_GCCP_CFG_TRA_INTB_INT_Q_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_INTB_INT_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTB_INT_I_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_INTB_INT_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_INTB_INT_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_INTB_RESETVAL   (0x00000000u)

/* TRA_ROTA */

#define CSL_GCCP_CFG_TRA_ROTA_PHAS_Q_MASK (0x0000FF00u)
#define CSL_GCCP_CFG_TRA_ROTA_PHAS_Q_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_TRA_ROTA_PHAS_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ROTA_PHAS_I_MASK (0x000000FFu)
#define CSL_GCCP_CFG_TRA_ROTA_PHAS_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_ROTA_PHAS_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ROTA_RESETVAL   (0x00000000u)

/* TRA_ROTB */

#define CSL_GCCP_CFG_TRA_ROTB_ROT_Q_MASK (0xFFFF0000u)
#define CSL_GCCP_CFG_TRA_ROTB_ROT_Q_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_ROTB_ROT_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ROTB_ROT_I_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_ROTB_ROT_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_ROTB_ROT_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ROTB_RESETVAL   (0x00000000u)

/* TRA_COH */

#define CSL_GCCP_CFG_TRA_COH_COH_ACC_MASK (0xFFFFFFFFu)
#define CSL_GCCP_CFG_TRA_COH_COH_ACC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_COH_COH_ACC_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_COH_RESETVAL    (0x00000000u)

/* TRA_COHC */

#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_Q_MASK (0xFFFF0000u)
#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_Q_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_Q_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_I_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_I_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_COHC_COH_OUT_I_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_COHC_RESETVAL   (0x00000000u)

/* TRA_AMP */

#define CSL_GCCP_CFG_TRA_AMP_AMPLITUDE_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_AMP_AMPLITUDE_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_AMP_AMPLITUDE_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_AMP_RESETVAL    (0x00000000u)

/* TRA_NCOH */

#define CSL_GCCP_CFG_TRA_NCOH_NCOH_ACC_MASK (0x0000FFFFu)
#define CSL_GCCP_CFG_TRA_NCOH_NCOH_ACC_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_NCOH_NCOH_ACC_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_NCOH_RESETVAL   (0x00000000u)

/* TRA_ACC */

#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_MASK (0x00000380u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_SHIFT (0x00000007u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_RESETVAL (0x00000000u)

/*----NCOH_ACC_STAT Tokens----*/
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_NO_ACC (0x00000000u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_RESET_ONLY (0x00000001u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_RESET_ACC (0x00000002u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_ACC (0x00000003u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_DUMP_ONLY (0x00000004u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_DUMP_ACC (0x00000005u)
#define CSL_GCCP_CFG_TRA_ACC_NCOH_ACC_STAT_BYPASSED (0x00000006u)

#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_MASK (0x00000070u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_SHIFT (0x00000004u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_RESETVAL (0x00000000u)

/*----COH_ACC_STAT Tokens----*/
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_NO_ACC (0x00000000u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_RESET_ONLY (0x00000001u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_RESET_ACC (0x00000002u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_ACC (0x00000003u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_DUMP_ONLY (0x00000004u)
#define CSL_GCCP_CFG_TRA_ACC_COH_ACC_STAT_DUMP_ACC (0x00000005u)

#define CSL_GCCP_CFG_TRA_ACC_ROT_STAT_MASK (0x00000008u)
#define CSL_GCCP_CFG_TRA_ACC_ROT_STAT_SHIFT (0x00000003u)
#define CSL_GCCP_CFG_TRA_ACC_ROT_STAT_RESETVAL (0x00000000u)

/*----ROT_STAT Tokens----*/
#define CSL_GCCP_CFG_TRA_ACC_ROT_STAT_BYPASSED (0x00000000u)
#define CSL_GCCP_CFG_TRA_ACC_ROT_STAT_NORMAL (0x00000001u)

#define CSL_GCCP_CFG_TRA_ACC_INT_STAT_MASK (0x00000007u)
#define CSL_GCCP_CFG_TRA_ACC_INT_STAT_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_ACC_INT_STAT_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_ACC_RESETVAL    (0x00000000u)

/* TRA_TPM */

#define CSL_GCCP_CFG_TRA_TPM_WORD_MASK   (0xFFFFFFFFu)
#define CSL_GCCP_CFG_TRA_TPM_WORD_SHIFT  (0x00000000u)
#define CSL_GCCP_CFG_TRA_TPM_WORD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_TPM_RESETVAL    (0x00000000u)

/* TRA_MTPM */

#define CSL_GCCP_CFG_TRA_MTPM_WORD_MASK  (0xFFFFFFFFu)
#define CSL_GCCP_CFG_TRA_MTPM_WORD_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_TRA_MTPM_WORD_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_TRA_MTPM_RESETVAL   (0x00000000u)

/* PRT_W0 */

#define CSL_GCCP_CFG_PRT_W0_SLOT2_MASK   (0x3FF00000u)
#define CSL_GCCP_CFG_PRT_W0_SLOT2_SHIFT  (0x00000014u)
#define CSL_GCCP_CFG_PRT_W0_SLOT2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W0_SLOT1_MASK   (0x000FFC00u)
#define CSL_GCCP_CFG_PRT_W0_SLOT1_SHIFT  (0x0000000Au)
#define CSL_GCCP_CFG_PRT_W0_SLOT1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W0_SLOT0_MASK   (0x000003FFu)
#define CSL_GCCP_CFG_PRT_W0_SLOT0_SHIFT  (0x00000000u)
#define CSL_GCCP_CFG_PRT_W0_SLOT0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W0_RESETVAL     (0x00000000u)

/* PRT_W1 */

#define CSL_GCCP_CFG_PRT_W1_SLOT5_MASK   (0x3FF00000u)
#define CSL_GCCP_CFG_PRT_W1_SLOT5_SHIFT  (0x00000014u)
#define CSL_GCCP_CFG_PRT_W1_SLOT5_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W1_SLOT4_MASK   (0x000FFC00u)
#define CSL_GCCP_CFG_PRT_W1_SLOT4_SHIFT  (0x0000000Au)
#define CSL_GCCP_CFG_PRT_W1_SLOT4_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W1_SLOT3_MASK   (0x000003FFu)
#define CSL_GCCP_CFG_PRT_W1_SLOT3_SHIFT  (0x00000000u)
#define CSL_GCCP_CFG_PRT_W1_SLOT3_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W1_RESETVAL     (0x00000000u)

/* PRT_W2 */

#define CSL_GCCP_CFG_PRT_W2_SLOT8_MASK   (0x3FF00000u)
#define CSL_GCCP_CFG_PRT_W2_SLOT8_SHIFT  (0x00000014u)
#define CSL_GCCP_CFG_PRT_W2_SLOT8_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W2_SLOT7_MASK   (0x000FFC00u)
#define CSL_GCCP_CFG_PRT_W2_SLOT7_SHIFT  (0x0000000Au)
#define CSL_GCCP_CFG_PRT_W2_SLOT7_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W2_SLOT6_MASK   (0x000003FFu)
#define CSL_GCCP_CFG_PRT_W2_SLOT6_SHIFT  (0x00000000u)
#define CSL_GCCP_CFG_PRT_W2_SLOT6_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W2_RESETVAL     (0x00000000u)

/* PRT_W3 */

#define CSL_GCCP_CFG_PRT_W3_SLOT11_MASK  (0x3FF00000u)
#define CSL_GCCP_CFG_PRT_W3_SLOT11_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_PRT_W3_SLOT11_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W3_SLOT10_MASK  (0x000FFC00u)
#define CSL_GCCP_CFG_PRT_W3_SLOT10_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_PRT_W3_SLOT10_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W3_SLOT9_MASK   (0x000003FFu)
#define CSL_GCCP_CFG_PRT_W3_SLOT9_SHIFT  (0x00000000u)
#define CSL_GCCP_CFG_PRT_W3_SLOT9_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W3_RESETVAL     (0x00000000u)

/* PRT_W4 */

#define CSL_GCCP_CFG_PRT_W4_SLOT14_MASK  (0x3FF00000u)
#define CSL_GCCP_CFG_PRT_W4_SLOT14_SHIFT (0x00000014u)
#define CSL_GCCP_CFG_PRT_W4_SLOT14_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W4_SLOT13_MASK  (0x000FFC00u)
#define CSL_GCCP_CFG_PRT_W4_SLOT13_SHIFT (0x0000000Au)
#define CSL_GCCP_CFG_PRT_W4_SLOT13_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W4_SLOT12_MASK  (0x000003FFu)
#define CSL_GCCP_CFG_PRT_W4_SLOT12_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_PRT_W4_SLOT12_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PRT_W4_RESETVAL     (0x00000000u)

/* TSM */

#define CSL_GCCP_CFG_TSM_TS_31_MASK      (0x80000000u)
#define CSL_GCCP_CFG_TSM_TS_31_SHIFT     (0x0000001Fu)
#define CSL_GCCP_CFG_TSM_TS_31_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_30_MASK      (0x40000000u)
#define CSL_GCCP_CFG_TSM_TS_30_SHIFT     (0x0000001Eu)
#define CSL_GCCP_CFG_TSM_TS_30_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_29_MASK      (0x20000000u)
#define CSL_GCCP_CFG_TSM_TS_29_SHIFT     (0x0000001Du)
#define CSL_GCCP_CFG_TSM_TS_29_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_28_MASK      (0x10000000u)
#define CSL_GCCP_CFG_TSM_TS_28_SHIFT     (0x0000001Cu)
#define CSL_GCCP_CFG_TSM_TS_28_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_27_MASK      (0x08000000u)
#define CSL_GCCP_CFG_TSM_TS_27_SHIFT     (0x0000001Bu)
#define CSL_GCCP_CFG_TSM_TS_27_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_26_MASK      (0x04000000u)
#define CSL_GCCP_CFG_TSM_TS_26_SHIFT     (0x0000001Au)
#define CSL_GCCP_CFG_TSM_TS_26_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_25_MASK      (0x02000000u)
#define CSL_GCCP_CFG_TSM_TS_25_SHIFT     (0x00000019u)
#define CSL_GCCP_CFG_TSM_TS_25_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_24_MASK      (0x01000000u)
#define CSL_GCCP_CFG_TSM_TS_24_SHIFT     (0x00000018u)
#define CSL_GCCP_CFG_TSM_TS_24_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_23_MASK      (0x00800000u)
#define CSL_GCCP_CFG_TSM_TS_23_SHIFT     (0x00000017u)
#define CSL_GCCP_CFG_TSM_TS_23_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_22_MASK      (0x00400000u)
#define CSL_GCCP_CFG_TSM_TS_22_SHIFT     (0x00000016u)
#define CSL_GCCP_CFG_TSM_TS_22_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_21_MASK      (0x00200000u)
#define CSL_GCCP_CFG_TSM_TS_21_SHIFT     (0x00000015u)
#define CSL_GCCP_CFG_TSM_TS_21_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_20_MASK      (0x00100000u)
#define CSL_GCCP_CFG_TSM_TS_20_SHIFT     (0x00000014u)
#define CSL_GCCP_CFG_TSM_TS_20_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_19_MASK      (0x00080000u)
#define CSL_GCCP_CFG_TSM_TS_19_SHIFT     (0x00000013u)
#define CSL_GCCP_CFG_TSM_TS_19_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_18_MASK      (0x00040000u)
#define CSL_GCCP_CFG_TSM_TS_18_SHIFT     (0x00000012u)
#define CSL_GCCP_CFG_TSM_TS_18_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_17_MASK      (0x00020000u)
#define CSL_GCCP_CFG_TSM_TS_17_SHIFT     (0x00000011u)
#define CSL_GCCP_CFG_TSM_TS_17_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_16_MASK      (0x00010000u)
#define CSL_GCCP_CFG_TSM_TS_16_SHIFT     (0x00000010u)
#define CSL_GCCP_CFG_TSM_TS_16_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_15_MASK      (0x00008000u)
#define CSL_GCCP_CFG_TSM_TS_15_SHIFT     (0x0000000Fu)
#define CSL_GCCP_CFG_TSM_TS_15_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_14_MASK      (0x00004000u)
#define CSL_GCCP_CFG_TSM_TS_14_SHIFT     (0x0000000Eu)
#define CSL_GCCP_CFG_TSM_TS_14_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_13_MASK      (0x00002000u)
#define CSL_GCCP_CFG_TSM_TS_13_SHIFT     (0x0000000Du)
#define CSL_GCCP_CFG_TSM_TS_13_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_12_MASK      (0x00001000u)
#define CSL_GCCP_CFG_TSM_TS_12_SHIFT     (0x0000000Cu)
#define CSL_GCCP_CFG_TSM_TS_12_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_11_MASK      (0x00000800u)
#define CSL_GCCP_CFG_TSM_TS_11_SHIFT     (0x0000000Bu)
#define CSL_GCCP_CFG_TSM_TS_11_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_10_MASK      (0x00000400u)
#define CSL_GCCP_CFG_TSM_TS_10_SHIFT     (0x0000000Au)
#define CSL_GCCP_CFG_TSM_TS_10_RESETVAL  (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_9_MASK       (0x00000200u)
#define CSL_GCCP_CFG_TSM_TS_9_SHIFT      (0x00000009u)
#define CSL_GCCP_CFG_TSM_TS_9_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_8_MASK       (0x00000100u)
#define CSL_GCCP_CFG_TSM_TS_8_SHIFT      (0x00000008u)
#define CSL_GCCP_CFG_TSM_TS_8_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_7_MASK       (0x00000080u)
#define CSL_GCCP_CFG_TSM_TS_7_SHIFT      (0x00000007u)
#define CSL_GCCP_CFG_TSM_TS_7_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_6_MASK       (0x00000040u)
#define CSL_GCCP_CFG_TSM_TS_6_SHIFT      (0x00000006u)
#define CSL_GCCP_CFG_TSM_TS_6_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_5_MASK       (0x00000020u)
#define CSL_GCCP_CFG_TSM_TS_5_SHIFT      (0x00000005u)
#define CSL_GCCP_CFG_TSM_TS_5_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_4_MASK       (0x00000010u)
#define CSL_GCCP_CFG_TSM_TS_4_SHIFT      (0x00000004u)
#define CSL_GCCP_CFG_TSM_TS_4_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_3_MASK       (0x00000008u)
#define CSL_GCCP_CFG_TSM_TS_3_SHIFT      (0x00000003u)
#define CSL_GCCP_CFG_TSM_TS_3_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_2_MASK       (0x00000004u)
#define CSL_GCCP_CFG_TSM_TS_2_SHIFT      (0x00000002u)
#define CSL_GCCP_CFG_TSM_TS_2_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_1_MASK       (0x00000002u)
#define CSL_GCCP_CFG_TSM_TS_1_SHIFT      (0x00000001u)
#define CSL_GCCP_CFG_TSM_TS_1_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_TS_0_MASK       (0x00000001u)
#define CSL_GCCP_CFG_TSM_TS_0_SHIFT      (0x00000000u)
#define CSL_GCCP_CFG_TSM_TS_0_RESETVAL   (0x00000000u)

#define CSL_GCCP_CFG_TSM_RESETVAL        (0x00000000u)

/* PAT */

#define CSL_GCCP_CFG_PAT_PAGE_31_MASK    (0x80000000u)
#define CSL_GCCP_CFG_PAT_PAGE_31_SHIFT   (0x0000001Fu)
#define CSL_GCCP_CFG_PAT_PAGE_31_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_30_MASK    (0x40000000u)
#define CSL_GCCP_CFG_PAT_PAGE_30_SHIFT   (0x0000001Eu)
#define CSL_GCCP_CFG_PAT_PAGE_30_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_29_MASK    (0x20000000u)
#define CSL_GCCP_CFG_PAT_PAGE_29_SHIFT   (0x0000001Du)
#define CSL_GCCP_CFG_PAT_PAGE_29_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_28_MASK    (0x10000000u)
#define CSL_GCCP_CFG_PAT_PAGE_28_SHIFT   (0x0000001Cu)
#define CSL_GCCP_CFG_PAT_PAGE_28_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_27_MASK    (0x08000000u)
#define CSL_GCCP_CFG_PAT_PAGE_27_SHIFT   (0x0000001Bu)
#define CSL_GCCP_CFG_PAT_PAGE_27_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_26_MASK    (0x04000000u)
#define CSL_GCCP_CFG_PAT_PAGE_26_SHIFT   (0x0000001Au)
#define CSL_GCCP_CFG_PAT_PAGE_26_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_25_MASK    (0x02000000u)
#define CSL_GCCP_CFG_PAT_PAGE_25_SHIFT   (0x00000019u)
#define CSL_GCCP_CFG_PAT_PAGE_25_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_24_MASK    (0x01000000u)
#define CSL_GCCP_CFG_PAT_PAGE_24_SHIFT   (0x00000018u)
#define CSL_GCCP_CFG_PAT_PAGE_24_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_23_MASK    (0x00800000u)
#define CSL_GCCP_CFG_PAT_PAGE_23_SHIFT   (0x00000017u)
#define CSL_GCCP_CFG_PAT_PAGE_23_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_22_MASK    (0x00400000u)
#define CSL_GCCP_CFG_PAT_PAGE_22_SHIFT   (0x00000016u)
#define CSL_GCCP_CFG_PAT_PAGE_22_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_21_MASK    (0x00200000u)
#define CSL_GCCP_CFG_PAT_PAGE_21_SHIFT   (0x00000015u)
#define CSL_GCCP_CFG_PAT_PAGE_21_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_20_MASK    (0x00100000u)
#define CSL_GCCP_CFG_PAT_PAGE_20_SHIFT   (0x00000014u)
#define CSL_GCCP_CFG_PAT_PAGE_20_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_19_MASK    (0x00080000u)
#define CSL_GCCP_CFG_PAT_PAGE_19_SHIFT   (0x00000013u)
#define CSL_GCCP_CFG_PAT_PAGE_19_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_18_MASK    (0x00040000u)
#define CSL_GCCP_CFG_PAT_PAGE_18_SHIFT   (0x00000012u)
#define CSL_GCCP_CFG_PAT_PAGE_18_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_17_MASK    (0x00020000u)
#define CSL_GCCP_CFG_PAT_PAGE_17_SHIFT   (0x00000011u)
#define CSL_GCCP_CFG_PAT_PAGE_17_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_16_MASK    (0x00010000u)
#define CSL_GCCP_CFG_PAT_PAGE_16_SHIFT   (0x00000010u)
#define CSL_GCCP_CFG_PAT_PAGE_16_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_15_MASK    (0x00008000u)
#define CSL_GCCP_CFG_PAT_PAGE_15_SHIFT   (0x0000000Fu)
#define CSL_GCCP_CFG_PAT_PAGE_15_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_14_MASK    (0x00004000u)
#define CSL_GCCP_CFG_PAT_PAGE_14_SHIFT   (0x0000000Eu)
#define CSL_GCCP_CFG_PAT_PAGE_14_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_13_MASK    (0x00002000u)
#define CSL_GCCP_CFG_PAT_PAGE_13_SHIFT   (0x0000000Du)
#define CSL_GCCP_CFG_PAT_PAGE_13_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_12_MASK    (0x00001000u)
#define CSL_GCCP_CFG_PAT_PAGE_12_SHIFT   (0x0000000Cu)
#define CSL_GCCP_CFG_PAT_PAGE_12_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_11_MASK    (0x00000800u)
#define CSL_GCCP_CFG_PAT_PAGE_11_SHIFT   (0x0000000Bu)
#define CSL_GCCP_CFG_PAT_PAGE_11_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_10_MASK    (0x00000400u)
#define CSL_GCCP_CFG_PAT_PAGE_10_SHIFT   (0x0000000Au)
#define CSL_GCCP_CFG_PAT_PAGE_10_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_9_MASK     (0x00000200u)
#define CSL_GCCP_CFG_PAT_PAGE_9_SHIFT    (0x00000009u)
#define CSL_GCCP_CFG_PAT_PAGE_9_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_8_MASK     (0x00000100u)
#define CSL_GCCP_CFG_PAT_PAGE_8_SHIFT    (0x00000008u)
#define CSL_GCCP_CFG_PAT_PAGE_8_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_7_MASK     (0x00000080u)
#define CSL_GCCP_CFG_PAT_PAGE_7_SHIFT    (0x00000007u)
#define CSL_GCCP_CFG_PAT_PAGE_7_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_6_MASK     (0x00000040u)
#define CSL_GCCP_CFG_PAT_PAGE_6_SHIFT    (0x00000006u)
#define CSL_GCCP_CFG_PAT_PAGE_6_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_5_MASK     (0x00000020u)
#define CSL_GCCP_CFG_PAT_PAGE_5_SHIFT    (0x00000005u)
#define CSL_GCCP_CFG_PAT_PAGE_5_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_4_MASK     (0x00000010u)
#define CSL_GCCP_CFG_PAT_PAGE_4_SHIFT    (0x00000004u)
#define CSL_GCCP_CFG_PAT_PAGE_4_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_3_MASK     (0x00000008u)
#define CSL_GCCP_CFG_PAT_PAGE_3_SHIFT    (0x00000003u)
#define CSL_GCCP_CFG_PAT_PAGE_3_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_2_MASK     (0x00000004u)
#define CSL_GCCP_CFG_PAT_PAGE_2_SHIFT    (0x00000002u)
#define CSL_GCCP_CFG_PAT_PAGE_2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_1_MASK     (0x00000002u)
#define CSL_GCCP_CFG_PAT_PAGE_1_SHIFT    (0x00000001u)
#define CSL_GCCP_CFG_PAT_PAGE_1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_PAGE_0_MASK     (0x00000001u)
#define CSL_GCCP_CFG_PAT_PAGE_0_SHIFT    (0x00000000u)
#define CSL_GCCP_CFG_PAT_PAGE_0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_PAT_RESETVAL        (0x00000000u)

/* INT_COEF */

#define CSL_GCCP_CFG_INT_COEF_COEFF3_MASK (0xFF000000u)
#define CSL_GCCP_CFG_INT_COEF_COEFF3_SHIFT (0x00000018u)
#define CSL_GCCP_CFG_INT_COEF_COEFF3_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_INT_COEF_COEFF2_MASK (0x00FF0000u)
#define CSL_GCCP_CFG_INT_COEF_COEFF2_SHIFT (0x00000010u)
#define CSL_GCCP_CFG_INT_COEF_COEFF2_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_INT_COEF_COEFF1_MASK (0x0000FF00u)
#define CSL_GCCP_CFG_INT_COEF_COEFF1_SHIFT (0x00000008u)
#define CSL_GCCP_CFG_INT_COEF_COEFF1_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_INT_COEF_COEFF0_MASK (0x000000FFu)
#define CSL_GCCP_CFG_INT_COEF_COEFF0_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_INT_COEF_COEFF0_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_INT_COEF_RESETVAL   (0x00000000u)

/* HCQ_CURR_LVL */

#define CSL_GCCP_CFG_HCQ_CURR_LVL_CURR_LVL_MASK (0x000000FFu)
#define CSL_GCCP_CFG_HCQ_CURR_LVL_CURR_LVL_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_HCQ_CURR_LVL_CURR_LVL_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_HCQ_CURR_LVL_RESETVAL (0x00000000u)

/* HCQ_WTMK_LVL */

#define CSL_GCCP_CFG_HCQ_WTMK_LVL_WATERMARK_MASK (0x000000FFu)
#define CSL_GCCP_CFG_HCQ_WTMK_LVL_WATERMARK_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_HCQ_WTMK_LVL_WATERMARK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_HCQ_WTMK_LVL_RESETVAL (0x00000000u)

/* HDQ_CURR_LVL */

#define CSL_GCCP_CFG_HDQ_CURR_LVL_CURR_LVL_MASK (0x000000FFu)
#define CSL_GCCP_CFG_HDQ_CURR_LVL_CURR_LVL_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_HDQ_CURR_LVL_CURR_LVL_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_HDQ_CURR_LVL_RESETVAL (0x00000000u)

/* HDQ_WTMK_LVL */

#define CSL_GCCP_CFG_HDQ_WTMK_LVL_WATERMARK_MASK (0x000000FFu)
#define CSL_GCCP_CFG_HDQ_WTMK_LVL_WATERMARK_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_HDQ_WTMK_LVL_WATERMARK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_HDQ_WTMK_LVL_RESETVAL (0x00000000u)

/* LCQ_CURR_LVL */

#define CSL_GCCP_CFG_LCQ_CURR_LVL_CURR_LVL_MASK (0x000007FFu)
#define CSL_GCCP_CFG_LCQ_CURR_LVL_CURR_LVL_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_LCQ_CURR_LVL_CURR_LVL_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_LCQ_CURR_LVL_RESETVAL (0x00000000u)

/* LCQ_WTMK_LVL */

#define CSL_GCCP_CFG_LCQ_WTMK_LVL_WATERMARK_MASK (0x000007FFu)
#define CSL_GCCP_CFG_LCQ_WTMK_LVL_WATERMARK_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_LCQ_WTMK_LVL_WATERMARK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_LCQ_WTMK_LVL_RESETVAL (0x00000000u)

/* LDQ_CURR_LVL */

#define CSL_GCCP_CFG_LDQ_CURR_LVL_CURR_LVL_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_LDQ_CURR_LVL_CURR_LVL_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_LDQ_CURR_LVL_CURR_LVL_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_LDQ_CURR_LVL_RESETVAL (0x00000000u)

/* LDQ_WTMK_LVL */

#define CSL_GCCP_CFG_LDQ_WTMK_LVL_WATERMARK_MASK (0x00000FFFu)
#define CSL_GCCP_CFG_LDQ_WTMK_LVL_WATERMARK_SHIFT (0x00000000u)
#define CSL_GCCP_CFG_LDQ_WTMK_LVL_WATERMARK_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_LDQ_WTMK_LVL_RESETVAL (0x00000000u)

/* CGT */

#define CSL_GCCP_CFG_CGT_Y_PART_MASK     (0x01FFFFFFu)
#define CSL_GCCP_CFG_CGT_Y_PART_SHIFT    (0x00000000u)
#define CSL_GCCP_CFG_CGT_Y_PART_RESETVAL (0x00000000u)

#define CSL_GCCP_CFG_CGT_RESETVAL        (0x00000000u)

#endif
