/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_intgen.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for INTGEN
 *
 */
#ifndef _CSLR_INTGEN_H_
#define _CSLR_INTGEN_H_

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[256];
    volatile Uint32 IPCGR[3];
    volatile Uint8 RSVD1[52];
    volatile Uint32 IPCAR[3];
} CSL_IntgenRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IPCGR */

#define CSL_INTGEN_IPCGR_SRCS27_MASK     (0x80000000u)
#define CSL_INTGEN_IPCGR_SRCS27_SHIFT    (0x0000001Fu)
#define CSL_INTGEN_IPCGR_SRCS27_RESETVAL (0x00000000u)

/*----SRCS27 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS27_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS26_MASK     (0x40000000u)
#define CSL_INTGEN_IPCGR_SRCS26_SHIFT    (0x0000001Eu)
#define CSL_INTGEN_IPCGR_SRCS26_RESETVAL (0x00000000u)

/*----SRCS26 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS26_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS25_MASK     (0x20000000u)
#define CSL_INTGEN_IPCGR_SRCS25_SHIFT    (0x0000001Du)
#define CSL_INTGEN_IPCGR_SRCS25_RESETVAL (0x00000000u)

/*----SRCS25 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS25_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS24_MASK     (0x10000000u)
#define CSL_INTGEN_IPCGR_SRCS24_SHIFT    (0x0000001Cu)
#define CSL_INTGEN_IPCGR_SRCS24_RESETVAL (0x00000000u)

/*----SRCS24 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS24_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS23_MASK     (0x08000000u)
#define CSL_INTGEN_IPCGR_SRCS23_SHIFT    (0x0000001Bu)
#define CSL_INTGEN_IPCGR_SRCS23_RESETVAL (0x00000000u)

/*----SRCS23 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS23_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS22_MASK     (0x04000000u)
#define CSL_INTGEN_IPCGR_SRCS22_SHIFT    (0x0000001Au)
#define CSL_INTGEN_IPCGR_SRCS22_RESETVAL (0x00000000u)

/*----SRCS22 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS22_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS21_MASK     (0x02000000u)
#define CSL_INTGEN_IPCGR_SRCS21_SHIFT    (0x00000019u)
#define CSL_INTGEN_IPCGR_SRCS21_RESETVAL (0x00000000u)

/*----SRCS21 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS21_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS20_MASK     (0x01000000u)
#define CSL_INTGEN_IPCGR_SRCS20_SHIFT    (0x00000018u)
#define CSL_INTGEN_IPCGR_SRCS20_RESETVAL (0x00000000u)

/*----SRCS20 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS20_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS19_MASK     (0x00800000u)
#define CSL_INTGEN_IPCGR_SRCS19_SHIFT    (0x00000017u)
#define CSL_INTGEN_IPCGR_SRCS19_RESETVAL (0x00000000u)

/*----SRCS19 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS19_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS18_MASK     (0x00400000u)
#define CSL_INTGEN_IPCGR_SRCS18_SHIFT    (0x00000016u)
#define CSL_INTGEN_IPCGR_SRCS18_RESETVAL (0x00000000u)

/*----SRCS18 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS18_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS17_MASK     (0x00200000u)
#define CSL_INTGEN_IPCGR_SRCS17_SHIFT    (0x00000015u)
#define CSL_INTGEN_IPCGR_SRCS17_RESETVAL (0x00000000u)

/*----SRCS17 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS17_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS16_MASK     (0x00100000u)
#define CSL_INTGEN_IPCGR_SRCS16_SHIFT    (0x00000014u)
#define CSL_INTGEN_IPCGR_SRCS16_RESETVAL (0x00000000u)

/*----SRCS16 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS16_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS15_MASK     (0x00080000u)
#define CSL_INTGEN_IPCGR_SRCS15_SHIFT    (0x00000013u)
#define CSL_INTGEN_IPCGR_SRCS15_RESETVAL (0x00000000u)

/*----SRCS15 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS15_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS14_MASK     (0x00040000u)
#define CSL_INTGEN_IPCGR_SRCS14_SHIFT    (0x00000012u)
#define CSL_INTGEN_IPCGR_SRCS14_RESETVAL (0x00000000u)

/*----SRCS14 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS14_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS13_MASK     (0x00020000u)
#define CSL_INTGEN_IPCGR_SRCS13_SHIFT    (0x00000011u)
#define CSL_INTGEN_IPCGR_SRCS13_RESETVAL (0x00000000u)

/*----SRCS13 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS13_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS12_MASK     (0x00010000u)
#define CSL_INTGEN_IPCGR_SRCS12_SHIFT    (0x00000010u)
#define CSL_INTGEN_IPCGR_SRCS12_RESETVAL (0x00000000u)

/*----SRCS12 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS12_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS11_MASK     (0x00008000u)
#define CSL_INTGEN_IPCGR_SRCS11_SHIFT    (0x0000000Fu)
#define CSL_INTGEN_IPCGR_SRCS11_RESETVAL (0x00000000u)

/*----SRCS11 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS11_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS10_MASK     (0x00004000u)
#define CSL_INTGEN_IPCGR_SRCS10_SHIFT    (0x0000000Eu)
#define CSL_INTGEN_IPCGR_SRCS10_RESETVAL (0x00000000u)

/*----SRCS10 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS10_SET      (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS9_MASK      (0x00002000u)
#define CSL_INTGEN_IPCGR_SRCS9_SHIFT     (0x0000000Du)
#define CSL_INTGEN_IPCGR_SRCS9_RESETVAL  (0x00000000u)

/*----SRCS9 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS9_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS8_MASK      (0x00001000u)
#define CSL_INTGEN_IPCGR_SRCS8_SHIFT     (0x0000000Cu)
#define CSL_INTGEN_IPCGR_SRCS8_RESETVAL  (0x00000000u)

/*----SRCS8 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS8_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS7_MASK      (0x00000800u)
#define CSL_INTGEN_IPCGR_SRCS7_SHIFT     (0x0000000Bu)
#define CSL_INTGEN_IPCGR_SRCS7_RESETVAL  (0x00000000u)

/*----SRCS7 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS7_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS6_MASK      (0x00000400u)
#define CSL_INTGEN_IPCGR_SRCS6_SHIFT     (0x0000000Au)
#define CSL_INTGEN_IPCGR_SRCS6_RESETVAL  (0x00000000u)

/*----SRCS6 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS6_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS5_MASK      (0x00000200u)
#define CSL_INTGEN_IPCGR_SRCS5_SHIFT     (0x00000009u)
#define CSL_INTGEN_IPCGR_SRCS5_RESETVAL  (0x00000000u)

/*----SRCS5 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS5_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS4_MASK      (0x00000100u)
#define CSL_INTGEN_IPCGR_SRCS4_SHIFT     (0x00000008u)
#define CSL_INTGEN_IPCGR_SRCS4_RESETVAL  (0x00000000u)

/*----SRCS4 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS4_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS3_MASK      (0x00000080u)
#define CSL_INTGEN_IPCGR_SRCS3_SHIFT     (0x00000007u)
#define CSL_INTGEN_IPCGR_SRCS3_RESETVAL  (0x00000000u)

/*----SRCS3 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS3_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS2_MASK      (0x00000040u)
#define CSL_INTGEN_IPCGR_SRCS2_SHIFT     (0x00000006u)
#define CSL_INTGEN_IPCGR_SRCS2_RESETVAL  (0x00000000u)

/*----SRCS2 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS2_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS1_MASK      (0x00000020u)
#define CSL_INTGEN_IPCGR_SRCS1_SHIFT     (0x00000005u)
#define CSL_INTGEN_IPCGR_SRCS1_RESETVAL  (0x00000000u)

/*----SRCS1 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS1_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_SRCS0_MASK      (0x00000010u)
#define CSL_INTGEN_IPCGR_SRCS0_SHIFT     (0x00000004u)
#define CSL_INTGEN_IPCGR_SRCS0_RESETVAL  (0x00000000u)

/*----SRCS0 Tokens----*/
#define CSL_INTGEN_IPCGR_SRCS0_SET       (0x00000001u)

#define CSL_INTGEN_IPCGR_IPCG_MASK       (0x00000001u)
#define CSL_INTGEN_IPCGR_IPCG_SHIFT      (0x00000000u)
#define CSL_INTGEN_IPCGR_IPCG_RESETVAL   (0x00000000u)

#define CSL_INTGEN_IPCGR_RESETVAL        (0x00000000u)

/* IPCAR */

#define CSL_INTGEN_IPCAR_SRCC27_MASK     (0x80000000u)
#define CSL_INTGEN_IPCAR_SRCC27_SHIFT    (0x0000001Fu)
#define CSL_INTGEN_IPCAR_SRCC27_RESETVAL (0x00000000u)

/*----SRCC27 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC27_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC26_MASK     (0x40000000u)
#define CSL_INTGEN_IPCAR_SRCC26_SHIFT    (0x0000001Eu)
#define CSL_INTGEN_IPCAR_SRCC26_RESETVAL (0x00000000u)

/*----SRCC26 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC26_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC25_MASK     (0x20000000u)
#define CSL_INTGEN_IPCAR_SRCC25_SHIFT    (0x0000001Du)
#define CSL_INTGEN_IPCAR_SRCC25_RESETVAL (0x00000000u)

/*----SRCC25 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC25_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC24_MASK     (0x10000000u)
#define CSL_INTGEN_IPCAR_SRCC24_SHIFT    (0x0000001Cu)
#define CSL_INTGEN_IPCAR_SRCC24_RESETVAL (0x00000000u)

/*----SRCC24 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC24_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC23_MASK     (0x08000000u)
#define CSL_INTGEN_IPCAR_SRCC23_SHIFT    (0x0000001Bu)
#define CSL_INTGEN_IPCAR_SRCC23_RESETVAL (0x00000000u)

/*----SRCC23 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC23_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC22_MASK     (0x04000000u)
#define CSL_INTGEN_IPCAR_SRCC22_SHIFT    (0x0000001Au)
#define CSL_INTGEN_IPCAR_SRCC22_RESETVAL (0x00000000u)

/*----SRCC22 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC22_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC21_MASK     (0x02000000u)
#define CSL_INTGEN_IPCAR_SRCC21_SHIFT    (0x00000019u)
#define CSL_INTGEN_IPCAR_SRCC21_RESETVAL (0x00000000u)

/*----SRCC21 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC21_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC20_MASK     (0x01000000u)
#define CSL_INTGEN_IPCAR_SRCC20_SHIFT    (0x00000018u)
#define CSL_INTGEN_IPCAR_SRCC20_RESETVAL (0x00000000u)

/*----SRCC20 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC20_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC19_MASK     (0x00800000u)
#define CSL_INTGEN_IPCAR_SRCC19_SHIFT    (0x00000017u)
#define CSL_INTGEN_IPCAR_SRCC19_RESETVAL (0x00000000u)

/*----SRCC19 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC19_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC18_MASK     (0x00400000u)
#define CSL_INTGEN_IPCAR_SRCC18_SHIFT    (0x00000016u)
#define CSL_INTGEN_IPCAR_SRCC18_RESETVAL (0x00000000u)

/*----SRCC18 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC18_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC17_MASK     (0x00200000u)
#define CSL_INTGEN_IPCAR_SRCC17_SHIFT    (0x00000015u)
#define CSL_INTGEN_IPCAR_SRCC17_RESETVAL (0x00000000u)

/*----SRCC17 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC17_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC16_MASK     (0x00100000u)
#define CSL_INTGEN_IPCAR_SRCC16_SHIFT    (0x00000014u)
#define CSL_INTGEN_IPCAR_SRCC16_RESETVAL (0x00000000u)

/*----SRCC16 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC16_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC15_MASK     (0x00080000u)
#define CSL_INTGEN_IPCAR_SRCC15_SHIFT    (0x00000013u)
#define CSL_INTGEN_IPCAR_SRCC15_RESETVAL (0x00000000u)

/*----SRCC15 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC15_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC14_MASK     (0x00040000u)
#define CSL_INTGEN_IPCAR_SRCC14_SHIFT    (0x00000012u)
#define CSL_INTGEN_IPCAR_SRCC14_RESETVAL (0x00000000u)

/*----SRCC14 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC14_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC13_MASK     (0x00020000u)
#define CSL_INTGEN_IPCAR_SRCC13_SHIFT    (0x00000011u)
#define CSL_INTGEN_IPCAR_SRCC13_RESETVAL (0x00000000u)

/*----SRCC13 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC13_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC12_MASK     (0x00010000u)
#define CSL_INTGEN_IPCAR_SRCC12_SHIFT    (0x00000010u)
#define CSL_INTGEN_IPCAR_SRCC12_RESETVAL (0x00000000u)

/*----SRCC12 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC12_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC11_MASK     (0x00008000u)
#define CSL_INTGEN_IPCAR_SRCC11_SHIFT    (0x0000000Fu)
#define CSL_INTGEN_IPCAR_SRCC11_RESETVAL (0x00000000u)

/*----SRCC11 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC11_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC10_MASK     (0x00004000u)
#define CSL_INTGEN_IPCAR_SRCC10_SHIFT    (0x0000000Eu)
#define CSL_INTGEN_IPCAR_SRCC10_RESETVAL (0x00000000u)

/*----SRCC10 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC10_CLEAR    (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC9_MASK      (0x00002000u)
#define CSL_INTGEN_IPCAR_SRCC9_SHIFT     (0x0000000Du)
#define CSL_INTGEN_IPCAR_SRCC9_RESETVAL  (0x00000000u)

/*----SRCC9 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC9_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC8_MASK      (0x00001000u)
#define CSL_INTGEN_IPCAR_SRCC8_SHIFT     (0x0000000Cu)
#define CSL_INTGEN_IPCAR_SRCC8_RESETVAL  (0x00000000u)

/*----SRCC8 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC8_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC7_MASK      (0x00000800u)
#define CSL_INTGEN_IPCAR_SRCC7_SHIFT     (0x0000000Bu)
#define CSL_INTGEN_IPCAR_SRCC7_RESETVAL  (0x00000000u)

/*----SRCC7 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC7_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC6_MASK      (0x00000400u)
#define CSL_INTGEN_IPCAR_SRCC6_SHIFT     (0x0000000Au)
#define CSL_INTGEN_IPCAR_SRCC6_RESETVAL  (0x00000000u)

/*----SRCC6 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC6_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC5_MASK      (0x00000200u)
#define CSL_INTGEN_IPCAR_SRCC5_SHIFT     (0x00000009u)
#define CSL_INTGEN_IPCAR_SRCC5_RESETVAL  (0x00000000u)

/*----SRCC5 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC5_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC4_MASK      (0x00000100u)
#define CSL_INTGEN_IPCAR_SRCC4_SHIFT     (0x00000008u)
#define CSL_INTGEN_IPCAR_SRCC4_RESETVAL  (0x00000000u)

/*----SRCC4 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC4_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC3_MASK      (0x00000080u)
#define CSL_INTGEN_IPCAR_SRCC3_SHIFT     (0x00000007u)
#define CSL_INTGEN_IPCAR_SRCC3_RESETVAL  (0x00000000u)

/*----SRCC3 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC3_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC2_MASK      (0x00000040u)
#define CSL_INTGEN_IPCAR_SRCC2_SHIFT     (0x00000006u)
#define CSL_INTGEN_IPCAR_SRCC2_RESETVAL  (0x00000000u)

/*----SRCC2 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC2_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC1_MASK      (0x00000020u)
#define CSL_INTGEN_IPCAR_SRCC1_SHIFT     (0x00000005u)
#define CSL_INTGEN_IPCAR_SRCC1_RESETVAL  (0x00000000u)

/*----SRCC1 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC1_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_SRCC0_MASK      (0x00000010u)
#define CSL_INTGEN_IPCAR_SRCC0_SHIFT     (0x00000004u)
#define CSL_INTGEN_IPCAR_SRCC0_RESETVAL  (0x00000000u)

/*----SRCC0 Tokens----*/
#define CSL_INTGEN_IPCAR_SRCC0_CLEAR     (0x00000001u)

#define CSL_INTGEN_IPCAR_RESETVAL        (0x00000000u)

#endif
