/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */
 
/** ============================================================================
 *   @file  cslr_mcbsp.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for MCBSP
 *
 */

#ifndef _CSLR_MCBSP_H_
#define _CSLR_MCBSP_H_


#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 DRR;
    volatile Uint32 DXR;
    volatile Uint32 SPCR;
    volatile Uint32 RCR;
    volatile Uint32 XCR;
    volatile Uint32 SRGR;
    volatile Uint32 MCR;
    volatile Uint32 RCERE0;
    volatile Uint32 XCERE0;
    volatile Uint32 PCR;
    volatile Uint32 RCERE1;
    volatile Uint32 XCERE1;
    volatile Uint32 RCERE2;
    volatile Uint32 XCERE2;
    volatile Uint32 RCERE3;
    volatile Uint32 XCERE3;
} CSL_McbspRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_McbspRegs             *CSL_McbspRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRR */

#define CSL_MCBSP_DRR_DRR_MASK           (0xFFFFFFFFu)
#define CSL_MCBSP_DRR_DRR_SHIFT          (0x00000000u)
#define CSL_MCBSP_DRR_DRR_RESETVAL       (0x00000000u)

#define CSL_MCBSP_DRR_RESETVAL           (0x00000000u)

/* DXR */

#define CSL_MCBSP_DXR_DXR_MASK           (0xFFFFFFFFu)
#define CSL_MCBSP_DXR_DXR_SHIFT          (0x00000000u)
#define CSL_MCBSP_DXR_DXR_RESETVAL       (0x00000000u)

#define CSL_MCBSP_DXR_RESETVAL           (0x00000000u)

/* SPCR */

#define CSL_MCBSP_SPCR_FREE_MASK         (0x02000000u)
#define CSL_MCBSP_SPCR_FREE_SHIFT        (0x00000019u)
#define CSL_MCBSP_SPCR_FREE_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_SOFT_MASK         (0x01000000u)
#define CSL_MCBSP_SPCR_SOFT_SHIFT        (0x00000018u)
#define CSL_MCBSP_SPCR_SOFT_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_FRST_MASK         (0x00800000u)
#define CSL_MCBSP_SPCR_FRST_SHIFT        (0x00000017u)
#define CSL_MCBSP_SPCR_FRST_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_GRST_MASK         (0x00400000u)
#define CSL_MCBSP_SPCR_GRST_SHIFT        (0x00000016u)
#define CSL_MCBSP_SPCR_GRST_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_XINTM_MASK        (0x00300000u)
#define CSL_MCBSP_SPCR_XINTM_SHIFT       (0x00000014u)
#define CSL_MCBSP_SPCR_XINTM_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SPCR_XSYNCERR_MASK     (0x00080000u)
#define CSL_MCBSP_SPCR_XSYNCERR_SHIFT    (0x00000013u)
#define CSL_MCBSP_SPCR_XSYNCERR_RESETVAL (0x00000000u)

/*----XSYNCERR Tokens----*/
#define CSL_MCBSP_SPCR_XSYNCERR_CLEAR    (0x00000000u)

#define CSL_MCBSP_SPCR_XEMPTY_MASK       (0x00040000u)
#define CSL_MCBSP_SPCR_XEMPTY_SHIFT      (0x00000012u)
#define CSL_MCBSP_SPCR_XEMPTY_RESETVAL   (0x00000000u)

#define CSL_MCBSP_SPCR_XRDY_MASK         (0x00020000u)
#define CSL_MCBSP_SPCR_XRDY_SHIFT        (0x00000011u)
#define CSL_MCBSP_SPCR_XRDY_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_XRST_MASK         (0x00010000u)
#define CSL_MCBSP_SPCR_XRST_SHIFT        (0x00000010u)
#define CSL_MCBSP_SPCR_XRST_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_DLB_MASK          (0x00008000u)
#define CSL_MCBSP_SPCR_DLB_SHIFT         (0x0000000Fu)
#define CSL_MCBSP_SPCR_DLB_RESETVAL      (0x00000000u)

#define CSL_MCBSP_SPCR_RJUST_MASK        (0x00006000u)
#define CSL_MCBSP_SPCR_RJUST_SHIFT       (0x0000000Du)
#define CSL_MCBSP_SPCR_RJUST_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SPCR_CLKSTP_MASK       (0x00001800u)
#define CSL_MCBSP_SPCR_CLKSTP_SHIFT      (0x0000000Bu)
#define CSL_MCBSP_SPCR_CLKSTP_RESETVAL   (0x00000000u)

#define CSL_MCBSP_SPCR_DXENA_MASK        (0x00000080u)
#define CSL_MCBSP_SPCR_DXENA_SHIFT       (0x00000007u)
#define CSL_MCBSP_SPCR_DXENA_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SPCR_RINTM_MASK        (0x00000030u)
#define CSL_MCBSP_SPCR_RINTM_SHIFT       (0x00000004u)
#define CSL_MCBSP_SPCR_RINTM_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SPCR_RSYNCERR_MASK     (0x00000008u)
#define CSL_MCBSP_SPCR_RSYNCERR_SHIFT    (0x00000003u)
#define CSL_MCBSP_SPCR_RSYNCERR_RESETVAL (0x00000000u)

/*----RSYNCERR Tokens----*/
#define CSL_MCBSP_SPCR_RSYNCERR_CLEAR    (0x00000000u)

#define CSL_MCBSP_SPCR_RFULL_MASK        (0x00000004u)
#define CSL_MCBSP_SPCR_RFULL_SHIFT       (0x00000002u)
#define CSL_MCBSP_SPCR_RFULL_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SPCR_RRDY_MASK         (0x00000002u)
#define CSL_MCBSP_SPCR_RRDY_SHIFT        (0x00000001u)
#define CSL_MCBSP_SPCR_RRDY_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_RRST_MASK         (0x00000001u)
#define CSL_MCBSP_SPCR_RRST_SHIFT        (0x00000000u)
#define CSL_MCBSP_SPCR_RRST_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SPCR_RESETVAL          (0x00000000u)

/* RCR */

#define CSL_MCBSP_RCR_RPHASE_MASK        (0x80000000u)
#define CSL_MCBSP_RCR_RPHASE_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_RCR_RPHASE_RESETVAL    (0x00000000u)

#define CSL_MCBSP_RCR_RFRLEN2_MASK       (0x7F000000u)
#define CSL_MCBSP_RCR_RFRLEN2_SHIFT      (0x00000018u)
#define CSL_MCBSP_RCR_RFRLEN2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCR_RWDLEN2_MASK       (0x00E00000u)
#define CSL_MCBSP_RCR_RWDLEN2_SHIFT      (0x00000015u)
#define CSL_MCBSP_RCR_RWDLEN2_RESETVAL   (0x00000000u)

/*----RWDLEN2 Tokens----*/
#define CSL_MCBSP_RCR_RWDLEN2_8BITS      (0x00000000u)
#define CSL_MCBSP_RCR_RWDLEN2_12BITS     (0x00000001u)
#define CSL_MCBSP_RCR_RWDLEN2_16BITS     (0x00000002u)
#define CSL_MCBSP_RCR_RWDLEN2_20BITS     (0x00000003u)
#define CSL_MCBSP_RCR_RWDLEN2_24BITS     (0x00000004u)
#define CSL_MCBSP_RCR_RWDLEN2_32BITS     (0x00000005u)

#define CSL_MCBSP_RCR_RCOMPAND_MASK      (0x00180000u)
#define CSL_MCBSP_RCR_RCOMPAND_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCR_RCOMPAND_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCR_RFIG_MASK          (0x00040000u)
#define CSL_MCBSP_RCR_RFIG_SHIFT         (0x00000012u)
#define CSL_MCBSP_RCR_RFIG_RESETVAL      (0x00000000u)

#define CSL_MCBSP_RCR_RDATDLY_MASK       (0x00030000u)
#define CSL_MCBSP_RCR_RDATDLY_SHIFT      (0x00000010u)
#define CSL_MCBSP_RCR_RDATDLY_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCR_RFRLEN1_MASK       (0x00007F00u)
#define CSL_MCBSP_RCR_RFRLEN1_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCR_RFRLEN1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCR_RWDLEN1_MASK       (0x000000E0u)
#define CSL_MCBSP_RCR_RWDLEN1_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCR_RWDLEN1_RESETVAL   (0x00000000u)

/*----RWDLEN1 Tokens----*/
#define CSL_MCBSP_RCR_RWDLEN1_8BITS      (0x00000000u)
#define CSL_MCBSP_RCR_RWDLEN1_12BITS     (0x00000001u)
#define CSL_MCBSP_RCR_RWDLEN1_16BITS     (0x00000002u)
#define CSL_MCBSP_RCR_RWDLEN1_20BITS     (0x00000003u)
#define CSL_MCBSP_RCR_RWDLEN1_24BITS     (0x00000004u)
#define CSL_MCBSP_RCR_RWDLEN1_32BITS     (0x00000005u)

#define CSL_MCBSP_RCR_RWDREVRS_MASK      (0x00000010u)
#define CSL_MCBSP_RCR_RWDREVRS_SHIFT     (0x00000004u)
#define CSL_MCBSP_RCR_RWDREVRS_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCR_RESETVAL           (0x00000000u)

/* XCR */

#define CSL_MCBSP_XCR_XPHASE_MASK        (0x80000000u)
#define CSL_MCBSP_XCR_XPHASE_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_XCR_XPHASE_RESETVAL    (0x00000000u)

#define CSL_MCBSP_XCR_XFRLEN2_MASK       (0x7F000000u)
#define CSL_MCBSP_XCR_XFRLEN2_SHIFT      (0x00000018u)
#define CSL_MCBSP_XCR_XFRLEN2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCR_XWDLEN2_MASK       (0x00E00000u)
#define CSL_MCBSP_XCR_XWDLEN2_SHIFT      (0x00000015u)
#define CSL_MCBSP_XCR_XWDLEN2_RESETVAL   (0x00000000u)

/*----XWDLEN2 Tokens----*/
#define CSL_MCBSP_XCR_XWDLEN2_8BITS      (0x00000000u)
#define CSL_MCBSP_XCR_XWDLEN2_12BITS     (0x00000001u)
#define CSL_MCBSP_XCR_XWDLEN2_16BITS     (0x00000002u)
#define CSL_MCBSP_XCR_XWDLEN2_20BITS     (0x00000003u)
#define CSL_MCBSP_XCR_XWDLEN2_24BITS     (0x00000004u)
#define CSL_MCBSP_XCR_XWDLEN2_32BITS     (0x00000005u)

#define CSL_MCBSP_XCR_XCOMPAND_MASK      (0x00180000u)
#define CSL_MCBSP_XCR_XCOMPAND_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCR_XCOMPAND_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCR_XFIG_MASK          (0x00040000u)
#define CSL_MCBSP_XCR_XFIG_SHIFT         (0x00000012u)
#define CSL_MCBSP_XCR_XFIG_RESETVAL      (0x00000000u)

#define CSL_MCBSP_XCR_XDATDLY_MASK       (0x00030000u)
#define CSL_MCBSP_XCR_XDATDLY_SHIFT      (0x00000010u)
#define CSL_MCBSP_XCR_XDATDLY_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCR_XFRLEN1_MASK       (0x00007F00u)
#define CSL_MCBSP_XCR_XFRLEN1_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCR_XFRLEN1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCR_XWDLEN1_MASK       (0x000000E0u)
#define CSL_MCBSP_XCR_XWDLEN1_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCR_XWDLEN1_RESETVAL   (0x00000000u)

/*----XWDLEN1 Tokens----*/
#define CSL_MCBSP_XCR_XWDLEN1_8BITS      (0x00000000u)
#define CSL_MCBSP_XCR_XWDLEN1_12BITS     (0x00000001u)
#define CSL_MCBSP_XCR_XWDLEN1_16BITS     (0x00000002u)
#define CSL_MCBSP_XCR_XWDLEN1_20BITS     (0x00000003u)
#define CSL_MCBSP_XCR_XWDLEN1_24BITS     (0x00000004u)
#define CSL_MCBSP_XCR_XWDLEN1_32BITS     (0x00000005u)

#define CSL_MCBSP_XCR_XWDREVRS_MASK      (0x00000010u)
#define CSL_MCBSP_XCR_XWDREVRS_SHIFT     (0x00000004u)
#define CSL_MCBSP_XCR_XWDREVRS_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCR_RESETVAL           (0x00000000u)

/* SRGR */

#define CSL_MCBSP_SRGR_GSYNC_MASK        (0x80000000u)
#define CSL_MCBSP_SRGR_GSYNC_SHIFT       (0x0000001Fu)
#define CSL_MCBSP_SRGR_GSYNC_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SRGR_CLKSP_MASK        (0x40000000u)
#define CSL_MCBSP_SRGR_CLKSP_SHIFT       (0x0000001Eu)
#define CSL_MCBSP_SRGR_CLKSP_RESETVAL    (0x00000000u)

#define CSL_MCBSP_SRGR_CLKSM_MASK        (0x20000000u)
#define CSL_MCBSP_SRGR_CLKSM_SHIFT       (0x0000001Du)
#define CSL_MCBSP_SRGR_CLKSM_RESETVAL    (0x00000001u)

#define CSL_MCBSP_SRGR_FSGM_MASK         (0x10000000u)
#define CSL_MCBSP_SRGR_FSGM_SHIFT        (0x0000001Cu)
#define CSL_MCBSP_SRGR_FSGM_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SRGR_FPER_MASK         (0x0FFF0000u)
#define CSL_MCBSP_SRGR_FPER_SHIFT        (0x00000010u)
#define CSL_MCBSP_SRGR_FPER_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SRGR_FWID_MASK         (0x0000FF00u)
#define CSL_MCBSP_SRGR_FWID_SHIFT        (0x00000008u)
#define CSL_MCBSP_SRGR_FWID_RESETVAL     (0x00000000u)

#define CSL_MCBSP_SRGR_CLKGDV_MASK       (0x000000FFu)
#define CSL_MCBSP_SRGR_CLKGDV_SHIFT      (0x00000000u)
#define CSL_MCBSP_SRGR_CLKGDV_RESETVAL   (0x00000001u)

#define CSL_MCBSP_SRGR_RESETVAL          (0x20000001u)

/* MCR */

#define CSL_MCBSP_MCR_XMCME_MASK         (0x02000000u)
#define CSL_MCBSP_MCR_XMCME_SHIFT        (0x00000019u)
#define CSL_MCBSP_MCR_XMCME_RESETVAL     (0x00000000u)

/*----XMCME Tokens----*/
#define CSL_MCBSP_MCR_XMCME_PARTITIONS2  (0x00000000u)

#define CSL_MCBSP_MCR_XPBBLK_MASK        (0x01800000u)
#define CSL_MCBSP_MCR_XPBBLK_SHIFT       (0x00000017u)
#define CSL_MCBSP_MCR_XPBBLK_RESETVAL    (0x00000000u)

#define CSL_MCBSP_MCR_XPABLK_MASK        (0x00600000u)
#define CSL_MCBSP_MCR_XPABLK_SHIFT       (0x00000015u)
#define CSL_MCBSP_MCR_XPABLK_RESETVAL    (0x00000000u)

#define CSL_MCBSP_MCR_XCBLK_MASK         (0x001C0000u)
#define CSL_MCBSP_MCR_XCBLK_SHIFT        (0x00000012u)
#define CSL_MCBSP_MCR_XCBLK_RESETVAL     (0x00000000u)

#define CSL_MCBSP_MCR_XMCM_MASK          (0x00030000u)
#define CSL_MCBSP_MCR_XMCM_SHIFT         (0x00000010u)
#define CSL_MCBSP_MCR_XMCM_RESETVAL      (0x00000000u)

/*----XMCM Tokens----*/
#define CSL_MCBSP_MCR_XMCM_ENABLE        (0x00000000u)
#define CSL_MCBSP_MCR_XMCM_DISABLE       (0x00000001u)
#define CSL_MCBSP_MCR_XMCM_ENABLE_MASK   (0x00000002u)
#define CSL_MCBSP_MCR_XMCM_SYMMETRIC     (0x00000003u)

#define CSL_MCBSP_MCR_RMCME_MASK         (0x00000200u)
#define CSL_MCBSP_MCR_RMCME_SHIFT        (0x00000009u)
#define CSL_MCBSP_MCR_RMCME_RESETVAL     (0x00000000u)

/*----RMCME Tokens----*/
#define CSL_MCBSP_MCR_RMCME_PARTITIONS2  (0x00000000u)
#define CSL_MCBSP_MCR_RMCME_PARTITIONS8  (0x00000001u)

#define CSL_MCBSP_MCR_RPBBLK_MASK        (0x00000180u)
#define CSL_MCBSP_MCR_RPBBLK_SHIFT       (0x00000007u)
#define CSL_MCBSP_MCR_RPBBLK_RESETVAL    (0x00000000u)

#define CSL_MCBSP_MCR_RPABLK_MASK        (0x00000060u)
#define CSL_MCBSP_MCR_RPABLK_SHIFT       (0x00000005u)
#define CSL_MCBSP_MCR_RPABLK_RESETVAL    (0x00000000u)

#define CSL_MCBSP_MCR_RCBLK_MASK         (0x0000001Cu)
#define CSL_MCBSP_MCR_RCBLK_SHIFT        (0x00000002u)
#define CSL_MCBSP_MCR_RCBLK_RESETVAL     (0x00000000u)

#define CSL_MCBSP_MCR_RMCM_MASK          (0x00000001u)
#define CSL_MCBSP_MCR_RMCM_SHIFT         (0x00000000u)
#define CSL_MCBSP_MCR_RMCM_RESETVAL      (0x00000000u)

/*----RMCM Tokens----*/
#define CSL_MCBSP_MCR_RMCM_ENABLE        (0x00000000u)
#define CSL_MCBSP_MCR_RMCM_DISABLE       (0x00000001u)

#define CSL_MCBSP_MCR_RESETVAL           (0x00000000u)

/* RCERE0 */

#define CSL_MCBSP_RCERE0_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE0_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE0_RCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE0_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE0_RCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE0_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE0_RCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE0_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE0_RCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE0_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE0_RCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE0_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE0_RCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE0_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE0_RCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE0_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE0_RCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE0_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE0_RCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE0_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE0_RCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE0_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE0_RCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE0_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE0_RCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE0_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE0_RCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE0_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE0_RCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE0_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE0_RCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE0_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE0_RCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE0_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE0_RCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE0_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE0_RCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE0_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE0_RCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE0_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE0_RCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE0_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE0_RCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE0_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE0_RCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE0_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE0_RCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE0_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE0_RCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE0_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE0_RCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE0_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE0_RCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE0_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE0_RCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE0_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE0_RCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE0_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE0_RCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE0_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE0_RCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE0_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE0_RCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE0_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE0_RCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE0_RESETVAL        (0x00000000u)

/* XCERE0 */

#define CSL_MCBSP_XCERE0_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE0_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE0_XCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE0_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE0_XCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE0_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE0_XCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE0_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE0_XCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE0_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE0_XCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE0_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE0_XCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE0_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE0_XCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE0_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE0_XCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE0_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE0_XCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE0_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE0_XCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE0_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE0_XCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE0_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE0_XCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE0_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE0_XCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE0_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE0_XCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE0_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE0_XCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE0_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE0_XCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE0_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE0_XCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE0_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE0_XCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE0_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE0_XCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE0_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE0_XCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE0_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE0_XCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE0_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE0_XCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE0_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE0_XCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE0_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE0_XCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE0_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE0_XCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE0_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE0_XCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE0_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE0_XCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE0_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE0_XCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE0_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE0_XCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE0_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE0_XCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE0_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE0_XCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE0_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE0_XCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE0_RESETVAL        (0x00000000u)

/* PCR */

#define CSL_MCBSP_PCR_XIOEN_MASK         (0x00002000u)
#define CSL_MCBSP_PCR_XIOEN_SHIFT        (0x0000000Du)
#define CSL_MCBSP_PCR_XIOEN_RESETVAL     (0x00000000u)

#define CSL_MCBSP_PCR_RIOEN_MASK         (0x00001000u)
#define CSL_MCBSP_PCR_RIOEN_SHIFT        (0x0000000Cu)
#define CSL_MCBSP_PCR_RIOEN_RESETVAL     (0x00000000u)

#define CSL_MCBSP_PCR_FSXM_MASK          (0x00000800u)
#define CSL_MCBSP_PCR_FSXM_SHIFT         (0x0000000Bu)
#define CSL_MCBSP_PCR_FSXM_RESETVAL      (0x00000000u)

/*----FSXM Tokens----*/
#define CSL_MCBSP_PCR_FSXM_INPUT         (0x00000000u)
#define CSL_MCBSP_PCR_FSXM_OUTPUT        (0x00000001u)

#define CSL_MCBSP_PCR_FSRM_MASK          (0x00000400u)
#define CSL_MCBSP_PCR_FSRM_SHIFT         (0x0000000Au)
#define CSL_MCBSP_PCR_FSRM_RESETVAL      (0x00000000u)

/*----FSRM Tokens----*/
#define CSL_MCBSP_PCR_FSRM_INPUT         (0x00000000u)
#define CSL_MCBSP_PCR_FSRM_OUTPUT        (0x00000001u)

#define CSL_MCBSP_PCR_CLKXM_MASK         (0x00000200u)
#define CSL_MCBSP_PCR_CLKXM_SHIFT        (0x00000009u)
#define CSL_MCBSP_PCR_CLKXM_RESETVAL     (0x00000000u)

/*----CLKXM Tokens----*/
#define CSL_MCBSP_PCR_CLKXM_INPUT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKXM_OUTPUT       (0x00000001u)

#define CSL_MCBSP_PCR_CLKRM_MASK         (0x00000100u)
#define CSL_MCBSP_PCR_CLKRM_SHIFT        (0x00000008u)
#define CSL_MCBSP_PCR_CLKRM_RESETVAL     (0x00000000u)

/*----CLKRM Tokens----*/
#define CSL_MCBSP_PCR_CLKRM_INPUT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKRM_OUTPUT       (0x00000001u)

#define CSL_MCBSP_PCR_CLKSSTAT_MASK      (0x00000040u)
#define CSL_MCBSP_PCR_CLKSSTAT_SHIFT     (0x00000006u)
#define CSL_MCBSP_PCR_CLKSSTAT_RESETVAL  (0x00000000u)

#define CSL_MCBSP_PCR_DXSTAT_MASK        (0x00000020u)
#define CSL_MCBSP_PCR_DXSTAT_SHIFT       (0x00000005u)
#define CSL_MCBSP_PCR_DXSTAT_RESETVAL    (0x00000000u)

#define CSL_MCBSP_PCR_DRSTAT_MASK        (0x00000010u)
#define CSL_MCBSP_PCR_DRSTAT_SHIFT       (0x00000004u)
#define CSL_MCBSP_PCR_DRSTAT_RESETVAL    (0x00000000u)

#define CSL_MCBSP_PCR_FSXP_MASK          (0x00000008u)
#define CSL_MCBSP_PCR_FSXP_SHIFT         (0x00000003u)
#define CSL_MCBSP_PCR_FSXP_RESETVAL      (0x00000000u)

#define CSL_MCBSP_PCR_FSRP_MASK          (0x00000004u)
#define CSL_MCBSP_PCR_FSRP_SHIFT         (0x00000002u)
#define CSL_MCBSP_PCR_FSRP_RESETVAL      (0x00000000u)

#define CSL_MCBSP_PCR_CLKXP_MASK         (0x00000002u)
#define CSL_MCBSP_PCR_CLKXP_SHIFT        (0x00000001u)
#define CSL_MCBSP_PCR_CLKXP_RESETVAL     (0x00000000u)

#define CSL_MCBSP_PCR_CLKRP_MASK         (0x00000001u)
#define CSL_MCBSP_PCR_CLKRP_SHIFT        (0x00000000u)
#define CSL_MCBSP_PCR_CLKRP_RESETVAL     (0x00000000u)

#define CSL_MCBSP_PCR_RESETVAL           (0x00000000u)

/* RCERE1 */

#define CSL_MCBSP_RCERE1_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE1_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE1_RCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE1_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE1_RCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE1_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE1_RCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE1_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE1_RCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE1_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE1_RCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE1_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE1_RCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE1_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE1_RCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE1_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE1_RCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE1_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE1_RCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE1_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE1_RCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE1_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE1_RCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE1_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE1_RCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE1_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE1_RCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE1_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE1_RCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE1_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE1_RCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE1_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE1_RCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE1_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE1_RCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE1_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE1_RCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE1_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE1_RCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE1_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE1_RCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE1_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE1_RCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE1_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE1_RCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE1_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE1_RCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE1_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE1_RCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE1_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE1_RCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE1_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE1_RCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE1_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE1_RCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE1_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE1_RCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE1_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE1_RCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE1_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE1_RCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE1_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE1_RCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE1_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE1_RCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE1_RESETVAL        (0x00000000u)

/* XCERE1 */

#define CSL_MCBSP_XCERE1_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE1_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE1_XCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE1_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE1_XCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE1_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE1_XCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE1_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE1_XCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE1_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE1_XCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE1_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE1_XCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE1_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE1_XCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE1_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE1_XCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE1_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE1_XCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE1_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE1_XCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE1_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE1_XCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE1_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE1_XCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE1_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE1_XCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE1_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE1_XCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE1_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE1_XCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE1_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE1_XCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE1_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE1_XCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE1_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE1_XCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE1_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE1_XCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE1_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE1_XCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE1_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE1_XCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE1_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE1_XCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE1_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE1_XCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE1_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE1_XCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE1_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE1_XCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE1_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE1_XCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE1_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE1_XCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE1_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE1_XCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE1_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE1_XCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE1_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE1_XCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE1_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE1_XCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE1_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE1_XCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE1_RESETVAL        (0x00000000u)

/* RCERE2 */

#define CSL_MCBSP_RCERE2_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE2_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE2_RCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE2_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE2_RCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE2_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE2_RCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE2_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE2_RCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE2_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE2_RCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE2_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE2_RCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE2_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE2_RCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE2_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE2_RCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE2_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE2_RCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE2_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE2_RCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE2_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE2_RCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE2_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE2_RCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE2_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE2_RCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE2_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE2_RCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE2_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE2_RCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE2_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE2_RCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE2_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE2_RCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE2_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE2_RCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE2_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE2_RCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE2_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE2_RCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE2_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE2_RCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE2_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE2_RCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE2_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE2_RCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE2_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE2_RCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE2_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE2_RCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE2_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE2_RCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE2_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE2_RCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE2_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE2_RCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE2_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE2_RCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE2_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE2_RCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE2_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE2_RCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE2_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE2_RCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE2_RESETVAL        (0x00000000u)

/* XCERE2 */

#define CSL_MCBSP_XCERE2_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE2_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE2_XCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE2_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE2_XCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE2_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE2_XCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE2_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE2_XCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE2_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE2_XCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE2_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE2_XCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE2_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE2_XCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE2_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE2_XCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE2_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE2_XCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE2_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE2_XCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE2_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE2_XCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE2_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE2_XCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE2_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE2_XCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE2_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE2_XCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE2_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE2_XCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE2_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE2_XCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE2_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE2_XCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE2_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE2_XCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE2_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE2_XCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE2_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE2_XCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE2_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE2_XCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE2_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE2_XCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE2_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE2_XCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE2_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE2_XCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE2_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE2_XCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE2_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE2_XCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE2_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE2_XCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE2_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE2_XCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE2_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE2_XCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE2_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE2_XCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE2_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE2_XCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE2_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE2_XCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE2_RESETVAL        (0x00000000u)

/* RCERE3 */

#define CSL_MCBSP_RCERE3_RCE31_MASK      (0x80000000u)
#define CSL_MCBSP_RCERE3_RCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_RCERE3_RCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE30_MASK      (0x40000000u)
#define CSL_MCBSP_RCERE3_RCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_RCERE3_RCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE29_MASK      (0x20000000u)
#define CSL_MCBSP_RCERE3_RCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_RCERE3_RCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE28_MASK      (0x10000000u)
#define CSL_MCBSP_RCERE3_RCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_RCERE3_RCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE27_MASK      (0x08000000u)
#define CSL_MCBSP_RCERE3_RCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_RCERE3_RCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE26_MASK      (0x04000000u)
#define CSL_MCBSP_RCERE3_RCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_RCERE3_RCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE25_MASK      (0x02000000u)
#define CSL_MCBSP_RCERE3_RCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_RCERE3_RCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE24_MASK      (0x01000000u)
#define CSL_MCBSP_RCERE3_RCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_RCERE3_RCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE23_MASK      (0x00800000u)
#define CSL_MCBSP_RCERE3_RCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_RCERE3_RCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE22_MASK      (0x00400000u)
#define CSL_MCBSP_RCERE3_RCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_RCERE3_RCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE21_MASK      (0x00200000u)
#define CSL_MCBSP_RCERE3_RCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_RCERE3_RCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE20_MASK      (0x00100000u)
#define CSL_MCBSP_RCERE3_RCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_RCERE3_RCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE19_MASK      (0x00080000u)
#define CSL_MCBSP_RCERE3_RCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_RCERE3_RCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE18_MASK      (0x00040000u)
#define CSL_MCBSP_RCERE3_RCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_RCERE3_RCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE17_MASK      (0x00020000u)
#define CSL_MCBSP_RCERE3_RCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_RCERE3_RCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE16_MASK      (0x00010000u)
#define CSL_MCBSP_RCERE3_RCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_RCERE3_RCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE15_MASK      (0x00008000u)
#define CSL_MCBSP_RCERE3_RCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_RCERE3_RCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE14_MASK      (0x00004000u)
#define CSL_MCBSP_RCERE3_RCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_RCERE3_RCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE13_MASK      (0x00002000u)
#define CSL_MCBSP_RCERE3_RCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_RCERE3_RCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE12_MASK      (0x00001000u)
#define CSL_MCBSP_RCERE3_RCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_RCERE3_RCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE11_MASK      (0x00000800u)
#define CSL_MCBSP_RCERE3_RCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_RCERE3_RCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE10_MASK      (0x00000400u)
#define CSL_MCBSP_RCERE3_RCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_RCERE3_RCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE9_MASK       (0x00000200u)
#define CSL_MCBSP_RCERE3_RCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_RCERE3_RCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE8_MASK       (0x00000100u)
#define CSL_MCBSP_RCERE3_RCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_RCERE3_RCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE7_MASK       (0x00000080u)
#define CSL_MCBSP_RCERE3_RCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_RCERE3_RCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE6_MASK       (0x00000040u)
#define CSL_MCBSP_RCERE3_RCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_RCERE3_RCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE5_MASK       (0x00000020u)
#define CSL_MCBSP_RCERE3_RCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_RCERE3_RCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE4_MASK       (0x00000010u)
#define CSL_MCBSP_RCERE3_RCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_RCERE3_RCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE3_MASK       (0x00000008u)
#define CSL_MCBSP_RCERE3_RCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_RCERE3_RCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE2_MASK       (0x00000004u)
#define CSL_MCBSP_RCERE3_RCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_RCERE3_RCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE1_MASK       (0x00000002u)
#define CSL_MCBSP_RCERE3_RCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_RCERE3_RCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RCE0_MASK       (0x00000001u)
#define CSL_MCBSP_RCERE3_RCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_RCERE3_RCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_RCERE3_RESETVAL        (0x00000000u)

/* XCERE3 */

#define CSL_MCBSP_XCERE3_XCE31_MASK      (0x80000000u)
#define CSL_MCBSP_XCERE3_XCE31_SHIFT     (0x0000001Fu)
#define CSL_MCBSP_XCERE3_XCE31_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE30_MASK      (0x40000000u)
#define CSL_MCBSP_XCERE3_XCE30_SHIFT     (0x0000001Eu)
#define CSL_MCBSP_XCERE3_XCE30_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE29_MASK      (0x20000000u)
#define CSL_MCBSP_XCERE3_XCE29_SHIFT     (0x0000001Du)
#define CSL_MCBSP_XCERE3_XCE29_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE28_MASK      (0x10000000u)
#define CSL_MCBSP_XCERE3_XCE28_SHIFT     (0x0000001Cu)
#define CSL_MCBSP_XCERE3_XCE28_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE27_MASK      (0x08000000u)
#define CSL_MCBSP_XCERE3_XCE27_SHIFT     (0x0000001Bu)
#define CSL_MCBSP_XCERE3_XCE27_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE26_MASK      (0x04000000u)
#define CSL_MCBSP_XCERE3_XCE26_SHIFT     (0x0000001Au)
#define CSL_MCBSP_XCERE3_XCE26_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE25_MASK      (0x02000000u)
#define CSL_MCBSP_XCERE3_XCE25_SHIFT     (0x00000019u)
#define CSL_MCBSP_XCERE3_XCE25_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE24_MASK      (0x01000000u)
#define CSL_MCBSP_XCERE3_XCE24_SHIFT     (0x00000018u)
#define CSL_MCBSP_XCERE3_XCE24_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE23_MASK      (0x00800000u)
#define CSL_MCBSP_XCERE3_XCE23_SHIFT     (0x00000017u)
#define CSL_MCBSP_XCERE3_XCE23_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE22_MASK      (0x00400000u)
#define CSL_MCBSP_XCERE3_XCE22_SHIFT     (0x00000016u)
#define CSL_MCBSP_XCERE3_XCE22_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE21_MASK      (0x00200000u)
#define CSL_MCBSP_XCERE3_XCE21_SHIFT     (0x00000015u)
#define CSL_MCBSP_XCERE3_XCE21_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE20_MASK      (0x00100000u)
#define CSL_MCBSP_XCERE3_XCE20_SHIFT     (0x00000014u)
#define CSL_MCBSP_XCERE3_XCE20_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE19_MASK      (0x00080000u)
#define CSL_MCBSP_XCERE3_XCE19_SHIFT     (0x00000013u)
#define CSL_MCBSP_XCERE3_XCE19_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE18_MASK      (0x00040000u)
#define CSL_MCBSP_XCERE3_XCE18_SHIFT     (0x00000012u)
#define CSL_MCBSP_XCERE3_XCE18_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE17_MASK      (0x00020000u)
#define CSL_MCBSP_XCERE3_XCE17_SHIFT     (0x00000011u)
#define CSL_MCBSP_XCERE3_XCE17_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE16_MASK      (0x00010000u)
#define CSL_MCBSP_XCERE3_XCE16_SHIFT     (0x00000010u)
#define CSL_MCBSP_XCERE3_XCE16_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE15_MASK      (0x00008000u)
#define CSL_MCBSP_XCERE3_XCE15_SHIFT     (0x0000000Fu)
#define CSL_MCBSP_XCERE3_XCE15_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE14_MASK      (0x00004000u)
#define CSL_MCBSP_XCERE3_XCE14_SHIFT     (0x0000000Eu)
#define CSL_MCBSP_XCERE3_XCE14_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE13_MASK      (0x00002000u)
#define CSL_MCBSP_XCERE3_XCE13_SHIFT     (0x0000000Du)
#define CSL_MCBSP_XCERE3_XCE13_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE12_MASK      (0x00001000u)
#define CSL_MCBSP_XCERE3_XCE12_SHIFT     (0x0000000Cu)
#define CSL_MCBSP_XCERE3_XCE12_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE11_MASK      (0x00000800u)
#define CSL_MCBSP_XCERE3_XCE11_SHIFT     (0x0000000Bu)
#define CSL_MCBSP_XCERE3_XCE11_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE10_MASK      (0x00000400u)
#define CSL_MCBSP_XCERE3_XCE10_SHIFT     (0x0000000Au)
#define CSL_MCBSP_XCERE3_XCE10_RESETVAL  (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE9_MASK       (0x00000200u)
#define CSL_MCBSP_XCERE3_XCE9_SHIFT      (0x00000009u)
#define CSL_MCBSP_XCERE3_XCE9_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE8_MASK       (0x00000100u)
#define CSL_MCBSP_XCERE3_XCE8_SHIFT      (0x00000008u)
#define CSL_MCBSP_XCERE3_XCE8_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE7_MASK       (0x00000080u)
#define CSL_MCBSP_XCERE3_XCE7_SHIFT      (0x00000007u)
#define CSL_MCBSP_XCERE3_XCE7_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE6_MASK       (0x00000040u)
#define CSL_MCBSP_XCERE3_XCE6_SHIFT      (0x00000006u)
#define CSL_MCBSP_XCERE3_XCE6_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE5_MASK       (0x00000020u)
#define CSL_MCBSP_XCERE3_XCE5_SHIFT      (0x00000005u)
#define CSL_MCBSP_XCERE3_XCE5_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE4_MASK       (0x00000010u)
#define CSL_MCBSP_XCERE3_XCE4_SHIFT      (0x00000004u)
#define CSL_MCBSP_XCERE3_XCE4_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE3_MASK       (0x00000008u)
#define CSL_MCBSP_XCERE3_XCE3_SHIFT      (0x00000003u)
#define CSL_MCBSP_XCERE3_XCE3_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE2_MASK       (0x00000004u)
#define CSL_MCBSP_XCERE3_XCE2_SHIFT      (0x00000002u)
#define CSL_MCBSP_XCERE3_XCE2_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE1_MASK       (0x00000002u)
#define CSL_MCBSP_XCERE3_XCE1_SHIFT      (0x00000001u)
#define CSL_MCBSP_XCERE3_XCE1_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_XCE0_MASK       (0x00000001u)
#define CSL_MCBSP_XCERE3_XCE0_SHIFT      (0x00000000u)
#define CSL_MCBSP_XCERE3_XCE0_RESETVAL   (0x00000000u)

#define CSL_MCBSP_XCERE3_RESETVAL        (0x00000000u)

#endif
