/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_memprot_L1P.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for MEMPROT_L1P
 *
 */
#ifndef _CSLR_MEMPROT_L1P_H_
#define _CSLR_MEMPROT_L1P_H_

#include <cslr.h>
#include <tistdtypes.h>


/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 MPFAR;
    volatile Uint32 MPFSR;
    volatile Uint32 MPFCR;
    volatile Uint8 RSVD0[244];
    volatile Uint32 MPLK0;
    volatile Uint32 MPLK1;
    volatile Uint32 MPLK2;
    volatile Uint32 MPLK3;
    volatile Uint32 MPLKCMD;
    volatile Uint32 MPLKSTAT;
    volatile Uint8 RSVD1[296];
    volatile Uint32 MPPA[16];
} CSL_Memprotl1pRegs;

typedef volatile CSL_Memprotl1pRegs  *CSL_Memprotl1pRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* MPFAR */

#define CSL_MEMPROTL1P_MPFAR_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MEMPROTL1P_MPFAR_ADDR_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPFAR_ADDR_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFAR_RESETVAL (0x00000000u)

/* MPFSR */


#define CSL_MEMPROTL1P_MPFSR_FID_MASK (0x0000FE00u)
#define CSL_MEMPROTL1P_MPFSR_FID_SHIFT (0x00000009u)
#define CSL_MEMPROTL1P_MPFSR_FID_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_LOCAL_MASK (0x00000100u)
#define CSL_MEMPROTL1P_MPFSR_LOCAL_SHIFT (0x00000008u)
#define CSL_MEMPROTL1P_MPFSR_LOCAL_RESETVAL (0x00000000u)


#define CSL_MEMPROTL1P_MPFSR_SR_MASK (0x00000020u)
#define CSL_MEMPROTL1P_MPFSR_SR_SHIFT (0x00000005u)
#define CSL_MEMPROTL1P_MPFSR_SR_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_SW_MASK (0x00000010u)
#define CSL_MEMPROTL1P_MPFSR_SW_SHIFT (0x00000004u)
#define CSL_MEMPROTL1P_MPFSR_SW_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_SX_MASK (0x00000008u)
#define CSL_MEMPROTL1P_MPFSR_SX_SHIFT (0x00000003u)
#define CSL_MEMPROTL1P_MPFSR_SX_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_UR_MASK (0x00000004u)
#define CSL_MEMPROTL1P_MPFSR_UR_SHIFT (0x00000002u)
#define CSL_MEMPROTL1P_MPFSR_UR_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_UW_MASK (0x00000002u)
#define CSL_MEMPROTL1P_MPFSR_UW_SHIFT (0x00000001u)
#define CSL_MEMPROTL1P_MPFSR_UW_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_UX_MASK (0x00000001u)
#define CSL_MEMPROTL1P_MPFSR_UX_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPFSR_UX_RESETVAL (0x00000000u)

#define CSL_MEMPROTL1P_MPFSR_RESETVAL (0x00000000u)

/* MPFCR */


#define CSL_MEMPROTL1P_MPFCR_MPFCLR_MASK (0x00000001u)
#define CSL_MEMPROTL1P_MPFCR_MPFCLR_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPFCR_MPFCLR_RESETVAL (0x00000000u)
/*----MPFCLR Tokens----*/
#define CSL_MEMPROTL1P_MPFCR_MPFCLR_CLEAR (0x00000001u)

#define CSL_MEMPROTL1P_MPFCR_RESETVAL (0x00000000u)

/* MPLK0 */


#define CSL_MEMPROTL1P_MPLK0_RESETVAL (0x00000000u)

/* MPLK1 */


#define CSL_MEMPROTL1P_MPLK1_RESETVAL (0x00000000u)

/* MPLK2 */


#define CSL_MEMPROTL1P_MPLK2_RESETVAL (0x00000000u)

/* MPLK3 */


#define CSL_MEMPROTL1P_MPLK3_RESETVAL (0x00000000u)

/* MPLKCMD */


#define CSL_MEMPROTL1P_MPLKCMD_KEYR_MASK (0x00000004u)
#define CSL_MEMPROTL1P_MPLKCMD_KEYR_SHIFT (0x00000002u)
#define CSL_MEMPROTL1P_MPLKCMD_KEYR_RESETVAL (0x00000000u)
/*----KEYR Tokens----*/
#define CSL_MEMPROTL1P_MPLKCMD_KEYR_YES (0x00000001u)
#define CSL_MEMPROTL1P_MPLKCMD_KEYR_NO (0x00000000u)

#define CSL_MEMPROTL1P_MPLKCMD_LOCK_MASK (0x00000002u)
#define CSL_MEMPROTL1P_MPLKCMD_LOCK_SHIFT (0x00000001u)
#define CSL_MEMPROTL1P_MPLKCMD_LOCK_RESETVAL (0x00000000u)
/*----LOCK Tokens----*/
#define CSL_MEMPROTL1P_MPLKCMD_LOCK_YES (0x00000001u)
#define CSL_MEMPROTL1P_MPLKCMD_LOCK_NO (0x00000000u)

#define CSL_MEMPROTL1P_MPLKCMD_UNLOCK_MASK (0x00000001u)
#define CSL_MEMPROTL1P_MPLKCMD_UNLOCK_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPLKCMD_UNLOCK_RESETVAL (0x00000000u)
/*----UNLOCK Tokens----*/
#define CSL_MEMPROTL1P_MPLKCMD_UNLOCK_YES (0x00000001u)
#define CSL_MEMPROTL1P_MPLKCMD_UNLOCK_NO (0x00000000u)

#define CSL_MEMPROTL1P_MPLKCMD_RESETVAL (0x00000000u)

/* MPLKSTAT */


#define CSL_MEMPROTL1P_MPLKSTAT_LK_MASK (0x00000001u)
#define CSL_MEMPROTL1P_MPLKSTAT_LK_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPLKSTAT_LK_RESETVAL (0x00000000u)
/*----LK Tokens----*/
#define CSL_MEMPROTL1P_MPLKSTAT_LK_YES (0x00000001u)
#define CSL_MEMPROTL1P_MPLKSTAT_LK_NO (0x00000000u)

#define CSL_MEMPROTL1P_MPLKSTAT_RESETVAL (0x00000000u)

/* MPPA */


#define CSL_MEMPROTL1P_MPPA_AID5_MASK (0x00008000u)
#define CSL_MEMPROTL1P_MPPA_AID5_SHIFT (0x0000000Fu)
#define CSL_MEMPROTL1P_MPPA_AID5_RESETVAL (0x00000000u)
/*----AID5 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID5_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID5_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_AID4_MASK (0x00004000u)
#define CSL_MEMPROTL1P_MPPA_AID4_SHIFT (0x0000000Eu)
#define CSL_MEMPROTL1P_MPPA_AID4_RESETVAL (0x00000000u)
/*----AID4 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID4_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID4_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_AID3_MASK (0x00002000u)
#define CSL_MEMPROTL1P_MPPA_AID3_SHIFT (0x0000000Du)
#define CSL_MEMPROTL1P_MPPA_AID3_RESETVAL (0x00000000u)
/*----AID3 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID3_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID3_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_AID2_MASK (0x00001000u)
#define CSL_MEMPROTL1P_MPPA_AID2_SHIFT (0x0000000Cu)
#define CSL_MEMPROTL1P_MPPA_AID2_RESETVAL (0x00000000u)
/*----AID2 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID2_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID2_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_AID1_MASK (0x00000800u)
#define CSL_MEMPROTL1P_MPPA_AID1_SHIFT (0x0000000Bu)
#define CSL_MEMPROTL1P_MPPA_AID1_RESETVAL (0x00000000u)
/*----AID1 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID1_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID1_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_AID0_MASK (0x00000400u)
#define CSL_MEMPROTL1P_MPPA_AID0_SHIFT (0x0000000Au)
#define CSL_MEMPROTL1P_MPPA_AID0_RESETVAL (0x00000000u)
/*----AID0 Tokens----*/
#define CSL_MEMPROTL1P_MPPA_AID0_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_AID0_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_ADX_MASK (0x00000200u)
#define CSL_MEMPROTL1P_MPPA_ADX_SHIFT (0x00000009u)
#define CSL_MEMPROTL1P_MPPA_ADX_RESETVAL (0x00000000u)
/*----ADX Tokens----*/
#define CSL_MEMPROTL1P_MPPA_ADX_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_ADX_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_LOCAL_MASK (0x00000100u)
#define CSL_MEMPROTL1P_MPPA_LOCAL_SHIFT (0x00000008u)
#define CSL_MEMPROTL1P_MPPA_LOCAL_RESETVAL (0x00000000u)
/*----LOCAL Tokens----*/
#define CSL_MEMPROTL1P_MPPA_LOCAL_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_LOCAL_YES (0x00000001u)


#define CSL_MEMPROTL1P_MPPA_SR_MASK (0x00000020u)
#define CSL_MEMPROTL1P_MPPA_SR_SHIFT (0x00000005u)
#define CSL_MEMPROTL1P_MPPA_SR_RESETVAL (0x00000000u)
/*----SR Tokens----*/
#define CSL_MEMPROTL1P_MPPA_SR_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_SR_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_SW_MASK (0x00000010u)
#define CSL_MEMPROTL1P_MPPA_SW_SHIFT (0x00000004u)
#define CSL_MEMPROTL1P_MPPA_SW_RESETVAL (0x00000000u)
/*----SW Tokens----*/
#define CSL_MEMPROTL1P_MPPA_SW_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_SW_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_SX_MASK (0x00000008u)
#define CSL_MEMPROTL1P_MPPA_SX_SHIFT (0x00000003u)
#define CSL_MEMPROTL1P_MPPA_SX_RESETVAL (0x00000000u)
/*----SX Tokens----*/
#define CSL_MEMPROTL1P_MPPA_SX_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_SX_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_UR_MASK (0x00000004u)
#define CSL_MEMPROTL1P_MPPA_UR_SHIFT (0x00000002u)
#define CSL_MEMPROTL1P_MPPA_UR_RESETVAL (0x00000000u)
/*----UR Tokens----*/
#define CSL_MEMPROTL1P_MPPA_UR_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_UR_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_UW_MASK (0x00000002u)
#define CSL_MEMPROTL1P_MPPA_UW_SHIFT (0x00000001u)
#define CSL_MEMPROTL1P_MPPA_UW_RESETVAL (0x00000000u)
/*----UW Tokens----*/
#define CSL_MEMPROTL1P_MPPA_UW_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_UW_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_UX_MASK (0x00000001u)
#define CSL_MEMPROTL1P_MPPA_UX_SHIFT (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_UX_RESETVAL (0x00000000u)
/*----UX Tokens----*/
#define CSL_MEMPROTL1P_MPPA_UX_NO (0x00000000u)
#define CSL_MEMPROTL1P_MPPA_UX_YES (0x00000001u)

#define CSL_MEMPROTL1P_MPPA_RESETVAL (0x00000000u)

#endif
