/*  ===========================================================================
 *  Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005, 2006
 *
 *  Use of this software is controlled by the terms and conditions found
 *  in the license agreement under which this software has been supplied
 *  provided
 *
 *  ===========================================================================
 */

/** ============================================================================
 *   @file  cslr_rac_cfg.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Desciptions for RAC_CFG
 *
 */

#ifndef _CSLR_RAC_CFG_H_
#define _CSLR_RAC_CFG_H_

#include <cslr.h>
#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for OCT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 OCT_W0;
    volatile Uint32 OCT_W1;
    volatile Uint32 OCT_W2;
    volatile Uint8 RSVD0[4];
} CSL_Rac_cfgOctRegs;

/**************************************************************************\
* Register Overlay Structure for OBBT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 OBBT_W0;
    volatile Uint32 OBBT_W1;
    volatile Uint32 OBBT_W2;
    volatile Uint32 OBBT_W3;
    volatile Uint32 OBBT_W4;
    volatile Uint32 OBBT_W5;
    volatile Uint8 RSVD0[8];
} CSL_Rac_cfgObbtRegs;

/**************************************************************************\
* Register Overlay Structure for ODBT 
\**************************************************************************/
typedef struct  {
    volatile Uint32 ODBT_W0;
    volatile Uint32 ODBT_W1;
    volatile Uint32 ODBT_W2;
    volatile Uint32 ODBT_W3;
} CSL_Rac_cfgOdbtRegs;

/**************************************************************************\
* Register Overlay Structure for PST 
\**************************************************************************/
typedef struct  {
    volatile Uint32 PST_W0;
    volatile Uint32 PST_W1;
    volatile Uint32 PST_W2;
    volatile Uint8 RSVD0[4];
} CSL_Rac_cfgPstRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 FE_PID;
    volatile Uint32 FE_ENA;
    volatile Uint32 FE_ID_DEPTH;
    volatile Uint32 FE_MAX;
    volatile Uint32 FE_STAT;
    volatile Uint32 FE_WCFG;
    volatile Uint32 FE_WST;
    volatile Uint32 FE_INT;
    volatile Uint8 RSVD0[65504];
    CSL_Rac_cfgOctRegs OCT[768];
    CSL_Rac_cfgObbtRegs OBBT[32];
    CSL_Rac_cfgOdbtRegs ODBT[32];
    volatile Uint8 RSVD1[2560];
    CSL_Rac_cfgPstRegs PST[256];
    volatile Uint8 RSVD2[12288];
    volatile Uint32 BETI_ENA;
    volatile Uint32 BETI_STAT;
    volatile Uint8 RSVD3[8];
    volatile Uint32 BETI_MIN_WCFG;
    volatile Uint32 BETI_MIN_WST[2];
    volatile Uint8 RSVD4[4];
    volatile Uint32 BETI_EOTI_STAT[3];
    volatile Uint32 BETI_NEW_OD;
    volatile Uint32 BETI_OBBT_STAT;
    volatile Uint32 BETI_OBBT_REQ;
    volatile Uint32 BETI_OBBT_REQS;
    volatile Uint32 BETI_OBBTS;
    volatile Uint32 BETI_ODBT_STAT;
    volatile Uint32 BETI_ODBT_REQ;
    volatile Uint32 BETI_ODBT_REQS;
    volatile Uint32 BETI_ODBTS;
	volatile Uint8 RSVD10[176];
	volatile Uint32 HP_FD_CTL_PRIO;
	volatile Uint8 RSVD11[4];
	volatile Uint32 HP_FPE_PRIO;
	volatile Uint8 RSVD12[20];
	volatile Uint32 LP_FD_CTL_PRIO;
	volatile Uint32 LP_FD_DATA_PRIO;
	volatile Uint32 LP_FPE_PRIO;
	volatile Uint32 LP_FT_PRIO;
	volatile Uint32 LP_PM_PRIO;
	volatile Uint32 LP_PD_PRIO;
	volatile Uint32 LP_SPE_PRIO;
	volatile Uint32 LP_SIP_PRIO;
	volatile Uint8 RSVD5[3776];
    volatile Uint32 BEII_ENA;
    volatile Uint32 BEII_MINT_ENA;
    volatile Uint32 BEII_INT_MSK[3];
    volatile Uint32 BEII_INT_STAT[3];
    volatile Uint8 RSVD6[4064];
    volatile Uint32 CFG_TOT;
    volatile Uint32 CFG_WRIT;
    volatile Uint32 CFG_READ;
    volatile Uint8 RSVD7[4];
    volatile Uint32 SLV_TOT;
    volatile Uint32 SLV_WRIT;
    volatile Uint32 SLV_READ;
    volatile Uint8 RSVD8[4];
    volatile Uint32 MST_TOT_LP;
    volatile Uint32 MST_TOT_HP;
    volatile Uint8 RSVD9[216];
    volatile Uint32 IGNORE_EMU;
} CSL_Rac_cfgRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* FE_PID */

#define CSL_RAC_CFG_FE_PID_RESETVAL      (0x00000000u)

/* FE_ENA */

#define CSL_RAC_CFG_FE_ENA_ENABLE_MASK   (0x00000001u)
#define CSL_RAC_CFG_FE_ENA_ENABLE_SHIFT  (0x00000000u)
#define CSL_RAC_CFG_FE_ENA_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_RAC_CFG_FE_ENA_ENABLE_DISABLE (0x00000000u)
#define CSL_RAC_CFG_FE_ENA_ENABLE_ENABLE (0x00000001u)

#define CSL_RAC_CFG_FE_ENA_RESETVAL      (0x00000000u)

/* FE_ID_DEPTH */

#define CSL_RAC_CFG_FE_ID_DEPTH_IB_DEPTH_MASK (0x0000000Fu)
#define CSL_RAC_CFG_FE_ID_DEPTH_IB_DEPTH_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_ID_DEPTH_IB_DEPTH_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_FE_ID_DEPTH_RESETVAL (0x00000000u)

/* FE_MAX */

#define CSL_RAC_CFG_FE_MAX_MAX_CYCLES_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_FE_MAX_MAX_CYCLES_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_MAX_MAX_CYCLES_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_FE_MAX_RESETVAL      (0x00000000u)

/* FE_STAT */

#define CSL_RAC_CFG_FE_STAT_FE_COUNTER_MASK (0xFFFF0000u)
#define CSL_RAC_CFG_FE_STAT_FE_COUNTER_SHIFT (0x00000010u)
#define CSL_RAC_CFG_FE_STAT_FE_COUNTER_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_FE_STAT_GCCP1_STAT_MASK (0x00000008u)
#define CSL_RAC_CFG_FE_STAT_GCCP1_STAT_SHIFT (0x00000003u)
#define CSL_RAC_CFG_FE_STAT_GCCP1_STAT_RESETVAL (0x00000000u)

/*----GCCP1_STAT Tokens----*/
#define CSL_RAC_CFG_FE_STAT_GCCP1_STAT_IDLE (0x00000000u)
#define CSL_RAC_CFG_FE_STAT_GCCP1_STAT_BUSY (0x00000001u)

#define CSL_RAC_CFG_FE_STAT_GCCP0_STAT_MASK (0x00000004u)
#define CSL_RAC_CFG_FE_STAT_GCCP0_STAT_SHIFT (0x00000002u)
#define CSL_RAC_CFG_FE_STAT_GCCP0_STAT_RESETVAL (0x00000000u)

/*----GCCP0_STAT Tokens----*/
#define CSL_RAC_CFG_FE_STAT_GCCP0_STAT_IDLE (0x00000000u)
#define CSL_RAC_CFG_FE_STAT_GCCP0_STAT_BUSY (0x00000001u)

#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_MASK (0x00000003u)
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_RESETVAL (0x00000001u)

/*----TRANSFER_FSM Tokens----*/
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_WAITING_TIMESTAMP (0x00000000u)
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_RECEIVING_SAMPLES (0x00000001u)
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_READY_TO_START (0x00000002u)
#define CSL_RAC_CFG_FE_STAT_TRANSFER_FSM_START_GCCP (0x00000003u)

#define CSL_RAC_CFG_FE_STAT_RESETVAL     (0x00000001u)

/* FE_WCFG */

#define CSL_RAC_CFG_FE_WCFG_FE_WD_CFG_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_FE_WCFG_FE_WD_CFG_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_WCFG_FE_WD_CFG_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_FE_WCFG_RESETVAL     (0x00000000u)

/* FE_WST */

#define CSL_RAC_CFG_FE_WST_FE_WD_STATUS_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_FE_WST_FE_WD_STATUS_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_WST_FE_WD_STATUS_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_FE_WST_RESETVAL      (0x00000000u)

/* FE_INT */

#define CSL_RAC_CFG_FE_INT_INT_STATUS_MASK (0x00000001u)
#define CSL_RAC_CFG_FE_INT_INT_STATUS_SHIFT (0x00000000u)
#define CSL_RAC_CFG_FE_INT_INT_STATUS_RESETVAL (0x00000000u)

/*----INT_STATUS Tokens----*/
#define CSL_RAC_CFG_FE_INT_INT_STATUS_NO_INT (0x00000000u)

#define CSL_RAC_CFG_FE_INT_RESETVAL      (0x00000000u)

/* OCT_W0 */

#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_MASK (0x60000000u)
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_RESETVAL (0x00000000u)

/*----EOT_INT_ENA Tokens----*/
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_NO_INT (0x00000000u)
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_INT_TO_DSP0 (0x00000001u)
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_INT_TO_DSP1 (0x00000002u)
#define CSL_RAC_CFG_OCT_W0_EOT_INT_ENA_INT_TO_DSP2 (0x00000003u)

#define CSL_RAC_CFG_OCT_W0_OBBT_ID_MASK  (0x1F000000u)
#define CSL_RAC_CFG_OCT_W0_OBBT_ID_SHIFT (0x00000018u)
#define CSL_RAC_CFG_OCT_W0_OBBT_ID_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W0_PST_PTR_MASK  (0x00FF0000u)
#define CSL_RAC_CFG_OCT_W0_PST_PTR_SHIFT (0x00000010u)
#define CSL_RAC_CFG_OCT_W0_PST_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W0_OCT_OD_FIELD_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_OCT_W0_OCT_OD_FIELD_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OCT_W0_OCT_OD_FIELD_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W0_RESETVAL      (0x00000000u)

/* OCT_W1 */

#define CSL_RAC_CFG_OCT_W1_E_OBBT_WWAC_MASK (0x0C000000u)
#define CSL_RAC_CFG_OCT_W1_E_OBBT_WWAC_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_OCT_W1_E_OBBT_WWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_MASK (0x03000000u)
#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_SHIFT (0x00000018u)
#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_RESETVAL (0x00000000u)

/*----E_PTR_STATUS Tokens----*/
#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_OPEN (0x00000000u)
#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_CLOSED (0x00000001u)
#define CSL_RAC_CFG_OCT_W1_E_PTR_STATUS_LOCKED (0x00000002u)

#define CSL_RAC_CFG_OCT_W1_E_WR_PTR_MASK (0x00FFFFFFu)
#define CSL_RAC_CFG_OCT_W1_E_WR_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OCT_W1_E_WR_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W1_RESETVAL      (0x00000000u)

/* OCT_W2 */

#define CSL_RAC_CFG_OCT_W2_O_OBBT_WWAC_MASK (0x0C000000u)
#define CSL_RAC_CFG_OCT_W2_O_OBBT_WWAC_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_OCT_W2_O_OBBT_WWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_MASK (0x03000000u)
#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_SHIFT (0x00000018u)
#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_RESETVAL (0x00000000u)

/*----O_PTR_STATUS Tokens----*/
#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_OPEN (0x00000000u)
#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_CLOSED (0x00000001u)
#define CSL_RAC_CFG_OCT_W2_O_PTR_STATUS_LOCKED (0x00000002u)

#define CSL_RAC_CFG_OCT_W2_O_WR_PTR_MASK (0x00FFFFFFu)
#define CSL_RAC_CFG_OCT_W2_O_WR_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OCT_W2_O_WR_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OCT_W2_RESETVAL      (0x00000000u)

/* OBBT_W0 */

#define CSL_RAC_CFG_OBBT_W0_START_AD_MASK (0xFFFFFFFFu)
#define CSL_RAC_CFG_OBBT_W0_START_AD_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W0_START_AD_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W0_RESETVAL     (0x00000000u)

/* OBBT_W1 */

#define CSL_RAC_CFG_OBBT_W1_BUFF_SIZE_MASK (0x00FFFFFFu)
#define CSL_RAC_CFG_OBBT_W1_BUFF_SIZE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W1_BUFF_SIZE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W1_RESETVAL     (0x00000000u)

/* OBBT_W2 */

#define CSL_RAC_CFG_OBBT_W2_ODBT_ID2_MASK (0x00007C00u)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID2_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID2_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W2_ODBT_ID1_MASK (0x000003E0u)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID1_SHIFT (0x00000005u)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID1_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W2_ODBT_ID0_MASK (0x0000001Fu)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W2_ODBT_ID0_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W2_RESETVAL     (0x00000000u)

/* OBBT_W3 */

#define CSL_RAC_CFG_OBBT_W3_WWAC_MASK    (0x03000000u)
#define CSL_RAC_CFG_OBBT_W3_WWAC_SHIFT   (0x00000018u)
#define CSL_RAC_CFG_OBBT_W3_WWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W3_WR_PTR_MASK  (0x00FFFFFFu)
#define CSL_RAC_CFG_OBBT_W3_WR_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W3_WR_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W3_RESETVAL     (0x00000000u)

/* OBBT_W4 */

#define CSL_RAC_CFG_OBBT_W4_CHECK_ENA_MASK (0x04000000u)
#define CSL_RAC_CFG_OBBT_W4_CHECK_ENA_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_OBBT_W4_CHECK_ENA_RESETVAL (0x00000000u)

/*----CHECK_ENA Tokens----*/
#define CSL_RAC_CFG_OBBT_W4_CHECK_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_OBBT_W4_CHECK_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_OBBT_W4_RWAC_MASK    (0x03000000u)
#define CSL_RAC_CFG_OBBT_W4_RWAC_SHIFT   (0x00000018u)
#define CSL_RAC_CFG_OBBT_W4_RWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W4_RD_PTR_MASK  (0x00FFFFFFu)
#define CSL_RAC_CFG_OBBT_W4_RD_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W4_RD_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W4_RESETVAL     (0x00000000u)

/* OBBT_W5 */

#define CSL_RAC_CFG_OBBT_W5_STATS_ENA_MASK (0x00000010u)
#define CSL_RAC_CFG_OBBT_W5_STATS_ENA_SHIFT (0x00000004u)
#define CSL_RAC_CFG_OBBT_W5_STATS_ENA_RESETVAL (0x00000000u)

/*----STATS_ENA Tokens----*/
#define CSL_RAC_CFG_OBBT_W5_STATS_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_OBBT_W5_STATS_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_OBBT_W5_BUFFER_TYPE_MASK (0x0000000Fu)
#define CSL_RAC_CFG_OBBT_W5_BUFFER_TYPE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_OBBT_W5_BUFFER_TYPE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_OBBT_W5_RESETVAL     (0x00000000u)

/* ODBT_W0 */

#define CSL_RAC_CFG_ODBT_W0_START_AD_MASK (0xFFFFFFFFu)
#define CSL_RAC_CFG_ODBT_W0_START_AD_SHIFT (0x00000000u)
#define CSL_RAC_CFG_ODBT_W0_START_AD_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W0_RESETVAL     (0x00000000u)

/* ODBT_W1 */

#define CSL_RAC_CFG_ODBT_W1_BUFFER_SIZE_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_ODBT_W1_BUFFER_SIZE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_ODBT_W1_BUFFER_SIZE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W1_RESETVAL     (0x00000000u)

/* ODBT_W2 */

#define CSL_RAC_CFG_ODBT_W2_WWAC_MASK    (0x00030000u)
#define CSL_RAC_CFG_ODBT_W2_WWAC_SHIFT   (0x00000010u)
#define CSL_RAC_CFG_ODBT_W2_WWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W2_WR_PTR_MASK  (0x0000FFFFu)
#define CSL_RAC_CFG_ODBT_W2_WR_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_ODBT_W2_WR_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W2_RESETVAL     (0x00000000u)

/* ODBT_W3 */

#define CSL_RAC_CFG_ODBT_W3_CHECK_ENA_MASK (0x00040000u)
#define CSL_RAC_CFG_ODBT_W3_CHECK_ENA_SHIFT (0x00000012u)
#define CSL_RAC_CFG_ODBT_W3_CHECK_ENA_RESETVAL (0x00000000u)

/*----CHECK_ENA Tokens----*/
#define CSL_RAC_CFG_ODBT_W3_CHECK_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_ODBT_W3_CHECK_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_ODBT_W3_RWAC_MASK    (0x00030000u)
#define CSL_RAC_CFG_ODBT_W3_RWAC_SHIFT   (0x00000010u)
#define CSL_RAC_CFG_ODBT_W3_RWAC_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W3_RD_PTR_MASK  (0x0000FFFFu)
#define CSL_RAC_CFG_ODBT_W3_RD_PTR_SHIFT (0x00000000u)
#define CSL_RAC_CFG_ODBT_W3_RD_PTR_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_ODBT_W3_RESETVAL     (0x00000000u)

/* PST_W0 */

#define CSL_RAC_CFG_PST_W0_PREV_SUM_MASK (0xFFFFFFFFu)
#define CSL_RAC_CFG_PST_W0_PREV_SUM_SHIFT (0x00000000u)
#define CSL_RAC_CFG_PST_W0_PREV_SUM_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_PST_W0_RESETVAL      (0x00000000u)

/* PST_W1 */

#define CSL_RAC_CFG_PST_W1_PREV_PEAK_VAL_MASK (0xFFFF0000u)
#define CSL_RAC_CFG_PST_W1_PREV_PEAK_VAL_SHIFT (0x00000010u)
#define CSL_RAC_CFG_PST_W1_PREV_PEAK_VAL_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_PST_W1_PREV_NB_OFF_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_PST_W1_PREV_NB_OFF_SHIFT (0x00000000u)
#define CSL_RAC_CFG_PST_W1_PREV_NB_OFF_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_PST_W1_RESETVAL      (0x00000000u)

/* PST_W2 */

#define CSL_RAC_CFG_PST_W2_PREV_PEAK_IDX_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_PST_W2_PREV_PEAK_IDX_SHIFT (0x00000000u)
#define CSL_RAC_CFG_PST_W2_PREV_PEAK_IDX_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_PST_W2_RESETVAL      (0x00000000u)

/* BETI_ENA */

#define CSL_RAC_CFG_BETI_ENA_ENABLE_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_ENA_ENABLE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_ENA_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_RAC_CFG_BETI_ENA_ENABLE_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BETI_ENA_ENABLE_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BETI_ENA_RESETVAL    (0x00000000u)

/* BETI_STAT */

#define CSL_RAC_CFG_BETI_STAT_STATUS_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_STAT_STATUS_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_STAT_STATUS_RESETVAL (0x00000000u)

/*----STATUS Tokens----*/
#define CSL_RAC_CFG_BETI_STAT_STATUS_DISABLED (0x00000000u)
#define CSL_RAC_CFG_BETI_STAT_STATUS_ENABLED (0x00000001u)

#define CSL_RAC_CFG_BETI_STAT_RESETVAL   (0x00000000u)

/* BETI_MIN_WCFG */

#define CSL_RAC_CFG_BETI_MIN_WCFG_BE_WD_CFG_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_BETI_MIN_WCFG_BE_WD_CFG_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_MIN_WCFG_BE_WD_CFG_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_MIN_WCFG_RESETVAL (0x00000000u)

/* BETI_MIN_WST */

#define CSL_RAC_CFG_BETI_MIN_WST_INT_STAT_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_MIN_WST_INT_STAT_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_MIN_WST_INT_STAT_RESETVAL (0x00000000u)

/*----INT_STAT Tokens----*/
#define CSL_RAC_CFG_BETI_MIN_WST_INT_STAT_NO_INT (0x00000000u)
#define CSL_RAC_CFG_BETI_MIN_WST_INT_STAT_INT_GENERATED (0x00000001u)

#define CSL_RAC_CFG_BETI_MIN_WST_BE_WD_STAT_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_BETI_MIN_WST_BE_WD_STAT_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_MIN_WST_BE_WD_STAT_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_MIN_WST_RESETVAL (0x00000000u)

/* BETI_EOTI_STAT */

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT31_RESETVAL (0x00000000u)

/*----ODBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT31_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT31_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT30_RESETVAL (0x00000000u)

/*----ODBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT30_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT30_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT29_RESETVAL (0x00000000u)

/*----ODBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT29_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT29_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT28_RESETVAL (0x00000000u)

/*----ODBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT28_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT28_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT27_RESETVAL (0x00000000u)

/*----ODBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT27_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT27_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT26_RESETVAL (0x00000000u)

/*----ODBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT26_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT26_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT25_RESETVAL (0x00000000u)

/*----ODBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT25_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT25_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT24_RESETVAL (0x00000000u)

/*----ODBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT24_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT24_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT23_RESETVAL (0x00000000u)

/*----ODBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT23_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT23_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT22_RESETVAL (0x00000000u)

/*----ODBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT22_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT22_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT21_RESETVAL (0x00000000u)

/*----ODBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT21_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT21_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT20_RESETVAL (0x00000000u)

/*----ODBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT20_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT20_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT19_RESETVAL (0x00000000u)

/*----ODBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT19_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT19_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT18_RESETVAL (0x00000000u)

/*----ODBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT18_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT18_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT17_RESETVAL (0x00000000u)

/*----ODBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT17_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT17_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT16_RESETVAL (0x00000000u)

/*----ODBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT16_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT16_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT15_RESETVAL (0x00000000u)

/*----ODBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT15_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT15_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT14_RESETVAL (0x00000000u)

/*----ODBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT14_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT14_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT13_RESETVAL (0x00000000u)

/*----ODBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT13_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT13_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT12_RESETVAL (0x00000000u)

/*----ODBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT12_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT12_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT11_RESETVAL (0x00000000u)

/*----ODBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT11_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT11_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT10_RESETVAL (0x00000000u)

/*----ODBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT10_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT10_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT9_RESETVAL (0x00000000u)

/*----ODBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT9_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT9_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT8_RESETVAL (0x00000000u)

/*----ODBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT8_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT8_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT7_RESETVAL (0x00000000u)

/*----ODBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT7_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT7_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT6_RESETVAL (0x00000000u)

/*----ODBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT6_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT6_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT5_RESETVAL (0x00000000u)

/*----ODBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT5_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT5_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT4_RESETVAL (0x00000000u)

/*----ODBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT4_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT4_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT3_RESETVAL (0x00000000u)

/*----ODBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT3_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT3_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT2_RESETVAL (0x00000000u)

/*----ODBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT2_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT2_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT1_RESETVAL (0x00000000u)

/*----ODBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT1_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT1_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT0_RESETVAL (0x00000000u)

/*----ODBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT0_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_EOTI_STAT_ODBT0_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_EOTI_STAT_RESETVAL (0x00000000u)

/* BETI_NEW_OD */

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT31_RESETVAL (0x00000000u)

/*----ODBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT31_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT31_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT30_RESETVAL (0x00000000u)

/*----ODBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT30_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT30_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT29_RESETVAL (0x00000000u)

/*----ODBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT29_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT29_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT28_RESETVAL (0x00000000u)

/*----ODBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT28_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT28_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT27_RESETVAL (0x00000000u)

/*----ODBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT27_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT27_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT26_RESETVAL (0x00000000u)

/*----ODBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT26_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT26_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT25_RESETVAL (0x00000000u)

/*----ODBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT25_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT25_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT24_RESETVAL (0x00000000u)

/*----ODBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT24_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT24_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT23_RESETVAL (0x00000000u)

/*----ODBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT23_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT23_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT22_RESETVAL (0x00000000u)

/*----ODBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT22_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT22_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT21_RESETVAL (0x00000000u)

/*----ODBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT21_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT21_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT20_RESETVAL (0x00000000u)

/*----ODBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT20_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT20_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT19_RESETVAL (0x00000000u)

/*----ODBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT19_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT19_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT18_RESETVAL (0x00000000u)

/*----ODBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT18_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT18_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT17_RESETVAL (0x00000000u)

/*----ODBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT17_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT17_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT16_RESETVAL (0x00000000u)

/*----ODBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT16_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT16_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT15_RESETVAL (0x00000000u)

/*----ODBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT15_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT15_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT14_RESETVAL (0x00000000u)

/*----ODBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT14_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT14_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT13_RESETVAL (0x00000000u)

/*----ODBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT13_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT13_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT12_RESETVAL (0x00000000u)

/*----ODBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT12_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT12_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT11_RESETVAL (0x00000000u)

/*----ODBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT11_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT11_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT10_RESETVAL (0x00000000u)

/*----ODBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT10_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT10_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT9_RESETVAL (0x00000000u)

/*----ODBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT9_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT9_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT8_RESETVAL (0x00000000u)

/*----ODBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT8_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT8_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT7_RESETVAL (0x00000000u)

/*----ODBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT7_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT7_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT6_RESETVAL (0x00000000u)

/*----ODBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT6_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT6_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT5_RESETVAL (0x00000000u)

/*----ODBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT5_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT5_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT4_RESETVAL (0x00000000u)

/*----ODBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT4_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT4_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT3_RESETVAL (0x00000000u)

/*----ODBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT3_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT3_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT2_RESETVAL (0x00000000u)

/*----ODBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT2_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT2_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT1_RESETVAL (0x00000000u)

/*----ODBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT1_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT1_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_ODBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT0_RESETVAL (0x00000000u)

/*----ODBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT0_NO_NEW_OD (0x00000000u)
#define CSL_RAC_CFG_BETI_NEW_OD_ODBT0_NEW_OD (0x00000001u)

#define CSL_RAC_CFG_BETI_NEW_OD_RESETVAL (0x00000000u)

/* BETI_OBBT_STAT */

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT31_RESETVAL (0x00000000u)

/*----OBBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT31_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT31_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT30_RESETVAL (0x00000000u)

/*----OBBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT30_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT30_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT29_RESETVAL (0x00000000u)

/*----OBBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT29_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT29_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT28_RESETVAL (0x00000000u)

/*----OBBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT28_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT28_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT27_RESETVAL (0x00000000u)

/*----OBBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT27_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT27_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT26_RESETVAL (0x00000000u)

/*----OBBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT26_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT26_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT25_RESETVAL (0x00000000u)

/*----OBBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT25_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT25_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT24_RESETVAL (0x00000000u)

/*----OBBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT24_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT24_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT23_RESETVAL (0x00000000u)

/*----OBBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT23_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT23_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT22_RESETVAL (0x00000000u)

/*----OBBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT22_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT22_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT21_RESETVAL (0x00000000u)

/*----OBBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT21_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT21_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT20_RESETVAL (0x00000000u)

/*----OBBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT20_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT20_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT19_RESETVAL (0x00000000u)

/*----OBBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT19_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT19_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT18_RESETVAL (0x00000000u)

/*----OBBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT18_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT18_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT17_RESETVAL (0x00000000u)

/*----OBBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT17_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT17_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT16_RESETVAL (0x00000000u)

/*----OBBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT16_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT16_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT15_RESETVAL (0x00000000u)

/*----OBBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT15_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT15_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT14_RESETVAL (0x00000000u)

/*----OBBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT14_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT14_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT13_RESETVAL (0x00000000u)

/*----OBBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT13_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT13_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT12_RESETVAL (0x00000000u)

/*----OBBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT12_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT12_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT11_RESETVAL (0x00000000u)

/*----OBBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT11_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT11_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT10_RESETVAL (0x00000000u)

/*----OBBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT10_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT10_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT9_RESETVAL (0x00000000u)

/*----OBBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT9_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT9_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT8_RESETVAL (0x00000000u)

/*----OBBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT8_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT8_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT7_RESETVAL (0x00000000u)

/*----OBBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT7_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT7_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT6_RESETVAL (0x00000000u)

/*----OBBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT6_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT6_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT5_RESETVAL (0x00000000u)

/*----OBBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT5_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT5_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT4_RESETVAL (0x00000000u)

/*----OBBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT4_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT4_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT3_RESETVAL (0x00000000u)

/*----OBBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT3_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT3_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT2_RESETVAL (0x00000000u)

/*----OBBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT2_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT2_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT1_RESETVAL (0x00000000u)

/*----OBBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT1_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT1_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT0_RESETVAL (0x00000000u)

/*----OBBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT0_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_STAT_OBBT0_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_STAT_RESETVAL (0x00000000u)

/* BETI_OBBT_REQ */

#define CSL_RAC_CFG_BETI_OBBT_REQ_CHECK_UPDATE_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_CHECK_UPDATE_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_OBBT_REQ_CHECK_UPDATE_RESETVAL (0x00000000u)

/*----CHECK_UPDATE Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_REQ_CHECK_UPDATE_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_CHECK_UPDATE_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_REQ_ID_UPDATE_MASK (0x7C000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_ID_UPDATE_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_OBBT_REQ_ID_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_OBBT_REQ_RWAC_UPDATE_MASK (0x03000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_RWAC_UPDATE_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_RWAC_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_OBBT_REQ_RD_PTR_UPDATE_MASK (0x00FFFFFFu)
#define CSL_RAC_CFG_BETI_OBBT_REQ_RD_PTR_UPDATE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQ_RD_PTR_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_OBBT_REQ_RESETVAL (0x00000000u)

/* BETI_OBBT_REQS */

#define CSL_RAC_CFG_BETI_OBBT_REQS_REQ_STATUS_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_OBBT_REQS_REQ_STATUS_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQS_REQ_STATUS_RESETVAL (0x00000000u)

/*----REQ_STATUS Tokens----*/
#define CSL_RAC_CFG_BETI_OBBT_REQS_REQ_STATUS_IDLE (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBT_REQS_REQ_STATUS_PENDING (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBT_REQS_RESETVAL (0x00000000u)

/* BETI_OBBTS */

#define CSL_RAC_CFG_BETI_OBBTS_OBBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT31_RESETVAL (0x00000000u)

/*----OBBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT31_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT31_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT30_RESETVAL (0x00000000u)

/*----OBBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT30_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT30_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT29_RESETVAL (0x00000000u)

/*----OBBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT29_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT29_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT28_RESETVAL (0x00000000u)

/*----OBBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT28_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT28_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT27_RESETVAL (0x00000000u)

/*----OBBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT27_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT27_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT26_RESETVAL (0x00000000u)

/*----OBBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT26_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT26_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT25_RESETVAL (0x00000000u)

/*----OBBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT25_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT25_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT24_RESETVAL (0x00000000u)

/*----OBBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT24_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT24_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT23_RESETVAL (0x00000000u)

/*----OBBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT23_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT23_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT22_RESETVAL (0x00000000u)

/*----OBBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT22_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT22_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT21_RESETVAL (0x00000000u)

/*----OBBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT21_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT21_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT20_RESETVAL (0x00000000u)

/*----OBBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT20_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT20_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT19_RESETVAL (0x00000000u)

/*----OBBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT19_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT19_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT18_RESETVAL (0x00000000u)

/*----OBBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT18_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT18_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT17_RESETVAL (0x00000000u)

/*----OBBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT17_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT17_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT16_RESETVAL (0x00000000u)

/*----OBBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT16_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT16_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT15_RESETVAL (0x00000000u)

/*----OBBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT15_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT15_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT14_RESETVAL (0x00000000u)

/*----OBBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT14_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT14_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT13_RESETVAL (0x00000000u)

/*----OBBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT13_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT13_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT12_RESETVAL (0x00000000u)

/*----OBBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT12_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT12_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT11_RESETVAL (0x00000000u)

/*----OBBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT11_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT11_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT10_RESETVAL (0x00000000u)

/*----OBBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT10_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT10_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT9_RESETVAL (0x00000000u)

/*----OBBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT9_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT9_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT8_RESETVAL (0x00000000u)

/*----OBBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT8_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT8_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT7_RESETVAL (0x00000000u)

/*----OBBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT7_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT7_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT6_RESETVAL (0x00000000u)

/*----OBBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT6_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT6_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT5_RESETVAL (0x00000000u)

/*----OBBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT5_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT5_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT4_RESETVAL (0x00000000u)

/*----OBBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT4_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT4_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT3_RESETVAL (0x00000000u)

/*----OBBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT3_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT3_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT2_RESETVAL (0x00000000u)

/*----OBBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT2_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT2_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT1_RESETVAL (0x00000000u)

/*----OBBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT1_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT1_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_OBBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT0_RESETVAL (0x00000000u)

/*----OBBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_OBBTS_OBBT0_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_OBBTS_OBBT0_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_OBBTS_RESETVAL  (0x00000000u)

/* BETI_ODBT_STAT */

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT31_RESETVAL (0x00000000u)

/*----ODBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT31_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT31_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT30_RESETVAL (0x00000000u)

/*----ODBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT30_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT30_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT29_RESETVAL (0x00000000u)

/*----ODBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT29_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT29_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT28_RESETVAL (0x00000000u)

/*----ODBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT28_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT28_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT27_RESETVAL (0x00000000u)

/*----ODBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT27_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT27_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT26_RESETVAL (0x00000000u)

/*----ODBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT26_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT26_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT25_RESETVAL (0x00000000u)

/*----ODBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT25_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT25_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT24_RESETVAL (0x00000000u)

/*----ODBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT24_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT24_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT23_RESETVAL (0x00000000u)

/*----ODBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT23_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT23_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT22_RESETVAL (0x00000000u)

/*----ODBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT22_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT22_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT21_RESETVAL (0x00000000u)

/*----ODBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT21_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT21_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT20_RESETVAL (0x00000000u)

/*----ODBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT20_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT20_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT19_RESETVAL (0x00000000u)

/*----ODBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT19_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT19_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT18_RESETVAL (0x00000000u)

/*----ODBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT18_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT18_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT17_RESETVAL (0x00000000u)

/*----ODBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT17_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT17_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT16_RESETVAL (0x00000000u)

/*----ODBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT16_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT16_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT15_RESETVAL (0x00000000u)

/*----ODBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT15_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT15_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT14_RESETVAL (0x00000000u)

/*----ODBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT14_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT14_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT13_RESETVAL (0x00000000u)

/*----ODBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT13_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT13_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT12_RESETVAL (0x00000000u)

/*----ODBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT12_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT12_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT11_RESETVAL (0x00000000u)

/*----ODBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT11_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT11_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT10_RESETVAL (0x00000000u)

/*----ODBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT10_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT10_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT9_RESETVAL (0x00000000u)

/*----ODBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT9_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT9_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT8_RESETVAL (0x00000000u)

/*----ODBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT8_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT8_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT7_RESETVAL (0x00000000u)

/*----ODBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT7_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT7_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT6_RESETVAL (0x00000000u)

/*----ODBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT6_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT6_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT5_RESETVAL (0x00000000u)

/*----ODBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT5_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT5_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT4_RESETVAL (0x00000000u)

/*----ODBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT4_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT4_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT3_RESETVAL (0x00000000u)

/*----ODBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT3_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT3_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT2_RESETVAL (0x00000000u)

/*----ODBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT2_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT2_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT1_RESETVAL (0x00000000u)

/*----ODBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT1_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT1_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT0_RESETVAL (0x00000000u)

/*----ODBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT0_NO_ERROR (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_STAT_ODBT0_BUFFER_IN_ERROR (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_STAT_RESETVAL (0x00000000u)

/* BETI_ODBT_REQ */

#define CSL_RAC_CFG_BETI_ODBT_REQ_CHECK_UPDATE_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_CHECK_UPDATE_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_CHECK_UPDATE_RESETVAL (0x00000000u)

/*----CHECK_UPDATE Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_REQ_CHECK_UPDATE_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_CHECK_UPDATE_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_REQ_ID_UPDATE_MASK (0x007C0000u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_ID_UPDATE_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_ID_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_ODBT_REQ_RWAC_UPDATE_MASK (0x00030000u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_RWAC_UPDATE_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_RWAC_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_ODBT_REQ_RD_PTR_UPDATE_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_BETI_ODBT_REQ_RD_PTR_UPDATE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_REQ_RD_PTR_UPDATE_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_BETI_ODBT_REQ_RESETVAL (0x00000000u)

/* BETI_ODBT_REQS */

#define CSL_RAC_CFG_BETI_ODBT_REQS_REQ_STATUS_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_ODBT_REQS_REQ_STATUS_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_REQS_REQ_STATUS_RESETVAL (0x00000000u)

/*----REQ_STATUS Tokens----*/
#define CSL_RAC_CFG_BETI_ODBT_REQS_REQ_STATUS_IDLE (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBT_REQS_REQ_STATUS_PENDING (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBT_REQS_RESETVAL (0x00000000u)

/* BETI_ODBTS */

#define CSL_RAC_CFG_BETI_ODBTS_ODBT31_MASK (0x80000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT31_SHIFT (0x0000001Fu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT31_RESETVAL (0x00000000u)

/*----ODBT31 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT31_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT31_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT30_MASK (0x40000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT30_SHIFT (0x0000001Eu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT30_RESETVAL (0x00000000u)

/*----ODBT30 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT30_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT30_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT29_MASK (0x20000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT29_SHIFT (0x0000001Du)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT29_RESETVAL (0x00000000u)

/*----ODBT29 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT29_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT29_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT28_MASK (0x10000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT28_SHIFT (0x0000001Cu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT28_RESETVAL (0x00000000u)

/*----ODBT28 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT28_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT28_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT27_MASK (0x08000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT27_SHIFT (0x0000001Bu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT27_RESETVAL (0x00000000u)

/*----ODBT27 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT27_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT27_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT26_MASK (0x04000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT26_SHIFT (0x0000001Au)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT26_RESETVAL (0x00000000u)

/*----ODBT26 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT26_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT26_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT25_MASK (0x02000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT25_SHIFT (0x00000019u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT25_RESETVAL (0x00000000u)

/*----ODBT25 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT25_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT25_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT24_MASK (0x01000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT24_SHIFT (0x00000018u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT24_RESETVAL (0x00000000u)

/*----ODBT24 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT24_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT24_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT23_MASK (0x00800000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT23_SHIFT (0x00000017u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT23_RESETVAL (0x00000000u)

/*----ODBT23 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT23_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT23_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT22_MASK (0x00400000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT22_SHIFT (0x00000016u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT22_RESETVAL (0x00000000u)

/*----ODBT22 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT22_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT22_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT21_MASK (0x00200000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT21_SHIFT (0x00000015u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT21_RESETVAL (0x00000000u)

/*----ODBT21 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT21_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT21_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT20_MASK (0x00100000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT20_SHIFT (0x00000014u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT20_RESETVAL (0x00000000u)

/*----ODBT20 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT20_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT20_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT19_MASK (0x00080000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT19_SHIFT (0x00000013u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT19_RESETVAL (0x00000000u)

/*----ODBT19 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT19_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT19_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT18_MASK (0x00040000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT18_SHIFT (0x00000012u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT18_RESETVAL (0x00000000u)

/*----ODBT18 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT18_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT18_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT17_MASK (0x00020000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT17_SHIFT (0x00000011u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT17_RESETVAL (0x00000000u)

/*----ODBT17 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT17_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT17_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT16_MASK (0x00010000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT16_SHIFT (0x00000010u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT16_RESETVAL (0x00000000u)

/*----ODBT16 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT16_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT16_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT15_MASK (0x00008000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT15_SHIFT (0x0000000Fu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT15_RESETVAL (0x00000000u)

/*----ODBT15 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT15_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT15_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT14_MASK (0x00004000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT14_SHIFT (0x0000000Eu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT14_RESETVAL (0x00000000u)

/*----ODBT14 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT14_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT14_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT13_MASK (0x00002000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT13_SHIFT (0x0000000Du)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT13_RESETVAL (0x00000000u)

/*----ODBT13 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT13_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT13_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT12_MASK (0x00001000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT12_SHIFT (0x0000000Cu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT12_RESETVAL (0x00000000u)

/*----ODBT12 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT12_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT12_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT11_MASK (0x00000800u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT11_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT11_RESETVAL (0x00000000u)

/*----ODBT11 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT11_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT11_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT10_MASK (0x00000400u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT10_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT10_RESETVAL (0x00000000u)

/*----ODBT10 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT10_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT10_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT9_MASK (0x00000200u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT9_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT9_RESETVAL (0x00000000u)

/*----ODBT9 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT9_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT9_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT8_MASK (0x00000100u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT8_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT8_RESETVAL (0x00000000u)

/*----ODBT8 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT8_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT8_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT7_MASK (0x00000080u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT7_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT7_RESETVAL (0x00000000u)

/*----ODBT7 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT7_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT7_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT6_MASK (0x00000040u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT6_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT6_RESETVAL (0x00000000u)

/*----ODBT6 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT6_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT6_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT5_MASK (0x00000020u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT5_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT5_RESETVAL (0x00000000u)

/*----ODBT5 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT5_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT5_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT4_MASK (0x00000010u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT4_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT4_RESETVAL (0x00000000u)

/*----ODBT4 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT4_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT4_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT3_MASK (0x00000008u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT3_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT3_RESETVAL (0x00000000u)

/*----ODBT3 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT3_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT3_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT2_MASK (0x00000004u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT2_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT2_RESETVAL (0x00000000u)

/*----ODBT2 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT2_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT2_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT1_MASK (0x00000002u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT1_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT1_RESETVAL (0x00000000u)

/*----ODBT1 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT1_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT1_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_ODBT0_MASK (0x00000001u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT0_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT0_RESETVAL (0x00000000u)

/*----ODBT0 Tokens----*/
#define CSL_RAC_CFG_BETI_ODBTS_ODBT0_UNLOCKED (0x00000000u)
#define CSL_RAC_CFG_BETI_ODBTS_ODBT0_LOCKED (0x00000001u)

#define CSL_RAC_CFG_BETI_ODBTS_RESETVAL  (0x00000000u)

/* BEII_ENA */

#define CSL_RAC_CFG_BEII_ENA_ENABLE_MASK (0x00000001u)
#define CSL_RAC_CFG_BEII_ENA_ENABLE_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BEII_ENA_ENABLE_RESETVAL (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_RAC_CFG_BEII_ENA_ENABLE_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_ENA_ENABLE_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_ENA_RESETVAL    (0x00000000u)

/* BEII_MINT_ENA */

#define CSL_RAC_CFG_BEII_MINT_ENA_DSP2_INT_ENA_MASK (0x00000004u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP2_INT_ENA_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP2_INT_ENA_RESETVAL (0x00000000u)

/*----DSP2_INT_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP2_INT_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP2_INT_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_MINT_ENA_DSP1_INT_ENA_MASK (0x00000002u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP1_INT_ENA_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP1_INT_ENA_RESETVAL (0x00000000u)

/*----DSP1_INT_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP1_INT_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP1_INT_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_MINT_ENA_DSP0_INT_ENA_MASK (0x00000001u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP0_INT_ENA_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP0_INT_ENA_RESETVAL (0x00000000u)

/*----DSP0_INT_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP0_INT_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_MINT_ENA_DSP0_INT_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_MINT_ENA_RESETVAL (0x00000000u)

/* BEII_INT_MSK */

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_WD_ENA_MASK (0x00000800u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_WD_ENA_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_WD_ENA_RESETVAL (0x00000000u)

/*----GCCP1_WD_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_WD_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_WD_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_WD_ENA_MASK (0x00000400u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_WD_ENA_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_WD_ENA_RESETVAL (0x00000000u)

/*----GCCP0_WD_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_WD_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_WD_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_FE_WD_ENA_MASK (0x00000200u)
#define CSL_RAC_CFG_BEII_INT_MSK_FE_WD_ENA_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BEII_INT_MSK_FE_WD_ENA_RESETVAL (0x00000000u)

/*----FE_WD_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_FE_WD_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_FE_WD_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_ODBT_RD_PTR_ENA_MASK (0x00000100u)
#define CSL_RAC_CFG_BEII_INT_MSK_ODBT_RD_PTR_ENA_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BEII_INT_MSK_ODBT_RD_PTR_ENA_RESETVAL (0x00000000u)

/*----ODBT_RD_PTR_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_ODBT_RD_PTR_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_ODBT_RD_PTR_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_OBBT_RD_PTR_ENA_MASK (0x00000080u)
#define CSL_RAC_CFG_BEII_INT_MSK_OBBT_RD_PTR_ENA_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BEII_INT_MSK_OBBT_RD_PTR_ENA_RESETVAL (0x00000000u)

/*----OBBT_RD_PTR_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_OBBT_RD_PTR_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_OBBT_RD_PTR_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_EOT_ENA_MASK (0x00000040u)
#define CSL_RAC_CFG_BEII_INT_MSK_EOT_ENA_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BEII_INT_MSK_EOT_ENA_RESETVAL (0x00000000u)

/*----EOT_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_EOT_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_EOT_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_SEQ_ENA_MASK (0x00000020u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_SEQ_ENA_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_SEQ_ENA_RESETVAL (0x00000000u)

/*----GCCP1_SEQ_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_SEQ_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_SEQ_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_FIFO_OVER_ENA_MASK (0x00000010u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_FIFO_OVER_ENA_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_FIFO_OVER_ENA_RESETVAL (0x00000000u)

/*----GCCP1_FIFO_OVER_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_FIFO_OVER_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_FIFO_OVER_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_CYC_OVER_ENA_MASK (0x00000008u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_CYC_OVER_ENA_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_CYC_OVER_ENA_RESETVAL (0x00000000u)

/*----GCCP1_CYC_OVER_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_CYC_OVER_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP1_CYC_OVER_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_SEQ_ENA_MASK (0x00000004u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_SEQ_ENA_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_SEQ_ENA_RESETVAL (0x00000000u)

/*----GCCP0_SEQ_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_SEQ_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_SEQ_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_FIFO_OVER_ENA_MASK (0x00000002u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_FIFO_OVER_ENA_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_FIFO_OVER_ENA_RESETVAL (0x00000000u)

/*----GCCP0_FIFO_OVER_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_FIFO_OVER_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_FIFO_OVER_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_CYC_OVER_ENA_MASK (0x00000001u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_CYC_OVER_ENA_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_CYC_OVER_ENA_RESETVAL (0x00000000u)

/*----GCCP0_CYC_OVER_ENA Tokens----*/
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_CYC_OVER_ENA_DISABLE (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_MSK_GCCP0_CYC_OVER_ENA_ENABLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_MSK_RESETVAL (0x00000000u)

/* BEII_INT_STAT */

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_WD_STAT_MASK (0x00000800u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_WD_STAT_SHIFT (0x0000000Bu)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_WD_STAT_RESETVAL (0x00000000u)

/*----GCCP1_WD_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_WD_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_WD_STAT_MASK (0x00000400u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_WD_STAT_SHIFT (0x0000000Au)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_WD_STAT_RESETVAL (0x00000000u)

/*----GCCP0_WD_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_WD_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_FE_WD_STAT_MASK (0x00000200u)
#define CSL_RAC_CFG_BEII_INT_STAT_FE_WD_STAT_SHIFT (0x00000009u)
#define CSL_RAC_CFG_BEII_INT_STAT_FE_WD_STAT_RESETVAL (0x00000000u)

/*----FE_WD_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_FE_WD_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_ODBT_RD_PTR_STAT_MASK (0x00000100u)
#define CSL_RAC_CFG_BEII_INT_STAT_ODBT_RD_PTR_STAT_SHIFT (0x00000008u)
#define CSL_RAC_CFG_BEII_INT_STAT_ODBT_RD_PTR_STAT_RESETVAL (0x00000000u)

/*----ODBT_RD_PTR_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_ODBT_RD_PTR_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_OBBT_RD_PTR_STAT_MASK (0x00000080u)
#define CSL_RAC_CFG_BEII_INT_STAT_OBBT_RD_PTR_STAT_SHIFT (0x00000007u)
#define CSL_RAC_CFG_BEII_INT_STAT_OBBT_RD_PTR_STAT_RESETVAL (0x00000000u)

/*----OBBT_RD_PTR_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_OBBT_RD_PTR_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_EOT_STAT_MASK (0x00000040u)
#define CSL_RAC_CFG_BEII_INT_STAT_EOT_STAT_SHIFT (0x00000006u)
#define CSL_RAC_CFG_BEII_INT_STAT_EOT_STAT_RESETVAL (0x00000000u)

/*----EOT_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_EOT_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_SEQ_STAT_MASK (0x00000020u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_SEQ_STAT_SHIFT (0x00000005u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_SEQ_STAT_RESETVAL (0x00000000u)

/*----GCCP1_SEQ_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_SEQ_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_FIFO_OVER_STAT_MASK (0x00000010u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_FIFO_OVER_STAT_SHIFT (0x00000004u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_FIFO_OVER_STAT_RESETVAL (0x00000000u)

/*----GCCP1_FIFO_OVER_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_FIFO_OVER_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_CYC_OVER_STAT_MASK (0x00000008u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_CYC_OVER_STAT_SHIFT (0x00000003u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_CYC_OVER_STAT_RESETVAL (0x00000000u)

/*----GCCP1_CYC_OVER_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP1_CYC_OVER_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_SEQ_STAT_MASK (0x00000004u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_SEQ_STAT_SHIFT (0x00000002u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_SEQ_STAT_RESETVAL (0x00000000u)

/*----GCCP0_SEQ_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_SEQ_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_FIFO_OVER_STAT_MASK (0x00000002u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_FIFO_OVER_STAT_SHIFT (0x00000001u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_FIFO_OVER_STAT_RESETVAL (0x00000000u)

/*----GCCP0_FIFO_OVER_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_FIFO_OVER_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_CYC_OVER_STAT_MASK (0x00000001u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_CYC_OVER_STAT_SHIFT (0x00000000u)
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_CYC_OVER_STAT_RESETVAL (0x00000000u)

/*----GCCP0_CYC_OVER_STAT Tokens----*/
#define CSL_RAC_CFG_BEII_INT_STAT_GCCP0_CYC_OVER_STAT_TOGGLE (0x00000001u)

#define CSL_RAC_CFG_BEII_INT_STAT_RESETVAL (0x00000000u)

/* CFG_TOT */

#define CSL_RAC_CFG_CFG_TOT_TOT_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_CFG_TOT_TOT_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_CFG_TOT_TOT_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_CFG_TOT_RESETVAL     (0x00000000u)

/* CFG_WRIT */

#define CSL_RAC_CFG_CFG_WRIT_WR_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_CFG_WRIT_WR_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_CFG_WRIT_WR_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_CFG_WRIT_RESETVAL    (0x00000000u)

/* CFG_READ */

#define CSL_RAC_CFG_CFG_READ_RD_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_CFG_READ_RD_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_CFG_READ_RD_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_CFG_READ_RESETVAL    (0x00000000u)

/* SLV_TOT */

#define CSL_RAC_CFG_SLV_TOT_TOT_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_SLV_TOT_TOT_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_SLV_TOT_TOT_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_SLV_TOT_RESETVAL     (0x00000000u)

/* SLV_WRIT */

#define CSL_RAC_CFG_SLV_WRIT_WR_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_SLV_WRIT_WR_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_SLV_WRIT_WR_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_SLV_WRIT_RESETVAL    (0x00000000u)

/* SLV_READ */

#define CSL_RAC_CFG_SLV_READ_RD_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_SLV_READ_RD_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_SLV_READ_RD_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_SLV_READ_RESETVAL    (0x00000000u)

/* MST_TOT_LP */

#define CSL_RAC_CFG_MST_TOT_LP_TOT_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_MST_TOT_LP_TOT_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_MST_TOT_LP_TOT_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_MST_TOT_LP_RESETVAL  (0x00000000u)

/* MST_TOT_HP */

#define CSL_RAC_CFG_MST_TOT_HP_TOT_ACC_NB_MASK (0x0000FFFFu)
#define CSL_RAC_CFG_MST_TOT_HP_TOT_ACC_NB_SHIFT (0x00000000u)
#define CSL_RAC_CFG_MST_TOT_HP_TOT_ACC_NB_RESETVAL (0x00000000u)

#define CSL_RAC_CFG_MST_TOT_HP_RESETVAL  (0x00000000u)

/* IGNORE_EMU */

#define CSL_RAC_CFG_IGNORE_EMU_IGNORE_EMU_MASK (0x00000001u)
#define CSL_RAC_CFG_IGNORE_EMU_IGNORE_EMU_SHIFT (0x00000000u)
#define CSL_RAC_CFG_IGNORE_EMU_IGNORE_EMU_RESETVAL (0x00000000u)

/*----IGNORE_EMU Tokens----*/
#define CSL_RAC_CFG_IGNORE_EMU_IGNORE_EMU_EMU_ON (0x00000000u)
#define CSL_RAC_CFG_IGNORE_EMU_IGNORE_EMU_EMU_OFF (0x00000001u)

#define CSL_RAC_CFG_IGNORE_EMU_RESETVAL  (0x00000000u)

/* HP_FD_CTL_PRIO */
#define CSL_RAC_CFG_HP_FD_CTL_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_HP_FD_CTL_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_HP_FD_CTL_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_HP_FD_CTL_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_HP_FD_CTL_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_HP_FD_CTL_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_HP_FD_CTL_PRIO_RESETVAL (0x00070007)

/* HP_FPE_PRIO */
#define CSL_RAC_CFG_HP_FPE_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_HP_FPE_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_HP_FPE_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_HP_FPE_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_HP_FPE_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_HP_FPE_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_HP_FPE_PRIO_RESETVAL (0x00070007)

/* LP_FD_CTL_PRIO */
#define CSL_RAC_CFG_LP_FD_CTL_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_FD_CTL_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_FD_CTL_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FD_CTL_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_FD_CTL_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_FD_CTL_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FD_CTL_PRIO_RESETVAL (0x00070007)

/* LP_FD_DATA_PRIO */
#define CSL_RAC_CFG_LP_FD_DATA_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_FD_DATA_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_FD_DATA_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FD_DATA_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_FD_DATA_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_FD_DATA_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FD_DATA_PRIO_RESETVAL (0x00070007)

/* LP_FPE_PRIO */
#define CSL_RAC_CFG_LP_FPE_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_FPE_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_FPE_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FPE_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_FPE_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_FPE_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FPE_PRIO_RESETVAL (0x00070007)

/* LP_FT_PRIO */
#define CSL_RAC_CFG_LP_FT_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_FT_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_FT_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FT_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_FT_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_FT_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_FT_PRIO_RESETVAL (0x00070007)

/* LP_PM_PRIO */
#define CSL_RAC_CFG_LP_PM_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_PM_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_PM_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_PM_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_PM_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_PM_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_PM_PRIO_RESETVAL (0x00070007)

/* LP_PD_PRIO */
#define CSL_RAC_CFG_LP_PD_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_PD_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_PD_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_PD_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_PD_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_PD_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_PD_PRIO_RESETVAL (0x00070007)

/* LP_SPE_PRIO */
#define CSL_RAC_CFG_LP_SPE_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_SPE_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_SPE_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_SPE_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_SPE_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_SPE_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_SPE_PRIO_RESETVAL (0x00070007)

/* LP_SIP_PRIO */
#define CSL_RAC_CFG_LP_SIP_PRIO_DATA_MASK (0x00000007)
#define CSL_RAC_CFG_LP_SIP_PRIO_DATA_SHIFT (0x00000000)
#define CSL_RAC_CFG_LP_SIP_PRIO_DATA_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_SIP_PRIO_OBD_MASK (0x00070000)
#define CSL_RAC_CFG_LP_SIP_PRIO_OBD_SHIFT (0x00000010)
#define CSL_RAC_CFG_LP_SIP_PRIO_OBD_RESETVAL (0x00000007)

#define CSL_RAC_CFG_LP_SIP_PRIO_RESETVAL (0x00070007)

#endif
