#ifndef _CSLR_SEM_H_
#define _CSLR_SEM_H_

#include <cslr.h>
#include <tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint8 RSVD0[8];
    volatile Uint32 EOI;
    volatile Uint8 RSVD1[240];
    volatile Uint32 DIRECT[32];
    volatile Uint8 RSVD2[128];
    volatile Uint32 INDIRECT[32];
    volatile Uint8 RSVD3[128];
    volatile Uint32 QUERY[32];
    volatile Uint8 RSVD4[128];
    volatile Uint32 FLAG[3];
    volatile Uint8 RSVD5[116];
    volatile Uint32 FLAG_SET[3];
    volatile Uint8 RSVD6[116];
    volatile Uint32 ERR;
    volatile Uint32 ERR_CLEAR;
} CSL_SemRegs;

typedef volatile CSL_SemRegs  *CSL_SemRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_SEM_PID_SCHEME_MASK (0xC0000000u)
#define CSL_SEM_PID_SCHEME_SHIFT (0x0000001Eu)
#define CSL_SEM_PID_SCHEME_RESETVAL (0x00000001u)


#define CSL_SEM_PID_FUNC_MASK (0x0FFF0000u)
#define CSL_SEM_PID_FUNC_SHIFT (0x00000010u)
#define CSL_SEM_PID_FUNC_RESETVAL (0x00000802u)

#define CSL_SEM_PID_RTL_MASK (0x0000F800u)
#define CSL_SEM_PID_RTL_SHIFT (0x0000000Bu)
#define CSL_SEM_PID_RTL_RESETVAL (0x00000000u)

#define CSL_SEM_PID_MAJOR_MASK (0x00000700u)
#define CSL_SEM_PID_MAJOR_SHIFT (0x00000008u)
#define CSL_SEM_PID_MAJOR_RESETVAL (0x00000001u)

#define CSL_SEM_PID_CUSTOM_MASK (0x000000C0u)
#define CSL_SEM_PID_CUSTOM_SHIFT (0x00000006u)
#define CSL_SEM_PID_CUSTOM_RESETVAL (0x00000000u)

#define CSL_SEM_PID_MINOR_MASK (0x0000003Fu)
#define CSL_SEM_PID_MINOR_SHIFT (0x00000000u)
#define CSL_SEM_PID_MINOR_RESETVAL (0x00000000u)

#define CSL_SEM_PID_RESETVAL (0x48020100u)

/* EOI */


#define CSL_SEM_EOI_SELECT_INTR_REARM_MASK (0x000000FFu)
#define CSL_SEM_EOI_SELECT_INTR_REARM_SHIFT (0x00000000u)
#define CSL_SEM_EOI_SELECT_INTR_REARM_RESETVAL (0x00000000u)
/*----SELECT_INTR_REARM Tokens----*/
#define CSL_SEM_EOI_SELECT_INTR_REARM_SEM0 (0x00000000u)
#define CSL_SEM_EOI_SELECT_INTR_REARM_SEM1 (0x00000001u)
#define CSL_SEM_EOI_SELECT_INTR_REARM_SEM2 (0x00000002u)
#define CSL_SEM_EOI_SELECT_INTR_REARM_ERR_ALL (0x00000010u)

#define CSL_SEM_EOI_RESETVAL (0x00000000u)

/* DIRECT */


#define CSL_SEM_DIRECT_OWNER_MASK (0x0000FF00u)
#define CSL_SEM_DIRECT_OWNER_SHIFT (0x00000008u)
#define CSL_SEM_DIRECT_OWNER_RESETVAL (0x00000000u)


#define CSL_SEM_DIRECT_FREE_MASK (0x00000001u)
#define CSL_SEM_DIRECT_FREE_SHIFT (0x00000000u)
#define CSL_SEM_DIRECT_FREE_RESETVAL (0x00000001u)

#define CSL_SEM_DIRECT_RESETVAL (0x00000001u)

/* INDIRECT */


#define CSL_SEM_INDIRECT_OWNER_MASK (0x0000FF00u)
#define CSL_SEM_INDIRECT_OWNER_SHIFT (0x00000008u)
#define CSL_SEM_INDIRECT_OWNER_RESETVAL (0x00000000u)


#define CSL_SEM_INDIRECT_FREE_MASK (0x00000001u)
#define CSL_SEM_INDIRECT_FREE_SHIFT (0x00000000u)
#define CSL_SEM_INDIRECT_FREE_RESETVAL (0x00000001u)

#define CSL_SEM_INDIRECT_RESETVAL (0x00000001u)

/* QUERY */


#define CSL_SEM_QUERY_OWNER_MASK (0x0000FF00u)
#define CSL_SEM_QUERY_OWNER_SHIFT (0x00000008u)
#define CSL_SEM_QUERY_OWNER_RESETVAL (0x00000000u)


#define CSL_SEM_QUERY_FREE_MASK (0x00000001u)
#define CSL_SEM_QUERY_FREE_SHIFT (0x00000000u)
#define CSL_SEM_QUERY_FREE_RESETVAL (0x00000001u)

#define CSL_SEM_QUERY_RESETVAL (0x00000001u)

/* FLAG */

#define CSL_SEM_FLAG_F31_MASK (0x80000000u)
#define CSL_SEM_FLAG_F31_SHIFT (0x0000001Fu)
#define CSL_SEM_FLAG_F31_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F30_MASK (0x40000000u)
#define CSL_SEM_FLAG_F30_SHIFT (0x0000001Eu)
#define CSL_SEM_FLAG_F30_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F29_MASK (0x20000000u)
#define CSL_SEM_FLAG_F29_SHIFT (0x0000001Du)
#define CSL_SEM_FLAG_F29_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F28_MASK (0x10000000u)
#define CSL_SEM_FLAG_F28_SHIFT (0x0000001Cu)
#define CSL_SEM_FLAG_F28_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F27_MASK (0x08000000u)
#define CSL_SEM_FLAG_F27_SHIFT (0x0000001Bu)
#define CSL_SEM_FLAG_F27_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F26_MASK (0x04000000u)
#define CSL_SEM_FLAG_F26_SHIFT (0x0000001Au)
#define CSL_SEM_FLAG_F26_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F25_MASK (0x02000000u)
#define CSL_SEM_FLAG_F25_SHIFT (0x00000019u)
#define CSL_SEM_FLAG_F25_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F24_MASK (0x01000000u)
#define CSL_SEM_FLAG_F24_SHIFT (0x00000018u)
#define CSL_SEM_FLAG_F24_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F23_MASK (0x00800000u)
#define CSL_SEM_FLAG_F23_SHIFT (0x00000017u)
#define CSL_SEM_FLAG_F23_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F22_MASK (0x00400000u)
#define CSL_SEM_FLAG_F22_SHIFT (0x00000016u)
#define CSL_SEM_FLAG_F22_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F21_MASK (0x00200000u)
#define CSL_SEM_FLAG_F21_SHIFT (0x00000015u)
#define CSL_SEM_FLAG_F21_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F20_MASK (0x00100000u)
#define CSL_SEM_FLAG_F20_SHIFT (0x00000014u)
#define CSL_SEM_FLAG_F20_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F19_MASK (0x00080000u)
#define CSL_SEM_FLAG_F19_SHIFT (0x00000013u)
#define CSL_SEM_FLAG_F19_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F18_MASK (0x00040000u)
#define CSL_SEM_FLAG_F18_SHIFT (0x00000012u)
#define CSL_SEM_FLAG_F18_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F17_MASK (0x00020000u)
#define CSL_SEM_FLAG_F17_SHIFT (0x00000011u)
#define CSL_SEM_FLAG_F17_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F16_MASK (0x00010000u)
#define CSL_SEM_FLAG_F16_SHIFT (0x00000010u)
#define CSL_SEM_FLAG_F16_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F15_MASK (0x00008000u)
#define CSL_SEM_FLAG_F15_SHIFT (0x0000000Fu)
#define CSL_SEM_FLAG_F15_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F14_MASK (0x00004000u)
#define CSL_SEM_FLAG_F14_SHIFT (0x0000000Eu)
#define CSL_SEM_FLAG_F14_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F13_MASK (0x00002000u)
#define CSL_SEM_FLAG_F13_SHIFT (0x0000000Du)
#define CSL_SEM_FLAG_F13_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F12_MASK (0x00001000u)
#define CSL_SEM_FLAG_F12_SHIFT (0x0000000Cu)
#define CSL_SEM_FLAG_F12_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F11_MASK (0x00000800u)
#define CSL_SEM_FLAG_F11_SHIFT (0x0000000Bu)
#define CSL_SEM_FLAG_F11_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F10_MASK (0x00000400u)
#define CSL_SEM_FLAG_F10_SHIFT (0x0000000Au)
#define CSL_SEM_FLAG_F10_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F9_MASK (0x00000200u)
#define CSL_SEM_FLAG_F9_SHIFT (0x00000009u)
#define CSL_SEM_FLAG_F9_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F8_MASK (0x00000100u)
#define CSL_SEM_FLAG_F8_SHIFT (0x00000008u)
#define CSL_SEM_FLAG_F8_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F7_MASK (0x00000080u)
#define CSL_SEM_FLAG_F7_SHIFT (0x00000007u)
#define CSL_SEM_FLAG_F7_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F6_MASK (0x00000040u)
#define CSL_SEM_FLAG_F6_SHIFT (0x00000006u)
#define CSL_SEM_FLAG_F6_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F5_MASK (0x00000020u)
#define CSL_SEM_FLAG_F5_SHIFT (0x00000005u)
#define CSL_SEM_FLAG_F5_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F4_MASK (0x00000010u)
#define CSL_SEM_FLAG_F4_SHIFT (0x00000004u)
#define CSL_SEM_FLAG_F4_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F3_MASK (0x00000008u)
#define CSL_SEM_FLAG_F3_SHIFT (0x00000003u)
#define CSL_SEM_FLAG_F3_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F2_MASK (0x00000004u)
#define CSL_SEM_FLAG_F2_SHIFT (0x00000002u)
#define CSL_SEM_FLAG_F2_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F1_MASK (0x00000002u)
#define CSL_SEM_FLAG_F1_SHIFT (0x00000001u)
#define CSL_SEM_FLAG_F1_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_F0_MASK (0x00000001u)
#define CSL_SEM_FLAG_F0_SHIFT (0x00000000u)
#define CSL_SEM_FLAG_F0_RESETVAL (0x00000000u)


#define CSL_SEM_FLAG_RESETVAL (0x00000000u)

/* FLAG_SET */

#define CSL_SEM_FLAG_SET_F31_MASK (0x80000000u)
#define CSL_SEM_FLAG_SET_F31_SHIFT (0x0000001Fu)
#define CSL_SEM_FLAG_SET_F31_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F30_MASK (0x40000000u)
#define CSL_SEM_FLAG_SET_F30_SHIFT (0x0000001Eu)
#define CSL_SEM_FLAG_SET_F30_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F29_MASK (0x20000000u)
#define CSL_SEM_FLAG_SET_F29_SHIFT (0x0000001Du)
#define CSL_SEM_FLAG_SET_F29_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F28_MASK (0x10000000u)
#define CSL_SEM_FLAG_SET_F28_SHIFT (0x0000001Cu)
#define CSL_SEM_FLAG_SET_F28_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F27_MASK (0x08000000u)
#define CSL_SEM_FLAG_SET_F27_SHIFT (0x0000001Bu)
#define CSL_SEM_FLAG_SET_F27_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F26_MASK (0x04000000u)
#define CSL_SEM_FLAG_SET_F26_SHIFT (0x0000001Au)
#define CSL_SEM_FLAG_SET_F26_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F25_MASK (0x02000000u)
#define CSL_SEM_FLAG_SET_F25_SHIFT (0x00000019u)
#define CSL_SEM_FLAG_SET_F25_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F24_MASK (0x01000000u)
#define CSL_SEM_FLAG_SET_F24_SHIFT (0x00000018u)
#define CSL_SEM_FLAG_SET_F24_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F23_MASK (0x00800000u)
#define CSL_SEM_FLAG_SET_F23_SHIFT (0x00000017u)
#define CSL_SEM_FLAG_SET_F23_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F22_MASK (0x00400000u)
#define CSL_SEM_FLAG_SET_F22_SHIFT (0x00000016u)
#define CSL_SEM_FLAG_SET_F22_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F21_MASK (0x00200000u)
#define CSL_SEM_FLAG_SET_F21_SHIFT (0x00000015u)
#define CSL_SEM_FLAG_SET_F21_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F20_MASK (0x00100000u)
#define CSL_SEM_FLAG_SET_F20_SHIFT (0x00000014u)
#define CSL_SEM_FLAG_SET_F20_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F19_MASK (0x00080000u)
#define CSL_SEM_FLAG_SET_F19_SHIFT (0x00000013u)
#define CSL_SEM_FLAG_SET_F19_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F18_MASK (0x00040000u)
#define CSL_SEM_FLAG_SET_F18_SHIFT (0x00000012u)
#define CSL_SEM_FLAG_SET_F18_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F17_MASK (0x00020000u)
#define CSL_SEM_FLAG_SET_F17_SHIFT (0x00000011u)
#define CSL_SEM_FLAG_SET_F17_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F16_MASK (0x00010000u)
#define CSL_SEM_FLAG_SET_F16_SHIFT (0x00000010u)
#define CSL_SEM_FLAG_SET_F16_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F15_MASK (0x00008000u)
#define CSL_SEM_FLAG_SET_F15_SHIFT (0x0000000Fu)
#define CSL_SEM_FLAG_SET_F15_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F14_MASK (0x00004000u)
#define CSL_SEM_FLAG_SET_F14_SHIFT (0x0000000Eu)
#define CSL_SEM_FLAG_SET_F14_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F13_MASK (0x00002000u)
#define CSL_SEM_FLAG_SET_F13_SHIFT (0x0000000Du)
#define CSL_SEM_FLAG_SET_F13_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F12_MASK (0x00001000u)
#define CSL_SEM_FLAG_SET_F12_SHIFT (0x0000000Cu)
#define CSL_SEM_FLAG_SET_F12_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F11_MASK (0x00000800u)
#define CSL_SEM_FLAG_SET_F11_SHIFT (0x0000000Bu)
#define CSL_SEM_FLAG_SET_F11_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F10_MASK (0x00000400u)
#define CSL_SEM_FLAG_SET_F10_SHIFT (0x0000000Au)
#define CSL_SEM_FLAG_SET_F10_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F9_MASK (0x00000200u)
#define CSL_SEM_FLAG_SET_F9_SHIFT (0x00000009u)
#define CSL_SEM_FLAG_SET_F9_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F8_MASK (0x00000100u)
#define CSL_SEM_FLAG_SET_F8_SHIFT (0x00000008u)
#define CSL_SEM_FLAG_SET_F8_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F7_MASK (0x00000080u)
#define CSL_SEM_FLAG_SET_F7_SHIFT (0x00000007u)
#define CSL_SEM_FLAG_SET_F7_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F6_MASK (0x00000040u)
#define CSL_SEM_FLAG_SET_F6_SHIFT (0x00000006u)
#define CSL_SEM_FLAG_SET_F6_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F5_MASK (0x00000020u)
#define CSL_SEM_FLAG_SET_F5_SHIFT (0x00000005u)
#define CSL_SEM_FLAG_SET_F5_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F4_MASK (0x00000010u)
#define CSL_SEM_FLAG_SET_F4_SHIFT (0x00000004u)
#define CSL_SEM_FLAG_SET_F4_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F3_MASK (0x00000008u)
#define CSL_SEM_FLAG_SET_F3_SHIFT (0x00000003u)
#define CSL_SEM_FLAG_SET_F3_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F2_MASK (0x00000004u)
#define CSL_SEM_FLAG_SET_F2_SHIFT (0x00000002u)
#define CSL_SEM_FLAG_SET_F2_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F1_MASK (0x00000002u)
#define CSL_SEM_FLAG_SET_F1_SHIFT (0x00000001u)
#define CSL_SEM_FLAG_SET_F1_RESETVAL (0x00000000u)

#define CSL_SEM_FLAG_SET_F0_MASK (0x00000001u)
#define CSL_SEM_FLAG_SET_F0_SHIFT (0x00000000u)
#define CSL_SEM_FLAG_SET_F0_RESETVAL (0x00000000u)

/*----F Tokens----*/
#define CSL_SEM_FLAG_SET_F_SET (0x00000001u)

#define CSL_SEM_FLAG_SET_RESETVAL (0x00000000u)

/* ERR */


#define CSL_SEM_ERR_FAULTID_MASK (0x0000FF00u)
#define CSL_SEM_ERR_FAULTID_SHIFT (0x00000008u)
#define CSL_SEM_ERR_FAULTID_RESETVAL (0x00000000u)

#define CSL_SEM_ERR_SEMNUM_MASK (0x000000F8u)
#define CSL_SEM_ERR_SEMNUM_SHIFT (0x00000003u)
#define CSL_SEM_ERR_SEMNUM_RESETVAL (0x00000000u)

#define CSL_SEM_ERR_ERR_MASK (0x00000007u)
#define CSL_SEM_ERR_ERR_SHIFT (0x00000000u)
#define CSL_SEM_ERR_ERR_RESETVAL (0x00000000u)
/*----ERR Tokens----*/
#define CSL_SEM_ERR_ERR_NO_ERR (0x00000000u)
#define CSL_SEM_ERR_ERR_ALREADY_FREE (0x00000001u)
#define CSL_SEM_ERR_ERR_CURRENTLY_OWNED (0x00000002u)
#define CSL_SEM_ERR_ERR_ALREADY_OWNED (0x00000003u)
#define CSL_SEM_ERR_ERR_REQ_PEND (0x00000004u)

#define CSL_SEM_ERR_RESETVAL (0x00000000u)

/* ERR_CLEAR */


#define CSL_SEM_ERR_CLEAR_CLRERR_MASK (0x00000001u)
#define CSL_SEM_ERR_CLEAR_CLRERR_SHIFT (0x00000000u)
#define CSL_SEM_ERR_CLEAR_CLRERR_RESETVAL (0x00000000u)
/*----CLRERR Tokens----*/
#define CSL_SEM_ERR_CLEAR_CLRERR_CLEAR (0x00000001u)

#define CSL_SEM_ERR_CLEAR_RESETVAL (0x00000000u)

#endif
