/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_CPPIDMA_GLOBAL_CONFIG_H_
#define _CSLR_CPPIDMA_GLOBAL_CONFIG_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION_REG;
    volatile Uint32 PERF_CONTROL_REG;
    volatile Uint32 EMULATION_CONTROL_REG;
    volatile Uint32 PRIORITY_CONTROL_REG;
    volatile Uint32 QM_BASE_ADDRESS_REG[4];
} CSL_Cppidma_global_configRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVISION_REG */

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMIN_MASK (0x0000003Fu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMIN_SHIFT (0x00000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMIN_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_CUSTOM_MASK (0x000000C0u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_CUSTOM_SHIFT (0x00000006u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_CUSTOM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMAJ_MASK (0x00000700u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMAJ_SHIFT (0x00000008u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVMAJ_RESETVAL (0x00000001u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVRTL_MASK (0x0000F800u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVRTL_SHIFT (0x0000000Bu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_REVRTL_RESETVAL (0x00000016u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_FUNCTION_ID_MASK (0x0FFF0000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_FUNCTION_ID_SHIFT (0x00000010u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_FUNCTION_ID_RESETVAL (0x00000E5Au)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_BU_MASK (0x30000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_BU_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_BU_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_RESERVED_MASK (0xC0000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_RESERVED_SHIFT (0x0000001Eu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_RESERVED_RESETVAL (0x00000001u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_REVISION_REG_RESETVAL (0x4E5AB100u)

/* PERF_CONTROL_REG */

#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_TIMEOUT_CNT_MASK (0x0000FFFFu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_TIMEOUT_CNT_SHIFT (0x00000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_TIMEOUT_CNT_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_WARB_FIFO_DEPTH_MASK (0x003F0000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_WARB_FIFO_DEPTH_SHIFT (0x00000010u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_WARB_FIFO_DEPTH_RESETVAL (0x00000020u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_PERF_CONTROL_REG_RESETVAL (0x00200000u)

/* EMULATION_CONTROL_REG */

#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_FREE_MASK (0x00000001u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_FREE_SHIFT (0x00000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_FREE_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_SOFT_MASK (0x00000002u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_SOFT_SHIFT (0x00000001u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_SOFT_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_LOOPBACK_EN_MASK (0x80000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_LOOPBACK_EN_SHIFT (0x0000001Fu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_LOOPBACK_EN_RESETVAL (0x00000001u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_EMULATION_CONTROL_REG_RESETVAL (0x80000000u)

/* PRIORITY_CONTROL_REG */

#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_TX_PRIORITY_MASK (0x00000007u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_TX_PRIORITY_SHIFT (0x00000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_TX_PRIORITY_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_RX_PRIORITY_MASK (0x00070000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_RX_PRIORITY_SHIFT (0x00000010u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_RX_PRIORITY_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_PRIORITY_CONTROL_REG_RESETVAL (0x00000000u)

/* QM_BASE_ADDRESS_REG */

#define CSL_CPPIDMA_GLOBAL_CONFIG_QM_BASE_ADDRESS_REG_QM_BASE_MASK (0xFFFFFFFFu)
#define CSL_CPPIDMA_GLOBAL_CONFIG_QM_BASE_ADDRESS_REG_QM_BASE_SHIFT (0x00000000u)
#define CSL_CPPIDMA_GLOBAL_CONFIG_QM_BASE_ADDRESS_REG_QM_BASE_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_GLOBAL_CONFIG_QM_BASE_ADDRESS_REG_RESETVAL (0x00000000u)

#endif

