/********************************************************************
* Copyright (C) 2003-2010 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_CPPIDMA_RX_FLOW_CONFIG_H_
#define _CSLR_CPPIDMA_RX_FLOW_CONFIG_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for RX_FLOW_CONFIG
\**************************************************************************/
typedef struct  {
    volatile Uint32 RX_FLOW_CONFIG_REG_A;
    volatile Uint32 RX_FLOW_CONFIG_REG_B;
    volatile Uint32 RX_FLOW_CONFIG_REG_C;
    volatile Uint32 RX_FLOW_CONFIG_REG_D;
    volatile Uint32 RX_FLOW_CONFIG_REG_E;
    volatile Uint32 RX_FLOW_CONFIG_REG_F;
    volatile Uint32 RX_FLOW_CONFIG_REG_G;
    volatile Uint32 RX_FLOW_CONFIG_REG_H;
} CSL_Cppidma_rx_flow_configRx_flow_configRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    CSL_Cppidma_rx_flow_configRx_flow_configRegs RX_FLOW_CONFIG[129];
} CSL_Cppidma_rx_flow_configRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* RX_FLOW_CONFIG_REG_A */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QNUM_MASK (0x00000FFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QNUM_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QMGR_MASK (0x00003000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QMGR_SHIFT (0x0000000Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DEST_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_SOP_OFFSET_MASK (0x01FF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_SOP_OFFSET_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_SOP_OFFSET_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PS_LOCATION_MASK (0x02000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PS_LOCATION_SHIFT (0x00000019u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PS_LOCATION_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DESC_TYPE_MASK (0x0C000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DESC_TYPE_SHIFT (0x0000001Au)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_DESC_TYPE_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_ERROR_HANDLING_MASK (0x10000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_ERROR_HANDLING_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_ERROR_HANDLING_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PSINFO_PRESENT_MASK (0x20000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PSINFO_PRESENT_SHIFT (0x0000001Du)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_PSINFO_PRESENT_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_EINFO_PRESENT_MASK (0x40000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_EINFO_PRESENT_SHIFT (0x0000001Eu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RX_EINFO_PRESENT_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_A_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_B */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_LO_MASK (0x000000FFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_LO_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_LO_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_HI_MASK (0x0000FF00u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_HI_SHIFT (0x00000008u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_DEST_TAG_HI_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_LO_MASK (0x00FF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_LO_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_LO_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_HI_MASK (0xFF000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_HI_SHIFT (0x00000018u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RX_SRC_TAG_HI_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_B_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_C */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SIZE_THRESH_EN_MASK (0x0000000Fu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SIZE_THRESH_EN_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SIZE_THRESH_EN_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_LO_SEL_MASK (0x00070000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_LO_SEL_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_LO_SEL_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_HI_SEL_MASK (0x00700000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_HI_SEL_SHIFT (0x00000014u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_DEST_TAG_HI_SEL_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_LO_SEL_MASK (0x07000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_LO_SEL_SHIFT (0x00000018u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_LO_SEL_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_HI_SEL_MASK (0x70000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_HI_SEL_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RX_SRC_TAG_HI_SEL_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_C_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_D */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QNUM_MASK (0x00000FFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QNUM_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QMGR_MASK (0x00003000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QMGR_SHIFT (0x0000000Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ1_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QNUM_MASK (0x0FFF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QNUM_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QMGR_MASK (0x30000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QMGR_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RX_FDQ0_SZ0_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_D_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_E */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QNUM_MASK (0x00000FFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QNUM_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QMGR_MASK (0x00003000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QMGR_SHIFT (0x0000000Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ3_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QNUM_MASK (0x0FFF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QNUM_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QMGR_MASK (0x30000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QMGR_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RX_FDQ2_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_E_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_F */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH1_MASK (0x0000FFFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH1_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH1_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH0_MASK (0xFFFF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH0_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RX_SIZE_THRESH0_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_F_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_G */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QNUM_MASK (0x00000FFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QNUM_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QMGR_MASK (0x00003000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QMGR_SHIFT (0x0000000Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_FDQ0_SZ1_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_SIZE_THRESH2_MASK (0xFFFF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_SIZE_THRESH2_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RX_SIZE_THRESH2_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_G_RESETVAL (0x00000000u)

/* RX_FLOW_CONFIG_REG_H */

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QNUM_MASK (0x00000FFFu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QNUM_SHIFT (0x00000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QMGR_MASK (0x00003000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QMGR_SHIFT (0x0000000Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ3_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QNUM_MASK (0x0FFF0000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QNUM_SHIFT (0x00000010u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QNUM_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QMGR_MASK (0x30000000u)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QMGR_SHIFT (0x0000001Cu)
#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RX_FDQ0_SZ2_QMGR_RESETVAL (0x00000000u)

#define CSL_CPPIDMA_RX_FLOW_CONFIG_RX_FLOW_CONFIG_REG_H_RESETVAL (0x00000000u)

#endif
