/********************************************************************
* Copyright (C) 2003-2011 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_MPU_H_
#define _CSLR_MPU_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified header file includes as per the RTSC specification
 *      b) Removed Interrupt vector.
 */
#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for prog_region
\**************************************************************************/
typedef struct  {
    volatile Uint32 PROG_START_ADDRESS;
    volatile Uint32 PROG_END_ADDRESS;
    volatile Uint32 PROG_MPPA;
    volatile Uint8 RSVD2[4];
} CSL_MpuProg_regionRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVISION;
    volatile Uint32 CONFIG;
    volatile Uint8 RSVD0[8];
    volatile Uint32 INT_RAW_STATUS_SET;
    volatile Uint32 INT_ENABLED_STATUS_CLEAR;
    volatile Uint32 INT_ENABLE;
    volatile Uint32 INT_ENABLE_CLEAR;
    volatile Uint32 EOI;
    volatile Uint8  RSVD[4];
    volatile Uint8 RSVD1[216];
    volatile Uint32 FIXED_START_ADDRESS;
    volatile Uint32 FIXED_END_ADDRESS;
    volatile Uint32 FIXED_MPPA;
    volatile Uint8 RSVD3[244];
    CSL_MpuProg_regionRegs PROG_REGION[16];
    volatile Uint32 FAULT_ADDRESS;
    volatile Uint32 FAULT_STATUS;
    volatile Uint32 FAULT_CLEAR;
} CSL_MpuRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* prog_start_address */

#define CSL_MPU_PROG_START_ADDRESS_START_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MPU_PROG_START_ADDRESS_START_ADDR_SHIFT (0x00000000u)
#define CSL_MPU_PROG_START_ADDRESS_START_ADDR_RESETVAL (0x00000000u)

#define CSL_MPU_PROG_START_ADDRESS_RESETVAL (0x00000000u)

/* prog_end_address */

#define CSL_MPU_PROG_END_ADDRESS_END_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MPU_PROG_END_ADDRESS_END_ADDR_SHIFT (0x00000000u)
#define CSL_MPU_PROG_END_ADDRESS_END_ADDR_RESETVAL (0x00000000u)

#define CSL_MPU_PROG_END_ADDRESS_RESETVAL (0x00000000u)

/* prog_mppa */

#define CSL_MPU_PROG_MPPA_AID_15_0_MASK  (0x03FFFC00u)
#define CSL_MPU_PROG_MPPA_AID_15_0_SHIFT (0x0000000Au)
#define CSL_MPU_PROG_MPPA_AID_15_0_RESETVAL (0x00000000u)

#define CSL_MPU_PROG_MPPA_AIDX_MASK      (0x00000200u)
#define CSL_MPU_PROG_MPPA_AIDX_SHIFT     (0x00000009u)
#define CSL_MPU_PROG_MPPA_AIDX_RESETVAL  (0x00000000u)

#define CSL_MPU_PROG_MPPA_NS_MASK        (0x00000080u)
#define CSL_MPU_PROG_MPPA_NS_SHIFT       (0x00000007u)
#define CSL_MPU_PROG_MPPA_NS_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_EMU_MASK       (0x00000040u)
#define CSL_MPU_PROG_MPPA_EMU_SHIFT      (0x00000006u)
#define CSL_MPU_PROG_MPPA_EMU_RESETVAL   (0x00000000u)

#define CSL_MPU_PROG_MPPA_SR_MASK        (0x00000020u)
#define CSL_MPU_PROG_MPPA_SR_SHIFT       (0x00000005u)
#define CSL_MPU_PROG_MPPA_SR_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_SW_MASK        (0x00000010u)
#define CSL_MPU_PROG_MPPA_SW_SHIFT       (0x00000004u)
#define CSL_MPU_PROG_MPPA_SW_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_SX_MASK        (0x00000008u)
#define CSL_MPU_PROG_MPPA_SX_SHIFT       (0x00000003u)
#define CSL_MPU_PROG_MPPA_SX_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_UR_MASK        (0x00000004u)
#define CSL_MPU_PROG_MPPA_UR_SHIFT       (0x00000002u)
#define CSL_MPU_PROG_MPPA_UR_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_UW_MASK        (0x00000002u)
#define CSL_MPU_PROG_MPPA_UW_SHIFT       (0x00000001u)
#define CSL_MPU_PROG_MPPA_UW_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_UX_MASK        (0x00000001u)
#define CSL_MPU_PROG_MPPA_UX_SHIFT       (0x00000000u)
#define CSL_MPU_PROG_MPPA_UX_RESETVAL    (0x00000000u)

#define CSL_MPU_PROG_MPPA_RESETVAL       (0x00000000u)

/* revision */

#define CSL_MPU_REVISION_SCHEME_MASK     (0xC0000000u)
#define CSL_MPU_REVISION_SCHEME_SHIFT    (0x0000001Eu)
#define CSL_MPU_REVISION_SCHEME_RESETVAL (0x00000001u)

#define CSL_MPU_REVISION_BU_MASK         (0x30000000u)
#define CSL_MPU_REVISION_BU_SHIFT        (0x0000001Cu)
#define CSL_MPU_REVISION_BU_RESETVAL     (0x00000000u)

#define CSL_MPU_REVISION_MODID_MASK      (0x0FFF0000u)
#define CSL_MPU_REVISION_MODID_SHIFT     (0x00000010u)
#define CSL_MPU_REVISION_MODID_RESETVAL  (0x00000E81u)

#define CSL_MPU_REVISION_RTL_VER_MASK    (0x0000F800u)
#define CSL_MPU_REVISION_RTL_VER_SHIFT   (0x0000000Bu)
#define CSL_MPU_REVISION_RTL_VER_RESETVAL (0x00000000u)

#define CSL_MPU_REVISION_REVMAJ_MASK     (0x00000700u)
#define CSL_MPU_REVISION_REVMAJ_SHIFT    (0x00000008u)
#define CSL_MPU_REVISION_REVMAJ_RESETVAL (0x00000001u)

#define CSL_MPU_REVISION_CUSTOMER_MASK   (0x000000C0u)
#define CSL_MPU_REVISION_CUSTOMER_SHIFT  (0x00000006u)
#define CSL_MPU_REVISION_CUSTOMER_RESETVAL (0x00000000u)

#define CSL_MPU_REVISION_REVMIN_MASK     (0x0000003Fu)
#define CSL_MPU_REVISION_REVMIN_SHIFT    (0x00000000u)
#define CSL_MPU_REVISION_REVMIN_RESETVAL (0x00000001u)

#define CSL_MPU_REVISION_RESETVAL        (0x4E810101u)

/* config */

#define CSL_MPU_CONFIG_ADDRESS_ALIGN_MASK (0xFF000000u)
#define CSL_MPU_CONFIG_ADDRESS_ALIGN_SHIFT (0x00000018u)
#define CSL_MPU_CONFIG_ADDRESS_ALIGN_RESETVAL (0x00000000u)

#define CSL_MPU_CONFIG_NUM_FIXED_MASK    (0x00F00000u)
#define CSL_MPU_CONFIG_NUM_FIXED_SHIFT   (0x00000014u)
#define CSL_MPU_CONFIG_NUM_FIXED_RESETVAL (0x00000000u)

#define CSL_MPU_CONFIG_NUM_PROG_MASK     (0x000F0000u)
#define CSL_MPU_CONFIG_NUM_PROG_SHIFT    (0x00000010u)
#define CSL_MPU_CONFIG_NUM_PROG_RESETVAL (0x00000000u)

#define CSL_MPU_CONFIG_NUM_FIXED_AIDS_MASK (0x0000F000u)
#define CSL_MPU_CONFIG_NUM_FIXED_AIDS_SHIFT (0x0000000Cu)
#define CSL_MPU_CONFIG_NUM_FIXED_AIDS_RESETVAL (0x00000000u)

#define CSL_MPU_CONFIG_ASSUMED_ALLOWED_MASK (0x00000001u)
#define CSL_MPU_CONFIG_ASSUMED_ALLOWED_SHIFT (0x00000000u)
#define CSL_MPU_CONFIG_ASSUMED_ALLOWED_RESETVAL (0x00000001u)

#define CSL_MPU_CONFIG_RESETVAL          (0x00000001u)

/* int_raw_status_set */

#define CSL_MPU_INT_RAW_STATUS_SET_ADDR_ERR_MASK (0x00000002u)
#define CSL_MPU_INT_RAW_STATUS_SET_ADDR_ERR_SHIFT (0x00000001u)
#define CSL_MPU_INT_RAW_STATUS_SET_ADDR_ERR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_RAW_STATUS_SET_PROT_ERR_MASK (0x00000001u)
#define CSL_MPU_INT_RAW_STATUS_SET_PROT_ERR_SHIFT (0x00000000u)
#define CSL_MPU_INT_RAW_STATUS_SET_PROT_ERR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_RAW_STATUS_SET_RESETVAL (0x00000000u)

/* int_enabled_status_clear */

#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_ADDR_ERR_MASK (0x00000002u)
#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_ADDR_ERR_SHIFT (0x00000001u)
#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_ADDR_ERR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_PROT_ERR_MASK (0x00000001u)
#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_PROT_ERR_SHIFT (0x00000000u)
#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_ENABLED_PROT_ERR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLED_STATUS_CLEAR_RESETVAL (0x00000000u)

/* int_enable */

#define CSL_MPU_INT_ENABLE_ADDR_ERR_EN_MASK (0x00000002u)
#define CSL_MPU_INT_ENABLE_ADDR_ERR_EN_SHIFT (0x00000001u)
#define CSL_MPU_INT_ENABLE_ADDR_ERR_EN_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLE_PROT_ERR_EN_MASK (0x00000001u)
#define CSL_MPU_INT_ENABLE_PROT_ERR_EN_SHIFT (0x00000000u)
#define CSL_MPU_INT_ENABLE_PROT_ERR_EN_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLE_RESETVAL      (0x00000000u)

/* int_enable_clear */

#define CSL_MPU_INT_ENABLE_CLEAR_ADDR_ERR_EN_CLR_MASK (0x00000002u)
#define CSL_MPU_INT_ENABLE_CLEAR_ADDR_ERR_EN_CLR_SHIFT (0x00000001u)
#define CSL_MPU_INT_ENABLE_CLEAR_ADDR_ERR_EN_CLR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLE_CLEAR_PROT_ERR_EN_CLR_MASK (0x00000001u)
#define CSL_MPU_INT_ENABLE_CLEAR_PROT_ERR_EN_CLR_SHIFT (0x00000000u)
#define CSL_MPU_INT_ENABLE_CLEAR_PROT_ERR_EN_CLR_RESETVAL (0x00000000u)

#define CSL_MPU_INT_ENABLE_CLEAR_RESETVAL (0x00000000u)

/* eoi */

#define CSL_MPU_EOI_EOI_VECTOR_MASK      (0x000000FFu)
#define CSL_MPU_EOI_EOI_VECTOR_SHIFT     (0x00000000u)
#define CSL_MPU_EOI_EOI_VECTOR_RESETVAL  (0x00000000u)

#define CSL_MPU_EOI_RESETVAL             (0x00000000u)

/* fixed_start_address */

#define CSL_MPU_FIXED_START_ADDRESS_START_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MPU_FIXED_START_ADDRESS_START_ADDR_SHIFT (0x00000000u)
#define CSL_MPU_FIXED_START_ADDRESS_START_ADDR_RESETVAL (0x00000000u)

#define CSL_MPU_FIXED_START_ADDRESS_RESETVAL (0x00000000u)

/* fixed_end_address */

#define CSL_MPU_FIXED_END_ADDRESS_END_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MPU_FIXED_END_ADDRESS_END_ADDR_SHIFT (0x00000000u)
#define CSL_MPU_FIXED_END_ADDRESS_END_ADDR_RESETVAL (0x00000000u)

#define CSL_MPU_FIXED_END_ADDRESS_RESETVAL (0x00000000u)

/* fixed_mppa */

#define CSL_MPU_FIXED_MPPA_AID_15_0_MASK (0x03FFFC00u)
#define CSL_MPU_FIXED_MPPA_AID_15_0_SHIFT (0x0000000Au)
#define CSL_MPU_FIXED_MPPA_AID_15_0_RESETVAL (0x00000000u)

#define CSL_MPU_FIXED_MPPA_AIDX_MASK     (0x00000200u)
#define CSL_MPU_FIXED_MPPA_AIDX_SHIFT    (0x00000009u)
#define CSL_MPU_FIXED_MPPA_AIDX_RESETVAL (0x00000000u)

#define CSL_MPU_FIXED_MPPA_NS_MASK       (0x00000080u)
#define CSL_MPU_FIXED_MPPA_NS_SHIFT      (0x00000007u)
#define CSL_MPU_FIXED_MPPA_NS_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_EMU_MASK      (0x00000040u)
#define CSL_MPU_FIXED_MPPA_EMU_SHIFT     (0x00000006u)
#define CSL_MPU_FIXED_MPPA_EMU_RESETVAL  (0x00000000u)

#define CSL_MPU_FIXED_MPPA_SR_MASK       (0x00000020u)
#define CSL_MPU_FIXED_MPPA_SR_SHIFT      (0x00000005u)
#define CSL_MPU_FIXED_MPPA_SR_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_SW_MASK       (0x00000010u)
#define CSL_MPU_FIXED_MPPA_SW_SHIFT      (0x00000004u)
#define CSL_MPU_FIXED_MPPA_SW_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_SX_MASK       (0x00000008u)
#define CSL_MPU_FIXED_MPPA_SX_SHIFT      (0x00000003u)
#define CSL_MPU_FIXED_MPPA_SX_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_UR_MASK       (0x00000004u)
#define CSL_MPU_FIXED_MPPA_UR_SHIFT      (0x00000002u)
#define CSL_MPU_FIXED_MPPA_UR_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_UW_MASK       (0x00000002u)
#define CSL_MPU_FIXED_MPPA_UW_SHIFT      (0x00000001u)
#define CSL_MPU_FIXED_MPPA_UW_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_UX_MASK       (0x00000001u)
#define CSL_MPU_FIXED_MPPA_UX_SHIFT      (0x00000000u)
#define CSL_MPU_FIXED_MPPA_UX_RESETVAL   (0x00000000u)

#define CSL_MPU_FIXED_MPPA_RESETVAL      (0x00000000u)

/* fault_address */

#define CSL_MPU_FAULT_ADDRESS_FAULT_ADDR_MASK (0xFFFFFFFFu)
#define CSL_MPU_FAULT_ADDRESS_FAULT_ADDR_SHIFT (0x00000000u)
#define CSL_MPU_FAULT_ADDRESS_FAULT_ADDR_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_ADDRESS_RESETVAL   (0x00000000u)

/* fault_status */

#define CSL_MPU_FAULT_STATUS_ID_MASK     (0xFF000000u)
#define CSL_MPU_FAULT_STATUS_ID_SHIFT    (0x00000018u)
#define CSL_MPU_FAULT_STATUS_ID_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_STATUS_MSTID_MASK  (0x00FF0000u)
#define CSL_MPU_FAULT_STATUS_MSTID_SHIFT (0x00000010u)
#define CSL_MPU_FAULT_STATUS_MSTID_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_STATUS_PRIVID_MASK (0x00001E00u)
#define CSL_MPU_FAULT_STATUS_PRIVID_SHIFT (0x00000009u)
#define CSL_MPU_FAULT_STATUS_PRIVID_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_STATUS_NS_MASK     (0x00000080u)
#define CSL_MPU_FAULT_STATUS_NS_SHIFT    (0x00000007u)
#define CSL_MPU_FAULT_STATUS_NS_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_STATUS_FAULT_TYPE_MASK (0x0000003Fu)
#define CSL_MPU_FAULT_STATUS_FAULT_TYPE_SHIFT (0x00000000u)
#define CSL_MPU_FAULT_STATUS_FAULT_TYPE_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_STATUS_RESETVAL    (0x00000000u)

/* fault_clear */

#define CSL_MPU_FAULT_CLEAR_FAULT_CLR_MASK (0x00000001u)
#define CSL_MPU_FAULT_CLEAR_FAULT_CLR_SHIFT (0x00000000u)
#define CSL_MPU_FAULT_CLEAR_FAULT_CLR_RESETVAL (0x00000000u)

#define CSL_MPU_FAULT_CLEAR_RESETVAL     (0x00000000u)

#endif
