/********************************************************************
* Copyright (C) 2003-2008 Texas Instruments Incorporated.
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
#ifndef _CSLR_SEM_H_
#define _CSLR_SEM_H_

/* CSL Modification:
 *  The file has been modified from the AUTOGEN file for the following
 *  reasons:-
 *      a) Modified the header file includes to be RTSC compliant
 */

#include <cslr.h>
#include <tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 SEM_PID;
    volatile Uint32 SEM_SCRATCH;
    volatile Uint32 SEM_RST_RUN;
    volatile Uint32 SEM_EOI;
    volatile Uint8 RSVD0[240];
    volatile Uint32 SEM[32];
    volatile Uint8 RSVD1[128];
    volatile Uint32 ISEM[32];
    volatile Uint8 RSVD2[128];
    volatile Uint32 QSEM[32];
    volatile Uint8 RSVD3[128];
    volatile Uint32 SEMFLAGL_CLEAR[4];
    volatile Uint8 RSVD4[112];
    volatile Uint32 SEMFLAGL_SET[4];
    volatile Uint8 RSVD5[112];
    volatile Uint32 SEMERR;
    volatile Uint32 SEMERR_CLEAR;
    volatile Uint32 SEMERR_SET;
} CSL_SemRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SEM_PID */

#define CSL_SEM_SEM_PID_SCHEME_MASK      (0xC0000000u)
#define CSL_SEM_SEM_PID_SCHEME_SHIFT     (0x0000001Eu)

#define CSL_SEM_SEM_PID_RSVD_MASK        (0x30000000u)
#define CSL_SEM_SEM_PID_RSVD_SHIFT       (0x0000001Cu)

#define CSL_SEM_SEM_PID_FUNC_MASK        (0x0FFF0000u)
#define CSL_SEM_SEM_PID_FUNC_SHIFT       (0x00000010u)
#define CSL_SEM_SEM_PID_FUNC_RESETVAL    (0x00000802u)

#define CSL_SEM_SEM_PID_RTL_MASK         (0x0000F800u)
#define CSL_SEM_SEM_PID_RTL_SHIFT        (0x0000000Bu)
#define CSL_SEM_SEM_PID_RTL_RESETVAL     (0x00000000u)

#define CSL_SEM_SEM_PID_MAJOR_MASK       (0x00000700u)
#define CSL_SEM_SEM_PID_MAJOR_SHIFT      (0x00000008u)
#define CSL_SEM_SEM_PID_MAJOR_RESETVAL   (0x00000000u)

#define CSL_SEM_SEM_PID_CUSTOM_MASK      (0x000000C0u)
#define CSL_SEM_SEM_PID_CUSTOM_SHIFT     (0x00000006u)

#define CSL_SEM_SEM_PID_MINOR_MASK       (0x0000003Fu)
#define CSL_SEM_SEM_PID_MINOR_SHIFT      (0x00000000u)
#define CSL_SEM_SEM_PID_MINOR_RESETVAL   (0x00000000u)

#define CSL_SEM_SEM_PID_RESETVAL         (0x08020000u)

/* SEM_SCRATCH */

#define CSL_SEM_SEM_SCRATCH_SCRATCH_MASK (0xFFFFFFFFu)
#define CSL_SEM_SEM_SCRATCH_SCRATCH_SHIFT (0x00000000u)
#define CSL_SEM_SEM_SCRATCH_SCRATCH_RESETVAL (0x00000000u)

#define CSL_SEM_SEM_SCRATCH_RESETVAL     (0x00000000u)

/* SEM_RST_RUN */


#define CSL_SEM_SEM_RST_RUN_RESET_MASK   (0x00000001u)
#define CSL_SEM_SEM_RST_RUN_RESET_SHIFT  (0x00000000u)
#define CSL_SEM_SEM_RST_RUN_RESET_RESETVAL (0x00000000u)

#define CSL_SEM_SEM_RST_RUN_RESETVAL     (0x00000000u)

/* SEM_EOI */


#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_MASK (0x000000FFu)
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_SHIFT (0x00000000u)
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_RESETVAL (0x00000000u)
/*----SELECT_INTERRUPT_REARM Tokens----*/
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_SEM0 (0x00000000u)
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_SEM1 (0x00000001u)
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_SEM2 (0x00000002u)
#define CSL_SEM_SEM_EOI_SELECT_INTERRUPT_REARM_SEM_ALL (0x00000010u)

#define CSL_SEM_SEM_EOI_RESETVAL         (0x00000000u)

/* SEM */


#define CSL_SEM_SEM_OWNER_MASK           (0x0000FF00u)
#define CSL_SEM_SEM_OWNER_SHIFT          (0x00000008u)
#define CSL_SEM_SEM_OWNER_RESETVAL       (0x00000000u)

#define CSL_SEM_SEM_RESERVED1_MASK       (0x000000FEu)
#define CSL_SEM_SEM_RESERVED1_SHIFT      (0x00000001u)

#define CSL_SEM_SEM_FREE_MASK            (0x00000001u)
#define CSL_SEM_SEM_FREE_SHIFT           (0x00000000u)
#define CSL_SEM_SEM_FREE_RESETVAL        (0x00000001u)

#define CSL_SEM_SEM_RESETVAL             (0x00000001u)

/* ISEM */

#define CSL_SEM_ISEM_RESERVED2_MASK      (0xFFFF0000u)
#define CSL_SEM_ISEM_RESERVED2_SHIFT     (0x00000010u)

#define CSL_SEM_ISEM_OWNER_MASK          (0x0000FF00u)
#define CSL_SEM_ISEM_OWNER_SHIFT         (0x00000008u)
#define CSL_SEM_ISEM_OWNER_RESETVAL      (0x00000000u)


#define CSL_SEM_ISEM_FREE_MASK           (0x00000001u)
#define CSL_SEM_ISEM_FREE_SHIFT          (0x00000000u)
#define CSL_SEM_ISEM_FREE_RESETVAL       (0x00000001u)

#define CSL_SEM_ISEM_RESETVAL            (0x00000001u)

/* QSEM */

#define CSL_SEM_QSEM_RESERVED2_MASK      (0xFFFF0000u)
#define CSL_SEM_QSEM_RESERVED2_SHIFT     (0x00000010u)

#define CSL_SEM_QSEM_OWNER_MASK          (0x0000FF00u)
#define CSL_SEM_QSEM_OWNER_SHIFT         (0x00000008u)
#define CSL_SEM_QSEM_OWNER_RESETVAL      (0x00000000u)


#define CSL_SEM_QSEM_FREE_MASK           (0x00000001u)
#define CSL_SEM_QSEM_FREE_SHIFT          (0x00000000u)
#define CSL_SEM_QSEM_FREE_RESETVAL       (0x00000001u)

#define CSL_SEM_QSEM_RESETVAL            (0x00000001u)

/* SEMFLAGL */

#define CSL_SEM_SEMFLAGL_F31_MASK        (0x80000000u)
#define CSL_SEM_SEMFLAGL_F31_SHIFT       (0x0000001fu)
#define CSL_SEM_SEMFLAGL_F31_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F30_MASK        (0x40000000u)
#define CSL_SEM_SEMFLAGL_F30_SHIFT       (0x0000001eu)
#define CSL_SEM_SEMFLAGL_F30_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F29_MASK        (0x20000000u)
#define CSL_SEM_SEMFLAGL_F29_SHIFT       (0x0000001du)
#define CSL_SEM_SEMFLAGL_F29_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F28_MASK        (0x10000000u)
#define CSL_SEM_SEMFLAGL_F28_SHIFT       (0x0000001cu)
#define CSL_SEM_SEMFLAGL_F28_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F27_MASK        (0x08000000u)
#define CSL_SEM_SEMFLAGL_F27_SHIFT       (0x0000001bu)
#define CSL_SEM_SEMFLAGL_F27_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F26_MASK        (0x04000000u)
#define CSL_SEM_SEMFLAGL_F26_SHIFT       (0x0000001au)
#define CSL_SEM_SEMFLAGL_F26_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F25_MASK        (0x02000000u)
#define CSL_SEM_SEMFLAGL_F25_SHIFT       (0x00000019u)
#define CSL_SEM_SEMFLAGL_F25_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F24_MASK        (0x01000000u)
#define CSL_SEM_SEMFLAGL_F24_SHIFT       (0x00000018u)
#define CSL_SEM_SEMFLAGL_F24_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F23_MASK        (0x00800000u)
#define CSL_SEM_SEMFLAGL_F23_SHIFT       (0x00000017u)
#define CSL_SEM_SEMFLAGL_F23_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F22_MASK        (0x00400000u)
#define CSL_SEM_SEMFLAGL_F22_SHIFT       (0x00000016u)
#define CSL_SEM_SEMFLAGL_F22_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F21_MASK        (0x00200000u)
#define CSL_SEM_SEMFLAGL_F21_SHIFT       (0x00000015u)
#define CSL_SEM_SEMFLAGL_F21_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F20_MASK        (0x00100000u)
#define CSL_SEM_SEMFLAGL_F20_SHIFT       (0x00000014u)
#define CSL_SEM_SEMFLAGL_F20_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F19_MASK        (0x00080000u)
#define CSL_SEM_SEMFLAGL_F19_SHIFT       (0x00000013u)
#define CSL_SEM_SEMFLAGL_F19_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F18_MASK        (0x00040000u)
#define CSL_SEM_SEMFLAGL_F18_SHIFT       (0x00000012u)
#define CSL_SEM_SEMFLAGL_F18_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F17_MASK        (0x00020000u)
#define CSL_SEM_SEMFLAGL_F17_SHIFT       (0x00000011u)
#define CSL_SEM_SEMFLAGL_F17_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F16_MASK        (0x00010000u)
#define CSL_SEM_SEMFLAGL_F16_SHIFT       (0x00000010u)
#define CSL_SEM_SEMFLAGL_F16_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F15_MASK        (0x00008000u)
#define CSL_SEM_SEMFLAGL_F15_SHIFT       (0x0000000fu)
#define CSL_SEM_SEMFLAGL_F15_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F14_MASK        (0x00004000u)
#define CSL_SEM_SEMFLAGL_F14_SHIFT       (0x0000000eu)
#define CSL_SEM_SEMFLAGL_F14_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F13_MASK        (0x00002000u)
#define CSL_SEM_SEMFLAGL_F13_SHIFT       (0x0000000du)
#define CSL_SEM_SEMFLAGL_F13_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F12_MASK        (0x00001000u)
#define CSL_SEM_SEMFLAGL_F12_SHIFT       (0x0000000cu)
#define CSL_SEM_SEMFLAGL_F12_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F11_MASK        (0x00000800u)
#define CSL_SEM_SEMFLAGL_F11_SHIFT       (0x0000000bu)
#define CSL_SEM_SEMFLAGL_F11_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F10_MASK        (0x00000400u)
#define CSL_SEM_SEMFLAGL_F10_SHIFT       (0x0000000au)
#define CSL_SEM_SEMFLAGL_F10_RESETVAL    (0x00000000u)

#define CSL_SEM_SEMFLAGL_F9_MASK         (0x00000200u)
#define CSL_SEM_SEMFLAGL_F9_SHIFT        (0x00000009u)
#define CSL_SEM_SEMFLAGL_F9_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F8_MASK         (0x00000100u)
#define CSL_SEM_SEMFLAGL_F8_SHIFT        (0x00000008u)
#define CSL_SEM_SEMFLAGL_F8_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F7_MASK         (0x00000080u)
#define CSL_SEM_SEMFLAGL_F7_SHIFT        (0x00000007u)
#define CSL_SEM_SEMFLAGL_F7_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F6_MASK         (0x00000040u)
#define CSL_SEM_SEMFLAGL_F6_SHIFT        (0x00000006u)
#define CSL_SEM_SEMFLAGL_F6_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F5_MASK         (0x00000020u)
#define CSL_SEM_SEMFLAGL_F5_SHIFT        (0x00000005u)
#define CSL_SEM_SEMFLAGL_F5_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F4_MASK         (0x00000010u)
#define CSL_SEM_SEMFLAGL_F4_SHIFT        (0x00000004u)
#define CSL_SEM_SEMFLAGL_F4_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F3_MASK         (0x00000008u)
#define CSL_SEM_SEMFLAGL_F3_SHIFT        (0x00000003u)
#define CSL_SEM_SEMFLAGL_F3_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F2_MASK         (0x00000004u)
#define CSL_SEM_SEMFLAGL_F2_SHIFT        (0x00000002u)
#define CSL_SEM_SEMFLAGL_F2_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F1_MASK         (0x00000002u)
#define CSL_SEM_SEMFLAGL_F1_SHIFT        (0x00000001u)
#define CSL_SEM_SEMFLAGL_F1_RESETVAL     (0x00000000u)

#define CSL_SEM_SEMFLAGL_F0_MASK         (0x00000001u)
#define CSL_SEM_SEMFLAGL_F0_SHIFT        (0x00000000u)
#define CSL_SEM_SEMFLAGL_F0_RESETVAL     (0x00000000u)


#define CSL_SEM_SEMFLAGL_RESETVAL        (0x00000000u)

/* SEMFLAGL_CLEAR */

#define CSL_SEM_SEMFLAGL_CLEAR_F31_MASK  (0x80000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F31_SHIFT (0x0000001fu)
#define CSL_SEM_SEMFLAGL_CLEAR_F31_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F30_MASK  (0x40000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F30_SHIFT (0x0000001eu)
#define CSL_SEM_SEMFLAGL_CLEAR_F30_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F29_MASK  (0x20000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F29_SHIFT (0x0000001du)
#define CSL_SEM_SEMFLAGL_CLEAR_F29_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F28_MASK  (0x10000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F28_SHIFT (0x0000001cu)
#define CSL_SEM_SEMFLAGL_CLEAR_F28_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F27_MASK  (0x08000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F27_SHIFT (0x0000001bu)
#define CSL_SEM_SEMFLAGL_CLEAR_F27_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F26_MASK  (0x04000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F26_SHIFT (0x0000001au)
#define CSL_SEM_SEMFLAGL_CLEAR_F26_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F25_MASK  (0x02000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F25_SHIFT (0x00000019u)
#define CSL_SEM_SEMFLAGL_CLEAR_F25_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F24_MASK  (0x01000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F24_SHIFT (0x00000018u)
#define CSL_SEM_SEMFLAGL_CLEAR_F24_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F23_MASK  (0x00800000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F23_SHIFT (0x00000017u)
#define CSL_SEM_SEMFLAGL_CLEAR_F23_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F22_MASK  (0x00400000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F22_SHIFT (0x00000016u)
#define CSL_SEM_SEMFLAGL_CLEAR_F22_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F21_MASK  (0x00200000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F21_SHIFT (0x00000015u)
#define CSL_SEM_SEMFLAGL_CLEAR_F21_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F20_MASK  (0x00100000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F20_SHIFT (0x00000014u)
#define CSL_SEM_SEMFLAGL_CLEAR_F20_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F19_MASK  (0x00080000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F19_SHIFT (0x00000013u)
#define CSL_SEM_SEMFLAGL_CLEAR_F19_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F18_MASK  (0x00040000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F18_SHIFT (0x00000012u)
#define CSL_SEM_SEMFLAGL_CLEAR_F18_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F17_MASK  (0x00020000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F17_SHIFT (0x00000011u)
#define CSL_SEM_SEMFLAGL_CLEAR_F17_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F16_MASK  (0x00010000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F16_SHIFT (0x00000010u)
#define CSL_SEM_SEMFLAGL_CLEAR_F16_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F15_MASK  (0x00008000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F15_SHIFT (0x0000000fu)
#define CSL_SEM_SEMFLAGL_CLEAR_F15_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F14_MASK  (0x00004000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F14_SHIFT (0x0000000eu)
#define CSL_SEM_SEMFLAGL_CLEAR_F14_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F13_MASK  (0x00002000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F13_SHIFT (0x0000000du)
#define CSL_SEM_SEMFLAGL_CLEAR_F13_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F12_MASK  (0x00001000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F12_SHIFT (0x0000000cu)
#define CSL_SEM_SEMFLAGL_CLEAR_F12_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F11_MASK  (0x00000800u)
#define CSL_SEM_SEMFLAGL_CLEAR_F11_SHIFT (0x0000000bu)
#define CSL_SEM_SEMFLAGL_CLEAR_F11_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F10_MASK  (0x00000400u)
#define CSL_SEM_SEMFLAGL_CLEAR_F10_SHIFT (0x0000000au)
#define CSL_SEM_SEMFLAGL_CLEAR_F10_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F9_MASK   (0x00000200u)
#define CSL_SEM_SEMFLAGL_CLEAR_F9_SHIFT  (0x00000009u)
#define CSL_SEM_SEMFLAGL_CLEAR_F9_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F8_MASK   (0x00000100u)
#define CSL_SEM_SEMFLAGL_CLEAR_F8_SHIFT  (0x00000008u)
#define CSL_SEM_SEMFLAGL_CLEAR_F8_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F7_MASK   (0x00000080u)
#define CSL_SEM_SEMFLAGL_CLEAR_F7_SHIFT  (0x00000007u)
#define CSL_SEM_SEMFLAGL_CLEAR_F7_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F6_MASK   (0x00000040u)
#define CSL_SEM_SEMFLAGL_CLEAR_F6_SHIFT  (0x00000006u)
#define CSL_SEM_SEMFLAGL_CLEAR_F6_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F5_MASK   (0x00000020u)
#define CSL_SEM_SEMFLAGL_CLEAR_F5_SHIFT  (0x00000005u)
#define CSL_SEM_SEMFLAGL_CLEAR_F5_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F4_MASK   (0x00000010u)
#define CSL_SEM_SEMFLAGL_CLEAR_F4_SHIFT  (0x00000004u)
#define CSL_SEM_SEMFLAGL_CLEAR_F4_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F3_MASK   (0x00000008u)
#define CSL_SEM_SEMFLAGL_CLEAR_F3_SHIFT  (0x00000003u)
#define CSL_SEM_SEMFLAGL_CLEAR_F3_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F2_MASK   (0x00000004u)
#define CSL_SEM_SEMFLAGL_CLEAR_F2_SHIFT  (0x00000002u)
#define CSL_SEM_SEMFLAGL_CLEAR_F2_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F1_MASK   (0x00000002u)
#define CSL_SEM_SEMFLAGL_CLEAR_F1_SHIFT  (0x00000001u)
#define CSL_SEM_SEMFLAGL_CLEAR_F1_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_CLEAR_F0_MASK   (0x00000001u)
#define CSL_SEM_SEMFLAGL_CLEAR_F0_SHIFT  (0x00000000u)
#define CSL_SEM_SEMFLAGL_CLEAR_F0_RESETVAL (0x00000000u)


#define CSL_SEM_SEMFLAGL_CLEAR_RESETVAL  (0x00000000u)

/* SEMFLAGL_SET */

#define CSL_SEM_SEMFLAGL_SET_F31_MASK    (0x80000000u)
#define CSL_SEM_SEMFLAGL_SET_F31_SHIFT   (0x0000001fu)
#define CSL_SEM_SEMFLAGL_SET_F31_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F30_MASK    (0x40000000u)
#define CSL_SEM_SEMFLAGL_SET_F30_SHIFT   (0x0000001eu)
#define CSL_SEM_SEMFLAGL_SET_F30_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F29_MASK    (0x20000000u)
#define CSL_SEM_SEMFLAGL_SET_F29_SHIFT   (0x0000001du)
#define CSL_SEM_SEMFLAGL_SET_F29_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F28_MASK    (0x10000000u)
#define CSL_SEM_SEMFLAGL_SET_F28_SHIFT   (0x0000001cu)
#define CSL_SEM_SEMFLAGL_SET_F28_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F27_MASK    (0x08000000u)
#define CSL_SEM_SEMFLAGL_SET_F27_SHIFT   (0x0000001bu)
#define CSL_SEM_SEMFLAGL_SET_F27_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F26_MASK    (0x04000000u)
#define CSL_SEM_SEMFLAGL_SET_F26_SHIFT   (0x0000001au)
#define CSL_SEM_SEMFLAGL_SET_F26_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F25_MASK    (0x02000000u)
#define CSL_SEM_SEMFLAGL_SET_F25_SHIFT   (0x00000019u)
#define CSL_SEM_SEMFLAGL_SET_F25_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F24_MASK    (0x01000000u)
#define CSL_SEM_SEMFLAGL_SET_F24_SHIFT   (0x00000018u)
#define CSL_SEM_SEMFLAGL_SET_F24_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F23_MASK    (0x00800000u)
#define CSL_SEM_SEMFLAGL_SET_F23_SHIFT   (0x00000017u)
#define CSL_SEM_SEMFLAGL_SET_F23_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F22_MASK    (0x00400000u)
#define CSL_SEM_SEMFLAGL_SET_F22_SHIFT   (0x00000016u)
#define CSL_SEM_SEMFLAGL_SET_F22_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F21_MASK    (0x00200000u)
#define CSL_SEM_SEMFLAGL_SET_F21_SHIFT   (0x00000015u)
#define CSL_SEM_SEMFLAGL_SET_F21_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F20_MASK    (0x00100000u)
#define CSL_SEM_SEMFLAGL_SET_F20_SHIFT   (0x00000014u)
#define CSL_SEM_SEMFLAGL_SET_F20_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F19_MASK    (0x00080000u)
#define CSL_SEM_SEMFLAGL_SET_F19_SHIFT   (0x00000013u)
#define CSL_SEM_SEMFLAGL_SET_F19_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F18_MASK    (0x00040000u)
#define CSL_SEM_SEMFLAGL_SET_F18_SHIFT   (0x00000012u)
#define CSL_SEM_SEMFLAGL_SET_F18_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F17_MASK    (0x00020000u)
#define CSL_SEM_SEMFLAGL_SET_F17_SHIFT   (0x00000011u)
#define CSL_SEM_SEMFLAGL_SET_F17_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F16_MASK    (0x00010000u)
#define CSL_SEM_SEMFLAGL_SET_F16_SHIFT   (0x00000010u)
#define CSL_SEM_SEMFLAGL_SET_F16_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F15_MASK    (0x00008000u)
#define CSL_SEM_SEMFLAGL_SET_F15_SHIFT   (0x0000000fu)
#define CSL_SEM_SEMFLAGL_SET_F15_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F14_MASK    (0x00004000u)
#define CSL_SEM_SEMFLAGL_SET_F14_SHIFT   (0x0000000eu)
#define CSL_SEM_SEMFLAGL_SET_F14_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F13_MASK    (0x00002000u)
#define CSL_SEM_SEMFLAGL_SET_F13_SHIFT   (0x0000000du)
#define CSL_SEM_SEMFLAGL_SET_F13_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F12_MASK    (0x00001000u)
#define CSL_SEM_SEMFLAGL_SET_F12_SHIFT   (0x0000000cu)
#define CSL_SEM_SEMFLAGL_SET_F12_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F11_MASK    (0x00000800u)
#define CSL_SEM_SEMFLAGL_SET_F11_SHIFT   (0x0000000bu)
#define CSL_SEM_SEMFLAGL_SET_F11_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F10_MASK    (0x00000400u)
#define CSL_SEM_SEMFLAGL_SET_F10_SHIFT   (0x0000000au)
#define CSL_SEM_SEMFLAGL_SET_F10_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F9_MASK     (0x00000200u)
#define CSL_SEM_SEMFLAGL_SET_F9_SHIFT    (0x00000009u)
#define CSL_SEM_SEMFLAGL_SET_F9_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F8_MASK     (0x00000100u)
#define CSL_SEM_SEMFLAGL_SET_F8_SHIFT    (0x00000008u)
#define CSL_SEM_SEMFLAGL_SET_F8_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F7_MASK     (0x00000080u)
#define CSL_SEM_SEMFLAGL_SET_F7_SHIFT    (0x00000007u)
#define CSL_SEM_SEMFLAGL_SET_F7_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F6_MASK     (0x00000040u)
#define CSL_SEM_SEMFLAGL_SET_F6_SHIFT    (0x00000006u)
#define CSL_SEM_SEMFLAGL_SET_F6_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F5_MASK     (0x00000020u)
#define CSL_SEM_SEMFLAGL_SET_F5_SHIFT    (0x00000005u)
#define CSL_SEM_SEMFLAGL_SET_F5_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F4_MASK     (0x00000010u)
#define CSL_SEM_SEMFLAGL_SET_F4_SHIFT    (0x00000004u)
#define CSL_SEM_SEMFLAGL_SET_F4_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F3_MASK     (0x00000008u)
#define CSL_SEM_SEMFLAGL_SET_F3_SHIFT    (0x00000003u)
#define CSL_SEM_SEMFLAGL_SET_F3_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F2_MASK     (0x00000004u)
#define CSL_SEM_SEMFLAGL_SET_F2_SHIFT    (0x00000002u)
#define CSL_SEM_SEMFLAGL_SET_F2_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F1_MASK     (0x00000002u)
#define CSL_SEM_SEMFLAGL_SET_F1_SHIFT    (0x00000001u)
#define CSL_SEM_SEMFLAGL_SET_F1_RESETVAL (0x00000000u)

#define CSL_SEM_SEMFLAGL_SET_F0_MASK     (0x00000001u)
#define CSL_SEM_SEMFLAGL_SET_F0_SHIFT    (0x00000000u)
#define CSL_SEM_SEMFLAGL_SET_F0_RESETVAL (0x00000000u)

/*----F Tokens----*/

#define CSL_SEM_SEMFLAGL_SET_RESETVAL    (0x00000000u)

/* SEMERR */


#define CSL_SEM_SEMERR_FAULTID_MASK      (0x0000FE00u)
#define CSL_SEM_SEMERR_FAULTID_SHIFT     (0x00000009u)

#define CSL_SEM_SEMERR_SEMNUM_MASK       (0x000001F8u)
#define CSL_SEM_SEMERR_SEMNUM_SHIFT      (0x00000003u)

#define CSL_SEM_SEMERR_ERR_MASK          (0x00000007u)
#define CSL_SEM_SEMERR_ERR_SHIFT         (0x00000000u)
/*----ERR Tokens----*/

#define CSL_SEM_SEMERR_RESETVAL          (0x00000000u)

/* SEMERR_CLEAR */


#define CSL_SEM_SEMERR_CLEAR_CLRERR_MASK (0x00000001u)
#define CSL_SEM_SEMERR_CLEAR_CLRERR_SHIFT (0x00000000u)
/*----CLRERR Tokens----*/

#define CSL_SEM_SEMERR_CLEAR_RESETVAL    (0x00000000u)

/* SEMERR_SET */


#define CSL_SEM_SEMERR_SET_FAULTID_MASK  (0x0000FE00u)
#define CSL_SEM_SEMERR_SET_FAULTID_SHIFT (0x00000009u)

#define CSL_SEM_SEMERR_SET_SEMNUM_MASK   (0x000001F8u)
#define CSL_SEM_SEMERR_SET_SEMNUM_SHIFT  (0x00000003u)

#define CSL_SEM_SEMERR_SET_ERR_MASK      (0x00000007u)
#define CSL_SEM_SEMERR_SET_ERR_SHIFT     (0x00000000u)
/*----ERR Tokens----*/

#define CSL_SEM_SEMERR_SET_RESETVAL      (0x00000000u)

#endif
