/******************************************************************************
 * Copyright (c) 2010 Texas Instruments Incorporated - http://www.ti.com
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/
/******************************************************************************
 *
 * File Name:  	evmc64x_mac.c
 *
 * Description:	This file contains the MAC related APIs
 *
 ******************************************************************************/
/****************
 * Include Files
****************/
#include "platform_internal.h"


/*********************************
 * Defines and Macros and globals
 *********************************/

/******************************************************************************
 * 
 * Function:	getEfuseMac	
 *
 * Description:	Gets the efuse mac id from the ROM. 
 *
 * Parameters:	uint8_t* puchMacBuffer - pointer to 6-bytes buffer
 *
 * Return Value: status
 ******************************************************************************/
uint32_t getEfuseMac(uint8_t* puchMacBuffer)
{
    uint32_t mac_addr2, mac_addr1;
    
    if(puchMacBuffer == NULL)
        return NULL_POINTER_ERROR;


    
    CSL_BootCfgGetMacIdentifier(&mac_addr1, &mac_addr2);
    puchMacBuffer[0] = ((mac_addr2 & 0x0000ff00) >> 8);
    puchMacBuffer[1] =  (mac_addr2 & 0x000000ff);
    
    puchMacBuffer[2] = ((mac_addr1 & 0xff000000) >> 24);
    puchMacBuffer[3] = ((mac_addr1 & 0x00ff0000) >> 16);
    puchMacBuffer[4] = ((mac_addr1 & 0x0000ff00) >> 8);
    puchMacBuffer[5] =  (mac_addr1 & 0x000000ff);
    return SUCCESS;
}	 
