-x
-stack 0x10000
-heap  0x6000


MEMORY
{

  VECTORS_MEM: origin = 0x00800000 length = 0x00000400
	
  /* Global addresses for Multi-GEM*/
  GEM0_BOOT_MEM: origin = 0x10800400 length = 0x00001C00	
  GEM1_BOOT_MEM: origin = 0x11800400 length = 0x00001C00
  GEM2_BOOT_MEM: origin = 0x12800400 length = 0x00001C00
  GEM3_BOOT_MEM: origin = 0x13800400 length = 0x00001C00
  
  GEM0_TEXT_MEM: origin = 0x10802000 length = 0x0009E000	
  GEM1_TEXT_MEM: origin = 0x11802000 length = 0x0009E000
  GEM2_TEXT_MEM: origin = 0x12802000 length = 0x0009E000
  GEM3_TEXT_MEM: origin = 0x13802000 length = 0x0009E000
  
  GEM0_DATA_MEM: origin = 0x108A0000 length = 0x00010000
  GEM0_DATA_MEM2: origin = 0x108B0000 length = 0x00010000
  GEM1_DATA_MEM: origin = 0x118A0000 length = 0x00020000
  GEM2_DATA_MEM: origin = 0x128A0000 length = 0x00020000
  GEM3_DATA_MEM: origin = 0x138A0000 length = 0x00020000
  
  L3ROM_MEM: origin = 0x3c000000 length = 0x00010000
  DDR16_0_MEM: origin = 0xE0000000 length = 0x20000000

  TB_MEM        : origin = 0x8f010000 length = 0x00010000
  EMAC_TB_MEM   : origin = 0x8f030000 length = 0x00010000
  EMIFCS2_TB_MEM: origin = 0xA0000000 length = 0x00800000
  EMIFCS3_TB_MEM: origin = 0xB0000000 length = 0x00800000
  EMIFCS4_TB_MEM: origin = 0xC0000000 length = 0x00800000
  EMIFCS5_TB_MEM: origin = 0xD0000000 length = 0x00800000

  /* M3 Config Memory */
  M3_CONFIG_MEM: origin = 0x08000000 length = 0x00008000

  /* M3 RAM */
  M3_RAM_MEM: origin = 0x0C000000 length = 0x00200000

}
 
SECTIONS
{
  .vectors: > VECTORS_MEM
  
  /* Boot Memory Sections */
  .gem0_boot: > GEM0_BOOT_MEM
  .gem1_boot: > GEM1_BOOT_MEM
  .gem2_boot: > GEM2_BOOT_MEM
  .gem3_boot: > GEM3_BOOT_MEM

  /* Text Memory Sections */
  .gem0_text: > GEM0_TEXT_MEM
  .gem1_text: > GEM1_TEXT_MEM
  .gem2_text: > GEM2_TEXT_MEM
  .gem3_text: > GEM3_TEXT_MEM

  /* Data Memory Sections */
  .gem0_data: > GEM0_DATA_MEM
  .gem0_data2: > GEM0_DATA_MEM2
  .gem1_data: > GEM1_DATA_MEM
  .gem2_data: > GEM2_DATA_MEM
  .gem3_data: > GEM3_DATA_MEM

  .ddrData: > DDR16_0_MEM
  .l3rom:   > L3ROM_MEM

  .tbram  : > TB_MEM
  .emac_tb: > EMAC_TB_MEM

  .emifcs2: > EMIFCS2_TB_MEM
  .emifcs3: > EMIFCS3_TB_MEM
  .emifcs4: > EMIFCS4_TB_MEM
  .emifcs5: > EMIFCS5_TB_MEM

  .csl_vect:  >       GEM0_TEXT_MEM
  .fasttext:  >       GEM0_TEXT_MEM
  .cinit:     >       GEM0_TEXT_MEM
  .stack:     >       GEM0_TEXT_MEM
  .bss:       >       GEM0_TEXT_MEM
  .const:     >       GEM0_TEXT_MEM
  .far:       >       GEM0_TEXT_MEM
  .switch:    >       GEM0_TEXT_MEM
  .sysmem:    >       GEM0_TEXT_MEM
  .cio:       >       GEM0_TEXT_MEM
  .text       >       GEM0_TEXT_MEM
  .intData_sect   >   M3_RAM_MEM
  .extData_sect   >   DDR16_0_MEM
  .cppi           >   M3_RAM_MEM
  .qmss           >   M3_RAM_MEM
  
}
