#ifndef HYPERLINK_CONFIG_H_
#define HYPERLINK_CONFIG_H_


#include <ti/csl/cslr_device.h>
#include <ti/csl/csl_chip.h>
#include <aet_counters_iar.h>
#include <aet_counters_mmr.h>
#include <aet_counters.h>

#define FIRST_HI_GEM_EVENT     48

#define PASS      1
#define FAIL      0
//CSL_MCM_CONFIG_REGS       0x21400000
#define 	CSL_MCM_PID	      (CSL_MCM_CONFIG_REGS + 0x00)	//Revision/ID Register
#define 	CSL_MCM_CR	      (CSL_MCM_CONFIG_REGS + 0x04)	//Control Register
#define 	CSL_MCM_SR	      (CSL_MCM_CONFIG_REGS + 0x08)	//Status Register
#define 	CSL_MCM_INTPVSCR	  (CSL_MCM_CONFIG_REGS + 0x0C)	//Interrupt Priority Vector Status/Clear Register
#define 	CSL_MCM_INTSCR	  (CSL_MCM_CONFIG_REGS + 0x10)	//Interrupt Status/Clear Register
#define 	CSL_MCM_INTPSR	  (CSL_MCM_CONFIG_REGS + 0x14)	//Interrupt Pending/Set Register
#define 	CSL_MCM_GSFTINT	  (CSL_MCM_CONFIG_REGS + 0x18)	//Generate Soft Interrupt Value
#define 	CSL_MCM_TXADDOVLCTL (CSL_MCM_CONFIG_REGS + 0x1C) //Tx Address Overlay Control
#define  	CSL_MCM_RXADDSELCTL		(CSL_MCM_CONFIG_REGS + 0x2c)	//Rx Address Selector Control 
#define 	CSL_MCM_RXADDPRVIDX	(CSL_MCM_CONFIG_REGS + 0x30)	//Rx Address Priv ID Index
#define 	CSL_MCM_RXADDPRVVAL	(CSL_MCM_CONFIG_REGS + 0x34)	//Rx Address Priv ID Value
#define 	CSL_MCM_RXADDSEGIDX	(CSL_MCM_CONFIG_REGS + 0x38)	//Rx Address Segment Index
#define 	CSL_MCM_RXADDSEGVAL	(CSL_MCM_CONFIG_REGS + 0x3C)	//Rx Address Segment Value
#define 	CSL_MCM_CVR	      (CSL_MCM_CONFIG_REGS + 0x40)	//Chip Version Register
#define 	CSL_MCM_LPMC	      (CSL_MCM_CONFIG_REGS + 0x44)	//Lane Power Management Control
#define 	CSL_MCM_ECCEC	  (CSL_MCM_CONFIG_REGS + 0x4C)	//ECC Error Counters
#define 	CSL_MCM_INTCI	  (CSL_MCM_CONFIG_REGS + 0x60)	//Interrupt Control Index
#define 	CSL_MCM_INTCV	  (CSL_MCM_CONFIG_REGS + 0x64)	//Interrupt Control Value
#define 	CSL_MCM_INTPI	  (CSL_MCM_CONFIG_REGS + 0x68)	//Interrupt Pointer Index
#define 	CSL_MCM_INTPV	  (CSL_MCM_CONFIG_REGS + 0x6C)	//Interrupt Pointer Value
#define 	CSL_MCM_SDCS1	  (CSL_MCM_CONFIG_REGS + 0x70)	//SERDES Control and Status 1
#define 	CSL_MCM_SDCS2	  (CSL_MCM_CONFIG_REGS + 0x74)	//SERDES Control and Status 2
#define 	CSL_MCM_SDCS3	  (CSL_MCM_CONFIG_REGS + 0x78)	//SERDES Control and Status 3
#define 	CSL_MCM_SDCS4	  (CSL_MCM_CONFIG_REGS + 0x7C)	//SERDES Control and Status 4

#define 	CSL_RMCM_PID	      (CSL_MCM_CONFIG_REGS + 0x80)	//Remote Revision Register
#define 	CSL_RMCM_CR	      (CSL_MCM_CONFIG_REGS + 0x84)	//Remote Control Register
#define 	CSL_RMCM_SR	      (CSL_MCM_CONFIG_REGS + 0x88)	//Remote Status Register
#define 	CSL_RMCM_INTPVSCR  (CSL_MCM_CONFIG_REGS + 0x8C)	//Remote Interrupt Priority Vector Status/Clear Register
#define 	CSL_RMCM_INTSCR	  (CSL_MCM_CONFIG_REGS + 0x90)	//Remote Interrupt Status/Clear Register
#define 	CSL_RMCM_INTPSR	  (CSL_MCM_CONFIG_REGS + 0x94)	//Remote Interrupt Pending/Set Register
#define 	CSL_RMCM_GSFTINT   (CSL_MCM_CONFIG_REGS + 0x98)	//Remote Generate Soft Interrupt Value
#define 	CSL_RMCM_TXADDOVLCTL (CSL_MCM_CONFIG_REGS + 0x9C) //Tx Address Overlay Control
#define  	CSL_RMCM_RXADDSELCTL		(CSL_MCM_CONFIG_REGS + 0xAC)	//Rx Address Selector Control 
#define 	CSL_RMCM_RXADDPRVIDX	(CSL_MCM_CONFIG_REGS + 0xB0)	//Rx Address Priv ID Index
#define 	CSL_RMCM_RXADDPRVVAL	(CSL_MCM_CONFIG_REGS + 0xB4)	//Rx Address Priv ID Value
#define 	CSL_RMCM_RXADDSEGIDX	(CSL_MCM_CONFIG_REGS + 0xB8)	//Rx Address Segment Index
#define 	CSL_RMCM_RXADDSEGVAL	(CSL_MCM_CONFIG_REGS + 0xBC)	//Rx Address Segment Value
#define 	CSL_RMCM_CVR	      (CSL_MCM_CONFIG_REGS + 0xC0)	//Remote Chip Version Register
#define 	CSL_RMCM_LPMC	  (CSL_MCM_CONFIG_REGS + 0xC4)	//Remote Lane Power Management Control
#define 	CSL_RMCM_ECCEC	  (CSL_MCM_CONFIG_REGS + 0xCC)	//Remote ECC Error Counters
#define 	CSL_RMCM_INTCI	  (CSL_MCM_CONFIG_REGS + 0xE0)	//Remote Interrupt Control Index
#define 	CSL_RMCM_INTCV	  (CSL_MCM_CONFIG_REGS + 0xE4)	//Remote Interrupt Control Value
#define 	CSL_RMCM_INTPI	  (CSL_MCM_CONFIG_REGS + 0xE8)	//Remote Interrupt Pointer Index
#define 	CSL_RMCM_INTPV	  (CSL_MCM_CONFIG_REGS + 0xEC)	//Remote Interrupt Pointer Value
#define 	CSL_RMCM_SDCS1	  (CSL_MCM_CONFIG_REGS + 0xF0)	//Remote SERDES Control and Status 1
#define 	CSL_RMCM_SDCS2	  (CSL_MCM_CONFIG_REGS + 0xF4)	//Remote SERDES Control and Status 2
#define 	CSL_RMCM_SDCS3	  (CSL_MCM_CONFIG_REGS + 0xF8)	//Remote SERDES Control and Status 3
#define 	CSL_RMCM_SDCS4	  (CSL_MCM_CONFIG_REGS + 0xFC)	//Remote SERDES Control and Status 4

#define 	CSL_MCM_DATA			(CSL_MCM_REGS) // 0x40000000

#define VUSR_SERDES_CFGPLL      0x03B4
#define VUSR_SERDES_CFGRX0      0x03B8
#define VUSR_SERDES_CFGTX0      0x03BC
#define VUSR_SERDES_CFGRX1      0x03C0
#define VUSR_SERDES_CFGTX1      0x03C4
#define VUSR_SERDES_CFGRX2      0x03C8
#define VUSR_SERDES_CFGTX2      0x03CC
#define VUSR_SERDES_CFGRX3      0x03D0
#define VUSR_SERDES_CFGTX3      0x03D4
#define VUSR_SERDES_RSVD        0x03D8
#define	STS_VUSR            	0x0160

/*********** EDMA related *****************************/
#define CSL_EDMA3CC_AETCTL_EN_MASK        (0x80000000u)
#define CSL_EDMA3CC_AETCTL_EN_SHIFT       (0x0000001Fu)
#define CSL_EDMA3CC_AETCTL_EN_RESETVAL    (0x00000000u)

/*----EN Tokens----*/
#define CSL_EDMA3CC_AETCTL_EN_DISABLE     (0x00000000u)
#define CSL_EDMA3CC_AETCTL_EN_ENABLE      (0x00000001u)

#define CSL_EDMA3CC_AETCTL_ENDINT_MASK    (0x00003F00u)
#define CSL_EDMA3CC_AETCTL_ENDINT_SHIFT   (0x00000008u)
#define CSL_EDMA3CC_AETCTL_ENDINT_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_AETCTL_TYPE_MASK      (0x00000040u)
#define CSL_EDMA3CC_AETCTL_TYPE_SHIFT     (0x00000006u)
#define CSL_EDMA3CC_AETCTL_TYPE_RESETVAL  (0x00000000u)

/*----TYPE Tokens----*/
#define CSL_EDMA3CC_AETCTL_TYPE_DMA       (0x00000000u)
#define CSL_EDMA3CC_AETCTL_TYPE_QDMA      (0x00000001u)

#define CSL_EDMA3CC_AETCTL_STRTEVT_MASK   (0x0000003Fu)
#define CSL_EDMA3CC_AETCTL_STRTEVT_SHIFT  (0x00000000u)
#define CSL_EDMA3CC_AETCTL_STRTEVT_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_AETCTL_RESETVAL       (0x00000000u)

/* AETSTAT */
#define CSL_EDMA3CC_AETSTAT_STAT_MASK     (0x00000001u)
#define CSL_EDMA3CC_AETSTAT_STAT_SHIFT    (0x00000000u)
#define CSL_EDMA3CC_AETSTAT_STAT_RESETVAL (0x00000000u)

/*----STAT Tokens----*/
#define CSL_EDMA3CC_AETSTAT_STAT_LOW      (0x00000000u)
#define CSL_EDMA3CC_AETSTAT_STAT_HIGH     (0x00000001u)
#define CSL_EDMA3CC_AETSTAT_RESETVAL      (0x00000000u)

/* AETCMD */
#define CSL_EDMA3CC_AETCMD_CLR_MASK       (0x00000001u)
#define CSL_EDMA3CC_AETCMD_CLR_SHIFT      (0x00000000u)
#define CSL_EDMA3CC_AETCMD_CLR_RESETVAL   (0x00000000u)

/*----CLR Tokens----*/
#define CSL_EDMA3CC_AETCMD_CLR_CLEAR      (0x00000001u)
#define CSL_EDMA3CC_AETCMD_RESETVAL       (0x00000000u)

#define EDMACC0_AETEVT_GEM		112

#define AET_CTL  *(volatile Uint32*)0x02700700
#define AET_STAT *(volatile Uint32*)0x02700704
#define AET_CMD  *(volatile Uint32*)0x02700708
// Setup the INTC AEGMUX register to route Event 85 to AEGEVT0
#define GEM_AEG_MUX0 *(volatile Uint32*)0x01800140

#define MCM_EDMA_RD_CHANNEL 0
#define MCM_EDMA_WR_CHANNEL 8

void Intc_config(void);
void MNav_config(void);
void Hyperlink_config(void);
void Hyperlink_Close(void);
void Test_result(void);
void Intc_Close(void);
void MNav_Close(void);

static inline uint64_t DSP_ReadTime64() 
{
  uint32_t low = TSCL;
  uint32_t high = TSCH;
  return _itoll(high,low);
}
void write_local_reg (unsigned int offset, unsigned int bit_position);
void Configure_vUSR_SerDes( void );
void vUSR_InternalLoopBackEnable(void);
void vUSR_NonLoopBack_LinkOnWait(void);
void vUSR_ModuleReset(void);
void configure_address_mappings(Uint32 Txigmask, Uint32 rxsegsel, Uint32 RxBufAddr1, Uint32 RxBufAddr2);
void configure_address_mappings_EDMA(Uint32 Txigmask, Uint32 rxadrsize1, Uint32 RxAddrOffset);
void vusr_edma_rd_setup_all_payload(Uint32 srcBuf, Uint32 dstBuf, Uint32 payload, Uint32 channel_num);
void vusr_edma_wr_setup_all_payload(Uint32 srcBuf, Uint32 dstBuf, Uint32 payload, Uint32 channel_num);
void verify_edma_complete(int ch_num);

void initCppiMem (void);
void initQmssMem (void);

void Setup_Aet(Uint32 channelNum,Uint32 tccNum);
Uint32 Retrieve_Aet();

#endif /*HYPERLINK_CONFIG_H_*/
