/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments
*  For  Unrestricted  Internal  Use  Only
*  Unauthorized reproduction and/or distribution is strictly prohibited.
*  This product is protected under copyright law and trade secret law
*  as an unpublished work.
*  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : edma_xxx.h
*  Date Created   : Oct 10, 2005
*  Last Modified  : April 8, 2008
*  Description    : EDMA3 related macros, data and func prototypes  
*  History        : Ported from Faraday
*  Project        : Curie
*  Author         : Anand Patil
\*****************************************************************************/
/* ======================================================================== */
/*  TEXAS INSTRUMENTS, INC.                                                 */
/*                                                                          */
/*  \file aet_counters.h                                                    */
/*                                                                          */
/*  \brief AET common support functions                                     */
/*                                                                          */
/*  \date  2nd Apr 2004                                                     */
/*                                                                          */
/*  \author Oliver Sohm                                                     */
/*                                                                          */
/*  DESCRIPTION                                                             */
/*                                                                          */
/*  LAST MODIFIED                                                           */
/*       4th Nov 2004                                                       */
/*                                                                          */
/*  MODIFICATIONS 1                                                         */
/*      - Oliver Sohm                                                       */
/*      - Created                                                           */
/*      - Date:  4th Nov 2004                                               */
/*                                                                          */
/* ------------------------------------------------------------------------ */
/*             Copyright (c) 2004 Texas Instruments, Incorporated.          */
/*                            All Rights Reserved.                          */
/* ======================================================================== */

/* ------------------------------------------------------------------------ */
/*  AET Memory Mapped Registers                                             */
/* ------------------------------------------------------------------------ */

#define AET_MMR_IAR_ADD  *(volatile unsigned int *)(0x01BC0020) /* Indirect Register Address */
#define AET_MMR_IAR_DAT  *(volatile unsigned int *)(0x01BC0024) /* Indirect Register Write Data */
#define AET_MMR_EVT      *(volatile unsigned int *)(0x01BC0028) /* Event Status Register */  
#define AET_MMR_PID      *(volatile unsigned int *)(0x01BC002C) /* Claim/Enable/Ownership */   
#define AET_MMR_PC       *(volatile unsigned int *)(0x01BC0030) /* PC Captured status register */   
#define AET_MMR_SPL_PC   *(volatile unsigned int *)(0x01BC0034) /* SPLOOP PC */
#define AET_MMR_SPL_STAT *(volatile unsigned int *)(0x01BC0038) /* SPLOOP Captured status register */

/* ------------------------------------------------------------------------ */
/*  AET Indirect Registers                                                  */
/* ------------------------------------------------------------------------ */
#define AET_FUNC_CNTL    (0x86)    /* Counter function control */
#define AET_CMPI_SEL     (0x87)    /* Bus Select Register */
#define AET_CNT_RLD0     (0xB0)    /* Counter reload value for counter 0 */
#define AET_CNT_RLD1     (0xB1)    /* Counter reload value for counter 1 */
#define AET_CNT_VAL0     (0xB0)    /* Value of counter 0 */
#define AET_CNT_VAL1     (0xB1)    /* Value of counter 1 */
#define AET_AE_CNTL1     (0x8A)    /* AEG Control Register for AEG 1 */
#define AET_AE_ENA1      (0x8B)    /* Input Select Register for AEG 1 (feeds counter 0) */
#define AET_AE_CNTL2     (0x8C)    /* AEG Control Register for AEG 2 */
#define AET_AE_ENA2      (0x8D)    /* Input Select Register for AEG 2 (feeds counter 1) */

/* ------------------------------------------------------------------------ */
/*  API Prototypes                                                          */
/* ------------------------------------------------------------------------ */
unsigned int AET_iregRead(unsigned int ireg);
void AET_iregWrite(unsigned int ireg, unsigned int val);
void AET_claim();
void AET_enable();
void AET_countEvents(int input_set, unsigned int input_mask_0, unsigned int input_mask_1);
int AET_counter0Read();
int AET_counter1Read();

