/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments
*  For  Unrestricted  Internal  Use  Only
*  Unauthorized reproduction and/or distribution is strictly prohibited.
*  This product is protected under copyright law and trade secret law
*  as an unpublished work.
*  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : edma_xxx.h
*  Date Created   : Oct 10, 2005
*  Last Modified  : April 8, 2008
*  Description    : EDMA3 related macros, data and func prototypes  
*  History        : Ported from Faraday
*  Project        : Curie
*  Author         : Anand Patil
\*****************************************************************************/
#ifndef _CSLR_AET_001_H_
#define _CSLR_AET_001_H_
/*********************************************************************
 * Copyright (C) 2003-2004 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_aet_001.h
 * 
 * \brief This file contains the Register Desciptions for AET
 * 
 *********************************************************************/

#include <ti/csl/cslr.h>

#include <ti/csl/tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for AE_SAE 
\**************************************************************************/
typedef struct  {
    volatile Uint32 AE_CNTL;
} CSL_AetAe_saeRegs;

/**************************************************************************\
* Register Overlay Structure for AE_OAE 
\**************************************************************************/
typedef struct  {
    volatile Uint32 AE_CNTL;
} CSL_AetAe_oaeRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[134];
    volatile Uint32 FUNC_CNTL;
    CSL_AetAe_saeRegs AE_SAE;
    CSL_AetAe_oaeRegs AE_OAE[4];
    volatile Uint8 RSVD1[18];
    volatile Uint32 CNT_RLD0;
} CSL_AetRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* FUNC_CNTL */

#define CSL_AET_FUNC_CNTL_CTE3_MASK      (0x00040000u)
#define CSL_AET_FUNC_CNTL_CTE3_SHIFT     (0x00000012u)
#define CSL_AET_FUNC_CNTL_CTE3_RESETVAL  (0x00000000u)

/*----CTE3 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTE3_DISABLE   (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTE3_WATERMARK (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTM3_MASK      (0x00018000u)
#define CSL_AET_FUNC_CNTL_CTM3_SHIFT     (0x0000000Fu)
#define CSL_AET_FUNC_CNTL_CTM3_RESETVAL  (0x00000000u)

/*----CTM3 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTM3_MIN_WM    (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTM3_MAX_WM    (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTA2_MASK      (0x00004000u)
#define CSL_AET_FUNC_CNTL_CTA2_SHIFT     (0x0000000Eu)
#define CSL_AET_FUNC_CNTL_CTA2_RESETVAL  (0x00000000u)

/*----CTA2 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTA2_CLK0      (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTA2_CLK1      (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTE2_MASK      (0x00002000u)
#define CSL_AET_FUNC_CNTL_CTE2_SHIFT     (0x0000000Du)
#define CSL_AET_FUNC_CNTL_CTE2_RESETVAL  (0x00000000u)

/*----CTE2 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTE2_DISABLE   (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTE2_ENABLE    (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTC2_MASK      (0x00001000u)
#define CSL_AET_FUNC_CNTL_CTC2_SHIFT     (0x0000000Cu)
#define CSL_AET_FUNC_CNTL_CTC2_RESETVAL  (0x00000000u)

/*----CTC2 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTC2_STOP      (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTC2_RUN       (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTM2_MASK      (0x00000C00u)
#define CSL_AET_FUNC_CNTL_CTM2_SHIFT     (0x0000000Au)
#define CSL_AET_FUNC_CNTL_CTM2_RESETVAL  (0x00000000u)

/*----CTM2 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTM2_COUNT     (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTM2_EVENT     (0x00000001u)
#define CSL_AET_FUNC_CNTL_CTM2_CONT      (0x00000002u)
#define CSL_AET_FUNC_CNTL_CTM2_ONESHOT   (0x00000003u)

#define CSL_AET_FUNC_CNTL_CTE1_MASK      (0x00000100u)
#define CSL_AET_FUNC_CNTL_CTE1_SHIFT     (0x00000008u)
#define CSL_AET_FUNC_CNTL_CTE1_RESETVAL  (0x00000000u)

/*----CTE1 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTE1_DISABLE   (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTE1_WATERMARK (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTM1_MASK      (0x00000060u)
#define CSL_AET_FUNC_CNTL_CTM1_SHIFT     (0x00000005u)
#define CSL_AET_FUNC_CNTL_CTM1_RESETVAL  (0x00000000u)

/*----CTM1 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTM1_MIN_WM    (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTM1_MAX_WM    (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTA0_MASK      (0x00000010u)
#define CSL_AET_FUNC_CNTL_CTA0_SHIFT     (0x00000004u)
#define CSL_AET_FUNC_CNTL_CTA0_RESETVAL  (0x00000000u)

/*----CTA0 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTA0_CLK0      (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTA0_CLK1      (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTE0_MASK      (0x00000008u)
#define CSL_AET_FUNC_CNTL_CTE0_SHIFT     (0x00000003u)
#define CSL_AET_FUNC_CNTL_CTE0_RESETVAL  (0x00000000u)

/*----CTE0 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTE0_DISABLE   (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTE0_ENABLE    (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTC0_MASK      (0x00000004u)
#define CSL_AET_FUNC_CNTL_CTC0_SHIFT     (0x00000002u)
#define CSL_AET_FUNC_CNTL_CTC0_RESETVAL  (0x00000000u)

/*----CTC0 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTC0_STOP      (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTC0_RUN       (0x00000001u)

#define CSL_AET_FUNC_CNTL_CTM0_MASK      (0x00000003u)
#define CSL_AET_FUNC_CNTL_CTM0_SHIFT     (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTM0_RESETVAL  (0x00000000u)

/*----CTM0 Tokens----*/
#define CSL_AET_FUNC_CNTL_CTM0_COUNT     (0x00000000u)
#define CSL_AET_FUNC_CNTL_CTM0_EVENT     (0x00000001u)
#define CSL_AET_FUNC_CNTL_CTM0_CONT      (0x00000002u)
#define CSL_AET_FUNC_CNTL_CTM0_ONESHOT   (0x00000003u)

#define CSL_AET_FUNC_CNTL_RESETVAL       (0x00000000u)

/* CNT_RLD0 */

#define CSL_AET_CNT_RLD0_VALUE_MASK      (0xFFFFFFFFu)
#define CSL_AET_CNT_RLD0_VALUE_SHIFT     (0x00000000u)
#define CSL_AET_CNT_RLD0_VALUE_RESETVAL  (0x00000000u)

#define CSL_AET_CNT_RLD0_RESETVAL        (0x00000000u)

/* CNT_VAL0 */

#define CSL_AET_CNT_VAL0_VALUE_MASK      (0xFFFFFFFFu)
#define CSL_AET_CNT_VAL0_VALUE_SHIFT     (0x00000000u)
#define CSL_AET_CNT_VAL0_VALUE_RESETVAL  (0x00000000u)

#define CSL_AET_CNT_VAL0_RESETVAL        (0x00000000u)

/* CNT_RLD1 */

#define CSL_AET_CNT_RLD1_VALUE_MASK      (0xFFFFFFFFu)
#define CSL_AET_CNT_RLD1_VALUE_SHIFT     (0x00000000u)
#define CSL_AET_CNT_RLD1_VALUE_RESETVAL  (0x00000000u)

#define CSL_AET_CNT_RLD1_RESETVAL        (0x00000000u)

/* CNT_VAL1 */

#define CSL_AET_CNT_VAL1_VALUE_MASK      (0xFFFFFFFFu)
#define CSL_AET_CNT_VAL1_VALUE_SHIFT     (0x00000000u)
#define CSL_AET_CNT_VAL1_VALUE_RESETVAL  (0x00000000u)

#define CSL_AET_CNT_VAL1_RESETVAL        (0x00000000u)

/* AE_CNTL */

#define CSL_AET_AE_CNTL_TDR_MASK         (0x00002000u)
#define CSL_AET_AE_CNTL_TDR_SHIFT        (0x0000000Du)
#define CSL_AET_AE_CNTL_TDR_RESETVAL     (0x00000000u)

/*----TDR Tokens----*/
#define CSL_AET_AE_CNTL_TDR_0X0          (0x00000000u)
#define CSL_AET_AE_CNTL_TDR_0X1          (0x00000001u)

#define CSL_AET_AE_CNTL_TMD_MASK         (0x00001000u)
#define CSL_AET_AE_CNTL_TMD_SHIFT        (0x0000000Cu)
#define CSL_AET_AE_CNTL_TMD_RESETVAL     (0x00000000u)

/*----TMD Tokens----*/
#define CSL_AET_AE_CNTL_TMD_DISABLE      (0x00000000u)
#define CSL_AET_AE_CNTL_TMD_ENABLE       (0x00000001u)

#define CSL_AET_AE_CNTL_SYNC_MASK        (0x00000400u)
#define CSL_AET_AE_CNTL_SYNC_SHIFT       (0x0000000Au)
#define CSL_AET_AE_CNTL_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_AET_AE_CNTL_SYNC_DISABLE     (0x00000000u)
#define CSL_AET_AE_CNTL_SYNC_ENABLE      (0x00000001u)

#define CSL_AET_AE_CNTL_EDGE_MASK        (0x00000200u)
#define CSL_AET_AE_CNTL_EDGE_SHIFT       (0x00000009u)
#define CSL_AET_AE_CNTL_EDGE_RESETVAL    (0x00000000u)

/*----EDGE Tokens----*/
#define CSL_AET_AE_CNTL_EDGE_LEVEL       (0x00000000u)
#define CSL_AET_AE_CNTL_EDGE_EDGE        (0x00000001u)

#define CSL_AET_AE_CNTL_ALIGN_MASK       (0x00000100u)
#define CSL_AET_AE_CNTL_ALIGN_SHIFT      (0x00000008u)
#define CSL_AET_AE_CNTL_ALIGN_RESETVAL   (0x00000000u)

/*----ALIGN Tokens----*/
#define CSL_AET_AE_CNTL_ALIGN_DISABLE    (0x00000000u)
#define CSL_AET_AE_CNTL_ALIGN_ENABLE     (0x00000001u)

#define CSL_AET_AE_CNTL_EP7_MASK         (0x00000080u)
#define CSL_AET_AE_CNTL_EP7_SHIFT        (0x00000007u)
#define CSL_AET_AE_CNTL_EP7_RESETVAL     (0x00000000u)

/*----EP7 Tokens----*/
#define CSL_AET_AE_CNTL_EP7_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP7_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP6_MASK         (0x00000040u)
#define CSL_AET_AE_CNTL_EP6_SHIFT        (0x00000006u)
#define CSL_AET_AE_CNTL_EP6_RESETVAL     (0x00000000u)

/*----EP6 Tokens----*/
#define CSL_AET_AE_CNTL_EP6_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP6_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP5_MASK         (0x00000020u)
#define CSL_AET_AE_CNTL_EP5_SHIFT        (0x00000005u)
#define CSL_AET_AE_CNTL_EP5_RESETVAL     (0x00000000u)

/*----EP5 Tokens----*/
#define CSL_AET_AE_CNTL_EP5_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP5_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP4_MASK         (0x00000010u)
#define CSL_AET_AE_CNTL_EP4_SHIFT        (0x00000004u)
#define CSL_AET_AE_CNTL_EP4_RESETVAL     (0x00000000u)

/*----EP4 Tokens----*/
#define CSL_AET_AE_CNTL_EP4_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP4_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP3_MASK         (0x00000008u)
#define CSL_AET_AE_CNTL_EP3_SHIFT        (0x00000003u)
#define CSL_AET_AE_CNTL_EP3_RESETVAL     (0x00000000u)

/*----EP3 Tokens----*/
#define CSL_AET_AE_CNTL_EP3_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP3_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP2_MASK         (0x00000004u)
#define CSL_AET_AE_CNTL_EP2_SHIFT        (0x00000002u)
#define CSL_AET_AE_CNTL_EP2_RESETVAL     (0x00000000u)

/*----EP2 Tokens----*/
#define CSL_AET_AE_CNTL_EP2_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP2_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP1_MASK         (0x00000002u)
#define CSL_AET_AE_CNTL_EP1_SHIFT        (0x00000001u)
#define CSL_AET_AE_CNTL_EP1_RESETVAL     (0x00000000u)

/*----EP1 Tokens----*/
#define CSL_AET_AE_CNTL_EP1_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP1_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP0_MASK         (0x00000001u)
#define CSL_AET_AE_CNTL_EP0_SHIFT        (0x00000000u)
#define CSL_AET_AE_CNTL_EP0_RESETVAL     (0x00000000u)

/*----EP0 Tokens----*/
#define CSL_AET_AE_CNTL_EP0_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP0_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_RESETVAL         (0x00000000u)

/* AE_SIN */

#define CSL_AET_AE_SIN_NUM_MASK          (0x0000001Fu)
#define CSL_AET_AE_SIN_NUM_SHIFT         (0x00000000u)
#define CSL_AET_AE_SIN_NUM_RESETVAL      (0x00000000u)

/*----NUM Tokens----*/
#define CSL_AET_AE_SIN_NUM_EXECUTE_CYCLES (0x00000000u)
#define CSL_AET_AE_SIN_NUM_PIPELINE_STALL (0x00000001u)
#define CSL_AET_AE_SIN_NUM_MARK0         (0x00000002u)
#define CSL_AET_AE_SIN_NUM_MARK1         (0x00000003u)
#define CSL_AET_AE_SIN_NUM_MARK2         (0x00000004u)
#define CSL_AET_AE_SIN_NUM_MARK3         (0x00000005u)
#define CSL_AET_AE_SIN_NUM_ET0           (0x00000006u)
#define CSL_AET_AE_SIN_NUM_ET1           (0x00000007u)
#define CSL_AET_AE_SIN_NUM_IACK          (0x00000008u)
#define CSL_AET_AE_SIN_NUM_AEGEVT0       (0x00000009u)
#define CSL_AET_AE_SIN_NUM_AEGEVT1       (0x0000000Au)
#define CSL_AET_AE_SIN_NUM_AEGEVT2       (0x0000000Bu)
#define CSL_AET_AE_SIN_NUM_AEGEVT3       (0x0000000Cu)
#define CSL_AET_AE_SIN_NUM_AEGEVT4       (0x0000000Du)
#define CSL_AET_AE_SIN_NUM_AEGEVT5       (0x0000000Eu)
#define CSL_AET_AE_SIN_NUM_AEGEVT6       (0x0000000Fu)
#define CSL_AET_AE_SIN_NUM_AEGEVT7       (0x00000010u)
#define CSL_AET_AE_SIN_NUM_EXCEP         (0x00000011u)
#define CSL_AET_AE_SIN_NUM_EXC           (0x00000012u)
#define CSL_AET_AE_SIN_NUM_NMI           (0x00000013u)
#define CSL_AET_AE_SIN_NUM_RTDX_RX_END   (0x00000014u)
#define CSL_AET_AE_SIN_NUM_RTDX_TX_END   (0x00000015u)
#define CSL_AET_AE_SIN_NUM_DT_DMA_END    (0x00000016u)
#define CSL_AET_AE_SIN_NUM_L1D_WM_L2SRAM (0x00000017u)
#define CSL_AET_AE_SIN_NUM_L1D_WM_L2CACHE (0x00000018u)
#define CSL_AET_AE_SIN_NUM_L1D_WM_EXT    (0x00000019u)
#define CSL_AET_AE_SIN_NUM_L1D_WM_EXT_NONCACHE (0x0000001Au)
#define CSL_AET_AE_SIN_NUM_VICTIM_WB_FROML2 (0x0000001Bu)
#define CSL_AET_AE_SIN_NUM_DMA_SNOOP_READ (0x0000001Cu)
#define CSL_AET_AE_SIN_NUM_DMA_SNOOP_WRITE (0x0000001Du)
#define CSL_AET_AE_SIN_NUM_TAG_UPDATE_QUEUED (0x0000001Eu)
#define CSL_AET_AE_SIN_NUM_VICTIM_WB_FROML1D (0x0000001Fu)

#define CSL_AET_AE_SIN_RESETVAL          (0x00000000u)

/* AE_CNTL */

#define CSL_AET_AE_CNTL_TDR_MASK         (0x00002000u)
#define CSL_AET_AE_CNTL_TDR_SHIFT        (0x0000000Du)
#define CSL_AET_AE_CNTL_TDR_RESETVAL     (0x00000000u)

/*----TDR Tokens----*/
#define CSL_AET_AE_CNTL_TDR_0X0          (0x00000000u)
#define CSL_AET_AE_CNTL_TDR_0X1          (0x00000001u)

#define CSL_AET_AE_CNTL_TMD_MASK         (0x00001000u)
#define CSL_AET_AE_CNTL_TMD_SHIFT        (0x0000000Cu)
#define CSL_AET_AE_CNTL_TMD_RESETVAL     (0x00000000u)

/*----TMD Tokens----*/
#define CSL_AET_AE_CNTL_TMD_DISABLE      (0x00000000u)
#define CSL_AET_AE_CNTL_TMD_ENABLE       (0x00000001u)

#define CSL_AET_AE_CNTL_SYNC_MASK        (0x00000400u)
#define CSL_AET_AE_CNTL_SYNC_SHIFT       (0x0000000Au)
#define CSL_AET_AE_CNTL_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_AET_AE_CNTL_SYNC_DISABLE     (0x00000000u)
#define CSL_AET_AE_CNTL_SYNC_ENABLE      (0x00000001u)

#define CSL_AET_AE_CNTL_EDGE_MASK        (0x00000200u)
#define CSL_AET_AE_CNTL_EDGE_SHIFT       (0x00000009u)
#define CSL_AET_AE_CNTL_EDGE_RESETVAL    (0x00000000u)

/*----EDGE Tokens----*/
#define CSL_AET_AE_CNTL_EDGE_LEVEL       (0x00000000u)
#define CSL_AET_AE_CNTL_EDGE_EDGE        (0x00000001u)

#define CSL_AET_AE_CNTL_ALIGN_MASK       (0x00000100u)
#define CSL_AET_AE_CNTL_ALIGN_SHIFT      (0x00000008u)
#define CSL_AET_AE_CNTL_ALIGN_RESETVAL   (0x00000000u)

/*----ALIGN Tokens----*/
#define CSL_AET_AE_CNTL_ALIGN_DISABLE    (0x00000000u)
#define CSL_AET_AE_CNTL_ALIGN_ENABLE     (0x00000001u)

#define CSL_AET_AE_CNTL_EP7_MASK         (0x00000080u)
#define CSL_AET_AE_CNTL_EP7_SHIFT        (0x00000007u)
#define CSL_AET_AE_CNTL_EP7_RESETVAL     (0x00000000u)

/*----EP7 Tokens----*/
#define CSL_AET_AE_CNTL_EP7_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP7_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP6_MASK         (0x00000040u)
#define CSL_AET_AE_CNTL_EP6_SHIFT        (0x00000006u)
#define CSL_AET_AE_CNTL_EP6_RESETVAL     (0x00000000u)

/*----EP6 Tokens----*/
#define CSL_AET_AE_CNTL_EP6_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP6_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP5_MASK         (0x00000020u)
#define CSL_AET_AE_CNTL_EP5_SHIFT        (0x00000005u)
#define CSL_AET_AE_CNTL_EP5_RESETVAL     (0x00000000u)

/*----EP5 Tokens----*/
#define CSL_AET_AE_CNTL_EP5_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP5_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP4_MASK         (0x00000010u)
#define CSL_AET_AE_CNTL_EP4_SHIFT        (0x00000004u)
#define CSL_AET_AE_CNTL_EP4_RESETVAL     (0x00000000u)

/*----EP4 Tokens----*/
#define CSL_AET_AE_CNTL_EP4_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP4_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP3_MASK         (0x00000008u)
#define CSL_AET_AE_CNTL_EP3_SHIFT        (0x00000003u)
#define CSL_AET_AE_CNTL_EP3_RESETVAL     (0x00000000u)

/*----EP3 Tokens----*/
#define CSL_AET_AE_CNTL_EP3_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP3_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP2_MASK         (0x00000004u)
#define CSL_AET_AE_CNTL_EP2_SHIFT        (0x00000002u)
#define CSL_AET_AE_CNTL_EP2_RESETVAL     (0x00000000u)

/*----EP2 Tokens----*/
#define CSL_AET_AE_CNTL_EP2_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP2_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP1_MASK         (0x00000002u)
#define CSL_AET_AE_CNTL_EP1_SHIFT        (0x00000001u)
#define CSL_AET_AE_CNTL_EP1_RESETVAL     (0x00000000u)

/*----EP1 Tokens----*/
#define CSL_AET_AE_CNTL_EP1_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP1_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_EP0_MASK         (0x00000001u)
#define CSL_AET_AE_CNTL_EP0_SHIFT        (0x00000000u)
#define CSL_AET_AE_CNTL_EP0_RESETVAL     (0x00000000u)

/*----EP0 Tokens----*/
#define CSL_AET_AE_CNTL_EP0_OUT0         (0x00000000u)
#define CSL_AET_AE_CNTL_EP0_OUT1         (0x00000001u)

#define CSL_AET_AE_CNTL_RESETVAL         (0x00000000u)

/* AE_ENA */

#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_NONCACHE_MASK (0x40000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_NONCACHE_SHIFT (0x0000001Eu)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_NONCACHE_RESETVAL (0x00000000u)

/*----L1P_Rd_Miss_Ext_NonCache Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_NONCACHE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_NONCACHE_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_MASK (0x20000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_SHIFT (0x0000001Du)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_RESETVAL (0x00000000u)

/*----L1P_Rd_Miss_Ext Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_EXT_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_RD_MISS_L2CACHE_MASK (0x10000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2CACHE_SHIFT (0x0000001Cu)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2CACHE_RESETVAL (0x00000000u)

/*----L1P_Rd_Miss_L2Cache Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2CACHE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2CACHE_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_RD_MISS_L2SRAM_MASK (0x08000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2SRAM_SHIFT (0x0000001Bu)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2SRAM_RESETVAL (0x00000000u)

/*----L1P_Rd_Miss_L2SRAM Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2SRAM_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_MISS_L2SRAM_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_RD_HIT_CACHE_MASK (0x04000000u)
#define CSL_AET_AE_ENA_L1P_RD_HIT_CACHE_SHIFT (0x0000001Au)
#define CSL_AET_AE_ENA_L1P_RD_HIT_CACHE_RESETVAL (0x00000000u)

/*----L1P_Rd_Hit_Cache Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_HIT_CACHE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_HIT_CACHE_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_RD_HIT_SRAM_MASK (0x02000000u)
#define CSL_AET_AE_ENA_L1P_RD_HIT_SRAM_SHIFT (0x00000019u)
#define CSL_AET_AE_ENA_L1P_RD_HIT_SRAM_RESETVAL (0x00000000u)

/*----L1P_Rd_Hit_SRAM Tokens----*/
#define CSL_AET_AE_ENA_L1P_RD_HIT_SRAM_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_RD_HIT_SRAM_SET (0x00000001u)

#define CSL_AET_AE_ENA_CPU_DMA_BANK_CONF_MASK (0x01000000u)
#define CSL_AET_AE_ENA_CPU_DMA_BANK_CONF_SHIFT (0x00000018u)
#define CSL_AET_AE_ENA_CPU_DMA_BANK_CONF_RESETVAL (0x00000000u)

/*----CPU_DMA_Bank_Conf Tokens----*/
#define CSL_AET_AE_ENA_CPU_DMA_BANK_CONF_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_CPU_DMA_BANK_CONF_SET (0x00000001u)

#define CSL_AET_AE_ENA_CPU_SNOOP_COH_CONF_MASK (0x00800000u)
#define CSL_AET_AE_ENA_CPU_SNOOP_COH_CONF_SHIFT (0x00000017u)
#define CSL_AET_AE_ENA_CPU_SNOOP_COH_CONF_RESETVAL (0x00000000u)

/*----CPU_Snoop_Coh_Conf Tokens----*/
#define CSL_AET_AE_ENA_CPU_SNOOP_COH_CONF_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_CPU_SNOOP_COH_CONF_SET (0x00000001u)

#define CSL_AET_AE_ENA_CPU_BANK_CONF_MASK (0x00400000u)
#define CSL_AET_AE_ENA_CPU_BANK_CONF_SHIFT (0x00000016u)
#define CSL_AET_AE_ENA_CPU_BANK_CONF_RESETVAL (0x00000000u)

/*----CPU_Bank_Conf Tokens----*/
#define CSL_AET_AE_ENA_CPU_BANK_CONF_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_CPU_BANK_CONF_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_B_MASK (0x00200000u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_B_SHIFT (0x00000015u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_B_RESETVAL (0x00000000u)

/*----L1D_Tag_Vict_Wt_Buf_Flush_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_A_MASK (0x00100000u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_A_SHIFT (0x00000014u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_A_RESETVAL (0x00000000u)

/*----L1D_Tag_Vict_Wt_Buf_Flush_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAG_VICT_WT_BUF_FLUSH_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_B_MASK (0x00080000u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_B_SHIFT (0x00000013u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_B_RESETVAL (0x00000000u)

/*----L1D_WtBuf_Full_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_A_MASK (0x00040000u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_A_SHIFT (0x00000012u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_A_RESETVAL (0x00000000u)

/*----L1D_WtBuf_Full_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WTBUF_FULL_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_MISS_B_MASK (0x00020000u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_B_SHIFT (0x00000011u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_B_RESETVAL (0x00000000u)

/*----L1D_Wt_Miss_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_MISS_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_MISS_A_MASK (0x00010000u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_A_SHIFT (0x00000010u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_A_RESETVAL (0x00000000u)

/*----L1D_Wt_Miss_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_MISS_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_MISS_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_B_MASK (0x00008000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_B_SHIFT (0x0000000Fu)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_Ext_NonCache_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_A_MASK (0x00004000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_A_SHIFT (0x0000000Eu)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_Ext_NonCache_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_NONCACHE_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_B_MASK (0x00002000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_B_SHIFT (0x0000000Du)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_Ext_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_A_MASK (0x00001000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_A_SHIFT (0x0000000Cu)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_Ext_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_EXT_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_B_MASK (0x00000800u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_B_SHIFT (0x0000000Bu)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_L2Cache_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_A_MASK (0x00000400u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_A_SHIFT (0x0000000Au)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_L2Cache_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2CACHE_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_B_MASK (0x00000200u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_B_SHIFT (0x00000009u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_L2SRAM_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_A_MASK (0x00000100u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_A_SHIFT (0x00000008u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Miss_L2SRAM_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_MISS_L2SRAM_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_B_MASK (0x00000080u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_B_SHIFT (0x00000007u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_B_RESETVAL (0x00000000u)

/*----L1D_TagBuf_Full_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_A_MASK (0x00000040u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_A_SHIFT (0x00000006u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_A_RESETVAL (0x00000000u)

/*----L1D_TagBuf_Full_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAGBUF_FULL_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_HIT_B_MASK (0x00000020u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_B_SHIFT (0x00000005u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_B_RESETVAL (0x00000000u)

/*----L1D_Wt_Hit_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_HIT_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_B_SET  (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_HIT_A_MASK (0x00000010u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_A_SHIFT (0x00000004u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_A_RESETVAL (0x00000000u)

/*----L1D_Wt_Hit_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_HIT_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_HIT_A_SET  (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_B_MASK (0x00000008u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_B_SHIFT (0x00000003u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Hit_Cache_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_A_MASK (0x00000004u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_A_SHIFT (0x00000002u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Hit_Cache_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_CACHE_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_B_MASK (0x00000002u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_B_SHIFT (0x00000001u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_B_RESETVAL (0x00000000u)

/*----L1D_Rd_Hit_SRAM_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_A_MASK (0x00000001u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_A_SHIFT (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_A_RESETVAL (0x00000000u)

/*----L1D_Rd_Hit_SRAM_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_RD_HIT_SRAM_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_RESETVAL          (0x00000000u)

/* AE_ENA */

#define CSL_AET_AE_ENA_L1D_COH_CONF_STALL_MASK (0x00400000u)
#define CSL_AET_AE_ENA_L1D_COH_CONF_STALL_SHIFT (0x00000016u)
#define CSL_AET_AE_ENA_L1D_COH_CONF_STALL_RESETVAL (0x00000000u)

/*----L1D_Coh_Conf_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_COH_CONF_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_COH_CONF_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_SNOOP_CONF_STALL_MASK (0x00200000u)
#define CSL_AET_AE_ENA_L1D_SNOOP_CONF_STALL_SHIFT (0x00000015u)
#define CSL_AET_AE_ENA_L1D_SNOOP_CONF_STALL_RESETVAL (0x00000000u)

/*----L1D_Snoop_Conf_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_SNOOP_CONF_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_SNOOP_CONF_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_RD_MISS_MASK (0x00100000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_RD_MISS_SHIFT (0x00000014u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_RD_MISS_RESETVAL (0x00000000u)

/*----L1D_Tag_Buf_Flush_Stall_On_Rd_Miss Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_RD_MISS_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_RD_MISS_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_WT_BUF_FULL_MASK (0x00080000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_WT_BUF_FULL_SHIFT (0x00000013u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_WT_BUF_FULL_RESETVAL (0x00000000u)

/*----L1D_Tag_Buf_Flush_Stall_On_Wt_Buf_Full Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_WT_BUF_FULL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FLUSH_STALL_ON_WT_BUF_FULL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_VICT_BUF_FLUSH_STALL_MASK (0x00040000u)
#define CSL_AET_AE_ENA_L1D_VICT_BUF_FLUSH_STALL_SHIFT (0x00000012u)
#define CSL_AET_AE_ENA_L1D_VICT_BUF_FLUSH_STALL_RESETVAL (0x00000000u)

/*----L1D_Vict_Buf_Flush_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_VICT_BUF_FLUSH_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_VICT_BUF_FLUSH_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_BUF_FLUSH_STALL_MASK (0x00020000u)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FLUSH_STALL_SHIFT (0x00000011u)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FLUSH_STALL_RESETVAL (0x00000000u)

/*----L1D_Wt_Buf_Flush_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_BUF_FLUSH_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FLUSH_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_A_MASK (0x00010000u)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_A_SHIFT (0x00000010u)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_A_RESETVAL (0x00000000u)

/*----L1D_Line_Fill_Stall_A Tokens----*/
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_A_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_A_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_B_MASK (0x00008000u)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_B_SHIFT (0x0000000Fu)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_B_RESETVAL (0x00000000u)

/*----L1D_Line_Fill_Stall_B Tokens----*/
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_B_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_LINE_FILL_STALL_B_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_TAG_BUF_FULL_STALL_MASK (0x00004000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FULL_STALL_SHIFT (0x0000000Eu)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FULL_STALL_RESETVAL (0x00000000u)

/*----L1D_Tag_Buf_Full_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FULL_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_TAG_BUF_FULL_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WT_BUF_FULL_STALL_MASK (0x00002000u)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FULL_STALL_SHIFT (0x0000000Du)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FULL_STALL_RESETVAL (0x00000000u)

/*----L1D_Wt_Buf_Full_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_WT_BUF_FULL_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WT_BUF_FULL_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_DMA_CONF_STALL_MASK (0x00001000u)
#define CSL_AET_AE_ENA_L1D_DMA_CONF_STALL_SHIFT (0x0000000Cu)
#define CSL_AET_AE_ENA_L1D_DMA_CONF_STALL_RESETVAL (0x00000000u)

/*----L1D_DMA_Conf_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_DMA_CONF_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_DMA_CONF_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_BANK_CONF_STALL_MASK (0x00000800u)
#define CSL_AET_AE_ENA_L1D_BANK_CONF_STALL_SHIFT (0x0000000Bu)
#define CSL_AET_AE_ENA_L1D_BANK_CONF_STALL_RESETVAL (0x00000000u)

/*----L1D_Bank_Conf_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_BANK_CONF_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_BANK_CONF_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_OTHER_STALL_MASK (0x00000400u)
#define CSL_AET_AE_ENA_L1D_OTHER_STALL_SHIFT (0x0000000Au)
#define CSL_AET_AE_ENA_L1D_OTHER_STALL_RESETVAL (0x00000000u)

/*----L1D_Other_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1D_OTHER_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_OTHER_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_MISS_STALL_MASK (0x00000100u)
#define CSL_AET_AE_ENA_L1P_MISS_STALL_SHIFT (0x00000008u)
#define CSL_AET_AE_ENA_L1P_MISS_STALL_RESETVAL (0x00000000u)

/*----L1P_Miss_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1P_MISS_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_MISS_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_WAIT_STATE_STALL_MASK (0x00000040u)
#define CSL_AET_AE_ENA_L1P_WAIT_STATE_STALL_SHIFT (0x00000006u)
#define CSL_AET_AE_ENA_L1P_WAIT_STATE_STALL_RESETVAL (0x00000000u)

/*----L1P_Wait_State_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1P_WAIT_STATE_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_WAIT_STATE_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1P_OTHER_STALL_MASK (0x00000020u)
#define CSL_AET_AE_ENA_L1P_OTHER_STALL_SHIFT (0x00000005u)
#define CSL_AET_AE_ENA_L1P_OTHER_STALL_RESETVAL (0x00000000u)

/*----L1P_Other_Stall Tokens----*/
#define CSL_AET_AE_ENA_L1P_OTHER_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1P_OTHER_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_MVC_STALL_MASK    (0x00000010u)
#define CSL_AET_AE_ENA_MVC_STALL_SHIFT   (0x00000004u)
#define CSL_AET_AE_ENA_MVC_STALL_RESETVAL (0x00000000u)

/*----MVC_STALL Tokens----*/
#define CSL_AET_AE_ENA_MVC_STALL_CLEAR   (0x00000000u)
#define CSL_AET_AE_ENA_MVC_STALL_SET     (0x00000001u)

#define CSL_AET_AE_ENA_EFI_STALL_MASK    (0x00000008u)
#define CSL_AET_AE_ENA_EFI_STALL_SHIFT   (0x00000003u)
#define CSL_AET_AE_ENA_EFI_STALL_RESETVAL (0x00000000u)

/*----EFI_STALL Tokens----*/
#define CSL_AET_AE_ENA_EFI_STALL_CLEAR   (0x00000000u)
#define CSL_AET_AE_ENA_EFI_STALL_SET     (0x00000001u)

#define CSL_AET_AE_ENA_BRANCH_SPANNING_EP_STALL_MASK (0x00000004u)
#define CSL_AET_AE_ENA_BRANCH_SPANNING_EP_STALL_SHIFT (0x00000002u)
#define CSL_AET_AE_ENA_BRANCH_SPANNING_EP_STALL_RESETVAL (0x00000000u)

/*----Branch_Spanning_EP_Stall Tokens----*/
#define CSL_AET_AE_ENA_BRANCH_SPANNING_EP_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_BRANCH_SPANNING_EP_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_CROSS_PATH_STALL_MASK (0x00000002u)
#define CSL_AET_AE_ENA_CROSS_PATH_STALL_SHIFT (0x00000001u)
#define CSL_AET_AE_ENA_CROSS_PATH_STALL_RESETVAL (0x00000000u)

/*----Cross_Path_Stall Tokens----*/
#define CSL_AET_AE_ENA_CROSS_PATH_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_CROSS_PATH_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_PIPELINE_STALL_MASK (0x00000001u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_SHIFT (0x00000000u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_RESETVAL (0x00000000u)

/*----Pipeline_Stall Tokens----*/
#define CSL_AET_AE_ENA_PIPELINE_STALL_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_SET (0x00000001u)

#define CSL_AET_AE_ENA_RESETVAL          (0x00000000u)

/* AE_ENA */

#define CSL_AET_AE_ENA_VICTIM_WB_FROML1D_MASK (0x80000000u)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML1D_SHIFT (0x0000001Fu)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML1D_RESETVAL (0x00000000u)

/*----VICTIM_WB_FROML1D Tokens----*/
#define CSL_AET_AE_ENA_VICTIM_WB_FROML1D_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML1D_SET (0x00000001u)

#define CSL_AET_AE_ENA_TAG_UPDATE_QUEUED_MASK (0x40000000u)
#define CSL_AET_AE_ENA_TAG_UPDATE_QUEUED_SHIFT (0x0000001Eu)
#define CSL_AET_AE_ENA_TAG_UPDATE_QUEUED_RESETVAL (0x00000000u)

/*----TAG_UPDATE_QUEUED Tokens----*/
#define CSL_AET_AE_ENA_TAG_UPDATE_QUEUED_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_TAG_UPDATE_QUEUED_SET (0x00000001u)

#define CSL_AET_AE_ENA_DMA_SNOOP_WRITE_MASK (0x20000000u)
#define CSL_AET_AE_ENA_DMA_SNOOP_WRITE_SHIFT (0x0000001Du)
#define CSL_AET_AE_ENA_DMA_SNOOP_WRITE_RESETVAL (0x00000000u)

/*----DMA_SNOOP_WRITE Tokens----*/
#define CSL_AET_AE_ENA_DMA_SNOOP_WRITE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_DMA_SNOOP_WRITE_SET (0x00000001u)

#define CSL_AET_AE_ENA_DMA_SNOOP_READ_MASK (0x10000000u)
#define CSL_AET_AE_ENA_DMA_SNOOP_READ_SHIFT (0x0000001Cu)
#define CSL_AET_AE_ENA_DMA_SNOOP_READ_RESETVAL (0x00000000u)

/*----DMA_SNOOP_READ Tokens----*/
#define CSL_AET_AE_ENA_DMA_SNOOP_READ_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_DMA_SNOOP_READ_SET (0x00000001u)

#define CSL_AET_AE_ENA_VICTIM_WB_FROML2_MASK (0x08000000u)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML2_SHIFT (0x0000001Bu)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML2_RESETVAL (0x00000000u)

/*----VICTIM_WB_FROML2 Tokens----*/
#define CSL_AET_AE_ENA_VICTIM_WB_FROML2_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_VICTIM_WB_FROML2_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WM_EXT_NONCACHE_MASK (0x04000000u)
#define CSL_AET_AE_ENA_L1D_WM_EXT_NONCACHE_SHIFT (0x0000001Au)
#define CSL_AET_AE_ENA_L1D_WM_EXT_NONCACHE_RESETVAL (0x00000000u)

/*----L1D_WM_EXT_NONCACHE Tokens----*/
#define CSL_AET_AE_ENA_L1D_WM_EXT_NONCACHE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WM_EXT_NONCACHE_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WM_EXT_MASK   (0x02000000u)
#define CSL_AET_AE_ENA_L1D_WM_EXT_SHIFT  (0x00000019u)
#define CSL_AET_AE_ENA_L1D_WM_EXT_RESETVAL (0x00000000u)

/*----L1D_WM_EXT Tokens----*/
#define CSL_AET_AE_ENA_L1D_WM_EXT_CLEAR  (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WM_EXT_SET    (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WM_L2CACHE_MASK (0x01000000u)
#define CSL_AET_AE_ENA_L1D_WM_L2CACHE_SHIFT (0x00000018u)
#define CSL_AET_AE_ENA_L1D_WM_L2CACHE_RESETVAL (0x00000000u)

/*----L1D_WM_L2CACHE Tokens----*/
#define CSL_AET_AE_ENA_L1D_WM_L2CACHE_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WM_L2CACHE_SET (0x00000001u)

#define CSL_AET_AE_ENA_L1D_WM_L2SRAM_MASK (0x00800000u)
#define CSL_AET_AE_ENA_L1D_WM_L2SRAM_SHIFT (0x00000017u)
#define CSL_AET_AE_ENA_L1D_WM_L2SRAM_RESETVAL (0x00000000u)

/*----L1D_WM_L2SRAM Tokens----*/
#define CSL_AET_AE_ENA_L1D_WM_L2SRAM_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_L1D_WM_L2SRAM_SET (0x00000001u)

#define CSL_AET_AE_ENA_DT_DMA_END_MASK   (0x00400000u)
#define CSL_AET_AE_ENA_DT_DMA_END_SHIFT  (0x00000016u)
#define CSL_AET_AE_ENA_DT_DMA_END_RESETVAL (0x00000000u)

/*----DT_DMA_END Tokens----*/
#define CSL_AET_AE_ENA_DT_DMA_END_CLEAR  (0x00000000u)
#define CSL_AET_AE_ENA_DT_DMA_END_SET    (0x00000001u)

#define CSL_AET_AE_ENA_RTDX_TX_END_MASK  (0x00200000u)
#define CSL_AET_AE_ENA_RTDX_TX_END_SHIFT (0x00000015u)
#define CSL_AET_AE_ENA_RTDX_TX_END_RESETVAL (0x00000000u)

/*----RTDX_TX_END Tokens----*/
#define CSL_AET_AE_ENA_RTDX_TX_END_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_RTDX_TX_END_SET   (0x00000001u)

#define CSL_AET_AE_ENA_RTDX_RX_END_MASK  (0x00100000u)
#define CSL_AET_AE_ENA_RTDX_RX_END_SHIFT (0x00000014u)
#define CSL_AET_AE_ENA_RTDX_RX_END_RESETVAL (0x00000000u)

/*----RTDX_RX_END Tokens----*/
#define CSL_AET_AE_ENA_RTDX_RX_END_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_RTDX_RX_END_SET   (0x00000001u)

#define CSL_AET_AE_ENA_NMI_MASK          (0x00080000u)
#define CSL_AET_AE_ENA_NMI_SHIFT         (0x00000013u)
#define CSL_AET_AE_ENA_NMI_RESETVAL      (0x00000000u)

/*----NMI Tokens----*/
#define CSL_AET_AE_ENA_NMI_CLEAR         (0x00000000u)
#define CSL_AET_AE_ENA_NMI_SET           (0x00000001u)

#define CSL_AET_AE_ENA_EXC_MASK          (0x00040000u)
#define CSL_AET_AE_ENA_EXC_SHIFT         (0x00000012u)
#define CSL_AET_AE_ENA_EXC_RESETVAL      (0x00000000u)

/*----EXC Tokens----*/
#define CSL_AET_AE_ENA_EXC_CLEAR         (0x00000000u)
#define CSL_AET_AE_ENA_EXC_SET           (0x00000001u)

#define CSL_AET_AE_ENA_EXCEP_MASK        (0x00020000u)
#define CSL_AET_AE_ENA_EXCEP_SHIFT       (0x00000011u)
#define CSL_AET_AE_ENA_EXCEP_RESETVAL    (0x00000000u)

/*----EXCEP Tokens----*/
#define CSL_AET_AE_ENA_EXCEP_CLEAR       (0x00000000u)
#define CSL_AET_AE_ENA_EXCEP_SET         (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT7_MASK      (0x00010000u)
#define CSL_AET_AE_ENA_AEGEVT7_SHIFT     (0x00000010u)
#define CSL_AET_AE_ENA_AEGEVT7_RESETVAL  (0x00000000u)

/*----AEGEVT7 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT7_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT7_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT6_MASK      (0x00008000u)
#define CSL_AET_AE_ENA_AEGEVT6_SHIFT     (0x0000000Fu)
#define CSL_AET_AE_ENA_AEGEVT6_RESETVAL  (0x00000000u)

/*----AEGEVT6 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT6_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT6_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT5_MASK      (0x00004000u)
#define CSL_AET_AE_ENA_AEGEVT5_SHIFT     (0x0000000Eu)
#define CSL_AET_AE_ENA_AEGEVT5_RESETVAL  (0x00000000u)

/*----AEGEVT5 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT5_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT5_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT4_MASK      (0x00002000u)
#define CSL_AET_AE_ENA_AEGEVT4_SHIFT     (0x0000000Du)
#define CSL_AET_AE_ENA_AEGEVT4_RESETVAL  (0x00000000u)

/*----AEGEVT4 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT4_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT4_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT3_MASK      (0x00001000u)
#define CSL_AET_AE_ENA_AEGEVT3_SHIFT     (0x0000000Cu)
#define CSL_AET_AE_ENA_AEGEVT3_RESETVAL  (0x00000000u)

/*----AEGEVT3 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT3_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT3_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT2_MASK      (0x00000800u)
#define CSL_AET_AE_ENA_AEGEVT2_SHIFT     (0x0000000Bu)
#define CSL_AET_AE_ENA_AEGEVT2_RESETVAL  (0x00000000u)

/*----AEGEVT2 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT2_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT2_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT1_MASK      (0x00000400u)
#define CSL_AET_AE_ENA_AEGEVT1_SHIFT     (0x0000000Au)
#define CSL_AET_AE_ENA_AEGEVT1_RESETVAL  (0x00000000u)

/*----AEGEVT1 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT1_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT1_SET       (0x00000001u)

#define CSL_AET_AE_ENA_AEGEVT0_MASK      (0x00000200u)
#define CSL_AET_AE_ENA_AEGEVT0_SHIFT     (0x00000009u)
#define CSL_AET_AE_ENA_AEGEVT0_RESETVAL  (0x00000000u)

/*----AEGEVT0 Tokens----*/
#define CSL_AET_AE_ENA_AEGEVT0_CLEAR     (0x00000000u)
#define CSL_AET_AE_ENA_AEGEVT0_SET       (0x00000001u)

#define CSL_AET_AE_ENA_IACK_MASK         (0x00000100u)
#define CSL_AET_AE_ENA_IACK_SHIFT        (0x00000008u)
#define CSL_AET_AE_ENA_IACK_RESETVAL     (0x00000000u)

/*----IACK Tokens----*/
#define CSL_AET_AE_ENA_IACK_CLEAR        (0x00000000u)
#define CSL_AET_AE_ENA_IACK_SET          (0x00000001u)

#define CSL_AET_AE_ENA_ET1_MASK          (0x00000080u)
#define CSL_AET_AE_ENA_ET1_SHIFT         (0x00000007u)
#define CSL_AET_AE_ENA_ET1_RESETVAL      (0x00000000u)

/*----ET1 Tokens----*/
#define CSL_AET_AE_ENA_ET1_CLEAR         (0x00000000u)
#define CSL_AET_AE_ENA_ET1_SET           (0x00000001u)

#define CSL_AET_AE_ENA_ET0_MASK          (0x00000040u)
#define CSL_AET_AE_ENA_ET0_SHIFT         (0x00000006u)
#define CSL_AET_AE_ENA_ET0_RESETVAL      (0x00000000u)

/*----ET0 Tokens----*/
#define CSL_AET_AE_ENA_ET0_CLEAR         (0x00000000u)
#define CSL_AET_AE_ENA_ET0_SET           (0x00000001u)

#define CSL_AET_AE_ENA_MARK3_MASK        (0x00000020u)
#define CSL_AET_AE_ENA_MARK3_SHIFT       (0x00000005u)
#define CSL_AET_AE_ENA_MARK3_RESETVAL    (0x00000000u)

/*----MARK3 Tokens----*/
#define CSL_AET_AE_ENA_MARK3_CLEAR       (0x00000000u)
#define CSL_AET_AE_ENA_MARK3_SET         (0x00000001u)

#define CSL_AET_AE_ENA_MARK2_MASK        (0x00000010u)
#define CSL_AET_AE_ENA_MARK2_SHIFT       (0x00000004u)
#define CSL_AET_AE_ENA_MARK2_RESETVAL    (0x00000000u)

/*----MARK2 Tokens----*/
#define CSL_AET_AE_ENA_MARK2_CLEAR       (0x00000000u)
#define CSL_AET_AE_ENA_MARK2_SET         (0x00000001u)

#define CSL_AET_AE_ENA_MARK1_MASK        (0x00000008u)
#define CSL_AET_AE_ENA_MARK1_SHIFT       (0x00000003u)
#define CSL_AET_AE_ENA_MARK1_RESETVAL    (0x00000000u)

/*----MARK1 Tokens----*/
#define CSL_AET_AE_ENA_MARK1_CLEAR       (0x00000000u)
#define CSL_AET_AE_ENA_MARK1_SET         (0x00000001u)

#define CSL_AET_AE_ENA_MARK0_MASK        (0x00000004u)
#define CSL_AET_AE_ENA_MARK0_SHIFT       (0x00000002u)
#define CSL_AET_AE_ENA_MARK0_RESETVAL    (0x00000000u)

/*----MARK0 Tokens----*/
#define CSL_AET_AE_ENA_MARK0_CLEAR       (0x00000000u)
#define CSL_AET_AE_ENA_MARK0_SET         (0x00000001u)

#define CSL_AET_AE_ENA_PIPELINE_STALL_MISC_MASK (0x00000002u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_MISC_SHIFT (0x00000001u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_MISC_RESETVAL (0x00000000u)

/*----PIPELINE_STALL_MISC Tokens----*/
#define CSL_AET_AE_ENA_PIPELINE_STALL_MISC_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_PIPELINE_STALL_MISC_SET (0x00000001u)

#define CSL_AET_AE_ENA_EXECUTE_CYCLES_MASK (0x00000001u)
#define CSL_AET_AE_ENA_EXECUTE_CYCLES_SHIFT (0x00000000u)
#define CSL_AET_AE_ENA_EXECUTE_CYCLES_RESETVAL (0x00000000u)

/*----EXECUTE_CYCLES Tokens----*/
#define CSL_AET_AE_ENA_EXECUTE_CYCLES_CLEAR (0x00000000u)
#define CSL_AET_AE_ENA_EXECUTE_CYCLES_SET (0x00000001u)

#define CSL_AET_AE_ENA_RESETVAL          (0x00000000u)

/* CMPI_SEL */

#define CSL_AET_CMPI_SEL_RESERVED_MASK   (0xFFFC0000u)
#define CSL_AET_CMPI_SEL_RESERVED_SHIFT  (0x00000012u)
#define CSL_AET_CMPI_SEL_RESERVED_RESETVAL (0x00000000u)

#define CSL_AET_CMPI_SEL_OAE_MASK        (0x00030000u)
#define CSL_AET_CMPI_SEL_OAE_SHIFT       (0x00000010u)
#define CSL_AET_CMPI_SEL_OAE_RESETVAL    (0x00000000u)

/*----OAE Tokens----*/
#define CSL_AET_CMPI_SEL_OAE_MEMORY_EVENTS (0x00000000u)
#define CSL_AET_CMPI_SEL_OAE_STALLS      (0x00000001u)
#define CSL_AET_CMPI_SEL_OAE_MISC_EVENTS (0x00000002u)

#define CSL_AET_CMPI_SEL_CMP3_ADR_MASK   (0x00003000u)
#define CSL_AET_CMPI_SEL_CMP3_ADR_SHIFT  (0x0000000Cu)
#define CSL_AET_CMPI_SEL_CMP3_ADR_RESETVAL (0x00000000u)

/*----CMP3_ADR Tokens----*/
#define CSL_AET_CMPI_SEL_CMP3_ADR_DA0    (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP3_ADR_DA1    (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP3_ADR_PA     (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP3_ADR_RESERVED (0x00000003u)

#define CSL_AET_CMPI_SEL_CMP2_ADR_MASK   (0x00000300u)
#define CSL_AET_CMPI_SEL_CMP2_ADR_SHIFT  (0x00000008u)
#define CSL_AET_CMPI_SEL_CMP2_ADR_RESETVAL (0x00000000u)

/*----CMP2_ADR Tokens----*/
#define CSL_AET_CMPI_SEL_CMP2_ADR_DA0    (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP2_ADR_DA1    (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP2_ADR_PA     (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP2_ADR_RESERVED (0x00000003u)

#define CSL_AET_CMPI_SEL_CMP1_DATA_MASK  (0x000000C0u)
#define CSL_AET_CMPI_SEL_CMP1_DATA_SHIFT (0x00000006u)
#define CSL_AET_CMPI_SEL_CMP1_DATA_RESETVAL (0x00000000u)

/*----CMP1_DATA Tokens----*/
#define CSL_AET_CMPI_SEL_CMP1_DATA_DW0   (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP1_DATA_DW1   (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP1_DATA_DR0   (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP1_DATA_DR1   (0x00000003u)

#define CSL_AET_CMPI_SEL_CMP1_ADR_MASK   (0x00000030u)
#define CSL_AET_CMPI_SEL_CMP1_ADR_SHIFT  (0x00000004u)
#define CSL_AET_CMPI_SEL_CMP1_ADR_RESETVAL (0x00000000u)

/*----CMP1_ADR Tokens----*/
#define CSL_AET_CMPI_SEL_CMP1_ADR_DA0    (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP1_ADR_DA1    (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP1_ADR_PA     (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP1_ADR_RESERVED (0x00000003u)

#define CSL_AET_CMPI_SEL_CMP0_DATA_MASK  (0x0000000Cu)
#define CSL_AET_CMPI_SEL_CMP0_DATA_SHIFT (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP0_DATA_RESETVAL (0x00000000u)

/*----CMP0_DATA Tokens----*/
#define CSL_AET_CMPI_SEL_CMP0_DATA_DW0   (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP0_DATA_DW1   (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP0_DATA_DR0   (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP0_DATA_DR1   (0x00000003u)

#define CSL_AET_CMPI_SEL_CMP0_ADR_MASK   (0x00000003u)
#define CSL_AET_CMPI_SEL_CMP0_ADR_SHIFT  (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP0_ADR_RESETVAL (0x00000000u)

/*----CMP0_ADR Tokens----*/
#define CSL_AET_CMPI_SEL_CMP0_ADR_DA0    (0x00000000u)
#define CSL_AET_CMPI_SEL_CMP0_ADR_DA1    (0x00000001u)
#define CSL_AET_CMPI_SEL_CMP0_ADR_PA     (0x00000002u)
#define CSL_AET_CMPI_SEL_CMP0_ADR_RESERVED (0x00000003u)

#define CSL_AET_CMPI_SEL_RESETVAL        (0x00000000u)

#endif
