/*****************************************************************************\
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments
*  For  Unrestricted  Internal  Use  Only
*  Unauthorized reproduction and/or distribution is strictly prohibited.
*  This product is protected under copyright law and trade secret law
*  as an unpublished work.
*  Created 2008, (C) Copyright 2008 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : edma_xxx.h
*  Date Created   : Oct 10, 2005
*  Last Modified  : April 8, 2008
*  Description    : EDMA3 related macros, data and func prototypes  
*  History        : Ported from Faraday
*  Project        : Curie
*  Author         : Anand Patil
\*****************************************************************************/
#ifndef _CSLR_AET_MMR_001_H_
#define _CSLR_AET_MMR_001_H_
/*********************************************************************
 * Copyright (C) 2003-2004 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_aet_mmr_001.h
 * 
 * \brief This file contains the Register Desciptions for AET_MMR
 * 
 *********************************************************************/

#include <ti/csl/cslr.h>

#include <ti/csl/tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 IAR_ADD_RD;
    volatile Uint32 IAR_DAT;
    volatile Uint32 EVT;
    volatile Uint32 PID_RD;
    volatile Uint32 PC;
    volatile Uint32 SPL_PC;
    volatile Uint32 SPL_STAT;
} CSL_Aet_mmrRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IAR_ADD_RD */

#define CSL_AET_MMR_IAR_ADD_RD_BEND_MASK (0x80000000u)
#define CSL_AET_MMR_IAR_ADD_RD_BEND_SHIFT (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_RD_BEND_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_TEND_MASK (0x40000000u)
#define CSL_AET_MMR_IAR_ADD_RD_TEND_SHIFT (0x0000001Eu)
#define CSL_AET_MMR_IAR_ADD_RD_TEND_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_PLOST_MASK (0x20000000u)
#define CSL_AET_MMR_IAR_ADD_RD_PLOST_SHIFT (0x0000001Du)
#define CSL_AET_MMR_IAR_ADD_RD_PLOST_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_DLOST_MASK (0x10000000u)
#define CSL_AET_MMR_IAR_ADD_RD_DLOST_SHIFT (0x0000001Cu)
#define CSL_AET_MMR_IAR_ADD_RD_DLOST_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_OVF1_MASK (0x02000000u)
#define CSL_AET_MMR_IAR_ADD_RD_OVF1_SHIFT (0x00000019u)
#define CSL_AET_MMR_IAR_ADD_RD_OVF1_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_OVF0_MASK (0x01000000u)
#define CSL_AET_MMR_IAR_ADD_RD_OVF0_SHIFT (0x00000018u)
#define CSL_AET_MMR_IAR_ADD_RD_OVF0_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_TRIG_MASK (0x00800000u)
#define CSL_AET_MMR_IAR_ADD_RD_TRIG_SHIFT (0x00000017u)
#define CSL_AET_MMR_IAR_ADD_RD_TRIG_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_REND_MASK (0x00400000u)
#define CSL_AET_MMR_IAR_ADD_RD_REND_SHIFT (0x00000016u)
#define CSL_AET_MMR_IAR_ADD_RD_REND_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_SMM_MASK  (0x00000200u)
#define CSL_AET_MMR_IAR_ADD_RD_SMM_SHIFT (0x00000009u)
#define CSL_AET_MMR_IAR_ADD_RD_SMM_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_ST_MASK   (0x000001E0u)
#define CSL_AET_MMR_IAR_ADD_RD_ST_SHIFT  (0x00000005u)
#define CSL_AET_MMR_IAR_ADD_RD_ST_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_CFR_MASK  (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_RD_CFR_SHIFT (0x00000000u)
#define CSL_AET_MMR_IAR_ADD_RD_CFR_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RD_RESETVAL  (0x00000000u)

/* IAR_ADD_WRT */

#define CSL_AET_MMR_IAR_ADD_WRT_RBEND_MASK (0x80000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_RBEND_SHIFT (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_WRT_RBEND_RESETVAL (0x00000000u)

/*----RBEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_RBEND_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_RTEND_MASK (0x40000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_RTEND_SHIFT (0x0000001Eu)
#define CSL_AET_MMR_IAR_ADD_WRT_RTEND_RESETVAL (0x00000000u)

/*----RTEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_RTEND_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_RPLOST_MASK (0x20000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_RPLOST_SHIFT (0x0000001Du)
#define CSL_AET_MMR_IAR_ADD_WRT_RPLOST_RESETVAL (0x00000000u)

/*----RPLOST Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_RPLOST_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_RDLOST_MASK (0x10000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_RDLOST_SHIFT (0x0000001Cu)
#define CSL_AET_MMR_IAR_ADD_WRT_RDLOST_RESETVAL (0x00000000u)

/*----RDLOST Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_RDLOST_RESET (0x00000001u)
#define CSL_AET_MMR_IAR_ADD_WRT__RESV_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_ROVF1_MASK (0x02000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF1_SHIFT (0x00000019u)
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF1_RESETVAL (0x00000000u)

/*----ROVF1 Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF1_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_ROVF0_MASK (0x01000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF0_SHIFT (0x00000018u)
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF0_RESETVAL (0x00000000u)

/*----ROVF0 Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_ROVF0_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_UTRV_MASK (0x00800000u)
#define CSL_AET_MMR_IAR_ADD_WRT_UTRV_SHIFT (0x00000017u)
#define CSL_AET_MMR_IAR_ADD_WRT_UTRV_RESETVAL (0x00000000u)

/*----UTRV Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_UTRV_UPDATE (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_STEND_MASK (0x00400000u)
#define CSL_AET_MMR_IAR_ADD_WRT_STEND_SHIFT (0x00000016u)
#define CSL_AET_MMR_IAR_ADD_WRT_STEND_RESETVAL (0x00000000u)

/*----STEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_STEND_SET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_RREND_MASK (0x00200000u)
#define CSL_AET_MMR_IAR_ADD_WRT_RREND_SHIFT (0x00000015u)
#define CSL_AET_MMR_IAR_ADD_WRT_RREND_RESETVAL (0x00000000u)

/*----RREND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRT_RREND_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRT_ADDR_MASK (0x000003FFu)
#define CSL_AET_MMR_IAR_ADD_WRT_ADDR_SHIFT (0x00000000u)
#define CSL_AET_MMR_IAR_ADD_WRT_ADDR_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_WRT_RESETVAL (0x00000000u)

/* IAR_DAT */

#define CSL_AET_MMR_IAR_DAT_DATA_MASK    (0xFFFFFFFFu)
#define CSL_AET_MMR_IAR_DAT_DATA_SHIFT   (0x00000000u)
#define CSL_AET_MMR_IAR_DAT_DATA_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_DAT_RESETVAL     (0x00000000u)

/* EVT */

#define CSL_AET_MMR_EVT_STATUS_MASK      (0xFFFFFFFFu)
#define CSL_AET_MMR_EVT_STATUS_SHIFT     (0x00000000u)
#define CSL_AET_MMR_EVT_STATUS_RESETVAL  (0x00000000u)

#define CSL_AET_MMR_EVT_RESETVAL         (0x00000000u)

/* PID_RD */

#define CSL_AET_MMR_PID_RD_AOWN_MASK     (0x80000000u)
#define CSL_AET_MMR_PID_RD_AOWN_SHIFT    (0x0000001Fu)
#define CSL_AET_MMR_PID_RD_AOWN_RESETVAL (0x00000000u)

/*----AOWN Tokens----*/
#define CSL_AET_MMR_PID_RD_AOWN_DEBUG    (0x00000000u)
#define CSL_AET_MMR_PID_RD_AOWN_APP      (0x00000001u)

#define CSL_AET_MMR_PID_RD_ID_MASK       (0x0000FFFCu)
#define CSL_AET_MMR_PID_RD_ID_SHIFT      (0x00000002u)
#define CSL_AET_MMR_PID_RD_ID_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_PID_RD_STATE_MASK    (0x00000003u)
#define CSL_AET_MMR_PID_RD_STATE_SHIFT   (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_RESETVAL (0x00000000u)

/*----STATE Tokens----*/
#define CSL_AET_MMR_PID_RD_STATE_RELEASED (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_CLAIMED (0x00000001u)
#define CSL_AET_MMR_PID_RD_STATE_ENABLED (0x00000002u)
#define CSL_AET_MMR_PID_RD_STATE_RESERVED (0x00000003u)

#define CSL_AET_MMR_PID_RD_RESETVAL      (0x00000000u)

/* PID_WRT */

#define CSL_AET_MMR_PID_WRT_AOWN_MASK    (0x80000000u)
#define CSL_AET_MMR_PID_WRT_AOWN_SHIFT   (0x0000001Fu)
#define CSL_AET_MMR_PID_WRT_AOWN_RESETVAL (0x00000000u)

/*----AOWN Tokens----*/
#define CSL_AET_MMR_PID_WRT_AOWN_0X0     (0x00000000u)
#define CSL_AET_MMR_PID_WRT_AOWN_0X1     (0x00000001u)

#define CSL_AET_MMR_PID_WRT_STATE_MASK   (0x00000003u)
#define CSL_AET_MMR_PID_WRT_STATE_SHIFT  (0x00000000u)
#define CSL_AET_MMR_PID_WRT_STATE_RESETVAL (0x00000000u)

/*----STATE Tokens----*/
#define CSL_AET_MMR_PID_WRT_STATE_RELEASE (0x00000000u)
#define CSL_AET_MMR_PID_WRT_STATE_CLAIM  (0x00000001u)
#define CSL_AET_MMR_PID_WRT_STATE_ENABLE (0x00000002u)
#define CSL_AET_MMR_PID_WRT_STATE_RESERVED (0x00000003u)

#define CSL_AET_MMR_PID_WRT_RESETVAL     (0x00000000u)

/* PC */

#define CSL_AET_MMR_PC_STATUS_MASK       (0xFFFFFFFFu)
#define CSL_AET_MMR_PC_STATUS_SHIFT      (0x00000000u)
#define CSL_AET_MMR_PC_STATUS_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_PC_RESETVAL          (0x00000000u)

/* SPL_PC */

#define CSL_AET_MMR_SPL_PC_PC_MASK       (0xFFFFFFFFu)
#define CSL_AET_MMR_SPL_PC_PC_SHIFT      (0x00000000u)
#define CSL_AET_MMR_SPL_PC_PC_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_SPL_PC_RESETVAL      (0x00000000u)

/* SPL_STAT */

#define CSL_AET_MMR_SPL_STAT_PC_MASK     (0xFFFFFFFFu)
#define CSL_AET_MMR_SPL_STAT_PC_SHIFT    (0x00000000u)
#define CSL_AET_MMR_SPL_STAT_PC_RESETVAL (0x00000000u)

#define CSL_AET_MMR_SPL_STAT_RESETVAL    (0x00000000u)





#endif
