#include <ti/csl/cslr_device.h>
#define PSC_PRE_RESV_START	 0x02340000 // 0x02a48400  //  John Herrington - Ported from Curie to Nyquist
#define PSC_PRE_RESV_END	 0x0234FFFC // 0x02abfffc
#define PSC_START_ADDRESS	 CSL_PSC_REGS //0x02350000 // 0x02ac0000
#define PSC_POST_RESV_START	 0x02351000 // 0x02ac1000
#define PSC_POST_RESV_END	 0x0235FFFC // 0x02ac3ffc

#define PSC_MDCTL00           0xA00
#define PSC_MDSTAT00          0x800
#define PSC_PDCTL00           0x300
#define PSC_PDSTAT00          0x200

#define PSC_MDCTL_BASE        PSC_MDCTL00
#define PSC_MDSTAT_BASE       PSC_MDSTAT00
#define PSC_PDCTL_BASE        PSC_PDCTL00
#define PSC_PDSTAT_BASE       PSC_PDSTAT00

extern unsigned int smrflx_pdctl       ; 
extern unsigned int smrflx_mdctl       ; 
extern unsigned int ddr3emif_pdctl     ; 
extern unsigned int ddr3emif_mdctl     ; 
extern unsigned int tcp3e_pdctl        ; 
extern unsigned int tcp3e_mdctl        ; 
extern unsigned int vcp0_pdctl         ; 
extern unsigned int vcp0_mdctl         ; 
extern unsigned int debugss_pdctl      ; 
extern unsigned int debugss_mdctl      ; 
extern unsigned int tetb_pdctl         ; 
extern unsigned int tetb_mdctl         ; 
extern unsigned int pass_pdctl         ; 
extern unsigned int pass_mdctl         ; 
extern unsigned int sgmii_pdctl        ; 
extern unsigned int sgmii_mdctl        ; 
extern unsigned int crypto_pdctl       ; 
extern unsigned int crypto_mdctl       ; 
extern unsigned int pciex_pdctl        ; 
extern unsigned int pciex_mdctl        ; 
extern unsigned int srio_pdctl         ; 
extern unsigned int srio_mdctl         ; 
extern unsigned int mcm_pdctl          ; 
extern unsigned int mcm_mdctl          ; 
extern unsigned int l2sram_pdctl       ; 
extern unsigned int l2sram_mdctl       ; 
extern unsigned int msmcram_pdctl      ; 
extern unsigned int msmcram_mdctl      ; 
extern unsigned int rac_pdctl          ; 
extern unsigned int rac_mdctl          ; 
extern unsigned int tac_pdctl          ; 
extern unsigned int tac_mdctl          ; 
extern unsigned int fftc_pdctl         ; 
extern unsigned int fftc_mdctl         ; 
extern unsigned int aif_pdctl          ; 
extern unsigned int aif_mdctl          ; 
extern unsigned int tcp3d_pdctl        ; 
extern unsigned int tcp3d_mdctl        ; 
extern unsigned int vcp1_pdctl         ; 
extern unsigned int vcp1_mdctl         ; 
extern unsigned int vcp2_pdctl         ; 
extern unsigned int vcp2_mdctl         ; 
extern unsigned int vcp3_pdctl         ; 
extern unsigned int vcp3_mdctl         ; 
extern unsigned int gem0_pdctl         ; 
extern unsigned int gem0_mdctl         ; 
extern unsigned int gem1_pdctl         ; 
extern unsigned int gem1_mdctl         ; 
extern unsigned int rsa01_pdctl        ; 
extern unsigned int rsa01_mdctl        ; 
extern unsigned int gem2_pdctl         ; 
extern unsigned int gem2_mdctl         ; 
extern unsigned int rsa23_pdctl        ; 
extern unsigned int rsa23_mdctl        ; 
extern unsigned int gem3_pdctl         ; 
extern unsigned int gem3_mdctl         ; 
extern const unsigned int max_pd;
#define MDLIMIT_PER_PD        8
extern unsigned int mds_in_pd[][MDLIMIT_PER_PD];


/*
//Following definitions to be updated with PSC register offsets

#define PSC_PERIPHERAL_ID  PSC_START_ADDRESS + 0x00000000
#define PSC_RESV_000       PSC_START_ADDRESS + 0x00000004
#define PSC_RESV_001       PSC_START_ADDRESS + 0x0000000c
	
#define PSC_GBLCTL         PSC_START_ADDRESS + 0x00000010
#define PSC_GBLSTAT        PSC_START_ADDRESS + 0x00000014
#define PSC_INTEVAL        PSC_START_ADDRESS + 0x00000018
#define PSC_RESV_010       PSC_START_ADDRESS + 0x0000001c
#define PSC_RESV_011       PSC_START_ADDRESS + 0x0000003c
	
#define PSC_MERRPR0	   PSC_START_ADDRESS + 0x00000040
#define PSC_MERRPR1	   PSC_START_ADDRESS + 0x00000044
#define PSC_RESV_020   PSC_START_ADDRESS + 0x00000048
#define PSC_RESV_021   PSC_START_ADDRESS + 0x0000004C

#define PSC_MERRCR0	   PSC_START_ADDRESS + 0x00000050
#define PSC_MERRCR1	   PSC_START_ADDRESS + 0x00000054
#define PSC_RESV_030   PSC_START_ADDRESS + 0x00000058
#define PSC_RESV_031   PSC_START_ADDRESS + 0x0000005C
	
#define PSC_PERRPR	   PSC_START_ADDRESS + 0x00000060
#define PSC_RESV_040   PSC_START_ADDRESS + 0x00000064
#define PSC_RESV_041   PSC_START_ADDRESS + 0x00000064

#define PSC_PERRCR	   PSC_START_ADDRESS + 0x00000068
#define PSC_RESV_050   PSC_START_ADDRESS + 0x0000006C
#define PSC_RESV_051   PSC_START_ADDRESS + 0x0000006C

#define PSC_EPCPR	   PSC_START_ADDRESS + 0x00000070
#define PSC_RESV_060   PSC_START_ADDRESS + 0x00000074
#define PSC_RESV_061   PSC_START_ADDRESS + 0x00000074

#define PSC_EPCCR	   PSC_START_ADDRESS + 0x00000078
#define PSC_RESV_070   PSC_START_ADDRESS + 0x0000007C
#define PSC_RESV_071   PSC_START_ADDRESS + 0x000000FC
				



#define PSC_RAILSTAT        PSC_START_ADDRESS + 0x00000100
#define PSC_RAILCTL         PSC_START_ADDRESS + 0x00000104
#define PSC_RAILSEL         PSC_START_ADDRESS + 0x00000108
#define PSC_RESV_080        PSC_START_ADDRESS + 0x0000010c
#define PSC_RESV_081        PSC_START_ADDRESS + 0x0000011c
#define PSC_PTCMD           PSC_START_ADDRESS + 0x00000120
#define PSC_RESV_090        PSC_START_ADDRESS + 0x00000124
#define PSC_RESV_091        PSC_START_ADDRESS + 0x00000124
#define PSC_PTSTAT          PSC_START_ADDRESS + 0x00000128
#define PSC_RESV_100        PSC_START_ADDRESS + 0x0000012c
#define PSC_RESV_101        PSC_START_ADDRESS + 0x000001fc
                   
#define PSC_PDSTAT0         PSC_START_ADDRESS + 0x00000200
#define PSC_PDSTAT1         PSC_START_ADDRESS + 0x00000204
#define PSC_PDSTAT2         PSC_START_ADDRESS + 0x00000208
#define PSC_PDSTAT3         PSC_START_ADDRESS + 0x0000020c
#define PSC_PDSTAT4         PSC_START_ADDRESS + 0x00000210
#define PSC_RESV_110        PSC_START_ADDRESS + 0x00000214
#define PSC_RESV_111        PSC_START_ADDRESS + 0x000002fc
	               
#define PSC_PDCTL0          PSC_START_ADDRESS + 0x00000300
#define PSC_PDCTL1          PSC_START_ADDRESS + 0x00000304
#define PSC_PDCTL2          PSC_START_ADDRESS + 0x00000308
#define PSC_PDCTL3          PSC_START_ADDRESS + 0x0000030c
#define PSC_PDCTL4          PSC_START_ADDRESS + 0x00000310
#define PSC_RESV_120        PSC_START_ADDRESS + 0x00000314
#define PSC_RESV_121        PSC_START_ADDRESS + 0x000003fc
	               
#define PSC_PDCFG0          PSC_START_ADDRESS + 0x00000400
#define PSC_PDCFG1          PSC_START_ADDRESS + 0x00000404
#define PSC_PDCFG2          PSC_START_ADDRESS + 0x00000408
#define PSC_PDCFG3          PSC_START_ADDRESS + 0x0000040c
#define PSC_PDCFG4          PSC_START_ADDRESS + 0x00000410
#define PSC_RESV_130        PSC_START_ADDRESS + 0x00000414
#define PSC_RESV_131        PSC_START_ADDRESS + 0x000005fc
	               
#define PSC_MDCFG0          PSC_START_ADDRESS + 0x00000600
#define PSC_MDCFG1          PSC_START_ADDRESS + 0x00000604
#define PSC_MDCFG2          PSC_START_ADDRESS + 0x00000608
#define PSC_MDCFG3          PSC_START_ADDRESS + 0x0000060c
#define PSC_MDCFG4          PSC_START_ADDRESS + 0x00000610
#define PSC_MDCFG5          PSC_START_ADDRESS + 0x00000614
#define PSC_MDCFG6          PSC_START_ADDRESS + 0x00000618
#define PSC_MDCFG7          PSC_START_ADDRESS + 0x0000061c
#define PSC_MDCFG8          PSC_START_ADDRESS + 0x00000620
#define PSC_MDCFG9          PSC_START_ADDRESS + 0x00000624
#define PSC_MDCFG10         PSC_START_ADDRESS + 0x00000628
#define PSC_RESV_140        PSC_START_ADDRESS + 0x0000062c
#define PSC_RESV_141        PSC_START_ADDRESS + 0x000007fc
	               
#define PSC_MDSTAT0         PSC_START_ADDRESS + 0x00000800
#define PSC_MDSTAT1         PSC_START_ADDRESS + 0x00000804
#define PSC_MDSTAT2         PSC_START_ADDRESS + 0x00000808
#define PSC_MDSTAT3         PSC_START_ADDRESS + 0x0000080c
#define PSC_MDSTAT4         PSC_START_ADDRESS + 0x00000810
#define PSC_MDSTAT5         PSC_START_ADDRESS + 0x00000814
#define PSC_MDSTAT6         PSC_START_ADDRESS + 0x00000818
#define PSC_MDSTAT7         PSC_START_ADDRESS + 0x0000081c
#define PSC_MDSTAT8         PSC_START_ADDRESS + 0x00000820
#define PSC_MDSTAT9         PSC_START_ADDRESS + 0x00000824
#define PSC_MDSTAT10        PSC_START_ADDRESS + 0x00000828
#define PSC_RESV_150        PSC_START_ADDRESS + 0x0000082c
#define PSC_RESV_151        PSC_START_ADDRESS + 0x000009fc
	               
#define PSC_MDCTL0          PSC_START_ADDRESS + 0x00000a00
#define PSC_MDCTL1          PSC_START_ADDRESS + 0x00000a04
#define PSC_MDCTL2          PSC_START_ADDRESS + 0x00000a08
#define PSC_MDCTL3          PSC_START_ADDRESS + 0x00000a0c
#define PSC_MDCTL4          PSC_START_ADDRESS + 0x00000a10
#define PSC_MDCTL5          PSC_START_ADDRESS + 0x00000a14
#define PSC_MDCTL6          PSC_START_ADDRESS + 0x00000a18
#define PSC_MDCTL7          PSC_START_ADDRESS + 0x00000a1c
#define PSC_MDCTL8          PSC_START_ADDRESS + 0x00000a20
#define PSC_MDCTL9          PSC_START_ADDRESS + 0x00000a24
#define PSC_MDCTL10         PSC_START_ADDRESS + 0x00000a28
#define PSC_RESV_160        PSC_START_ADDRESS + 0x00000a2c
#define PSC_RESV_161        PSC_START_ADDRESS + 0x00000ffc
*/

//  Register reset values
#define PSC_PERIPHERAL_ID_RSTVAL		0x44820200
#define PSC_GBLCTL_RSTVAL			0x00000000
#define PSC_GBLSTAT_RSTVAL			0x0FFF0000
#define PSC_MERRPR0_RSTVAL			0x00000000
#define PSC_MERRPR1_RSTVAL			0x00000000
#define PSC_MERRCR0_RSTVAL			0x00000000
#define PSC_MERRCR1_RSTVAL			0x00000000
#define PSC_PERRPR_RSTVAL			0x00000000
#define PSC_PERRCR_RSTVAL			0x00000000
#define PSC_EPCPR_RSTVAL			0x00000000
#define PSC_EPCCR_RSTVAL			0x00000000
#define PSC_RAILSTAT_RSTVAL			0x00000000
#define PSC_RAILCTL_RSTVAL			0x00000000
#define PSC_RAILSEL_RSTVAL			0x00000000
#define PSC_PTCMD_RSTVAL			0x00000000
#define PSC_PTSTAT_RSTVAL			0x00000000

#define PSC_PDSTAT0_RSTVAL			0x00000301
#define PSC_PDSTAT1_RSTVAL			0x00000200
#define PSC_PDSTAT2_RSTVAL			0x00000200
#define PSC_PDSTAT3_RSTVAL			0x00000200
#define PSC_PDSTAT4_RSTVAL			0x00000200

#define PSC_PDCTL0_RSTVAL			0x00220001
#define PSC_PDCTL1_RSTVAL			0x00220000
#define PSC_PDCTL2_RSTVAL			0x00220000
#define PSC_PDCTL3_RSTVAL			0x00220000
#define PSC_PDCTL4_RSTVAL			0x00220000

#define PSC_PDCFG0_RSTVAL			0x0000000D
#define PSC_PDCFG1_RSTVAL			0x00000002
#define PSC_PDCFG2_RSTVAL			0x00000002
#define PSC_PDCFG3_RSTVAL			0x00000002
#define PSC_PDCFG4_RSTVAL			0x00000002

#define PSC_MDCFG0_RSTVAL			0x000000DB
#define PSC_MDCFG1_RSTVAL			0x000004DB
#define PSC_MDCFG2_RSTVAL			0x000001DB
#define PSC_MDCFG3_RSTVAL			0x000000DB
#define PSC_MDCFG4_RSTVAL			0x000000DB
#define PSC_MDCFG5_RSTVAL			0x000000DB
#define PSC_MDCFG6_RSTVAL			0x000004DB
#define PSC_MDCFG7_RSTVAL			0x000100DB
#define PSC_MDCFG8_RSTVAL			0x000200DB
#define PSC_MDCFG9_RSTVAL			0x000300DB
#define PSC_MDCFG10_RSTVAL			0x000400DB

#define PSC_MDSTAT0_RSTVAL			0x00001f03
#define PSC_MDSTAT1_RSTVAL			0x00001f03
#define PSC_MDSTAT2_RSTVAL			0x00001f03
#define PSC_MDSTAT3_RSTVAL			0x00001f03
#define PSC_MDSTAT4_RSTVAL			0x00001f03
#define PSC_MDSTAT5_RSTVAL			0x00001f03
#define PSC_MDSTAT6_RSTVAL			0x00001f03
#define PSC_MDSTAT7_RSTVAL			0x00001f03
#define PSC_MDSTAT8_RSTVAL			0x00001f03
#define PSC_MDSTAT9_RSTVAL			0x00001f03
#define PSC_MDSTAT10_RSTVAL			0x00001f03

#define PSC_MDCTL0_RSTVAL			0x00000103
#define PSC_MDCTL1_RSTVAL			0x00000103
#define PSC_MDCTL2_RSTVAL			0x00000103
#define PSC_MDCTL3_RSTVAL			0x00000103
#define PSC_MDCTL4_RSTVAL			0x00000103
#define PSC_MDCTL5_RSTVAL			0x00000103
#define PSC_MDCTL6_RSTVAL			0x00000103
#define PSC_MDCTL7_RSTVAL			0x00000103
#define PSC_MDCTL8_RSTVAL			0x00000103
#define PSC_MDCTL9_RSTVAL			0x00000103
#define PSC_MDCTL10_RSTVAL			0x00000103

// Register rw masks. Tells which bits are ok to do write.
#define PSC_REG_RDMASK				0xFFFFFFFF	
#define PSC_REG_WRMASK				0xFFFFFFFF	
/*
	;; Register writability mask. Masked bits are writable but
	;; write has no effect. The retain prewrite values. Unmasked bits
	;; Should show written value.
*/

#define PSC_STAT_VALMASK		 0xFFFFFFFF
#define PSC_CFG_VALMASK			 0xFFFFFFFF
#define PSC_CMD_VALMASK			 0xFFFFFFFF

#define PSC_PERIPHERAL_ID_VALMASK	0xFFFFFFFF
#define PSC_GBLCTL_VALMASK		0xFFFF00FC
	
//PSC_MERRCR0_VALMASK		 0x00000000
//PSC_MERRCR1_VALMASK		 0x00000000
//PSC_PERRCR_VALMASK		 0x00000000
//PSC_EPCCR_VALMASK		 0x00000000

#define PSC_RAILCTL_VALMASK		 0xFFFF0000
#define PSC_RAILSEL_VALMASK		 0xFFFFFFE0 // only 5 power domains others rsvd

#define PSC_PDCTL_VALMASK		 0x4F008CFE
#define PSC_MDCTL_VALMASK		 0x7FFFF0E0
	
unsigned int enable_all();
unsigned int enable_module(unsigned int pdctl, unsigned int mdctl);
unsigned int disable_module(unsigned int pdctl, unsigned int mdctl);
