/****************************************************************************\
 *           Copyright (C) 2009 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * -------------------------------------------------------------------------*
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchant ability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Albert Bae                                                    *
 *            Texas Instruments                                             *
 *            01 Feb, 2011                                                 *
 *                                                                          *
 ***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h> 
#include <c6x.h>
#include <ti/csl/csl.h>
#include <ti/csl/csl_chip.h>
/* HyperLink CSL include */
#include "Hyperlink_config.h"
#include "psc_util.h"
   
#define PAYLOAD 8192
#pragma DATA_SECTION(srcBuf1,".gem0_data")
#pragma DATA_ALIGN(srcBuf1, 32)
Uint32 srcBuf1[PAYLOAD];
#pragma DATA_SECTION(dstBuf1,".gem0_data2")
#pragma DATA_ALIGN(dstBuf1, 32)
Uint32 dstBuf1[PAYLOAD] ;
#pragma DATA_ALIGN(dstBuf2, 32)
Uint32 dstBuf2[PAYLOAD];

#define iLoopModeOn //comment this line for non loopback mode

Uint32 profileWr[7];
Uint32 aetCountWr[7], aetCountRd[7];

CSL_Uint64 profileWrStart = 0;
CSL_Uint64 profileWrStop = 0;

extern CSL_Uint64 CSL_tscRead();
extern CSL_Uint64 CSL_tscEnable();
extern void memset();

void Hyperlink_config(void)
{
    /************ Initialize Hyperlink ************************************************/ 
    
	/* Start Hyperlink module Serdes */
    Configure_vUSR_SerDes();
    
    /*	Enable all four lanes */
    *((int *)CSL_MCM_LPMC) |= 0x4;//0x4 quad lane, 0x2 single lane
    //*((int *)CSL_MCM_LPMC) &= 0xFFFFFFA;//single lane
    *((int *)CSL_MCM_LPMC) &= 0xFFFFFFC;// quad lane
    
#ifdef iLoopModeOn
    vUSR_InternalLoopBackEnable(); //internal loopback mode on
#else
    vUSR_NonLoopBack_LinkOnWait(); //wait until the vUSR in other DSP is turned on
#endif
}

void Setup_Aet(Uint32 channelNum,Uint32 tccNum)
{
	// Setup EDMA registers
	AET_CMD = 0x1;
	AET_CTL = CSL_FMKT(EDMA3CC_AETCTL_EN,ENABLE)| \
		CSL_FMK(EDMA3CC_AETCTL_ENDINT,tccNum)| \
		CSL_FMKT(EDMA3CC_AETCTL_TYPE,DMA)| \
		CSL_FMK(EDMA3CC_AETCTL_STRTEVT,channelNum);

	// Assign the event id depending on the GEM
	// CPU/2 EDMA 0 AET EVT is mapped to 37 of CPINTC 0 
	GEM_AEG_MUX0 = EDMACC0_AETEVT_GEM;
		
	// Setup AEG Registers in Interrupt Controller
	AET_claim();
	AET_countEvents(2, 
                    CSL_FMKT(AET_AE_ENA_AEGEVT0,SET),
                    0);
	AET_enable();                    
}	

Uint32 Retrieve_Aet()
{
	return (-(AET_counter0Read()));
}

void Hyperlink_Close(void)
{
   vUSR_ModuleReset();//reset vUSR module
}

void Test_result(void){
	Uint32 Tput = 0, i, packet_len;
	
    printf(" Test Result) VUSR Packet Data Send/Recv via EDMA: PASS\n");
    
    for(i=0; i<4; i++){
       switch(i)
       {
		  case 0:packet_len = 1024; break;
		  case 1:packet_len = 2048; break;
		  case 2:packet_len = 4096; break;
		  case 3:packet_len = 8192; break;
       }
       Tput = (packet_len*4*8)/aetCountWr[i];
       printf(" Packet Length: %d Byte. Data throughput is %d Gbps \n",packet_len,Tput);
    }
    
    printf("Ending Hyperlink Write/Read access and Throughput test via EDMA\n");
}

Uint32 verify_data(Uint32 *srcBuf, Uint32 *dstBuf, Uint32 payload)
{
	int i;
	
	for (i=0;i<payload;i++)
	{
		if (srcBuf[i] != dstBuf[i])
			return FAIL;
	}
	return PASS;
}

void corrupt_VUSR_data(int count)
{
	int i;
	for(i=0;i<count;i++)
	(*(int *)(0x40000000+i*4)) = 0;
}

void main(void)
{
    Uint32 result = FAIL;
	Uint32 i, payload;
	
    printf("\nBeginning Hyperlink Write/Read access and Throughput test via EDMA:\n");
    
    enable_module(mcm_pdctl, mcm_mdctl);//Enable Hyperlink module power
    
    CSL_tscEnable(); /* Enable the TSC */
    
    memset(dstBuf1, 0xFF, sizeof(dstBuf1));
    memset(dstBuf2, 0xFF, sizeof(dstBuf2));
    
    for(i=0; i<8192; i++)
    srcBuf1[i] = (Uint32)i; 
    
    Hyperlink_config();//hyperlink configuration for Cppi mode
    
    /* Write Testcase */
	for(i=0;i<4;i++)
	{	
    	
		/*Write Operation */    
		configure_address_mappings_EDMA(0xD, 0x7000,(Uint32)dstBuf1);

        // Setup AET related registers
		Setup_Aet(MCM_EDMA_WR_CHANNEL+i,MCM_EDMA_WR_CHANNEL+i); // Start from Channel 0 and end to Interrupt on TCC 0
    
    	switch(i)
    	{
			case 0:payload = 1024; break;
			case 1:payload = 2048; break;
			case 2:payload = 4096; break;
			case 3:payload = 8192; break;
    	}
		vusr_edma_wr_setup_all_payload((Uint32)srcBuf1, CSL_MCM_DATA, payload,MCM_EDMA_WR_CHANNEL+i);
        profileWrStart = CSL_tscRead();
        
		verify_edma_complete(MCM_EDMA_WR_CHANNEL+i);
		while(dstBuf1[payload-1] != srcBuf1[payload-1]);
		profileWrStop = CSL_tscRead();
		profileWr[i] =  profileWrStop - profileWrStart;
		
		aetCountWr[i] = Retrieve_Aet();	
		
		result = verify_data(srcBuf1, dstBuf1, payload);	
		if(result == FAIL){
			printf("Write Test data verification Failed. Test Halted\n");
			return;
		}
		corrupt_VUSR_data(payload);		
	}
    /*Read Testcase with loopback*/
	for(i=0;i<4;i++)
	{	
		/*Read Operation */    
		configure_address_mappings_EDMA(0xD, 0x2000,(Uint32)srcBuf1);

    	// Setup AET related registers
		Setup_Aet(MCM_EDMA_RD_CHANNEL+i,MCM_EDMA_RD_CHANNEL+i); // Start from Channel 0 and end to Interrupt on TCC 0
    
    	switch(i)
    	{
			case 0:payload = 1024; break;
			case 1:payload = 2048; break;
			case 2:payload = 4096; break;
			case 3:payload = 8192; break;
    	}
		vusr_edma_rd_setup_all_payload(CSL_MCM_DATA, (Uint32)dstBuf2, payload,MCM_EDMA_RD_CHANNEL+i);
	 
		verify_edma_complete(MCM_EDMA_RD_CHANNEL+i);
		aetCountRd[i] = Retrieve_Aet();	
		
		result = verify_data(srcBuf1, dstBuf2, payload);	
		if(result == FAIL){
			printf("Read Test data verification Failed. Test Halted\n");
			return;
		}
		//corrupt_VUSR_data(payload);
	}		
    
    Test_result(); //compare Tx, Rx data
    
    Hyperlink_Close();
        
}

