/*****************************************************************************
*           TEXAS INSTRUMENTS INCORPORATED PROPRIETARY INFORMATION           
*                                                                            
*  Property of Texas Instruments 
*  For  Unrestricted  Internal  Use  Only 
*  Unauthorized reproduction and/or distribution is strictly prohibited.  
*  This product is protected under copyright law and trade secret law 
*  as an unpublished work.  
*  Created 2009, (C) Copyright 2009 Texas Instruments.  All rights reserved.
*------------------------------------------------------------------------------
*  Filename       : psc_util.c
*  Description    : Functions to enable specific module in PSC
*  History        : 
*  Ported by      : Rafeeq
*  Project        : NySh
*  Date           : Aug 2009 
*****************************************************************************/
#define CONFIG_SRC
#include <psc.h>
#include <psc_vars.h>
#include "psc_util.h"
#include "val_util.h"

unsigned int enable_all()
{
    unsigned int pd_mask = 0x1;
    unsigned int loop_cnt = 0;
    volatile unsigned int *ptstat = (volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTSTAT);
    volatile unsigned int *mdctl = (volatile unsigned int *)(PSC_START_ADDRESS + PSC_MDCTL_BASE);
    volatile unsigned int *pdctl = (volatile unsigned int *)(PSC_START_ADDRESS + PSC_PDCTL_BASE);
    int pdnum,mdnum;

    for(pdnum=0; pdnum < max_pd; pdnum++) {
	pdctl[pdnum] |= 1;
	pd_mask |= (1 << pdnum);
    }
    for(mdnum=0; mdnum <= mds_in_pd[max_pd-1][0]; mdnum++) {
	mdctl[mdnum] |= 3;
    }
    // start the process and wait. but timeout in 1000 loops.
    (*(volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTCMD)) |= pd_mask;
	while(((*ptstat & pd_mask) != 0) && (loop_cnt < 1000))
	{
		loop_cnt++;
	}
    if ((*ptstat & pd_mask) == 0) return(PASS);
    return(FAIL);
}

unsigned int enable_module(unsigned int pdctl, unsigned int mdctl)
{
    unsigned int pd_mask = 0x1;
    unsigned int loop_cnt = 0;
    volatile unsigned int *ptstat = (volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTSTAT); 
    volatile unsigned int *mdstat = (volatile unsigned int *)(PSC_START_ADDRESS + mdctl - PSC_MDCTL_BASE + PSC_MDSTAT_BASE); 
    if (mdctl == 0) return(FAIL);
    // Is module already enabled?
    if ((*mdstat & 0x3F) == 0x3) return(PASS);

    // program pdctl and mdctl to enable the module. 
    if (pdctl) {
        pd_mask = (0x1 << ((pdctl-PSC_PDCTL_BASE)>>2));
        (*(volatile unsigned int *)(PSC_START_ADDRESS + pdctl)) |= 0x1;
     }
    (*(volatile unsigned int *)(PSC_START_ADDRESS + mdctl)) |= 0x3; 
    // start the process and wait. but timeout in 1000 loops.
    (*(volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTCMD)) = pd_mask;	
	while(((*ptstat & pd_mask) != 0) && (loop_cnt < 1000))
	{
		loop_cnt++;
	}
    // report result. 
    return(((*mdstat & 0x3F) == 0x3)? PASS : FAIL);
}

unsigned int disable_module(unsigned int pdctl, unsigned int mdctl)
{
    unsigned int pd_mask = 0x1;
    unsigned int loop_cnt = 0;
    unsigned int force_pwrdwn = 0;
    volatile unsigned int *pdstat;
    volatile unsigned int *ptstat = (volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTSTAT); 
    volatile unsigned int *mdstat = (volatile unsigned int *)(PSC_START_ADDRESS + mdctl - PSC_MDCTL_BASE + PSC_MDSTAT_BASE); 

    if (mdctl == 0) return(FAIL);

    // Is module already powered down?
    if (pdctl) {
        pdstat = (volatile unsigned int *)(PSC_START_ADDRESS + pdctl - PSC_PDCTL_BASE + PSC_PDSTAT_BASE); 
        if ((*pdstat & 0x1F) == 0x0) return(PASS);
        pd_mask = (0x1 << ((pdctl-PSC_PDCTL_BASE)>>2));
	force_pwrdwn = 0;
    }

    // Is module already disabled
    if (((*mdstat & 0x3F) == 0x0) || ((*mdstat & 0x3F) == 0x2)) return(PASS);


    if (force_pwrdwn && pdctl) (*(volatile unsigned int *)(PSC_START_ADDRESS + pdctl)) &= ~0x1; //*mkptr(psc_cfg_base,pdctl) &= ~0x1;
    (*(volatile unsigned int *)(PSC_START_ADDRESS + mdctl)) &= ~0x3F; 	

    // start the transitions and wait. but timeout in 1000 loops.
    (*(volatile unsigned int *)(PSC_START_ADDRESS + PSC_PTCMD)) = pd_mask; 
    while(((*ptstat & pd_mask) != 0) && (loop_cnt < 1000))
    {
    	loop_cnt++;
    }	

    return(((*mdstat & 0x3F) == 0x0)? PASS : FAIL);
}

