
// emif  --------------------------------------------------------

#define EMIF_GCTL       0x01800000
#define EMIF_CE1        0x01800004
#define EMIF_CE0        0x01800008
#define EMIF_CE2        0x01800010
#define EMIF_CE3        0x01800014
#define EMIF_SDRAMCTL   0x01800018
#define EMIF_SDRAMTIM   0x0180001C
#define EMIF_SDRAMEXT   0x01800020
#define EMIF_CCFG       0x01840000;
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
void init_emif( void )
{
	*(int *)EMIF_GCTL     = 0x00000078;
	*(int *)EMIF_CE0      = 0xffffbf93;  /* CE0 SDRAM                     */
	*(int *)EMIF_CE1      = 0xffffff13;  /* CE1 Flash 8-bit               */
	*(int *)EMIF_CE2      = 0xffffff93;  /* CE2 Daughtercard 32-bit async */
	*(int *)EMIF_CE3      = 0xffffff2f;  /* CE3 Daughtercard 32-bit async */
	*(int *)EMIF_SDRAMCTL = 0x53115000;  /* SDRAM control                 */
	*(int *)EMIF_SDRAMTIM = 0x00000578;  /* SDRAM timing (refresh)        */
	*(int *)EMIF_SDRAMEXT = 0x000a8529;  /* SDRAM Extension register      */
}


void Delay(unsigned int nDelay)
{
	int ii,jj,kk=0;
	for ( ii=0;ii<nDelay;ii++ )
	{
		for ( jj=0;jj<1024;jj++ )
		{
			kk++;
		}
	}
}

void Delay0(unsigned int nDelay)
{
	int ii,jj,kk=0;
	for ( ii=0;ii<nDelay;ii++ )
	{
		for ( jj=0;jj<16;jj++ )
		{
			kk++;
		}
	}
}

void Delay2(unsigned int nDelay)
{
	int ii,jj,ss,kk=0;
	for ( ii=0;ii<nDelay;ii++ )
	{
		for ( ss=0;ss<64;ss++ )
		{
			for( jj=0;jj<64;jj++ )
			{	
				kk++;
			}
		}
	}
}
