/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DSP/BIOS 4.90.270 06-11-03 (barracuda-m10)" */
/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *
 */
/* "@(#) DSP/BIOS 4.90.150 04-08-03 (barracuda-m02)" */
/******************************************************************************\
*           Copyright (C) 2000 Texas Instruments Incorporated.
*                           All Rights Reserved
*------------------------------------------------------------------------------
* FILENAME...... main.c
* DATE CREATED.. 01/11/2000
* LAST MODIFIED. 03/08/2000
*
\******************************************************************************/
#include <std.h>
//#include <log.h>


#include <csl.h>
#include <csl_mcbsp.h>
#include <csl_gpio.h>
//#include "ICETEK-C6713-A.h"
#include "C6713_A.h"

#define CHIP_6713 1


//extern far LOG_Obj LogMain;
static GPIO_Handle hGpio;
  MCBSP_Handle hMcbsp0;

#define CS_set          GPIO_pinWrite(hGpio,GPIO_PIN9,1)
#define CS_reset        GPIO_pinWrite(hGpio,GPIO_PIN9,0)

#define CLKSEL_set   		GPIO_pinWrite(hGpio,GPIO_PIN11,1)   //internal clock
#define CLKSEL_reset()   	GPIO_pinWrite(hGpio,GPIO_PIN11,0)  //external clock

#define PWDN_set   			GPIO_pinWrite(hGpio,GPIO_PIN12,1)
#define PWDN_reset   		GPIO_pinWrite(hGpio,GPIO_PIN12,0)

#define ADS1298_set   		GPIO_pinWrite(hGpio,GPIO_PIN13,1)
#define ADS1298_reset   	GPIO_pinWrite(hGpio,GPIO_PIN13,0)

#define START_set   		GPIO_pinWrite(hGpio,GPIO_PIN15,1)
#define START_reset   	GPIO_pinWrite(hGpio,GPIO_PIN15,0)

#define  SDATAC_Command  0x11
#define  RDATAC_Command  0x10
#define  number          30


//extern far void vectors();

void delay(Uint32 NDelay)
{
	for(;NDelay>0;NDelay--);
}

void delay1(Uint32 NDelay)
{	
	Uint32 ii=0;
	for(;NDelay>0;NDelay--)
	{
		for(ii=0;ii<1000;ii++)
		{
			;
		}
	}
}

void mcbsp_write(Uint8 data)
{
   	while(!MCBSP_xrdy(hMcbsp0));
   	MCBSP_write(hMcbsp0,data);
}
 
 Uint8 CONFIG3[3]=
{
	0x43,0x00,0xc0
};//internal reference

Uint8 CONFIG1[3]=
{
	0x41,0x00,0x26
};// HR mode  and  internal clk  output enabled

Uint8 CONFIG2[3]=
{
	0x42,0x00,0x10
};//generated internal test signals  

//  delay(1); //wait 1.5us
//  delay(62);//wait 10us
//	delay1(500) //wait 80ms
// delay1(1000) // wait 160ms
//	delay1(6200);//wait 1s
//	

Uint8 ADS1298testcfg[10]=
{ 
   0x45,0x07,0x05,0x80,0x80,0x80,0x80,0x80,0x80,0x80
   };

////8bite
//Uint8 ads1298_config1[14]=
//{
//	0x41,0x0b,0x86,0x00,0xc0,0x13,//11 SDATAC COMMAND 4300C0 internal reference 410086  set device in HR mode and DR=fmod/1024
//	0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01//SET all channals to input short	
//};
//
//Uint8 ads1298_testconfig[10]=
//{
//	0x45,0x07,0x05,0x80,0x80,0x80,0x80,0x80,0x80,0x80
//};

static GPIO_Config MyGPIOCfg={
	0X00000000,		//gpgc
	0X0000BE00,		//gpen  1011 1110 0000 0000  15--START 13--RESET 12--PWDN 11--CLKSEL 10--DRDY  9--CS
	0X0000BA00,		//gpdir 1011 1010 0000 0000  15--START(1) 13--RESET(1) 12--PWDN(1) 11--CLKSEL(1) 10--DRDY(0)  9--CS(1)
	0X00000000,		//gpval
	0X00000000,		//gphm
	0X00000000,		//gplm
	0X00000000		//gppol
	};

//static MCBSP_Config ConfigLoopback = {
//	0x03c31801,   // SPCR
//	0X00010E00,   // RCR
//	0X00010E00,   //XCR
//	0X20000013,    //SRGR   sclk=25MHZ/(19+1)=1.25MHZ<20MHZ(sclkʱ)
//	0x00000000,		//MCR
//	0x00000000,		//RCER
//	0x00000000,		//XCER
//	0X00000F0c  	//PCR
//};

	 MCBSP_Config mcbspCfg0 = {
	MCBSP_SPCR_RMK(	
		MCBSP_SPCR_FREE_DEFAULT,
    MCBSP_SPCR_SOFT_DEFAULT,
    MCBSP_SPCR_FRST_DEFAULT,
    MCBSP_SPCR_GRST_DEFAULT,
    MCBSP_SPCR_XINTM_DEFAULT,
    MCBSP_SPCR_XSYNCERR_DEFAULT,
    MCBSP_SPCR_XRST_DEFAULT,
    MCBSP_SPCR_DLB_DEFAULT,
    MCBSP_SPCR_RJUST_DEFAULT,
    MCBSP_SPCR_CLKSTP_DELAY, /* CLKSTP=11b with CLKXP=0, clock starts with */
    MCBSP_SPCR_DXENA_OFF,    /* rising edge with delay                     */
    MCBSP_SPCR_RINTM_DEFAULT,
    MCBSP_SPCR_RSYNCERR_DEFAULT,
    MCBSP_SPCR_RRST_DEFAULT 
    ),
	MCBSP_RCR_RMK(			/*one bit delay,one frame,one element,8 bits*/
		MCBSP_RCR_RPHASE_SINGLE,
    MCBSP_RCR_RFRLEN2_DEFAULT,
    MCBSP_RCR_RWDLEN2_DEFAULT,
    MCBSP_RCR_RCOMPAND_DEFAULT,
    MCBSP_RCR_RFIG_DEFAULT,
    MCBSP_RCR_RDATDLY_1BIT,
    MCBSP_RCR_RFRLEN1_OF(0),
    MCBSP_RCR_RWDLEN1_8BIT,  /* receive element length phase 1 is 32 bits */
    MCBSP_RCR_RWDREVRS_DISABLE
    ),
	MCBSP_XCR_RMK(			
			MCBSP_XCR_XPHASE_SINGLE,
			MCBSP_XCR_XFRLEN2_DEFAULT,
			MCBSP_XCR_XWDLEN2_DEFAULT,
			MCBSP_XCR_XCOMPAND_DEFAULT,
			MCBSP_XCR_XFIG_DEFAULT,
			MCBSP_XCR_XDATDLY_1BIT,
			MCBSP_XCR_XFRLEN1_OF(0),
			MCBSP_XCR_XWDLEN1_8BIT,
			MCBSP_XCR_XWDREVRS_DEFAULT
			),	
		MCBSP_SRGR_RMK(
			MCBSP_SRGR_GSYNC_FREE,
      MCBSP_SRGR_CLKSP_RISING,
      MCBSP_SRGR_CLKSM_INTERNAL, /* SRGR clock mode from internal source */
      MCBSP_SRGR_FSGM_DEFAULT,
      MCBSP_SRGR_FPER_DEFAULT,
      MCBSP_SRGR_FWID_DEFAULT,
      MCBSP_SRGR_CLKGDV_OF(0x13) /* divide clock by factor of 19        */
			),
		MCBSP_MCR_DEFAULT,
    MCBSP_RCER_DEFAULT,       
    MCBSP_XCER_DEFAULT,       
		
	/* setup PCR */
	MCBSP_PCR_RMK( 
		MCBSP_PCR_XIOEN_SP, 
		MCBSP_PCR_RIOEN_SP,
		MCBSP_PCR_FSXM_INTERNAL,		//internal 
	    MCBSP_PCR_FSRM_INTERNAL, 
	    MCBSP_PCR_CLKXM_OUTPUT,	
	//the same clock,clkxm=clkrm 
		MCBSP_PCR_CLKRM_OUTPUT, 
		MCBSP_PCR_CLKSSTAT_DEFAULT, 
		MCBSP_PCR_DXSTAT_DEFAULT, 
	    MCBSP_PCR_FSXP_ACTIVELOW,	//low --active
	    MCBSP_PCR_FSRP_ACTIVELOW,	// low --active
		MCBSP_PCR_CLKXP_RISING,   /*rising  clkxp=0*/ 
		MCBSP_PCR_CLKRP_FALLING   /*falling clkrp=0*/
		) 
	}; 

void main() 
{
  Uint8 i;//,j=0
  Uint8 pinval0[number],pinval1[number],pinval2[number],pinval3[number],pinval4[number],pinval5[number],pinval6[number];
  
  CSL_init();
      
      /* Initialize  ICETEK-C6713  board */
     init_emif();       // init EMIF
    //IRQ_setVecs(vectors);     /* point to the IRQ vector table  */
    IRQ_globalEnable();       /* Globally enable interrupts       */
    IRQ_nmiEnable();          /* Enable NMI interrupt             */

    /*set  GPIO. */
	hGpio = GPIO_open(GPIO_DEV0,GPIO_OPEN_RESET);
 //   GPIO_reset(hGpio);
    // GPIO_RSET(GPEN,0x0000f000);
    // GPIO_RSET(GPDIR,0x0000f000);
	GPIO_config(hGpio,&MyGPIOCfg);

  /* The following code                                         */
  /* configures the serial port for digital loopback mode. We   */
  /* then use the CPU to write/read from the port. In loopback  */
  /* mode, we should read the same value as written, this is    */
  /* checked for in a loop.                                     */

  /* Let's open up serial port 1 */
   hMcbsp0 = MCBSP_open(MCBSP_DEV0, MCBSP_OPEN_RESET);
  
  /* We'll set it up for digital loopback, 32bit mode. We have   */
  /* to setup the sample rate generator to allow self clocking.  */
  MCBSP_config(hMcbsp0,&mcbspCfg0);
  
  /* Enable sample rate generator   GRST=1      */
	MCBSP_enableSrgr(hMcbsp0);  /* Handle to SRGR */
	Delay0(1);  ///Wait two bit clocks for the McBSP to reinitialize.
	MCBSP_enableRcv(hMcbsp0); /* Enable McBSP channel                     */
	MCBSP_enableXmt(hMcbsp0); /* McBSP port 0 as the transmitter/receiver */

  //MCBSP_start(hMcbsp0,MCBSP_RCV_START | MCBSP_XMIT_START | MCBSP_SRGR_START| MCBSP_SRGR_FRAMESYNC, 0);
  
  //all signals remain low
 // while(1)
 // {
  CLKSEL_reset();
  PWDN_reset;
  ADS1298_reset;
  START_reset;
  CS_reset;
  delay(62);
  
  ADS1298_set;
  delay1(500);
  ADS1298_reset;
  delay(5);
  ADS1298_set;
  delay(62);
  
  
	CLKSEL_set; //internal clock
  delay1(6200);// wait for oscillator  to wake up
  
  PWDN_set;
  ADS1298_set;
  delay1(6200); //wait 1s for Power-on reset

  
  ADS1298_reset;
  delay(5);  //wait 2tclk 
  ADS1298_set;
  delay(62); //wait 18tclk   
//}
// while(1)
// {
 	CS_reset;//here i used a GPIO to send the ads1298 cs signal,cs=0

 	mcbsp_write(SDATAC_Command);
  delay(100);
  CS_set;
  delay(35);
  CS_reset;
  for(i=0;i<3;i++)   //internal reference  43  00  C0
  {
  	   	while(!MCBSP_xrdy(hMcbsp0));
   			MCBSP_write(hMcbsp0,CONFIG3[i]); 
   	delay(100);		
  }
//  CS_set;
//  delay(35);
//  CS_reset;
 for(i=0;i<3;i++)    //low power mode and internal oscillator output enable 41  00 26 
 {
 		while(!MCBSP_xrdy(hMcbsp0));
 		MCBSP_write(hMcbsp0,CONFIG1[i]);// 41 00 26 
 		delay(100);	
 	}
//  CS_set;
//  delay(35);
//  CS_reset;
	for(i=0;i<10;i++)  //set 8 channels  address 05 80 80 80  80  80  80  80 
	{
		while(!MCBSP_xrdy(hMcbsp0));
		MCBSP_write(hMcbsp0,ADS1298testcfg[i]);//45 07 05 80 80 80 80 80 80 80 
		delay(100);
	}
//  CS_set;
//  delay(35);
//  CS_reset;
	for(i=0;i<3;i++)   //set internal test signals
	{
		 while(!MCBSP_xrdy(hMcbsp0));
		 MCBSP_write(hMcbsp0,CONFIG2[i]);// 42 00 13 
		 delay(100);
	}	
 	START_set;	//  START  is pulled high 
	mcbsp_write(RDATAC_Command);
	delay(100);
  CS_set;
  delay(35);
  CS_reset;
//} //while(1) test 

	
 // // delay(1);
//	for(i=0;i<14;i++)   //HR mode and set all channels to input short
//  {
//   			while(!MCBSP_xrdy(hMcbsp0));
//   			MCBSP_write(hMcbsp0,ads1298_config1[i]);
//   			  //delay(1); 			
//  }
// 
//
// //delay1(2300);
// //delay(1);
// mcbsp_write(RDATAC_Command);
// delay(5);
// 
// //test config
//   mcbsp_write(SDATAC_Command);
//   delay(5);
//  for(i=0;i<3;i++)    //internal test signals
//  {
//  	   	while(!MCBSP_xrdy(hMcbsp0));
//   			MCBSP_write(hMcbsp0,CONFIG2[i]);  
//  }
//    //delay(1);
//    for(i=0;i<3;i++)    //internal test signals
//  {
//  	   	while(!MCBSP_xrdy(hMcbsp0));
//   			MCBSP_write(hMcbsp0,CONFIG1[i]);
//   		//	  delay(1);
//  }
//  //delay(1);
//  
//  	for(i=0;i<10;i++)   //HR mode and set all channels to input short
//  {
//   			while(!MCBSP_xrdy(hMcbsp0));
//   			MCBSP_write(hMcbsp0,ads1298_testconfig[i]);
//  }
//     //	  delay(1);
//   mcbsp_write(RDATAC_Command);
//   delay(5);
////   delay1(23);
//// }
  /*******************/
  i=0;
  while(1)
{		
		
	   	if(!(GPIO_pinRead(hGpio,GPIO_PIN10)))
	   		{
	   		//	delay(1);
	   			while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval0[i]=MCBSP_read(hMcbsp0);
	   	 	//	delay(62);
	   			while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval1[i]=MCBSP_read(hMcbsp0);
	   	 		//delay(62);
	   			while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval2[i]=MCBSP_read(hMcbsp0);
	   	 	 	//delay(62);	   	 		
	   	 		while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval3[i]=MCBSP_read(hMcbsp0);
	   	 		//delay(62);
	   	 		while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval4[i]=MCBSP_read(hMcbsp0);
	   	 		//delay(62);
	   	 		while(!MCBSP_xrdy(hMcbsp0));
	   			MCBSP_write(hMcbsp0,0x00);
	   			while(!MCBSP_rrdy(hMcbsp0));
	   	 		pinval5[i]=MCBSP_read(hMcbsp0);
	   	 		//delay(62);

	   	 		i++;	   	 		
				}
			delay(35);
 			  CS_set;
			delay(35);
			CS_reset;				
}
	   
//
//	}
// 
//while(1);


  /* All done now, close the port. */
//GPIO_close(hGpio);
// MCBSP_close(hMcbsp0);
  
}

/*----------------------------------------------------------------------------*/

/******************************************************************************\
* End of main.c
\******************************************************************************/

