//******************************************************************************
//+--------------------------------------------------------------------------+**
//|                            ****                                          |**
//|                            ****                                          |**
//|                            ******o***                                    |**
//|                      ********_///_****                                   |**
//|                      ***** /_//_/ ****                                   |**
//|                       ** ** (__/ ****                                    |**
//|                           *********                                      |**
//|                            ****                                          |**
//|                            ***                                           |**
//|                                                                          |**
//|         Copyright (c) 1998-2012 Texas Instruments Incorporated           |**
//|                        ALL RIGHTS RESERVED                               |**
//|                                                                          |**
//| Permission is hereby granted to licensees of Texas Instruments           |**
//| Incorporated (TI) products to use this computer program for the sole     |**
//| purpose of implementing a licensee product based on TI products.         |**
//| No other rights to reproduce, use, or disseminate this computer          |**
//| program, whether in part or in whole, are granted.                       |**
//|                                                                          |**
//| TI makes no representation or warranties with respect to the             |**
//| performance of this computer program, and specifically disclaims         |**
//| any responsibility for any damages, special or consequential,            |**
//| connected with the use of this program.                                  |**
//|                                                                          |**
//+--------------------------------------------------------------------------+**
//*****************************************************************************/
/*
 *  ======== hello.c ========
 *  The hello example serves as a basic sanity check program for SYS/BIOS. It
 *  demonstrates how to print the string "hello world" to stdout. 
 */

#include <xdc/std.h>

#include <xdc/runtime/System.h>
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/family/arm/a8/Mmu.h>
#include "hw_types.h"
#include "mux.h"
#include "hw_gpmc.h"
#include "hw_cm_per.h"
#include "soc_AM335x.h"
#include "hw_gpmc.h"


#define GPMC_non_muxed_16bit 	1
#define GPMC_muxed_16bit 		0

UInt16 GPMC_DPRAM_Init(void);
void PINMUX_Config(UInt8 mode);
void mmuInit_local(void);

/*
 *  ======== main ========
 */
Void main()
{ 
	UInt32	error = 0;
	UInt32	i;
	UInt32	*pmem;

	mmuInit_local();
	System_printf("hello world\n");

    /*
     *  normal BIOS programs, would call BIOS_start() to enable interrupts
     *  and start the scheduler and kick BIOS into gear.  But, this program
     *  is a simple sanity test and calls BIOS_exit() instead.
     */
    GPMC_DPRAM_Init();
	PINMUX_Config(GPMC_muxed_16bit);

    while(1)
    {
    	pmem = (UInt32*) 0x09000000;
    	// fill data
    	for(i=0; i<0x2000; i+=4) // 16kByte
    	{
    		*pmem++ = 0x12345678;
    	}

    	// verify data
    	pmem = (UInt32*) 0x09000000;
    	for(i=0; i<0x2000; i+=4) // 16kByte
    	{
    		if(*pmem++ != 0x12345678)
    			error++;
    	}

    	//System_printf("Error count (%d)\n", error);
    }



    BIOS_exit(0);  /* terminates program and dumps SysMin output */
}


UInt16 GPMC_DPRAM_Init(void)
{
	UInt16 csNum = 1;
    UInt32 temp = 0;

    //enable clock to GPMC module
    HWREG(SOC_PRCM_REGS + CM_PER_GPMC_CLKCTRL ) |=
        		CM_PER_GPMC_CLKCTRL_MODULEMODE_ENABLE;
    //check to see if enabled
    while((HWREG(SOC_PRCM_REGS + CM_PER_GPMC_CLKCTRL) & CM_PER_GPMC_CLKCTRL_IDLEST) !=
        		(CM_PER_GPMC_CLKCTRL_IDLEST_FUNC << CM_PER_GPMC_CLKCTRL_IDLEST_SHIFT));

    //reset the GPMC module
    HWREG(SOC_GPMC_0_REGS + GPMC_SYSCONFIG ) |= GPMC_SYSCONFIG_SOFTRESET;
    while((HWREG(SOC_GPMC_0_REGS + GPMC_SYSSTATUS) & GPMC_SYSSTATUS_RESETDONE) ==
        		GPMC_SYSSTATUS_RESETDONE_RSTONGOING);

    //Configure to no idle
    temp = HWREG(SOC_GPMC_0_REGS + GPMC_SYSCONFIG);
    temp &= ~GPMC_SYSCONFIG_IDLEMODE;
    temp |= GPMC_SYSCONFIG_IDLEMODE_NOIDLE << GPMC_SYSCONFIG_IDLEMODE_SHIFT;
    HWREG(SOC_GPMC_0_REGS + GPMC_SYSCONFIG) = temp;

    HWREG(SOC_GPMC_0_REGS + GPMC_IRQENABLE) = 0x0;
    HWREG(SOC_GPMC_0_REGS + GPMC_TIMEOUT_CONTROL) = 0x0;

    //configure for NOR and granularity x2
    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG1(csNum)) = (0x0 |
    	(GPMC_CONFIG1_0_DEVICESIZE_SIXTEENBITS <<
    			GPMC_CONFIG1_0_DEVICESIZE_SHIFT ) |
	    (GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_FOUR <<
	    		GPMC_CONFIG1_0_ATTACHEDDEVICEPAGELENGTH_SHIFT ) |
	    (0x2 << 8 ));	//Address/Data Multiplex enable


    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG2(csNum)) = (0x0 |
    	(1) |	// CS_ON_TIME
        (5 << GPMC_CONFIG2_0_CSRDOFFTIME_SHIFT) |	// CS_DEASSERT_RD
        (5 << GPMC_CONFIG2_0_CSWROFFTIME_SHIFT));	//CS_DEASSERT_WR

    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG3(csNum)) = (0x0 |
        (0 << GPMC_CONFIG3_0_ADVONTIME_SHIFT) | //ADV_ASSERT
	    (1 << GPMC_CONFIG3_0_ADVRDOFFTIME_SHIFT) | //ADV_DEASSERT_RD
	    (1 << GPMC_CONFIG3_0_ADVWROFFTIME_SHIFT)); //ADV_DEASSERT_WR

    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG4(csNum)) = (0x0 |
        (2 << GPMC_CONFIG4_0_OEONTIME_SHIFT) |	//OE_ASSERT
	    (5 << GPMC_CONFIG4_0_OEOFFTIME_SHIFT) |	//OE_DEASSERT
	    (1 << GPMC_CONFIG4_0_WEONTIME_SHIFT)| //WE_ASSERT
	    (5 << GPMC_CONFIG4_0_WEOFFTIME_SHIFT)); //WE_DEASSERT

    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG5(csNum)) = (0x0 |
	    (6 << GPMC_CONFIG5_0_RDCYCLETIME_SHIFT)|	//CFG_5_RD_CYCLE_TIM
	    (5 << GPMC_CONFIG5_0_WRCYCLETIME_SHIFT)|	//CFG_5_WR_CYCLE_TIM
	    (4 << GPMC_CONFIG5_0_RDACCESSTIME_SHIFT));  // CFG_5_RD_ACCESS_TIM

    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG6(csNum)) = (0x0 |
		(0 << //GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN_C2CDELAY
				GPMC_CONFIG6_0_CYCLE2CYCLESAMECSEN_SHIFT) |
		(0 << GPMC_CONFIG6_0_CYCLE2CYCLEDELAY_SHIFT) | //CYC2CYC_DELAY
	    (1 << GPMC_CONFIG6_0_WRDATAONADMUXBUS_SHIFT)| //WR_DATA_ON_ADMUX
	    (0 << GPMC_CONFIG6_0_WRACCESSTIME_SHIFT));  //CFG_6_WR_ACCESS_TIM

    HWREG(SOC_GPMC_0_REGS + GPMC_CONFIG7(csNum)) =
        ( 0x09 << GPMC_CONFIG7_0_BASEADDRESS_SHIFT) | //CFG_7_BASE_ADDR
        (0x1 << GPMC_CONFIG7_0_CSVALID_SHIFT) |
        (0x0f << GPMC_CONFIG7_0_MASKADDRESS_SHIFT);  //CFG_7_MASK

    return 0;
}

void PINMUX_Config(UInt8 mode)
{
	if(mode == GPMC_muxed_16bit)
	{
	MUX_VAL(CONTROL_PADCONF_GPMC_AD0, (IEN | PD | MODE0 )) /* GPMC_AD0 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD1, (IEN | PD | MODE0 )) /* GPMC_AD1 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD2, (IEN | PD | MODE0 )) /* GPMC_AD2 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD3, (IEN | PD | MODE0 )) /* GPMC_AD3 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD4, (IEN | PD | MODE0 )) /* GPMC_AD4 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD5, (IEN | PD | MODE0 )) /* GPMC_AD5 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD6, (IEN | PD | MODE0 )) /* GPMC_AD6 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD7, (IEN | PD | MODE0 )) /* GPMC_AD7 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD8, (IEN | PD | MODE0 )) /* GPMC_AD8 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD9, (IEN | PD | MODE0 )) /* GPMC_AD9 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD10, (IEN | PD | MODE0 )) /* GPMC_AD10 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD11, (IEN | PD | MODE0 )) /* GPMC_AD11 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD12, (IEN | PD | MODE0 )) /* GPMC_AD12 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD13, (IEN | PD | MODE0 )) /* GPMC_AD13 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD14, (IEN | PD | MODE0 )) /* GPMC_AD14 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_AD15, (IEN | PD | MODE0 )) /* GPMC_AD15 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A0, (IEN | OFF | MODE5 )) /* PR1_MII_MT1_CLK */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A1, (IDIS | PD | MODE5 )) /* PR1_MII1_TXD3 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A2, (IDIS | PD | MODE5 )) /* PR1_MII1_TXD2 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A3, (IDIS | PD | MODE5 )) /* PR1_MII1_TXD1 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A4, (IDIS | PD | MODE5 )) /* PR1_MII1_TXD0 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A5, (IEN | OFF | MODE5 )) /* PR1_MII1_RXD3 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A6, (IEN | OFF | MODE5 )) /* PR1_MII1_RXD2 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A7, (IEN | OFF | MODE5 )) /* PR1_MII1_RXD1 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A8, (IEN | OFF | MODE5 )) /* PR1_MII1_RXD0 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A9, (IEN | OFF | MODE5 )) /* PR1_MII_MR1_CLK */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A10, (IEN | OFF | MODE5 )) /* PR1_MII1_RXDV */;
	MUX_VAL(CONTROL_PADCONF_GPMC_A11, (IEN | OFF | MODE5 )) /* PR1_MII1_RXER */;
	MUX_VAL(CONTROL_PADCONF_GPMC_WAIT0, (IEN | PD | MODE0 )) /* GPMC_WAIT0 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_WPN, (IDIS | PD | MODE5 )) /* PR1_MII1_TXEN */;
	MUX_VAL(CONTROL_PADCONF_GPMC_BEN1, (IEN | OFF | MODE5 )) /* PR1_MII1_RXLINK */;
	MUX_VAL(CONTROL_PADCONF_GPMC_CSN0, (IDIS | PD | MODE0 )) /* GPMC_CSN0 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_CSN1, (IDIS | PD | MODE0 )) /* GPMC_CSN1 */;
	MUX_VAL(CONTROL_PADCONF_GPMC_CSN2, (IEN | PD | MODE7 )) /* GPIO1[31] */;
	MUX_VAL(CONTROL_PADCONF_GPMC_CSN3, (IEN | PU | MODE5 )) /* PR1_MDIO_DATA */;
	MUX_VAL(CONTROL_PADCONF_GPMC_CLK, (IDIS | PU | MODE5 )) /* PR1_MDIO_MDCLK */;
	MUX_VAL(CONTROL_PADCONF_GPMC_ADVN_ALE, (IDIS | PD | MODE0 )) /* GPMC_ADVN_ALE */;
	MUX_VAL(CONTROL_PADCONF_GPMC_OEN_REN, (IDIS | PD | MODE0 )) /* GPMC_OEN_REN */;
	MUX_VAL(CONTROL_PADCONF_GPMC_WEN, (IDIS | PD | MODE0 )) /* GPMC_WEN */;
	MUX_VAL(CONTROL_PADCONF_GPMC_BEN0_CLE, (IDIS | PD | MODE7 )) /* GPIO2[5] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA0, (IEN | OFF | MODE2 )) /* PR1_MII_MT0_CLK_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA1, (IDIS | PD | MODE2 )) /* PR1_MII0_TXEN_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA2, (IDIS | PD | MODE2 )) /* PR1_MII0_TXD3_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA3, (IDIS | PD | MODE2 )) /* PR1_MII0_TXD2_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA4, (IDIS | PD | MODE2 )) /* PR1_MII0_TXD1_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA5, (IDIS | PD | MODE2 )) /* PR1_MII0_TXD0_MUX1 */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA6, (IEN | OFF | MODE7 )) /* GPIO2[12] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA7, (IEN | OFF | MODE7 )) /* GPIO2[13] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA8, (IEN | OFF | MODE7 )) /* GPIO2[14] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA9, (IEN | OFF | MODE7 )) /* GPIO2[15] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA10, (IEN | OFF | MODE7 )) /* GPIO2[16] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA11, (IDIS | PD | MODE7 )) /* GPIO2[17] */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA12, (IEN | OFF | MODE5 )) /* PR1_MII0_RXLINK */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA13, (IEN | OFF | MODE5 )) /* PR1_MII0_RXER */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA14, (IEN | OFF | MODE5 )) /* PR1_MII_MR0_CLK */;
	MUX_VAL(CONTROL_PADCONF_LCD_DATA15, (IEN | OFF | MODE5 )) /* PR1_MII0_RXDV */;
	MUX_VAL(CONTROL_PADCONF_LCD_VSYNC, (IEN | OFF | MODE6 )) /* PR1_PRU1_PRU_R31[8] */;
	MUX_VAL(CONTROL_PADCONF_LCD_HSYNC, (IEN | OFF | MODE6 )) /* PR1_PRU1_PRU_R31[9] */;
	MUX_VAL(CONTROL_PADCONF_LCD_PCLK, (IEN | OFF | MODE6 )) /* PR1_PRU1_PRU_R31[10] */;
	MUX_VAL(CONTROL_PADCONF_LCD_AC_BIAS_EN, (IEN | OFF | MODE6 )) /* PR1_PRU1_PRU_R31[11] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_DAT3, (IEN | PU | MODE7 )) /* GPIO2[26] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_DAT2, (IEN | PU | MODE7 )) /* GPIO2[27] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_DAT1, (IEN | PU | MODE7 )) /* GPIO2[28] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_DAT0, (IEN | PU | MODE7 )) /* GPIO2[29] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_CLK, (IEN | PU | MODE7 )) /* GPIO2[30] */;
	MUX_VAL(CONTROL_PADCONF_MMC0_CMD, (IEN | PU | MODE7 )) /* GPIO2[31] */;
	MUX_VAL(CONTROL_PADCONF_MII1_COL, (IDIS | PD | MODE7 )) /* GPIO3[0] */;
	MUX_VAL(CONTROL_PADCONF_MII1_CRS, (IDIS | PD | MODE7 )) /* GPIO3[1] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RX_ER, (IDIS | PD | MODE7 )) /* GPIO3[2] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TX_EN, (IDIS | PD | MODE7 )) /* GPIO3[3] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RX_DV, (IEN | PD | MODE7 )) /* GPIO3[4] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TXD3, (IDIS | PD | MODE7 )) /* GPIO0[16] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TXD2, (IDIS | PD | MODE7 )) /* GPIO0[17] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TXD1, (IEN | PD | MODE7 )) /* GPIO0[21] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TXD0, (IEN | PD | MODE7 )) /* GPIO0[28] */;
	MUX_VAL(CONTROL_PADCONF_MII1_TX_CLK, (IEN | PD | MODE7 )) /* GPIO3[9] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RX_CLK, (IEN | PD | MODE7 )) /* GPIO3[10] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RXD3, (IEN | PD | MODE7 )) /* GPIO2[18] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RXD2, (IEN | PD | MODE7 )) /* GPIO2[19] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RXD1, (IEN | PD | MODE7 )) /* GPIO2[20] */;
	MUX_VAL(CONTROL_PADCONF_MII1_RXD0, (IEN | PD | MODE7 )) /* GPIO2[21] */;
	MUX_VAL(CONTROL_PADCONF_RMII1_REF_CLK, (IEN | PD | MODE7 )) /* GPIO0[29] */;
	MUX_VAL(CONTROL_PADCONF_MDIO, (IDIS | PD | MODE7 )) /* GPIO0[0] */;
	MUX_VAL(CONTROL_PADCONF_MDC, (IDIS | PD | MODE7 )) /* GPIO0[1] */;
	MUX_VAL(CONTROL_PADCONF_SPI0_SCLK, (IEN | PD | MODE0 )) /* SPI0_SCLK */;
	MUX_VAL(CONTROL_PADCONF_SPI0_D0, (IEN | OFF | MODE0 )) /* SPI0_D0 */;
	MUX_VAL(CONTROL_PADCONF_SPI0_D1, (IDIS | PD | MODE0 )) /* SPI0_D1 */;
	MUX_VAL(CONTROL_PADCONF_SPI0_CS0, (IDIS | PD | MODE0 )) /* SPI0_CS0 */;
	MUX_VAL(CONTROL_PADCONF_SPI0_CS1, (IEN | OFF | MODE7 )) /* GPIO0[6] */;
	MUX_VAL(CONTROL_PADCONF_ECAP0_IN_PWM0_OUT, (IEN | OFF | MODE7 )) /* GPIO0[7] */;
	MUX_VAL(CONTROL_PADCONF_UART0_CTSN, (IEN | OFF | MODE7 )) /* GPIO1[8] */;
	MUX_VAL(CONTROL_PADCONF_UART0_RTSN, (IEN | OFF | MODE7 )) /* GPIO1[9] */;
	MUX_VAL(CONTROL_PADCONF_UART0_RXD, (IEN | OFF | MODE7 )) /* GPIO1[10] */;
	MUX_VAL(CONTROL_PADCONF_UART0_TXD, (IEN | OFF | MODE7 )) /* GPIO1[11] */;
	MUX_VAL(CONTROL_PADCONF_UART1_CTSN, (IDIS | PD | MODE7 )) /* GPIO0[12] */;
	MUX_VAL(CONTROL_PADCONF_UART1_RTSN, (IDIS | PD | MODE7 )) /* GPIO0[13] */;
	MUX_VAL(CONTROL_PADCONF_UART1_RXD, (IEN | OFF | MODE7 )) /* GPIO0[14] */;
	MUX_VAL(CONTROL_PADCONF_UART1_TXD, (IEN | OFF | MODE7 )) /* GPIO0[15] */;
	MUX_VAL(CONTROL_PADCONF_I2C0_SDA, (IEN | PD | MODE0 )) /* I2C0_SDA */;
	MUX_VAL(CONTROL_PADCONF_I2C0_SCL, (IEN | PD | MODE0 )) /* I2C0_SCL */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKX, (IEN | PD | MODE3 )) /* SPI1_SCLK_MUX2 */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_FSX, (IEN | PD | MODE3 )) /* SPI1_D0_MUX2 */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_AXR0, (IEN | PD | MODE3 )) /* SPI1_D1_MUX2 */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKR, (IEN | PD | MODE7 )) /* GPIO3[17] */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKR, (IDIS | PD | MODE7 )) /* GPIO3[18] */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_FSR, (IEN | PD | MODE7 )) /* GPIO3[19] */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_AXR1, (IEN | PD | MODE7 )) /* GPIO3[20] */;
	MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKX, (IEN | PD | MODE7 )) /* GPIO3[21] */;
	MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR0, (IEN | OFF | MODE7 )) /* GPIO0[19] */;
	MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR1, (IEN | OFF | MODE7 )) /* GPIO0[20] */;
	}
	if(mode == GPMC_non_muxed_16bit)
	{
		MUX_VAL(CONTROL_PADCONF_GPMC_AD0, (IEN | PD | MODE0 )) /* GPMC_AD0 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD1, (IEN | PD | MODE0 )) /* GPMC_AD1 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD2, (IEN | PD | MODE0 )) /* GPMC_AD2 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD3, (IEN | PD | MODE0 )) /* GPMC_AD3 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD4, (IEN | PD | MODE0 )) /* GPMC_AD4 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD5, (IEN | PD | MODE0 )) /* GPMC_AD5 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD6, (IEN | PD | MODE0 )) /* GPMC_AD6 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD7, (IEN | PD | MODE0 )) /* GPMC_AD7 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD8, (IEN | PD | MODE0 )) /* GPMC_AD8 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD9, (IEN | PD | MODE0 )) /* GPMC_AD9 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD10, (IEN | PD | MODE0 )) /* GPMC_AD10 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD11, (IEN | PD | MODE0 )) /* GPMC_AD11 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD12, (IEN | PD | MODE0 )) /* GPMC_AD12 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD13, (IEN | PD | MODE0 )) /* GPMC_AD13 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD14, (IEN | PD | MODE0 )) /* GPMC_AD14 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_AD15, (IEN | PD | MODE0 )) /* GPMC_AD15 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A0, (IEN | PD | MODE7 )) /* GPIO1[16] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A1, (IEN | PD | MODE7 )) /* GPIO1[17] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A2, (IEN | PD | MODE7 )) /* GPIO1[18] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A3, (IEN | PD | MODE7 )) /* GPIO1[19] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A4, (IEN | PD | MODE7 )) /* GPIO1[20] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A5, (IEN | PD | MODE7 )) /* GPIO1[21] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A6, (IEN | PD | MODE7 )) /* GPIO1[22] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A7, (IEN | PD | MODE7 )) /* GPIO1[23] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A8, (IEN | PD | MODE7 )) /* GPIO1[24] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A9, (IEN | PD | MODE7 )) /* GPIO1[25] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A10, (IEN | PD | MODE7 )) /* GPIO1[26] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_A11, (IEN | PD | MODE7 )) /* GPIO1[27] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_WAIT0, (IEN | PU | MODE0 )) /* GPMC_WAIT0 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_WPN, (IDIS | PU | MODE0 )) /* GPMC_WPN */;
		MUX_VAL(CONTROL_PADCONF_GPMC_BEN1, (IDIS | PU | MODE0 )) /* GPMC_BE1N_MUX0 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_CSN0, (IEN | PU | MODE7 )) /* GPIO1[29] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_CSN1, (IEN | PU | MODE1 )) /* GPMC_CLK_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_CSN2, (IDIS | PU | MODE0 )) /* GPMC_CSN2 */;
		MUX_VAL(CONTROL_PADCONF_GPMC_CSN3, (IEN | PU | MODE7 )) /* GPIO2[0] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_CLK, (IEN | PD | MODE7 )) /* GPIO2[1] */;
		MUX_VAL(CONTROL_PADCONF_GPMC_ADVN_ALE, (IDIS | PU | MODE0 )) /* GPMC_ADVN_ALE */;
		MUX_VAL(CONTROL_PADCONF_GPMC_OEN_REN, (IDIS | PU | MODE0 )) /* GPMC_OEN_REN */;
		MUX_VAL(CONTROL_PADCONF_GPMC_WEN, (IDIS | PU | MODE0 )) /* GPMC_WEN */;
		MUX_VAL(CONTROL_PADCONF_GPMC_BEN0_CLE, (IEN | PU | MODE7 )) /* GPIO2[5] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA0, (IEN | OFF | MODE7 )) /* GPIO2[6] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA1, (IDIS | OFF | MODE1 )) /* GPMC_A1_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA2, (IDIS | OFF | MODE1 )) /* GPMC_A2_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA3, (IDIS | OFF | MODE1 )) /* GPMC_A3_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA4, (IDIS | OFF | MODE1 )) /* GPMC_A4_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA5, (IDIS | OFF | MODE1 )) /* GPMC_A5_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA6, (IDIS | OFF | MODE1 )) /* GPMC_A6_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA7, (IDIS | OFF | MODE1 )) /* GPMC_A7_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA8, (IEN | OFF | MODE7 )) /* GPIO2[14] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA9, (IEN | OFF | MODE7 )) /* GPIO2[15] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA10, (IEN | OFF | MODE7 )) /* GPIO2[16] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA11, (IEN | OFF | MODE7 )) /* GPIO2[17] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA12, (IEN | OFF | MODE7 )) /* GPIO0[8] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA13, (IEN | OFF | MODE7 )) /* GPIO0[9] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA14, (IEN | OFF | MODE7 )) /* GPIO0[10] */;
		MUX_VAL(CONTROL_PADCONF_LCD_DATA15, (IEN | OFF | MODE7 )) /* GPIO0[11] */;
		MUX_VAL(CONTROL_PADCONF_LCD_VSYNC, (IDIS | OFF | MODE1 )) /* GPMC_A8_MUX1 */;
		MUX_VAL(CONTROL_PADCONF_LCD_HSYNC, (IEN | OFF | MODE7 )) /* GPIO2[23] */;
		MUX_VAL(CONTROL_PADCONF_LCD_PCLK, (IEN | OFF | MODE7 )) /* GPIO2[24] */;
		MUX_VAL(CONTROL_PADCONF_LCD_AC_BIAS_EN, (IEN | OFF | MODE7 )) /* GPIO2[25] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_DAT3, (IEN | PU | MODE7 )) /* GPIO2[26] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_DAT2, (IEN | PU | MODE7 )) /* GPIO2[27] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_DAT1, (IEN | PU | MODE7 )) /* GPIO2[28] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_DAT0, (IEN | PU | MODE7 )) /* GPIO2[29] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_CLK, (IEN | PU | MODE7 )) /* GPIO2[30] */;
		MUX_VAL(CONTROL_PADCONF_MMC0_CMD, (IEN | PU | MODE7 )) /* GPIO2[31] */;
		MUX_VAL(CONTROL_PADCONF_MII1_COL, (IEN | PD | MODE7 )) /* GPIO3[0] */;
		MUX_VAL(CONTROL_PADCONF_MII1_CRS, (IEN | PD | MODE7 )) /* GPIO3[1] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RX_ER, (IEN | PD | MODE7 )) /* GPIO3[2] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TX_EN, (IEN | PD | MODE7 )) /* GPIO3[3] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RX_DV, (IEN | PD | MODE7 )) /* GPIO3[4] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TXD3, (IEN | PD | MODE7 )) /* GPIO0[16] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TXD2, (IEN | PD | MODE7 )) /* GPIO0[17] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TXD1, (IEN | PD | MODE7 )) /* GPIO0[21] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TXD0, (IEN | PD | MODE7 )) /* GPIO0[28] */;
		MUX_VAL(CONTROL_PADCONF_MII1_TX_CLK, (IEN | PD | MODE7 )) /* GPIO3[9] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RX_CLK, (IEN | PD | MODE7 )) /* GPIO3[10] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RXD3, (IEN | PD | MODE7 )) /* GPIO2[18] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RXD2, (IEN | PD | MODE7 )) /* GPIO2[19] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RXD1, (IEN | PD | MODE7 )) /* GPIO2[20] */;
		MUX_VAL(CONTROL_PADCONF_MII1_RXD0, (IEN | PD | MODE7 )) /* GPIO2[21] */;
		MUX_VAL(CONTROL_PADCONF_RMII1_REF_CLK, (IEN | PD | MODE7 )) /* GPIO0[29] */;
		MUX_VAL(CONTROL_PADCONF_MDIO, (IEN | PU | MODE7 )) /* GPIO0[0] */;
		MUX_VAL(CONTROL_PADCONF_MDC, (IEN | PU | MODE7 )) /* GPIO0[1] */;
		MUX_VAL(CONTROL_PADCONF_SPI0_SCLK, (IEN | OFF | MODE7 )) /* GPIO0[2] */;
		MUX_VAL(CONTROL_PADCONF_SPI0_D0, (IEN | OFF | MODE7 )) /* GPIO0[3] */;
		MUX_VAL(CONTROL_PADCONF_SPI0_D1, (IEN | OFF | MODE7 )) /* GPIO0[4] */;
		MUX_VAL(CONTROL_PADCONF_SPI0_CS0, (IEN | OFF | MODE7 )) /* GPIO0[5] */;
		MUX_VAL(CONTROL_PADCONF_SPI0_CS1, (IEN | OFF | MODE7 )) /* GPIO0[6] */;
		MUX_VAL(CONTROL_PADCONF_ECAP0_IN_PWM0_OUT, (IEN | OFF | MODE7 )) /* GPIO0[7] */;
		MUX_VAL(CONTROL_PADCONF_UART0_CTSN, (IEN | OFF | MODE7 )) /* GPIO1[8] */;
		MUX_VAL(CONTROL_PADCONF_UART0_RTSN, (IEN | OFF | MODE7 )) /* GPIO1[9] */;
		MUX_VAL(CONTROL_PADCONF_UART0_RXD, (IEN | OFF | MODE7 )) /* GPIO1[10] */;
		MUX_VAL(CONTROL_PADCONF_UART0_TXD, (IEN | OFF | MODE7 )) /* GPIO1[11] */;
		MUX_VAL(CONTROL_PADCONF_UART1_CTSN, (IEN | OFF | MODE7 )) /* GPIO0[12] */;
		MUX_VAL(CONTROL_PADCONF_UART1_RTSN, (IEN | OFF | MODE7 )) /* GPIO0[13] */;
		MUX_VAL(CONTROL_PADCONF_UART1_RXD, (IEN | OFF | MODE7 )) /* GPIO0[14] */;
		MUX_VAL(CONTROL_PADCONF_UART1_TXD, (IEN | OFF | MODE7 )) /* GPIO0[15] */;
		MUX_VAL(CONTROL_PADCONF_I2C0_SDA, (IEN | OFF | MODE7 )) /* GPIO3[5] */;
		MUX_VAL(CONTROL_PADCONF_I2C0_SCL, (IEN | OFF | MODE7 )) /* GPIO3[6] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKX, (IEN | PD | MODE7 )) /* GPIO3[14] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_FSX, (IEN | PD | MODE7 )) /* GPIO3[15] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_AXR0, (IEN | PD | MODE7 )) /* GPIO3[16] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKR, (IEN | PD | MODE7 )) /* GPIO3[17] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_ACLKR, (IEN | PD | MODE7 )) /* GPIO3[18] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_FSR, (IEN | PD | MODE7 )) /* GPIO3[19] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_AXR1, (IEN | PD | MODE7 )) /* GPIO3[20] */;
		MUX_VAL(CONTROL_PADCONF_MCASP0_AHCLKX, (IEN | PD | MODE7 )) /* GPIO3[21] */;
		MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR0, (IEN | OFF | MODE7 )) /* GPIO0[19] */;
		MUX_VAL(CONTROL_PADCONF_XDMA_EVENT_INTR1, (IEN | OFF | MODE7 )) /* GPIO0[20] */;
	}
}

void mmuInit_local(void)
{
	Mmu_disable();
	Mmu_FirstLevelDescAttrs attrs;
	Mmu_initDescAttrs(&attrs);

	attrs.type = Mmu_FirstLevelDesc_SECTION;
	attrs.bufferable = FALSE;
	attrs.cacheable = FALSE;
	attrs.domain = 0;
	attrs.imp = 1;
	attrs.accPerm = 3;
	// mark all sections below as non-cached
	Mmu_setFirstLevelDesc((Ptr)0x50000000, (Ptr)0x50000000 , &attrs);  // GPMC controller
	Mmu_setFirstLevelDesc((Ptr)0x48300000, (Ptr)0x48300000 , &attrs);  // PWM
	Mmu_setFirstLevelDesc((Ptr)0x48200000, (Ptr)0x48200000 , &attrs);  //
	Mmu_setFirstLevelDesc((Ptr)0x48100000, (Ptr)0x48100000 , &attrs);  //
	Mmu_setFirstLevelDesc((Ptr)0x48000000, (Ptr)0x48000000 , &attrs);  // Timer
	Mmu_setFirstLevelDesc((Ptr)0x44E00000, (Ptr)0x44E00000 , &attrs);  // Control Module
	Mmu_setFirstLevelDesc((Ptr)0x4A300000, (Ptr)0x4A300000 , &attrs);  // ICSS/PRUSS
	Mmu_setFirstLevelDesc((Ptr)0x40300000, (Ptr)0x40300000 , &attrs);  // OCMC RAM
	Mmu_setFirstLevelDesc((Ptr)0x09000000, (Ptr)0x09000000 , &attrs);  // DPRAM on CS1
	Mmu_setFirstLevelDesc((Ptr)0x0A000000, (Ptr)0x0A000000 , &attrs);  // FPGA on CS2
	Mmu_enable();
}
