/** @file sys_main.c 
*   @brief Application main file
*   @date 15.July.2009
*   @version 1.00.000
*
*   This file contains the main function of the Demo Software.
*    - The code starts with a running LED to indicate the board is ready.
*    - Interrupts, SCI, ESM, ADC module are configured to perform demo.
* 	 - Micro Communicates to the PC(COM port) using SCI(LIN1) module
* 	 - The Demo consists of following 
* 		- Get Software Version
* 		- Get Hardware Informations
* 		- Safety Features Demo
* 			-- PBIST  
* 			-- STC 
* 			-- ESM
*  		- Ambient Light Sensor Demo
* 		- Temperature Sensor Demo
* 		- Running LED Demo
* 
* 	 - The required Demo can be chossen by sending commands from PC through SCI,
* 	   the Demo GUI is used to send Commands to choose the Demo and to display
* 	   the status or data that micro transmits back.
* 
* 	@note : The Demo software runs out of Flash with ECC enabled. Incase of rebuld or 
* 			changes to this project, user has to appended ECC to the executable
* 			using nowEcc tool.
* 			Example command: "nowEcc.exe -F035 -r4 -a Demo_Software_Ver1_1.out"
*        	
*/		
/* (c) Texas Instruments 2009, All rights reserved. */

/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"
#include "system.h"
#include "swi_util.h"
#include "sci.h"
#include "adc.h"
#include "esm.h"
#include "stc.h"


/* External Variables */
extern unsigned char receive_command[8];
extern unsigned int Task_Number;
extern unsigned int SubTask_Number;

/* External Functions */
extern void Running_LED_demo(void);
extern void run_LED_StartUp(void);
void get_software_Version(void);
void get_hardware_Info(void);
void pbist_test(void);

/** @fn void main(void)
*   @brief Application main function
*
*/

void main(void)
{
    pbist_test();
  /** - Call RUN LED routine during the startup */
  run_LED_StartUp();
  
  /** - Enable IRQ and FIQ interrupt in Cortex R4 */
  swi_enable_fiq_irq();
  
  /** - Initialize SCI Routines to receive Command and transmit data */
  sciInit();
  
  /** - Configure SCI to receive 8 bytes of Command information */
  sciReceive(sciREG1, 8, receive_command);
  
  /** - Configure ADC to perform Temprature and Ambient Light Demo */
  adcInit();
  
  /** - Configure GIO for LED demo Software */
  gioInit();
  
  /** - Configure ESM module to capture esm errors on Error Pin */
  esmInit();
  
  /** - Clear the Task Number */
  Task_Number = 0;
  
  /** - Be in infinite Loop waiting for the command from PC/SCI */
  while(1)
  {
   	/** - Depending on the Command received the Task is selected */
   	switch(Task_Number)
  	{
  		case 1:
  				/** - Get Software Version */
  				get_software_Version();
  				
  				/** - Reset the Task Number */
  				Task_Number = 0;
  				break;
  		case 2:
  				/** - Get Hardware Informations */
  				get_hardware_Info();
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;    
  		case 3:
  				/** - Run Pbist Test */
  				pbist_test();
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;
  		case 4:
  				/** - Run STC Test */
  				stc_test();
  				
 			    /** - Enable IRQ and FIQ interrupt in Cortex R4 
 			     *  - After STC test asll Core registers has to be reinitialized */
 			    swi_enable_fiq_irq();
 			    
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;
  		case 5:
  				/** - Run ESM Test */
  				esm_test();
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;
  		case 6:
  				/** - Clear ESM pin if set */
  				esmClearErrPin();
  				
  				/** - Respond Back to PC with 0x00000001 */
				sciSend_32bitdata(sciREG1, 1);
				
  				/** - Reset the Task Number */
  				Task_Number = 0;
  				break;  				
  		case 7:
  				/** - Perform Temprature Sensor Demo */
  				Temp_Sensor_demo();
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;  				
  		case 8:
  				/** - Perform Ambient Light Sensor Demo */
  				Ambient_Light_Sensor_demo();
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;
  		case 9:
  				/** - Perform LED Demo */
  				Running_LED_demo();
  				
  				/** - Respond Back to PC with 0x00000001 */
  				sciSend_32bitdata(sciREG1, 1);
  				
  				/** - Reset the Task Number */  				
  				Task_Number = 0;
  				break;  	  				
  	}
  }			    

}

