#ifndef __INTERFACE_H__
#define __INTERFACE_H__

/**************************************************************************/
			/**Data Type Definition for TMS320C6416T **/
/**************************************************************************/
#define Uint64 unsigned long
#define Uint32 unsigned int
#define Uint16 unsigned short
#define Uint8  unsigned char

#define Int64  long
#define Int32  int
#define Int16  short
#define Int8   char
/**************************************************************************/
			/** Register Definition for TMS320C6416T **/
/**************************************************************************/
#define EMIFA_GCTL       0x01800000	//EMIFA global control
#define EMIFA_CE1        0x01800004	//EMIFA CE1 space control
#define EMIFA_CE0        0x01800008	//EMIFA CE0 space control
#define EMIFA_CE2        0x01800010	//EMIFA CE2 space control
#define EMIFA_CE3        0x01800014	//EMIFA CE3 space control
#define EMIFA_SDRAMCTL   0x01800018	//EMIFA SDRAM control
#define EMIFA_SDRAMTIM   0x0180001C	//EMIFA SDRAM refresh control
#define EMIFA_SDRAMEXT   0x01800020	//EMIFA SDRAM extension
#define EMIFA_CE1SECCTL  0x01800044	//EMIFA CE1 space secondary control
#define EMIFA_CE0SECCTL  0x01800048	//EMIFA CE0 space secondary control
#define EMIFA_CE2SECCTL  0x01800050	//EMIFA CE2 space secondary control
#define EMIFA_CE3SECCTL  0x01800054	//EMIFA CE3 space secondary control

#define EMIFB_GCTL       0x01A80000	//EMIFB global control
#define EMIFB_CE1        0x01A80004	//EMIFB CE1 space control
#define EMIFB_CE0        0x01A80008	//EMIFB CE0 space control
#define EMIFB_CE2        0x01A80010	//EMIFB CE2 space control
#define EMIFB_CE3        0x01A80014	//EMIFB CE3 space control
#define EMIFB_SDRAMCTL   0x01A80018	//EMIFB SDRAM control
#define EMIFB_SDRAMTIM   0x01A8001C	//EMIFB SDRAM refresh control
#define EMIFB_SDRAMEXT   0x01A80020	//EMIFB SDRAM extension
#define EMIFB_CE1SECCTL  0x01A80044	//EMIFB CE1 space secondary control
#define EMIFB_CE0SECCTL  0x01A80048	//EMIFB CE0 space secondary control
#define EMIFB_CE2SECCTL  0x01A80050	//EMIFB CE2 space secondary control
#define EMIFB_CE3SECCTL  0x01A80054	//EMIFB CE3 space secondary control

Uint32 *EMIFA_GCTL_REG=(Uint32 *)EMIFA_GCTL;//Address pointer for EMIFA global control
Uint32 *EMIFA_CE1_REG = (Uint32 *)EMIFA_CE1;//Address pointer for EMIFA CE1 Space Control Register 1 
Uint32 *EMIFA_CE0_REG = (Uint32 *)EMIFA_CE0;//Address pointer for EMIFA CE0 Space Control Register 0 
Uint32 *EMIFA_CE2_REG = (Uint32 *)EMIFA_CE2;//Address pointer for EMIFA CE2 Space Control Register 2
Uint32 *EMIFA_CE3_REG = (Uint32 *)EMIFA_CE3;//Address pointer for EMIFA CE3 Space Control Register 3
Uint32 *EMIFA_CE0SECCTL_REG = (Uint32 *)EMIFA_CE0SECCTL;//Address pointer for EMIFA CE1 space secondary control

Uint32 *EMIFB_GCTL_REG=(Uint32 *)EMIFB_GCTL;//Address pointer for EMIFB global control
Uint32 *EMIFB_CE1_REG = (Uint32 *)EMIFB_CE1;//Address pointer for EMIFB CE1 Space Control Register 1 
Uint32 *EMIFB_CE0_REG = (Uint32 *)EMIFB_CE0;//Address pointer for EMIFB CE0 Space Control Register 0 
Uint32 *EMIFB_CE2_REG = (Uint32 *)EMIFB_CE2;//Address pointer for EMIFB CE2 Space Control Register 2
Uint32 *EMIFB_CE3_REG = (Uint32 *)EMIFB_CE3;//Address pointer for EMIFB CE3 Space Control Register 3
Uint32 *EMIFB_CE0SECCTL_REG = (Uint32 *)EMIFB_CE0SECCTL;//Address pointer for EMIFB CE1 space secondary control

/**************************************************************************/
			 /** Base Address Definition for TMS320C6416T **/
/**************************************************************************/
#define	EMIFB_CE0_Base	 0x60000000
#define	EMIFB_CE1_Base	 0x64000000
#define	EMIFA_CE0_Base	 0x80000000

#endif
