#include <stdio.h>
//#include <sram.h>
/**************************************************************************/
/** Main Program **/
/**************************************************************************/


/**************************************************************************/
			/**Data Type Definition for TMS320C6416T **/
/**************************************************************************/
#define Uint64 unsigned long
#define Uint32 unsigned int
#define Uint16 unsigned short
#define Uint8  unsigned char

#define Int64  long
#define Int32  int
#define Int16  short
#define Int8   char
/**************************************************************************/
			/** Register Definition for TMS320C6416T **/
/**************************************************************************/
#define EMIFA_GCTL       0x01800000	//EMIFA global control
#define EMIFA_CE1        0x01800004	//EMIFA CE1 space control
#define EMIFA_CE0        0x01800008	//EMIFA CE0 space control
#define EMIFA_CE2        0x01800010	//EMIFA CE2 space control
#define EMIFA_CE3        0x01800014	//EMIFA CE3 space control
#define EMIFA_SDRAMCTL   0x01800018	//EMIFA SDRAM control
#define EMIFA_SDRAMTIM   0x0180001C	//EMIFA SDRAM refresh control
#define EMIFA_SDRAMEXT   0x01800020	//EMIFA SDRAM extension
#define EMIFA_CE1SECCTL  0x01800044	//EMIFA CE1 space secondary control
#define EMIFA_CE0SECCTL  0x01800048	//EMIFA CE0 space secondary control
#define EMIFA_CE2SECCTL  0x01800050	//EMIFA CE2 space secondary control
#define EMIFA_CE3SECCTL  0x01800054	//EMIFA CE3 space secondary control

#define EMIFB_GCTL       0x01A80000	//EMIFB global control
#define EMIFB_CE1        0x01A80004	//EMIFB CE1 space control
#define EMIFB_CE0        0x01A80008	//EMIFB CE0 space control
#define EMIFB_CE2        0x01A80010	//EMIFB CE2 space control
#define EMIFB_CE3        0x01A80014	//EMIFB CE3 space control
#define EMIFB_SDRAMCTL   0x01A80018	//EMIFB SDRAM control
#define EMIFB_SDRAMTIM   0x01A8001C	//EMIFB SDRAM refresh control
#define EMIFB_SDRAMEXT   0x01A80020	//EMIFB SDRAM extension
#define EMIFB_CE1SECCTL  0x01A80044	//EMIFB CE1 space secondary control
#define EMIFB_CE0SECCTL  0x01A80048	//EMIFB CE0 space secondary control
#define EMIFB_CE2SECCTL  0x01A80050	//EMIFB CE2 space secondary control
#define EMIFB_CE3SECCTL  0x01A80054	//EMIFB CE3 space secondary control

Uint32 *EMIFA_GCTL_REG=(Uint32 *)EMIFA_GCTL;//Address pointer for EMIFA global control
Uint32 *EMIFA_CE1_REG = (Uint32 *)EMIFA_CE1;//Address pointer for EMIFA CE1 Space Control Register 1
Uint32 *EMIFA_CE0_REG = (Uint32 *)EMIFA_CE0;//Address pointer for EMIFA CE0 Space Control Register 0
Uint32 *EMIFA_CE2_REG = (Uint32 *)EMIFA_CE2;//Address pointer for EMIFA CE2 Space Control Register 2
Uint32 *EMIFA_CE3_REG = (Uint32 *)EMIFA_CE3;//Address pointer for EMIFA CE3 Space Control Register 3
Uint32 *EMIFA_CE0SECCTL_REG = (Uint32 *)EMIFA_CE0SECCTL;//Address pointer for EMIFA CE1 space secondary control

Uint32 *EMIFB_GCTL_REG=(Uint32 *)EMIFB_GCTL;//Address pointer for EMIFB global control
Uint32 *EMIFB_CE1_REG = (Uint32 *)EMIFB_CE1;//Address pointer for EMIFB CE1 Space Control Register 1
Uint32 *EMIFB_CE0_REG = (Uint32 *)EMIFB_CE0;//Address pointer for EMIFB CE0 Space Control Register 0
Uint32 *EMIFB_CE2_REG = (Uint32 *)EMIFB_CE2;//Address pointer for EMIFB CE2 Space Control Register 2
Uint32 *EMIFB_CE3_REG = (Uint32 *)EMIFB_CE3;//Address pointer for EMIFB CE3 Space Control Register 3
Uint32 *EMIFB_CE0SECCTL_REG = (Uint32 *)EMIFB_CE0SECCTL;//Address pointer for EMIFB CE1 space secondary control

/**************************************************************************/
			 /** Base Address Definition for TMS320C6416T **/
/**************************************************************************/
#define	EMIFB_CE0_Base	 0x60000000
#define	EMIFB_CE1_Base	 0x64000000
#define	EMIFA_CE0_Base	 0x80000000




void main( void )
{   
	Uint32 *regdata_SRAM,*regdata_SRAM1,*pdata;
	static Uint16 m,i,j,arrB[40],arrA[40];
	int WRSETUP, WRSTRB, WRHLD, RDSETUP, RDSTRB, MTYPE, RDHLD,TA;

	WRSETUP =2;
	WRSTRB  =11;
	WRHLD   =3;
	RDSETUP =1;
	TA 		=3;
	RDSTRB  =17;	
	MTYPE   =0;
	RDHLD   =3;	
	
	*EMIFA_GCTL_REG=(0x9<<16);
	*EMIFA_CE0_REG =(0xB<<4);//EMIFA_SBSRAM
	*EMIFA_CE1_REG =(0xB<<4);
	*EMIFA_CE2_REG =(0xB<<4);
	*EMIFA_CE3_REG =(0xB<<4);
	*EMIFA_CE0SECCTL_REG = 0x2;//EMIFA_SBSRAM

	*EMIFB_GCTL_REG=(0x9<<16);
	*EMIFB_CE0_REG =(0xB<<4);//EMIFB_SBSRAM
	//*EMIFB_CE1_REG =(0xB<<4);//EMIFB_ROM change	
	*EMIFB_CE1_REG =((WRSETUP<<28)||(WRSTRB<<22)||(WRHLD<<20)||(RDSETUP<<16)||(TA<<14)||(RDSTRB<<8)||(MTYPE<<4)||(RDHLD<<0));	
	*EMIFB_CE2_REG =(0xB<<4);
	*EMIFB_CE3_REG =(0xB<<4);
	*EMIFB_CE0SECCTL_REG = 0x2;//EMIFB_SBSRAM

	for (i=0,j=0;i<40;i++,j+=2)
	{
		Uint32 *EMIFB_SRAM=(Uint32 *)(EMIFB_CE0_Base+j);
		*EMIFB_SRAM = i; 	
	}
	
	for (i=0,j=0;i<40;i++,j+=2)
	{
		Uint32 *EMIFB_SRAM=(Uint32 *)(EMIFB_CE0_Base+j);
		arrB[i] = *EMIFB_SRAM ;    
	}
	
	for (i=0,j=0;i<40;i++,j+=2)
	{
		Uint32 *EMIFA_SRAM=(Uint32 *)(EMIFA_CE0_Base+j);
		*EMIFA_SRAM = i; 	
	}

	for (i=0,j=0;i<40;i++,j+=2)
	{
		Uint32 *EMIFA_SRAM=(Uint32 *)(EMIFA_CE0_Base+j);
		arrA[i] = *EMIFA_SRAM ;    
	}

}
