#include <cslr.h>
#include <cslr_gpio.h>
#include <cslr_syscfg0_OMAPL138.h>
#include <cslr_syscfg1_OMAPL138.h>
#include <soc_OMAPL138.h>
#include <csl_types.h>
#include <cslr_i2c.h>
#include <stdio.h>
#define NUM_CHARS       8
#define I2C_ADDR		0x21
#define CONFIG_PORT0    0x6
#define CONFIG_PORT1    0x7
#define OUTPUT_PORT0    0x2
#define OUTPUT_PORT1    0x3
#define WAIT_LOOP 		0x50000
#define SYS_BASE           0x01C14000
#define KICK0Ra             *(unsigned int*)(SYS_BASE + 0x038)
#define KICK1Ra             *(unsigned int*)(SYS_BASE + 0x03c)

static void init_i2c(void);
static int blink_leds(void);
static int writeI2C(unsigned, unsigned, unsigned);

CSL_I2cRegsOvly i2cRegs = (CSL_I2cRegsOvly)CSL_I2C_0_REGS;
CSL_SyscfgRegsOvly SYS_REGS = (CSL_SyscfgRegsOvly)CSL_SYSCFG_0_REGS;


int main (void)
{
  
  //setup i2c registers and start i2c running
  init_i2c();

  blink_leds();

  while(1);

}

void init_i2c(void)
{
 
  // Open Permissions to SYSCFG Registers (Not required for PG2.0 silicon and above)
  KICK0Ra = 0x83e70b13;
  KICK1Ra = 0x95A4F1E0;

  //Setup Pinmux for I2C0 Pins
  SYS_REGS->PINMUX4 = (CSL_SYSCFG_PINMUX4_PINMUX4_15_12_I2C0_SDA <<  CSL_SYSCFG_PINMUX4_PINMUX4_15_12_SHIFT) |
    				  (CSL_SYSCFG_PINMUX4_PINMUX4_11_8_I2C0_SCL <<  CSL_SYSCFG_PINMUX4_PINMUX4_11_8_SHIFT);

  //i2c mode register
  i2cRegs->ICMDR = CSL_FMKT(I2C_ICMDR_MST,MASTER_MODE) //master mode
                            | CSL_FMKT(I2C_ICMDR_TRX,TX_MODE) //transmitter mode
                            | CSL_FMKT(I2C_ICMDR_RM,ENABLE) //repeat mode
                            | CSL_FMKT(I2C_ICMDR_MST,MASTER_MODE) //Master mode
                            | CSL_FMKT(I2C_ICMDR_DLB,DISABLE); //digital loopback

  //set i2c clock low time divide down value, 0-FFFFh
  i2cRegs->ICCLKL = CSL_FMK(I2C_ICCLKL_ICCL,0x10);

  //set i2c clock high time divide down value, 0-FFFFh
  i2cRegs->ICCLKH = CSL_FMK(I2C_ICCLKH_ICCH,0x10);

  //set i2c prescalar divide down value, 0-FFh
  i2cRegs->ICPSC = CSL_FMK(I2C_ICPSC_IPSC,0x2);

  //bring i2c module out of reset
  CSL_FINST(i2cRegs->ICMDR,I2C_ICMDR_IRS,ENABLE);

}

int blink_leds(void)
{
  int j;

  //Toggle LEDS on and off
  while(1) 
  {
    writeI2C(I2C_ADDR, OUTPUT_PORT0, 0x7F);
    for(j=0;j<WAIT_LOOP;j++);	
    
    writeI2C(I2C_ADDR, CONFIG_PORT0, 0x7F); 
    for(j=0;j<WAIT_LOOP;j++);
	
	writeI2C(I2C_ADDR, OUTPUT_PORT0, 0xBF);
    for(j=0;j<WAIT_LOOP;j++);
    
    writeI2C(I2C_ADDR, CONFIG_PORT0, 0xBF);
    for(j=0;j<WAIT_LOOP;j++);

  }
}

int writeI2C(unsigned addr, unsigned reg, unsigned data)
{

    /* set slave address to be the I2C expander */
	i2cRegs->ICSAR = addr;		

    /* set transmit byte count (ICCNT) to two bytes (register ID + value) */
	i2cRegs->ICCNT = 2;

    /* put the register ID into the transmit data register */
    i2cRegs->ICDXR = reg;

    /* start the transaction */
    i2cRegs->ICMDR |= CSL_FMKT(I2C_ICMDR_STT,SET);

    asm(" .global _PMI_waitT1");
    asm("_PMI_waitT1:");

    /* wait for TX ready status */
    while(CSL_FEXT(i2cRegs->ICSTR,I2C_ICSTR_ICXRDY)!= 1);

    /* put the register data value into the transmit data register */
    i2cRegs->ICDXR = data;

    asm(" .global _PMI_waitT2");
    asm("_PMI_waitT2:");

    /* wait for TX ready status */
    while(CSL_FEXT(i2cRegs->ICSTR,I2C_ICSTR_ICXRDY)!= 1);

   return 1;
}

