#include "DSP2833x_Device.h"     // Headerfile Include File
#include "DSP2833x_ECan.h"		// canbus device support
#include "DSP2833x_Mcbsp.h"		// mcbsp device support
#include "DSP2833x_Examples.h"   // Examples Include File


void init()
{
// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2804x_SysCtrl.c file.
   InitSysCtrl();
      
// Step 2. Initalize GPIO: 
// This example function is found in the DSP2804x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
   InitGpio();
 

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts 
   DINT;

// Initialize PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.  
// This function is found in the DSP2804x_PieCtrl.c file.
   InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt 
// Service Routines (ISR).  
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2804x_DefaultIsr.c.
// This function is found in DSP2804x_PieVect.c.
   InitPieVectTable();

	
// Step 4. Initialize all the Device Peripherals:


   EnableInterrupts();
   

   InitMcbspa();
   InitMcbspaGpio();
   InitMcbspa8bit();



} // end of init()


class LFSR
{
	int state;
	int poly;
public:
	LFSR() : state(1), poly(0x2345) {}
	void step()
	{
		int newState = state >> 1;
		if (state & 1)
			newState ^= poly;
	}
};

LFSR lfsr;
void loop()
{
	while (true)
	{
		lfsr.step();
	}
}

int main()
{
	init();
	loop();
	return 0; // we never get here but oh well
}



